package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of OpsItem severity available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.183Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.OpsItemSeverity")
public enum OpsItemSeverity {
    /**
     * Set the severity to critical.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CRITICAL,
    /**
     * Set the severity to high.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH,
    /**
     * Set the severity to medium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     * Set the severity to low.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LOW,
}
