package software.amazon.awscdk.services.codebuild;

/**
 * Cache options for CodeBuild Project.
 * <p>
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myCachingBucket;
 * Project.Builder.create(this, "Project")
 *         .source(Source.bitBucket(BitBucketSourceProps.builder()
 *                 .owner("awslabs")
 *                 .repo("aws-cdk")
 *                 .build()))
 *         .cache(Cache.bucket(myCachingBucket))
 *         // BuildSpec with a 'cache' section necessary for S3 caching. This can
 *         // also come from 'buildspec.yml' in your source.
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("..."))),
 *                 "cache", Map.of(
 *                         "paths", List.of("/root/cachedir/**&#47;*")))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Cache")
public abstract class Cache extends software.amazon.jsii.JsiiObject {

    protected Cache(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cache(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Cache() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create an S3 caching strategy.
     * <p>
     * @param bucket the S3 bucket to use for caching. This parameter is required.
     * @param options additional options to pass to the S3 caching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BucketCacheOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), options });
    }

    /**
     * Create an S3 caching strategy.
     * <p>
     * @param bucket the S3 bucket to use for caching. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Create a local caching strategy.
     * <p>
     * @param modes the mode(s) to enable for local caching. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache local(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.LocalCacheMode... modes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "local", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), java.util.Arrays.<Object>stream(modes).toArray(Object[]::new));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.Cache {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
