package software.amazon.awscdk.services.codedeploy;

/**
 * Represents the structure to pass into the underlying CfnDeploymentConfig class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codedeploy.*;
 * TrafficRoutingConfig trafficRoutingConfig = TrafficRoutingConfig.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .timeBasedCanary(CanaryTrafficRoutingConfig.builder()
 *                 .canaryInterval(123)
 *                 .canaryPercentage(123)
 *                 .build())
 *         .timeBasedLinear(LinearTrafficRoutingConfig.builder()
 *                 .linearInterval(123)
 *                 .linearPercentage(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.454Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.TrafficRoutingConfig")
@software.amazon.jsii.Jsii.Proxy(TrafficRoutingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TrafficRoutingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of traffic shifting ( <code>TimeBasedCanary</code> or <code>TimeBasedLinear</code> ) used by a deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig getTimeBasedCanary() {
        return null;
    }

    /**
     * A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig getTimeBasedLinear() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TrafficRoutingConfig> {
        java.lang.String type;
        software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig timeBasedCanary;
        software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig timeBasedLinear;

        /**
         * Sets the value of {@link TrafficRoutingConfig#getType}
         * @param type The type of traffic shifting ( <code>TimeBasedCanary</code> or <code>TimeBasedLinear</code> ) used by a deployment configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link TrafficRoutingConfig#getTimeBasedCanary}
         * @param timeBasedCanary A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedCanary(software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig timeBasedCanary) {
            this.timeBasedCanary = timeBasedCanary;
            return this;
        }

        /**
         * Sets the value of {@link TrafficRoutingConfig#getTimeBasedLinear}
         * @param timeBasedLinear A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedLinear(software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig timeBasedLinear) {
            this.timeBasedLinear = timeBasedLinear;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TrafficRoutingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TrafficRoutingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TrafficRoutingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrafficRoutingConfig {
        private final java.lang.String type;
        private final software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig timeBasedCanary;
        private final software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig timeBasedLinear;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeBasedCanary = software.amazon.jsii.Kernel.get(this, "timeBasedCanary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig.class));
            this.timeBasedLinear = software.amazon.jsii.Kernel.get(this, "timeBasedLinear", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.timeBasedCanary = builder.timeBasedCanary;
            this.timeBasedLinear = builder.timeBasedLinear;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.CanaryTrafficRoutingConfig getTimeBasedCanary() {
            return this.timeBasedCanary;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.LinearTrafficRoutingConfig getTimeBasedLinear() {
            return this.timeBasedLinear;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getTimeBasedCanary() != null) {
                data.set("timeBasedCanary", om.valueToTree(this.getTimeBasedCanary()));
            }
            if (this.getTimeBasedLinear() != null) {
                data.set("timeBasedLinear", om.valueToTree(this.getTimeBasedLinear()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.TrafficRoutingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TrafficRoutingConfig.Jsii$Proxy that = (TrafficRoutingConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.timeBasedCanary != null ? !this.timeBasedCanary.equals(that.timeBasedCanary) : that.timeBasedCanary != null) return false;
            return this.timeBasedLinear != null ? this.timeBasedLinear.equals(that.timeBasedLinear) : that.timeBasedLinear == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.timeBasedCanary != null ? this.timeBasedCanary.hashCode() : 0);
            result = 31 * result + (this.timeBasedLinear != null ? this.timeBasedLinear.hashCode() : 0);
            return result;
        }
    }
}
