package software.amazon.awscdk.services.codestarnotifications;

/**
 * Properties for a new notification rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.chatbot.*;
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * Topic topic = new Topic(this, "MyTopic1");
 * SlackChannelConfiguration slack = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * NotificationRule rule = NotificationRule.Builder.create(this, "NotificationRule")
 *         .source(project)
 *         .events(List.of("codebuild-project-build-state-succeeded", "codebuild-project-build-state-failed"))
 *         .targets(List.of(topic))
 *         .notificationRuleName("MyNotificationRuleName")
 *         .enabled(true) // The default is true
 *         .detailType(DetailType.FULL) // The default is FULL
 *         .createdBy("Jone Doe")
 *         .build();
 * rule.addTarget(slack);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.681Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarnotifications.NotificationRuleProps")
@software.amazon.jsii.Jsii.Proxy(NotificationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NotificationRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions {

    /**
     * A list of event types associated with this notification rule.
     * <p>
     * For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEvents();

    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the notification rule.
     * <p>
     * Currently, Supported sources include pipelines in AWS CodePipeline, build projects in AWS CodeBuild, and repositories in AWS CodeCommit in this L2 constructor.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarnotifications-notificationrule.html#cfn-codestarnotifications-notificationrule-resource">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarnotifications-notificationrule.html#cfn-codestarnotifications-notificationrule-resource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource getSource();

    /**
     * The targets to register for the notification destination.
     * <p>
     * Default: - No targets are added to the rule. Use `addTarget()` to add a target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NotificationRuleProps> {
        java.util.List<java.lang.String> events;
        software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource source;
        java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> targets;
        java.lang.String createdBy;
        software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        java.lang.Boolean enabled;
        java.lang.String notificationRuleName;

        /**
         * Sets the value of {@link NotificationRuleProps#getEvents}
         * @param events A list of event types associated with this notification rule. This parameter is required.
         *               For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<java.lang.String> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getSource}
         * @param source The Amazon Resource Name (ARN) of the resource to associate with the notification rule. This parameter is required.
         *               Currently, Supported sources include pipelines in AWS CodePipeline, build projects in AWS CodeBuild, and repositories in AWS CodeCommit in this L2 constructor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getTargets}
         * @param targets The targets to register for the notification destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targets(java.util.List<? extends software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> targets) {
            this.targets = (java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget>)targets;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getCreatedBy}
         * @param createdBy The name or email alias of the person who created the notification rule.
         *                  If not specified, it means that the creator's alias is not provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getDetailType}
         * @param detailType The level of detail to include in the notifications for this resource.
         *                   BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
         *                   FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(software.amazon.awscdk.services.codestarnotifications.DetailType detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getEnabled}
         * @param enabled The status of the notification rule.
         *                If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link NotificationRuleProps#getNotificationRuleName}
         * @param notificationRuleName The name for the notification rule.
         *                             Notification rule names must be unique in your AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationRuleName(java.lang.String notificationRuleName) {
            this.notificationRuleName = notificationRuleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NotificationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NotificationRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationRuleProps {
        private final java.util.List<java.lang.String> events;
        private final software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource source;
        private final java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> targets;
        private final java.lang.String createdBy;
        private final software.amazon.awscdk.services.codestarnotifications.DetailType detailType;
        private final java.lang.Boolean enabled;
        private final java.lang.String notificationRuleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget.class)));
            this.createdBy = software.amazon.jsii.Kernel.get(this, "createdBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.DetailType.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationRuleName = software.amazon.jsii.Kernel.get(this, "notificationRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.events = java.util.Objects.requireNonNull(builder.events, "events is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.targets = (java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget>)builder.targets;
            this.createdBy = builder.createdBy;
            this.detailType = builder.detailType;
            this.enabled = builder.enabled;
            this.notificationRuleName = builder.notificationRuleName;
        }

        @Override
        public final java.util.List<java.lang.String> getEvents() {
            return this.events;
        }

        @Override
        public final software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource getSource() {
            return this.source;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final software.amazon.awscdk.services.codestarnotifications.DetailType getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getNotificationRuleName() {
            return this.notificationRuleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("events", om.valueToTree(this.getEvents()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getCreatedBy() != null) {
                data.set("createdBy", om.valueToTree(this.getCreatedBy()));
            }
            if (this.getDetailType() != null) {
                data.set("detailType", om.valueToTree(this.getDetailType()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getNotificationRuleName() != null) {
                data.set("notificationRuleName", om.valueToTree(this.getNotificationRuleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codestarnotifications.NotificationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NotificationRuleProps.Jsii$Proxy that = (NotificationRuleProps.Jsii$Proxy) o;

            if (!events.equals(that.events)) return false;
            if (!source.equals(that.source)) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) return false;
            if (this.detailType != null ? !this.detailType.equals(that.detailType) : that.detailType != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.notificationRuleName != null ? this.notificationRuleName.equals(that.notificationRuleName) : that.notificationRuleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.events.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
            result = 31 * result + (this.detailType != null ? this.detailType.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.notificationRuleName != null ? this.notificationRuleName.hashCode() : 0);
            return result;
        }
    }
}
