package software.amazon.awscdk.services.cognito;

/**
 * Creates a new set of branding settings for a user pool style and associates it with an app client.
 * <p>
 * This operation is the programmatic option for the creation of a new style in the branding designer.
 * <p>
 * Provides values for UI customization in a <code>Settings</code> JSON object and image files in an <code>Assets</code> array. To send the JSON object <code>Document</code> type parameter in <code>Settings</code> , you might need to update to the most recent version of your AWS SDK.
 * <p>
 * This operation has a 2-megabyte request-size limit and include the CSS settings and image assets for your app client. Your branding settings might exceed 2MB in size. Amazon Cognito doesn't require that you pass all parameters in one request and preserves existing style settings that you don't specify. If your request is larger than 2MB, separate it into multiple requests, each with a size smaller than the limit.
 * <p>
 * As a best practice, modify the output of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeManagedLoginBrandingByClient.html">DescribeManagedLoginBrandingByClient</a> into the request parameters for this operation. To get all settings, set <code>ReturnMergedResources</code> to <code>true</code> . For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/managed-login-brandingdesigner.html#branding-designer-api">API and SDK operations for managed login branding</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object settings;
 * CfnManagedLoginBranding cfnManagedLoginBranding = CfnManagedLoginBranding.Builder.create(this, "MyCfnManagedLoginBranding")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .assets(List.of(AssetTypeProperty.builder()
 *                 .category("category")
 *                 .colorMode("colorMode")
 *                 .extension("extension")
 *                 // the properties below are optional
 *                 .bytes("bytes")
 *                 .resourceId("resourceId")
 *                 .build()))
 *         .clientId("clientId")
 *         .returnMergedResources(false)
 *         .settings(settings)
 *         .useCognitoProvidedValues(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnManagedLoginBranding")
public class CfnManagedLoginBranding extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnManagedLoginBranding(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnManagedLoginBranding(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnManagedLoginBranding.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnManagedLoginBranding(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnManagedLoginBrandingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the managed login branding style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrManagedLoginBrandingId() {
        return software.amazon.jsii.Kernel.get(this, "attrManagedLoginBrandingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The user pool where the branding style is assigned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user pool where the branding style is assigned.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssets() {
        return software.amazon.jsii.Kernel.get(this, "assets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "assets", value);
    }

    /**
     * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cognito.CfnManagedLoginBranding.AssetTypeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cognito.CfnManagedLoginBranding.AssetTypeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "assets", value);
    }

    /**
     * The app client that's assigned to the branding style that you want more information about.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
        return software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The app client that's assigned to the branding style that you want more information about.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientId", value);
    }

    /**
     * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getReturnMergedResources() {
        return software.amazon.jsii.Kernel.get(this, "returnMergedResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReturnMergedResources(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "returnMergedResources", value);
    }

    /**
     * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReturnMergedResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "returnMergedResources", value);
    }

    /**
     * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * When true, applies the default branding style options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseCognitoProvidedValues() {
        return software.amazon.jsii.Kernel.get(this, "useCognitoProvidedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When true, applies the default branding style options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCognitoProvidedValues(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useCognitoProvidedValues", value);
    }

    /**
     * When true, applies the default branding style options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCognitoProvidedValues(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useCognitoProvidedValues", value);
    }
    /**
     * An image file from a managed login branding style in a user pool.
     * <p>
     * This data type is a request parameter of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateManagedLoginBranding.html">CreateManagedLoginBranding</a> and <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateManagedLoginBranding.html">UpdateManagedLoginBranding</a> , and a response parameter of <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeManagedLoginBranding.html">DescribeManagedLoginBranding</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * AssetTypeProperty assetTypeProperty = AssetTypeProperty.builder()
     *         .category("category")
     *         .colorMode("colorMode")
     *         .extension("extension")
     *         // the properties below are optional
     *         .bytes("bytes")
     *         .resourceId("resourceId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnManagedLoginBranding.AssetTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category that the image corresponds to in your managed login configuration.
         * <p>
         * Managed login has asset categories for different types of logos, backgrounds, and icons.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The display-mode target of the asset: light, dark, or browser-adaptive.
         * <p>
         * For example, Amazon Cognito displays a dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file in all contexts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-colormode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-colormode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColorMode();

        /**
         * The file type of the image file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-extension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-extension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExtension();

        /**
         * The image file, in Base64-encoded binary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-bytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-bytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBytes() {
            return null;
        }

        /**
         * The ID of the asset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-managedloginbranding-assettype.html#cfn-cognito-managedloginbranding-assettype-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetTypeProperty> {
            java.lang.String category;
            java.lang.String colorMode;
            java.lang.String extension;
            java.lang.String bytes;
            java.lang.String resourceId;

            /**
             * Sets the value of {@link AssetTypeProperty#getCategory}
             * @param category The category that the image corresponds to in your managed login configuration. This parameter is required.
             *                 Managed login has asset categories for different types of logos, backgrounds, and icons.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link AssetTypeProperty#getColorMode}
             * @param colorMode The display-mode target of the asset: light, dark, or browser-adaptive. This parameter is required.
             *                  For example, Amazon Cognito displays a dark-mode image only when the browser or application is in dark mode, but displays a browser-adaptive file in all contexts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorMode(java.lang.String colorMode) {
                this.colorMode = colorMode;
                return this;
            }

            /**
             * Sets the value of {@link AssetTypeProperty#getExtension}
             * @param extension The file type of the image file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extension(java.lang.String extension) {
                this.extension = extension;
                return this;
            }

            /**
             * Sets the value of {@link AssetTypeProperty#getBytes}
             * @param bytes The image file, in Base64-encoded binary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytes(java.lang.String bytes) {
                this.bytes = bytes;
                return this;
            }

            /**
             * Sets the value of {@link AssetTypeProperty#getResourceId}
             * @param resourceId The ID of the asset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetTypeProperty {
            private final java.lang.String category;
            private final java.lang.String colorMode;
            private final java.lang.String extension;
            private final java.lang.String bytes;
            private final java.lang.String resourceId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.colorMode = software.amazon.jsii.Kernel.get(this, "colorMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.extension = software.amazon.jsii.Kernel.get(this, "extension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytes = software.amazon.jsii.Kernel.get(this, "bytes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.colorMode = java.util.Objects.requireNonNull(builder.colorMode, "colorMode is required");
                this.extension = java.util.Objects.requireNonNull(builder.extension, "extension is required");
                this.bytes = builder.bytes;
                this.resourceId = builder.resourceId;
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getColorMode() {
                return this.colorMode;
            }

            @Override
            public final java.lang.String getExtension() {
                return this.extension;
            }

            @Override
            public final java.lang.String getBytes() {
                return this.bytes;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("colorMode", om.valueToTree(this.getColorMode()));
                data.set("extension", om.valueToTree(this.getExtension()));
                if (this.getBytes() != null) {
                    data.set("bytes", om.valueToTree(this.getBytes()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnManagedLoginBranding.AssetTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetTypeProperty.Jsii$Proxy that = (AssetTypeProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!colorMode.equals(that.colorMode)) return false;
                if (!extension.equals(that.extension)) return false;
                if (this.bytes != null ? !this.bytes.equals(that.bytes) : that.bytes != null) return false;
                return this.resourceId != null ? this.resourceId.equals(that.resourceId) : that.resourceId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.colorMode.hashCode());
                result = 31 * result + (this.extension.hashCode());
                result = 31 * result + (this.bytes != null ? this.bytes.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnManagedLoginBranding}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnManagedLoginBranding> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnManagedLoginBrandingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnManagedLoginBrandingProps.Builder();
        }

        /**
         * The user pool where the branding style is assigned.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-userpoolid</a>
         * @param userPoolId The user pool where the branding style is assigned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
         * <p>
         * Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets</a>
         * @param assets An array of image files that you want to apply to roles like backgrounds, logos, and icons. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assets(final software.amazon.awscdk.IResolvable assets) {
            this.props.assets(assets);
            return this;
        }
        /**
         * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
         * <p>
         * Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets</a>
         * @param assets An array of image files that you want to apply to roles like backgrounds, logos, and icons. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assets(final java.util.List<? extends java.lang.Object> assets) {
            this.props.assets(assets);
            return this;
        }

        /**
         * The app client that's assigned to the branding style that you want more information about.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-clientid</a>
         * @param clientId The app client that's assigned to the branding style that you want more information about. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
         * <p>
         * When <code>false</code> or when you omit this parameter, returns only values that you customized in your branding style.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources</a>
         * @param returnMergedResources When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnMergedResources(final java.lang.Boolean returnMergedResources) {
            this.props.returnMergedResources(returnMergedResources);
            return this;
        }
        /**
         * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
         * <p>
         * When <code>false</code> or when you omit this parameter, returns only values that you customized in your branding style.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources</a>
         * @param returnMergedResources When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnMergedResources(final software.amazon.awscdk.IResolvable returnMergedResources) {
            this.props.returnMergedResources(returnMergedResources);
            return this;
        }

        /**
         * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-settings</a>
         * @param settings A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final java.lang.Object settings) {
            this.props.settings(settings);
            return this;
        }

        /**
         * When true, applies the default branding style options.
         * <p>
         * This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding designer.
         * <p>
         * When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and <code>Assets</code> in the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues</a>
         * @param useCognitoProvidedValues When true, applies the default branding style options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCognitoProvidedValues(final java.lang.Boolean useCognitoProvidedValues) {
            this.props.useCognitoProvidedValues(useCognitoProvidedValues);
            return this;
        }
        /**
         * When true, applies the default branding style options.
         * <p>
         * This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding designer.
         * <p>
         * When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and <code>Assets</code> in the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues</a>
         * @param useCognitoProvidedValues When true, applies the default branding style options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCognitoProvidedValues(final software.amazon.awscdk.IResolvable useCognitoProvidedValues) {
            this.props.useCognitoProvidedValues(useCognitoProvidedValues);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnManagedLoginBranding}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnManagedLoginBranding build() {
            return new software.amazon.awscdk.services.cognito.CfnManagedLoginBranding(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
