package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnConfigurationRecorder</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationRecorderProps cfnConfigurationRecorderProps = CfnConfigurationRecorderProps.builder()
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .name("name")
 *         .recordingGroup(RecordingGroupProperty.builder()
 *                 .allSupported(false)
 *                 .exclusionByResourceTypes(ExclusionByResourceTypesProperty.builder()
 *                         .resourceTypes(List.of("resourceTypes"))
 *                         .build())
 *                 .includeGlobalResourceTypes(false)
 *                 .recordingStrategy(RecordingStrategyProperty.builder()
 *                         .useOnly("useOnly")
 *                         .build())
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .build())
 *         .recordingMode(RecordingModeProperty.builder()
 *                 .recordingFrequency("recordingFrequency")
 *                 // the properties below are optional
 *                 .recordingModeOverrides(List.of(RecordingModeOverrideProperty.builder()
 *                         .recordingFrequency("recordingFrequency")
 *                         .resourceTypes(List.of("resourceTypes"))
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:19.925Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationRecorderProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationRecorderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationRecorderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
     * <p>
     * <blockquote>
     * <p>
     * <em>Pre-existing AWS Config role</em>
     * <p>
     * If you have used an AWS service that uses AWS Config , such as AWS Security Hub or AWS Control Tower , and an AWS Config role has already been created, make sure that the IAM role that you use when setting up AWS Config keeps the same minimum permissions as the already created AWS Config role. You must do this so that the other AWS service continues to run as expected.
     * <p>
     * For example, if AWS Control Tower has an IAM role that allows AWS Config to read Amazon Simple Storage Service ( Amazon S3 ) objects, make sure that the same permissions are granted within the IAM role you use when setting up AWS Config . Otherwise, it may interfere with how AWS Control Tower operates. For more information about IAM roles for AWS Config , see <a href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"><em>Identity and Access Management for AWS Config</em></a> in the <em>AWS Config Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the configuration recorder. AWS Config automatically assigns the name of "default" when creating the configuration recorder.
     * <p>
     * You cannot change the name of the configuration recorder after it has been created. To change the configuration recorder name, you must delete it and create a new configuration recorder with a new name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies which resource types AWS Config records for configuration changes.
     * <p>
     * <blockquote>
     * <p>
     * <em>High Number of AWS Config Evaluations</em>
     * <p>
     * You may notice increased activity in your account during your initial month recording with AWS Config when compared to subsequent months. During the initial bootstrapping process, AWS Config runs evaluations on all the resources in your account that you have selected for AWS Config to record.
     * <p>
     * If you are running ephemeral workloads, you may see increased activity from AWS Config as it records configuration changes associated with creating and deleting these temporary resources. An <em>ephemeral workload</em> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud ( Amazon EC2 ) Spot Instances, Amazon EMR jobs, and AWS Auto Scaling . If you want to avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a separate account with AWS Config turned off to avoid increased configuration recording and rule evaluations.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecordingGroup() {
        return null;
    }

    /**
     * Specifies the default recording frequency for the configuration recorder. AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
     * <p>
     * <ul>
     * <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
     * <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * <em>Some resource types require continuous recording</em>
     * <p>
     * AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
     * <p>
     * </blockquote>
     * <p>
     * You can also override the recording frequency for specific resource types.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecordingMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationRecorderProps> {
        java.lang.String roleArn;
        java.lang.String name;
        java.lang.Object recordingGroup;
        java.lang.Object recordingMode;

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRoleArn}
         * @param roleArn Amazon Resource Name (ARN) of the IAM role assumed by AWS Config and used by the configuration recorder. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/iamrole-permissions.html">Permissions for the IAM Role Assigned</a> to AWS Config in the AWS Config Developer Guide.
         *                <p>
         *                <blockquote>
         *                <p>
         *                <em>Pre-existing AWS Config role</em>
         *                <p>
         *                If you have used an AWS service that uses AWS Config , such as AWS Security Hub or AWS Control Tower , and an AWS Config role has already been created, make sure that the IAM role that you use when setting up AWS Config keeps the same minimum permissions as the already created AWS Config role. You must do this so that the other AWS service continues to run as expected.
         *                <p>
         *                For example, if AWS Control Tower has an IAM role that allows AWS Config to read Amazon Simple Storage Service ( Amazon S3 ) objects, make sure that the same permissions are granted within the IAM role you use when setting up AWS Config . Otherwise, it may interfere with how AWS Control Tower operates. For more information about IAM roles for AWS Config , see <a href="https://docs.aws.amazon.com/config/latest/developerguide/security-iam.html"><em>Identity and Access Management for AWS Config</em></a> in the <em>AWS Config Developer Guide</em> .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getName}
         * @param name The name of the configuration recorder. AWS Config automatically assigns the name of "default" when creating the configuration recorder.
         *             You cannot change the name of the configuration recorder after it has been created. To change the configuration recorder name, you must delete it and create a new configuration recorder with a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingGroup}
         * @param recordingGroup Specifies which resource types AWS Config records for configuration changes.
         *                       <blockquote>
         *                       <p>
         *                       <em>High Number of AWS Config Evaluations</em>
         *                       <p>
         *                       You may notice increased activity in your account during your initial month recording with AWS Config when compared to subsequent months. During the initial bootstrapping process, AWS Config runs evaluations on all the resources in your account that you have selected for AWS Config to record.
         *                       <p>
         *                       If you are running ephemeral workloads, you may see increased activity from AWS Config as it records configuration changes associated with creating and deleting these temporary resources. An <em>ephemeral workload</em> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud ( Amazon EC2 ) Spot Instances, Amazon EMR jobs, and AWS Auto Scaling . If you want to avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a separate account with AWS Config turned off to avoid increased configuration recording and rule evaluations.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(software.amazon.awscdk.IResolvable recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingGroup}
         * @param recordingGroup Specifies which resource types AWS Config records for configuration changes.
         *                       <blockquote>
         *                       <p>
         *                       <em>High Number of AWS Config Evaluations</em>
         *                       <p>
         *                       You may notice increased activity in your account during your initial month recording with AWS Config when compared to subsequent months. During the initial bootstrapping process, AWS Config runs evaluations on all the resources in your account that you have selected for AWS Config to record.
         *                       <p>
         *                       If you are running ephemeral workloads, you may see increased activity from AWS Config as it records configuration changes associated with creating and deleting these temporary resources. An <em>ephemeral workload</em> is a temporary use of computing resources that are loaded and run when needed. Examples include Amazon Elastic Compute Cloud ( Amazon EC2 ) Spot Instances, Amazon EMR jobs, and AWS Auto Scaling . If you want to avoid the increased activity from running ephemeral workloads, you can run these types of workloads in a separate account with AWS Config turned off to avoid increased configuration recording and rule evaluations.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingGroup(software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty recordingGroup) {
            this.recordingGroup = recordingGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingMode}
         * @param recordingMode Specifies the default recording frequency for the configuration recorder. AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
         *                      <ul>
         *                      <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
         *                      <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
         *                      </ul>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      <em>Some resource types require continuous recording</em>
         *                      <p>
         *                      AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      You can also override the recording frequency for specific resource types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingMode(software.amazon.awscdk.IResolvable recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationRecorderProps#getRecordingMode}
         * @param recordingMode Specifies the default recording frequency for the configuration recorder. AWS Config supports <em>Continuous recording</em> and <em>Daily recording</em> .
         *                      <ul>
         *                      <li>Continuous recording allows you to record configuration changes continuously whenever a change occurs.</li>
         *                      <li>Daily recording allows you to receive a configuration item (CI) representing the most recent state of your resources over the last 24-hour period, only if it’s different from the previous CI recorded.</li>
         *                      </ul>
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      <em>Some resource types require continuous recording</em>
         *                      <p>
         *                      AWS Firewall Manager depends on continuous recording to monitor your resources. If you are using Firewall Manager, it is recommended that you set the recording frequency to Continuous.
         *                      <p>
         *                      </blockquote>
         *                      <p>
         *                      You can also override the recording frequency for specific resource types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingMode(software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingModeProperty recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationRecorderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationRecorderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationRecorderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationRecorderProps {
        private final java.lang.String roleArn;
        private final java.lang.String name;
        private final java.lang.Object recordingGroup;
        private final java.lang.Object recordingMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingGroup = software.amazon.jsii.Kernel.get(this, "recordingGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.recordingMode = software.amazon.jsii.Kernel.get(this, "recordingMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.name = builder.name;
            this.recordingGroup = builder.recordingGroup;
            this.recordingMode = builder.recordingMode;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRecordingGroup() {
            return this.recordingGroup;
        }

        @Override
        public final java.lang.Object getRecordingMode() {
            return this.recordingMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRecordingGroup() != null) {
                data.set("recordingGroup", om.valueToTree(this.getRecordingGroup()));
            }
            if (this.getRecordingMode() != null) {
                data.set("recordingMode", om.valueToTree(this.getRecordingMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationRecorderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationRecorderProps.Jsii$Proxy that = (CfnConfigurationRecorderProps.Jsii$Proxy) o;

            if (!roleArn.equals(that.roleArn)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.recordingGroup != null ? !this.recordingGroup.equals(that.recordingGroup) : that.recordingGroup != null) return false;
            return this.recordingMode != null ? this.recordingMode.equals(that.recordingMode) : that.recordingMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.roleArn.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.recordingGroup != null ? this.recordingGroup.hashCode() : 0);
            result = 31 * result + (this.recordingMode != null ? this.recordingMode.hashCode() : 0);
            return result;
        }
    }
}
