package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnSecurityProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnSecurityProfileProps cfnSecurityProfileProps = CfnSecurityProfileProps.builder()
 *         .instanceArn("instanceArn")
 *         .securityProfileName("securityProfileName")
 *         // the properties below are optional
 *         .allowedAccessControlHierarchyGroupId("allowedAccessControlHierarchyGroupId")
 *         .allowedAccessControlTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .applications(List.of(ApplicationProperty.builder()
 *                 .applicationPermissions(List.of("applicationPermissions"))
 *                 .namespace("namespace")
 *                 .build()))
 *         .description("description")
 *         .hierarchyRestrictedResources(List.of("hierarchyRestrictedResources"))
 *         .permissions(List.of("permissions"))
 *         .tagRestrictedResources(List.of("tagRestrictedResources"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:20.061Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Connect instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The name for the security profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-securityprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-securityprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityProfileName();

    /**
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontrolhierarchygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontrolhierarchygroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAllowedAccessControlHierarchyGroupId() {
        return null;
    }

    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedAccessControlTags() {
        return null;
    }

    /**
     * A list of third-party applications that the security profile will give access to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplications() {
        return null;
    }

    /**
     * The description of the security profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
     * <p>
     * Following are acceptable ResourceNames: <code>User</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-hierarchyrestrictedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-hierarchyrestrictedresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHierarchyRestrictedResources() {
        return null;
    }

    /**
     * Permissions assigned to the security profile.
     * <p>
     * For a list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
        return null;
    }

    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tagrestrictedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tagrestrictedresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagRestrictedResources() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityProfileProps> {
        java.lang.String instanceArn;
        java.lang.String securityProfileName;
        java.lang.String allowedAccessControlHierarchyGroupId;
        java.lang.Object allowedAccessControlTags;
        java.lang.Object applications;
        java.lang.String description;
        java.util.List<java.lang.String> hierarchyRestrictedResources;
        java.util.List<java.lang.String> permissions;
        java.util.List<java.lang.String> tagRestrictedResources;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getInstanceArn}
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getSecurityProfileName}
         * @param securityProfileName The name for the security profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileName(java.lang.String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAllowedAccessControlHierarchyGroupId}
         * @param allowedAccessControlHierarchyGroupId The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlHierarchyGroupId(java.lang.String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAllowedAccessControlTags}
         * @param allowedAccessControlTags The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlTags(software.amazon.awscdk.IResolvable allowedAccessControlTags) {
            this.allowedAccessControlTags = allowedAccessControlTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAllowedAccessControlTags}
         * @param allowedAccessControlTags The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlTags(java.util.List<? extends java.lang.Object> allowedAccessControlTags) {
            this.allowedAccessControlTags = allowedAccessControlTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getApplications}
         * @param applications A list of third-party applications that the security profile will give access to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(software.amazon.awscdk.IResolvable applications) {
            this.applications = applications;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getApplications}
         * @param applications A list of third-party applications that the security profile will give access to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(java.util.List<? extends java.lang.Object> applications) {
            this.applications = applications;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getDescription}
         * @param description The description of the security profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getHierarchyRestrictedResources}
         * @param hierarchyRestrictedResources The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         *                                     Following are acceptable ResourceNames: <code>User</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hierarchyRestrictedResources(java.util.List<java.lang.String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = hierarchyRestrictedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getPermissions}
         * @param permissions Permissions assigned to the security profile.
         *                    For a list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<java.lang.String> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getTagRestrictedResources}
         * @param tagRestrictedResources The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagRestrictedResources(java.util.List<java.lang.String> tagRestrictedResources) {
            this.tagRestrictedResources = tagRestrictedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         *             For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityProfileProps {
        private final java.lang.String instanceArn;
        private final java.lang.String securityProfileName;
        private final java.lang.String allowedAccessControlHierarchyGroupId;
        private final java.lang.Object allowedAccessControlTags;
        private final java.lang.Object applications;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> hierarchyRestrictedResources;
        private final java.util.List<java.lang.String> permissions;
        private final java.util.List<java.lang.String> tagRestrictedResources;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityProfileName = software.amazon.jsii.Kernel.get(this, "securityProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowedAccessControlHierarchyGroupId = software.amazon.jsii.Kernel.get(this, "allowedAccessControlHierarchyGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowedAccessControlTags = software.amazon.jsii.Kernel.get(this, "allowedAccessControlTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hierarchyRestrictedResources = software.amazon.jsii.Kernel.get(this, "hierarchyRestrictedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tagRestrictedResources = software.amazon.jsii.Kernel.get(this, "tagRestrictedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.securityProfileName = java.util.Objects.requireNonNull(builder.securityProfileName, "securityProfileName is required");
            this.allowedAccessControlHierarchyGroupId = builder.allowedAccessControlHierarchyGroupId;
            this.allowedAccessControlTags = builder.allowedAccessControlTags;
            this.applications = builder.applications;
            this.description = builder.description;
            this.hierarchyRestrictedResources = builder.hierarchyRestrictedResources;
            this.permissions = builder.permissions;
            this.tagRestrictedResources = builder.tagRestrictedResources;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final java.lang.String getAllowedAccessControlHierarchyGroupId() {
            return this.allowedAccessControlHierarchyGroupId;
        }

        @Override
        public final java.lang.Object getAllowedAccessControlTags() {
            return this.allowedAccessControlTags;
        }

        @Override
        public final java.lang.Object getApplications() {
            return this.applications;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getHierarchyRestrictedResources() {
            return this.hierarchyRestrictedResources;
        }

        @Override
        public final java.util.List<java.lang.String> getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<java.lang.String> getTagRestrictedResources() {
            return this.tagRestrictedResources;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("securityProfileName", om.valueToTree(this.getSecurityProfileName()));
            if (this.getAllowedAccessControlHierarchyGroupId() != null) {
                data.set("allowedAccessControlHierarchyGroupId", om.valueToTree(this.getAllowedAccessControlHierarchyGroupId()));
            }
            if (this.getAllowedAccessControlTags() != null) {
                data.set("allowedAccessControlTags", om.valueToTree(this.getAllowedAccessControlTags()));
            }
            if (this.getApplications() != null) {
                data.set("applications", om.valueToTree(this.getApplications()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHierarchyRestrictedResources() != null) {
                data.set("hierarchyRestrictedResources", om.valueToTree(this.getHierarchyRestrictedResources()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getTagRestrictedResources() != null) {
                data.set("tagRestrictedResources", om.valueToTree(this.getTagRestrictedResources()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityProfileProps.Jsii$Proxy that = (CfnSecurityProfileProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!securityProfileName.equals(that.securityProfileName)) return false;
            if (this.allowedAccessControlHierarchyGroupId != null ? !this.allowedAccessControlHierarchyGroupId.equals(that.allowedAccessControlHierarchyGroupId) : that.allowedAccessControlHierarchyGroupId != null) return false;
            if (this.allowedAccessControlTags != null ? !this.allowedAccessControlTags.equals(that.allowedAccessControlTags) : that.allowedAccessControlTags != null) return false;
            if (this.applications != null ? !this.applications.equals(that.applications) : that.applications != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.hierarchyRestrictedResources != null ? !this.hierarchyRestrictedResources.equals(that.hierarchyRestrictedResources) : that.hierarchyRestrictedResources != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.tagRestrictedResources != null ? !this.tagRestrictedResources.equals(that.tagRestrictedResources) : that.tagRestrictedResources != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.securityProfileName.hashCode());
            result = 31 * result + (this.allowedAccessControlHierarchyGroupId != null ? this.allowedAccessControlHierarchyGroupId.hashCode() : 0);
            result = 31 * result + (this.allowedAccessControlTags != null ? this.allowedAccessControlTags.hashCode() : 0);
            result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.hierarchyRestrictedResources != null ? this.hierarchyRestrictedResources.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.tagRestrictedResources != null ? this.tagRestrictedResources.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
