package software.amazon.awscdk.services.dynamodb;

/**
 * Reference to WarmThroughput for a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .warmThroughput(WarmThroughput.builder()
 *                 .readUnitsPerSecond(15000)
 *                 .writeUnitsPerSecond(20000)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:20.779Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.WarmThroughput")
@software.amazon.jsii.Jsii.Proxy(WarmThroughput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WarmThroughput extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configures the number of read units per second a table will be able to handle instantly.
     * <p>
     * Default: - no readUnitsPerSecond configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReadUnitsPerSecond() {
        return null;
    }

    /**
     * Configures the number of write units per second a table will be able to handle instantly.
     * <p>
     * Default: - no writeUnitsPerSecond configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWriteUnitsPerSecond() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WarmThroughput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WarmThroughput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WarmThroughput> {
        java.lang.Number readUnitsPerSecond;
        java.lang.Number writeUnitsPerSecond;

        /**
         * Sets the value of {@link WarmThroughput#getReadUnitsPerSecond}
         * @param readUnitsPerSecond Configures the number of read units per second a table will be able to handle instantly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readUnitsPerSecond(java.lang.Number readUnitsPerSecond) {
            this.readUnitsPerSecond = readUnitsPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link WarmThroughput#getWriteUnitsPerSecond}
         * @param writeUnitsPerSecond Configures the number of write units per second a table will be able to handle instantly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeUnitsPerSecond(java.lang.Number writeUnitsPerSecond) {
            this.writeUnitsPerSecond = writeUnitsPerSecond;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WarmThroughput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WarmThroughput build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WarmThroughput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WarmThroughput {
        private final java.lang.Number readUnitsPerSecond;
        private final java.lang.Number writeUnitsPerSecond;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "readUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.writeUnitsPerSecond = software.amazon.jsii.Kernel.get(this, "writeUnitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readUnitsPerSecond = builder.readUnitsPerSecond;
            this.writeUnitsPerSecond = builder.writeUnitsPerSecond;
        }

        @Override
        public final java.lang.Number getReadUnitsPerSecond() {
            return this.readUnitsPerSecond;
        }

        @Override
        public final java.lang.Number getWriteUnitsPerSecond() {
            return this.writeUnitsPerSecond;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getReadUnitsPerSecond() != null) {
                data.set("readUnitsPerSecond", om.valueToTree(this.getReadUnitsPerSecond()));
            }
            if (this.getWriteUnitsPerSecond() != null) {
                data.set("writeUnitsPerSecond", om.valueToTree(this.getWriteUnitsPerSecond()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.WarmThroughput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WarmThroughput.Jsii$Proxy that = (WarmThroughput.Jsii$Proxy) o;

            if (this.readUnitsPerSecond != null ? !this.readUnitsPerSecond.equals(that.readUnitsPerSecond) : that.readUnitsPerSecond != null) return false;
            return this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.equals(that.writeUnitsPerSecond) : that.writeUnitsPerSecond == null;
        }

        @Override
        public final int hashCode() {
            int result = this.readUnitsPerSecond != null ? this.readUnitsPerSecond.hashCode() : 0;
            result = 31 * result + (this.writeUnitsPerSecond != null ? this.writeUnitsPerSecond.hashCode() : 0);
            return result;
        }
    }
}
