package software.amazon.awscdk.services.ec2;

/**
 * Supported EBS volume types for blockDevices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("/dev/sda1")
 *                 .volume(BlockDeviceVolume.ebs(100, EbsDeviceOptions.builder()
 *                         .volumeType(EbsDeviceVolumeType.GP3)
 *                         .throughput(250)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:21.357Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EbsDeviceVolumeType")
public enum EbsDeviceVolumeType {
    /**
     * Magnetic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Provisioned IOPS SSD - IO1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO1,
    /**
     * Provisioned IOPS SSD - IO2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO2,
    /**
     * General Purpose SSD - GP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP2,
    /**
     * General Purpose SSD - GP3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP3,
    /**
     * Throughput Optimized HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ST1,
    /**
     * Cold HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SC1,
}
