package software.amazon.awscdk.services.ecs;

/**
 * The process namespace to use for the containers in the task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FargateTaskDefinition fargateTaskDefinition = FargateTaskDefinition.Builder.create(this, "TaskDef")
 *         .runtimePlatform(RuntimePlatform.builder()
 *                 .operatingSystemFamily(OperatingSystemFamily.LINUX)
 *                 .cpuArchitecture(CpuArchitecture.ARM64)
 *                 .build())
 *         .memoryLimitMiB(512)
 *         .cpu(256)
 *         .pidMode(PidMode.TASK)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:21.885Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PidMode")
public enum PidMode {
    /**
     * If host is specified, then all containers within the tasks that specified the host PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HOST,
    /**
     * If task is specified, all containers within the specified task share the same process namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TASK,
}
