package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the NetworkMultipleTargetGroupsFargateService service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Two network load balancers, each with their own listener and target group.
 * Cluster cluster;
 * NetworkMultipleTargetGroupsFargateService loadBalancedFargateService = NetworkMultipleTargetGroupsFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .taskImageOptions(NetworkLoadBalancedTaskImageProps.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .loadBalancers(List.of(NetworkLoadBalancerProps.builder()
 *                 .name("lb1")
 *                 .listeners(List.of(NetworkListenerProps.builder()
 *                         .name("listener1")
 *                         .build()))
 *                 .build(), NetworkLoadBalancerProps.builder()
 *                 .name("lb2")
 *                 .listeners(List.of(NetworkListenerProps.builder()
 *                         .name("listener2")
 *                         .build()))
 *                 .build()))
 *         .targetGroups(List.of(NetworkTargetProps.builder()
 *                 .containerPort(80)
 *                 .listener("listener1")
 *                 .build(), NetworkTargetProps.builder()
 *                 .containerPort(90)
 *                 .listener("listener2")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.011Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.NetworkMultipleTargetGroupsFargateServiceProps")
@software.amazon.jsii.Jsii.Proxy(NetworkMultipleTargetGroupsFargateServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkMultipleTargetGroupsFargateServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.NetworkMultipleTargetGroupsServiceBaseProps, software.amazon.awscdk.services.ecs.patterns.FargateServiceBaseProps {

    /**
     * Determines whether the service will be assigned a public IP address.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkMultipleTargetGroupsFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkMultipleTargetGroupsFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NetworkMultipleTargetGroupsFargateServiceProps> {
        java.lang.Boolean assignPublicIp;
        software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        java.lang.Number desiredCount;
        java.lang.Boolean enableEcsManagedTags;
        java.lang.Boolean enableExecuteCommand;
        software.amazon.awscdk.Duration healthCheckGracePeriod;
        java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps> loadBalancers;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        java.lang.String serviceName;
        java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps> targetGroups;
        software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps taskImageOptions;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Number cpu;
        java.lang.Number ephemeralStorageGiB;
        java.lang.Number memoryLimitMiB;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getAssignPublicIp}
         * @param assignPublicIp Determines whether the service will be assigned a public IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         *                     The minimum value is 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether ECS Exec should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getLoadBalancers}
         * @param loadBalancers The network load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadBalancers(java.util.List<? extends software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps> loadBalancers) {
            this.loadBalancers = (java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps>)loadBalancers;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getServiceName}
         * @param serviceName Name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getTargetGroups}
         * @param targetGroups Properties to specify NLB target groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targetGroups(java.util.List<? extends software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps> targetGroups) {
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps>)targetGroups;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         Only one of TaskDefinition or TaskImageOptions must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            Valid values, which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         *            <p>
         *            8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
         *            <p>
         *            16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
         *            <p>
         *            This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getEphemeralStorageGiB}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task.
         *                            The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         *                            <p>
         *                            Only supported in Fargate platform version 1.4.0 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(java.lang.Number ephemeralStorageGiB) {
            this.ephemeralStorageGiB = ephemeralStorageGiB;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task.
         *                       This field is required and you must use one of the following values, which determines your range of valid values
         *                       for the cpu parameter:
         *                       <p>
         *                       512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         *                       <p>
         *                       1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         *                       <p>
         *                       2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         *                       <p>
         *                       Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         *                       <p>
         *                       Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         *                       <p>
         *                       Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         *                       <p>
         *                       Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         *                       <p>
         *                       This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getPlatformVersion}
         * @param platformVersion The platform version on which to run your service.
         *                        If one is not specified, the LATEST platform version is used by default. For more information, see
         *                        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         *                        in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getRuntimePlatform}
         * @param runtimePlatform The runtime platform of the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link NetworkMultipleTargetGroupsFargateServiceProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkMultipleTargetGroupsFargateServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NetworkMultipleTargetGroupsFargateServiceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NetworkMultipleTargetGroupsFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkMultipleTargetGroupsFargateServiceProps {
        private final java.lang.Boolean assignPublicIp;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredCount;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final software.amazon.awscdk.Duration healthCheckGracePeriod;
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps> loadBalancers;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.String serviceName;
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps> targetGroups;
        private final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Number cpu;
        private final java.lang.Number ephemeralStorageGiB;
        private final java.lang.Number memoryLimitMiB;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        private final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cloudMapOptions = software.amazon.jsii.Kernel.get(this, "cloudMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CloudMapOptions.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.desiredCount = software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.loadBalancers = software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps.class)));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps.class)));
            this.taskImageOptions = software.amazon.jsii.Kernel.get(this, "taskImageOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ephemeralStorageGiB = software.amazon.jsii.Kernel.get(this, "ephemeralStorageGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.memoryLimitMiB = software.amazon.jsii.Kernel.get(this, "memoryLimitMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.RuntimePlatform.class));
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignPublicIp = builder.assignPublicIp;
            this.cloudMapOptions = builder.cloudMapOptions;
            this.cluster = builder.cluster;
            this.desiredCount = builder.desiredCount;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.enableExecuteCommand = builder.enableExecuteCommand;
            this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
            this.loadBalancers = (java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps>)builder.loadBalancers;
            this.propagateTags = builder.propagateTags;
            this.serviceName = builder.serviceName;
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps>)builder.targetGroups;
            this.taskImageOptions = builder.taskImageOptions;
            this.vpc = builder.vpc;
            this.cpu = builder.cpu;
            this.ephemeralStorageGiB = builder.ephemeralStorageGiB;
            this.memoryLimitMiB = builder.memoryLimitMiB;
            this.platformVersion = builder.platformVersion;
            this.runtimePlatform = builder.runtimePlatform;
            this.taskDefinition = builder.taskDefinition;
        }

        @Override
        public final java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final software.amazon.awscdk.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.patterns.NetworkTargetProps> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageProps getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Number getEphemeralStorageGiB() {
            return this.ephemeralStorageGiB;
        }

        @Override
        public final java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.RuntimePlatform getRuntimePlatform() {
            return this.runtimePlatform;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getLoadBalancers() != null) {
                data.set("loadBalancers", om.valueToTree(this.getLoadBalancers()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEphemeralStorageGiB() != null) {
                data.set("ephemeralStorageGiB", om.valueToTree(this.getEphemeralStorageGiB()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getRuntimePlatform() != null) {
                data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
            }
            if (this.getTaskDefinition() != null) {
                data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.NetworkMultipleTargetGroupsFargateServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkMultipleTargetGroupsFargateServiceProps.Jsii$Proxy that = (NetworkMultipleTargetGroupsFargateServiceProps.Jsii$Proxy) o;

            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.loadBalancers != null ? !this.loadBalancers.equals(that.loadBalancers) : that.loadBalancers != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.ephemeralStorageGiB != null ? !this.ephemeralStorageGiB.equals(that.ephemeralStorageGiB) : that.ephemeralStorageGiB != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
            return this.taskDefinition != null ? this.taskDefinition.equals(that.taskDefinition) : that.taskDefinition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.loadBalancers != null ? this.loadBalancers.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorageGiB != null ? this.ephemeralStorageGiB.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
            result = 31 * result + (this.taskDefinition != null ? this.taskDefinition.hashCode() : 0);
            return result;
        }
    }
}
