package software.amazon.awscdk.services.elasticache;

/**
 * Properties for defining a <code>CfnUser</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * Object authenticationMode;
 * CfnUserProps cfnUserProps = CfnUserProps.builder()
 *         .engine("engine")
 *         .userId("userId")
 *         .userName("userName")
 *         // the properties below are optional
 *         .accessString("accessString")
 *         .authenticationMode(authenticationMode)
 *         .noPasswordRequired(false)
 *         .passwords(List.of("passwords"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.321Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The current supported values are valkey and redis.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * The ID of the user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-userid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-userid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserId();

    /**
     * The username of the user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-username</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserName();

    /**
     * Access permissions string used for this user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-accessstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-accessstring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessString() {
        return null;
    }

    /**
     * Specifies the authentication mode to use. Below is an example of the possible JSON values:.
     * <p>
     * <blockquote><pre>
     * { Passwords: ["*****", "******"] // If Type is password.
     * }
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-authenticationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-authenticationmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationMode() {
        return null;
    }

    /**
     * Indicates a password is not required for this user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-nopasswordrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-nopasswordrequired</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNoPasswordRequired() {
        return null;
    }

    /**
     * Passwords used for this user.
     * <p>
     * You can create up to two passwords for each user.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-passwords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-passwords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPasswords() {
        return null;
    }

    /**
     * The list of tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticache-user.html#cfn-elasticache-user-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProps> {
        java.lang.String engine;
        java.lang.String userId;
        java.lang.String userName;
        java.lang.String accessString;
        java.lang.Object authenticationMode;
        java.lang.Object noPasswordRequired;
        java.util.List<java.lang.String> passwords;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnUserProps#getEngine}
         * @param engine The current supported values are valkey and redis. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getUserId}
         * @param userId The ID of the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userId(java.lang.String userId) {
            this.userId = userId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getUserName}
         * @param userName The username of the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userName(java.lang.String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getAccessString}
         * @param accessString Access permissions string used for this user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessString(java.lang.String accessString) {
            this.accessString = accessString;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getAuthenticationMode}
         * @param authenticationMode Specifies the authentication mode to use. Below is an example of the possible JSON values:.
         *                           <blockquote><pre>
         *                           { Passwords: ["*****", "******"] // If Type is password.
         *                           }
         *                           </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationMode(java.lang.Object authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getNoPasswordRequired}
         * @param noPasswordRequired Indicates a password is not required for this user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noPasswordRequired(java.lang.Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getNoPasswordRequired}
         * @param noPasswordRequired Indicates a password is not required for this user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noPasswordRequired(software.amazon.awscdk.IResolvable noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPasswords}
         * @param passwords Passwords used for this user.
         *                  You can create up to two passwords for each user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwords(java.util.List<java.lang.String> passwords) {
            this.passwords = passwords;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getTags}
         * @param tags The list of tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProps {
        private final java.lang.String engine;
        private final java.lang.String userId;
        private final java.lang.String userName;
        private final java.lang.String accessString;
        private final java.lang.Object authenticationMode;
        private final java.lang.Object noPasswordRequired;
        private final java.util.List<java.lang.String> passwords;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userId = software.amazon.jsii.Kernel.get(this, "userId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessString = software.amazon.jsii.Kernel.get(this, "accessString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authenticationMode = software.amazon.jsii.Kernel.get(this, "authenticationMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.noPasswordRequired = software.amazon.jsii.Kernel.get(this, "noPasswordRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.passwords = software.amazon.jsii.Kernel.get(this, "passwords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.userId = java.util.Objects.requireNonNull(builder.userId, "userId is required");
            this.userName = java.util.Objects.requireNonNull(builder.userName, "userName is required");
            this.accessString = builder.accessString;
            this.authenticationMode = builder.authenticationMode;
            this.noPasswordRequired = builder.noPasswordRequired;
            this.passwords = builder.passwords;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getUserId() {
            return this.userId;
        }

        @Override
        public final java.lang.String getUserName() {
            return this.userName;
        }

        @Override
        public final java.lang.String getAccessString() {
            return this.accessString;
        }

        @Override
        public final java.lang.Object getAuthenticationMode() {
            return this.authenticationMode;
        }

        @Override
        public final java.lang.Object getNoPasswordRequired() {
            return this.noPasswordRequired;
        }

        @Override
        public final java.util.List<java.lang.String> getPasswords() {
            return this.passwords;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("userId", om.valueToTree(this.getUserId()));
            data.set("userName", om.valueToTree(this.getUserName()));
            if (this.getAccessString() != null) {
                data.set("accessString", om.valueToTree(this.getAccessString()));
            }
            if (this.getAuthenticationMode() != null) {
                data.set("authenticationMode", om.valueToTree(this.getAuthenticationMode()));
            }
            if (this.getNoPasswordRequired() != null) {
                data.set("noPasswordRequired", om.valueToTree(this.getNoPasswordRequired()));
            }
            if (this.getPasswords() != null) {
                data.set("passwords", om.valueToTree(this.getPasswords()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProps.Jsii$Proxy that = (CfnUserProps.Jsii$Proxy) o;

            if (!engine.equals(that.engine)) return false;
            if (!userId.equals(that.userId)) return false;
            if (!userName.equals(that.userName)) return false;
            if (this.accessString != null ? !this.accessString.equals(that.accessString) : that.accessString != null) return false;
            if (this.authenticationMode != null ? !this.authenticationMode.equals(that.authenticationMode) : that.authenticationMode != null) return false;
            if (this.noPasswordRequired != null ? !this.noPasswordRequired.equals(that.noPasswordRequired) : that.noPasswordRequired != null) return false;
            if (this.passwords != null ? !this.passwords.equals(that.passwords) : that.passwords != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.engine.hashCode();
            result = 31 * result + (this.userId.hashCode());
            result = 31 * result + (this.userName.hashCode());
            result = 31 * result + (this.accessString != null ? this.accessString.hashCode() : 0);
            result = 31 * result + (this.authenticationMode != null ? this.authenticationMode.hashCode() : 0);
            result = 31 * result + (this.noPasswordRequired != null ? this.noPasswordRequired.hashCode() : 0);
            result = 31 * result + (this.passwords != null ? this.passwords.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
