package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * A load balancer with a single listener.
 * <p>
 * Routes to a fleet of of instances in a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Vpc vpc;
 * Ec2Service service = Ec2Service.Builder.create(this, "Service").cluster(cluster).taskDefinition(taskDefinition).build();
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB").vpc(vpc).build();
 * lb.addListener(LoadBalancerListener.builder().externalPort(80).build());
 * lb.addTarget(service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("MyContainer")
 *         .containerPort(80)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.357Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancing.LoadBalancer")
public class LoadBalancer extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IConnectable {

    protected LoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LoadBalancer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a backend to the load balancer.
     * <p>
     * @return A ListenerPort object that controls connections to the listener port
     * @param listener This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.ListenerPort addListener(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener listener) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.ListenerPort.class), new Object[] { java.util.Objects.requireNonNull(listener, "listener is required") });
    }

    /**
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget target) {
        software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Control all connections from and to this load balancer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * An object controlling specifically the connections for each listener added to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ListenerPort> getListenerPorts() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "listenerPorts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancing.ListenerPort.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerCanonicalHostedZoneName() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerCanonicalHostedZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerCanonicalHostedZoneNameId() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerCanonicalHostedZoneNameId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerDnsName() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerSourceSecurityGroupGroupName() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerSourceSecurityGroupGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerSourceSecurityGroupOwnerAlias() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancerSourceSecurityGroupOwnerAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps.Builder();
        }

        /**
         * VPC network of the fleet instances.
         * <p>
         * @return {@code this}
         * @param vpc VPC network of the fleet instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Enable Loadbalancer access logs Can be used to avoid manual work as aws console Required S3 bucket name , enabled flag Can add interval for pushing log Can set bucket prefix in order to provide folder name inside bucket.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param accessLoggingPolicy Enable Loadbalancer access logs Can be used to avoid manual work as aws console Required S3 bucket name , enabled flag Can add interval for pushing log Can set bucket prefix in order to provide folder name inside bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }

        /**
         * Whether cross zone load balancing is enabled.
         * <p>
         * This controls whether the load balancer evenly distributes requests
         * across each availability zone
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param crossZone Whether cross zone load balancing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(final java.lang.Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        /**
         * Health check settings for the load balancing targets.
         * <p>
         * Not required but recommended.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param healthCheck Health check settings for the load balancing targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * Whether this is an internet-facing Load Balancer.
         * <p>
         * This controls whether the LB has a public IP address assigned. It does
         * not open up the Load Balancer's security groups to public internet access.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param internetFacing Whether this is an internet-facing Load Balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(final java.lang.Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        /**
         * What listeners to set up for the load balancer.
         * <p>
         * Can also be added by .addListener()
         * <p>
         * Default: -
         * <p>
         * @return {@code this}
         * @param listeners What listeners to set up for the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * Which subnets to deploy the load balancer.
         * <p>
         * Can be used to define a specific set of subnets to deploy the load balancer to.
         * Useful multiple public or private subnets are covering the same availability zone.
         * <p>
         * Default: - Public subnets if internetFacing, Private subnets otherwise
         * <p>
         * @return {@code this}
         * @param subnetSelection Which subnets to deploy the load balancer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * What targets to load balance to.
         * <p>
         * Can also be added by .addTarget()
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param targets What targets to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
