/**
 * <h1>Amazon Elastic Load Balancing Construct Library</h1>
 * <p>
 * The <code>aws-cdk-lib/aws-elasticloadbalancing</code> package provides constructs for configuring
 * classic load balancers.
 * <p>
 * <h2>Configuring a Load Balancer</h2>
 * <p>
 * Load balancers send traffic to one or more AutoScalingGroups. Create a load
 * balancer, set up listeners and a health check, and supply the fleet(s) you want
 * to load balance to in the <code>targets</code> property. If you want the load balancer to be
 * accessible from the internet, set <code>internetFacing: true</code>.
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * 
 * AutoScalingGroup myAutoScalingGroup;
 * 
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .healthCheck(HealthCheck.builder()
 *                 .port(80)
 *                 .build())
 *         .build();
 * lb.addTarget(myAutoScalingGroup);
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .build());
 * </pre></blockquote>
 * <p>
 * The load balancer allows all connections by default. If you want to change that,
 * pass the <code>allowConnectionsFrom</code> property while setting up the listener:
 * <p>
 * <blockquote><pre>
 * SecurityGroup mySecurityGroup;
 * LoadBalancer lb;
 * 
 * lb.addListener(LoadBalancerListener.builder()
 *         .externalPort(80)
 *         .allowConnectionsFrom(List.of(mySecurityGroup))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Adding Ec2 Instance as a target for the load balancer</h3>
 * <p>
 * You can add an EC2 instance to the load balancer by calling using <code>new InstanceTarget</code> as the argument to <code>addTarget()</code>:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * 
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * 
 * // instance to add as the target for load balancer.
 * Instance instance = Instance.Builder.create(this, "targetInstance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(AmazonLinuxImage.Builder.create().generation(AmazonLinuxGeneration.AMAZON_LINUX_2).build())
 *         .build();
 * lb.addTarget(new InstanceTarget(instance));
 * </pre></blockquote>
 */
package software.amazon.awscdk.services.elasticloadbalancing;
