package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * The client certificate handling method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * Certificate certificate;
 * ApplicationLoadBalancer lb;
 * Bucket bucket;
 * TrustStore trustStore = TrustStore.Builder.create(this, "Store")
 *         .bucket(bucket)
 *         .key("rootCA_cert.pem")
 *         .build();
 * lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(443)
 *         .protocol(ApplicationProtocol.HTTPS)
 *         .certificates(List.of(certificate))
 *         // mTLS settings
 *         .mutualAuthentication(MutualAuthentication.builder()
 *                 .ignoreClientCertificateExpiry(false)
 *                 .mutualAuthenticationMode(MutualAuthenticationMode.VERIFY)
 *                 .trustStore(trustStore)
 *                 .build())
 *         .defaultAction(ListenerAction.fixedResponse(200, FixedResponseOptions.builder().contentType("text/plain").messageBody("Success mTLS").build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.MutualAuthenticationMode")
public enum MutualAuthenticationMode {
    /**
     * Off.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OFF,
    /**
     * Application Load Balancer sends the whole client certificate chain to the target using HTTP headers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PASS_THROUGH,
    /**
     * Application Load Balancer performs X.509 client certificate authentication for clients when a load balancer negotiates TLS connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VERIFY,
}
