package software.amazon.awscdk.services.elasticloadbalancingv2.targets;

/**
 * A single Application Load Balancer's listener as the target for load balancing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.targets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * Vpc vpc;
 * FargateTaskDefinition task = FargateTaskDefinition.Builder.create(this, "Task").cpu(256).memoryLimitMiB(512).build();
 * task.addContainer("nginx", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("public.ecr.aws/nginx/nginx:latest"))
 *         .portMappings(List.of(PortMapping.builder().containerPort(80).build()))
 *         .build());
 * ApplicationLoadBalancedFargateService svc = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .vpc(vpc)
 *         .taskDefinition(task)
 *         .publicLoadBalancer(false)
 *         .build();
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "Nlb")
 *         .vpc(vpc)
 *         .crossZoneEnabled(true)
 *         .internetFacing(true)
 *         .build();
 * NetworkListener listener = nlb.addListener("listener", BaseNetworkListenerProps.builder().port(80).build());
 * listener.addTargets("Targets", AddNetworkTargetsProps.builder()
 *         .targets(List.of(new AlbListenerTarget(svc.getListener())))
 *         .port(80)
 *         .build());
 * CfnOutput.Builder.create(this, "NlbEndpoint").value(String.format("http://%s", nlb.getLoadBalancerDnsName())).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.538Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2_targets.AlbListenerTarget")
public class AlbListenerTarget extends software.amazon.awscdk.services.elasticloadbalancingv2.targets.AlbArnTarget {

    protected AlbListenerTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AlbListenerTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a new ALB target.
     * <p>
     * The associated target group will automatically have a dependency added
     * against the ALB's listener.
     * <p>
     * @param albListener The application load balancer listener to target. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AlbListenerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener albListener) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(albListener, "albListener is required") });
    }

    /**
     * Register this ALB target with a load balancer.
     * <p>
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     * <p>
     * This adds dependency on albListener because creation of ALB listener and NLB can vary during runtime.
     * More Details on - https://github.com/aws/aws-cdk/issues/17208
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
