package software.amazon.awscdk.services.events;

/**
 * The properties to import an existing Api Destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IConnection connection = Connection.fromEventBusArn(this, "Connection", "arn:aws:events:us-east-1:123456789012:event-bus/EventBusName", "arn:aws:secretsmanager:us-east-1:123456789012:secret:SecretName-f3gDy9");
 * String apiDestinationArn = "arn:aws:events:us-east-1:123456789012:api-destination/DestinationName";
 * ApiDestination destination = ApiDestination.fromApiDestinationAttributes(this, "Destination", ApiDestinationAttributes.builder().apiDestinationArn(apiDestinationArn).connection(connection).build());
 * Rule rule = Rule.Builder.create(this, "OtherRule")
 *         .schedule(Schedule.rate(Duration.minutes(10)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.728Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.ApiDestinationAttributes")
@software.amazon.jsii.Jsii.Proxy(ApiDestinationAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiDestinationAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Api Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiDestinationArn();

    /**
     * The Connection to associate with the Api Destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection getConnection();

    /**
     * @return a {@link Builder} of {@link ApiDestinationAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiDestinationAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiDestinationAttributes> {
        java.lang.String apiDestinationArn;
        software.amazon.awscdk.services.events.IConnection connection;

        /**
         * Sets the value of {@link ApiDestinationAttributes#getApiDestinationArn}
         * @param apiDestinationArn The ARN of the Api Destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiDestinationArn(java.lang.String apiDestinationArn) {
            this.apiDestinationArn = apiDestinationArn;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationAttributes#getConnection}
         * @param connection The Connection to associate with the Api Destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connection(software.amazon.awscdk.services.events.IConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiDestinationAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiDestinationAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiDestinationAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiDestinationAttributes {
        private final java.lang.String apiDestinationArn;
        private final software.amazon.awscdk.services.events.IConnection connection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiDestinationArn = software.amazon.jsii.Kernel.get(this, "apiDestinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiDestinationArn = java.util.Objects.requireNonNull(builder.apiDestinationArn, "apiDestinationArn is required");
            this.connection = java.util.Objects.requireNonNull(builder.connection, "connection is required");
        }

        @Override
        public final java.lang.String getApiDestinationArn() {
            return this.apiDestinationArn;
        }

        @Override
        public final software.amazon.awscdk.services.events.IConnection getConnection() {
            return this.connection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiDestinationArn", om.valueToTree(this.getApiDestinationArn()));
            data.set("connection", om.valueToTree(this.getConnection()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.ApiDestinationAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiDestinationAttributes.Jsii$Proxy that = (ApiDestinationAttributes.Jsii$Proxy) o;

            if (!apiDestinationArn.equals(that.apiDestinationArn)) return false;
            return this.connection.equals(that.connection);
        }

        @Override
        public final int hashCode() {
            int result = this.apiDestinationArn.hashCode();
            result = 31 * result + (this.connection.hashCode());
            return result;
        }
    }
}
