package software.amazon.awscdk.services.events.targets;

/**
 * Customize the API Gateway Event Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .build();
 * Function fn = Function.Builder.create(this, "MyFunc")
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .code(Code.fromInline("exports.handler = e =&gt; {}"))
 *         .build();
 * LambdaRestApi restApi = LambdaRestApi.Builder.create(this, "MyRestAPI").handler(fn).build();
 * Queue dlq = new Queue(this, "DeadLetterQueue");
 * rule.addTarget(
 * ApiGateway.Builder.create(restApi)
 *         .path("/*&#47;test")
 *         .method("GET")
 *         .stage("prod")
 *         .pathParameterValues(List.of("path-value"))
 *         .headerParameters(Map.of(
 *                 "Header1", "header1"))
 *         .queryStringParameters(Map.of(
 *                 "QueryParam1", "query-param-1"))
 *         .deadLetterQueue(dlq)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.820Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.ApiGatewayProps")
@software.amazon.jsii.Jsii.Proxy(ApiGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiGatewayProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
     * <p>
     * Default: - a new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getEventRole() {
        return null;
    }

    /**
     * The headers to be set when requesting API.
     * <p>
     * Default: no header parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getHeaderParameters() {
        return null;
    }

    /**
     * The method for api resource invoked by the rule.
     * <p>
     * Default: '*' that treated as ANY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
        return null;
    }

    /**
     * The api resource invoked by the rule.
     * <p>
     * We can use wildcards('*') to specify the path. In that case,
     * an equal number of real values must be specified for pathParameterValues.
     * <p>
     * Default: '/'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * The path parameter values to be used to populate to wildcards("*") of requesting api path.
     * <p>
     * Default: no path parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathParameterValues() {
        return null;
    }

    /**
     * This will be the post request body send to the API.
     * <p>
     * Default: the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getPostBody() {
        return null;
    }

    /**
     * The query parameters to be set when requesting API.
     * <p>
     * Default: no querystring parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getQueryStringParameters() {
        return null;
    }

    /**
     * The deploy stage of api gateway invoked by the rule.
     * <p>
     * Default: the value of deploymentStage.stageName of target api gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiGatewayProps> {
        software.amazon.awscdk.services.iam.IRole eventRole;
        java.util.Map<java.lang.String, java.lang.String> headerParameters;
        java.lang.String method;
        java.lang.String path;
        java.util.List<java.lang.String> pathParameterValues;
        software.amazon.awscdk.services.events.RuleTargetInput postBody;
        java.util.Map<java.lang.String, java.lang.String> queryStringParameters;
        java.lang.String stage;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link ApiGatewayProps#getEventRole}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(software.amazon.awscdk.services.iam.IRole eventRole) {
            this.eventRole = eventRole;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getHeaderParameters}
         * @param headerParameters The headers to be set when requesting API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerParameters(java.util.Map<java.lang.String, java.lang.String> headerParameters) {
            this.headerParameters = headerParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getMethod}
         * @param method The method for api resource invoked by the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(java.lang.String method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getPath}
         * @param path The api resource invoked by the rule.
         *             We can use wildcards('*') to specify the path. In that case,
         *             an equal number of real values must be specified for pathParameterValues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getPathParameterValues}
         * @param pathParameterValues The path parameter values to be used to populate to wildcards("*") of requesting api path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathParameterValues(java.util.List<java.lang.String> pathParameterValues) {
            this.pathParameterValues = pathParameterValues;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getPostBody}
         * @param postBody This will be the post request body send to the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postBody(software.amazon.awscdk.services.events.RuleTargetInput postBody) {
            this.postBody = postBody;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getQueryStringParameters}
         * @param queryStringParameters The query parameters to be set when requesting API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringParameters(java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getStage}
         * @param stage The deploy stage of api gateway invoked by the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiGatewayProps {
        private final software.amazon.awscdk.services.iam.IRole eventRole;
        private final java.util.Map<java.lang.String, java.lang.String> headerParameters;
        private final java.lang.String method;
        private final java.lang.String path;
        private final java.util.List<java.lang.String> pathParameterValues;
        private final software.amazon.awscdk.services.events.RuleTargetInput postBody;
        private final java.util.Map<java.lang.String, java.lang.String> queryStringParameters;
        private final java.lang.String stage;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventRole = software.amazon.jsii.Kernel.get(this, "eventRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathParameterValues = software.amazon.jsii.Kernel.get(this, "pathParameterValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.postBody = software.amazon.jsii.Kernel.get(this, "postBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventRole = builder.eventRole;
            this.headerParameters = builder.headerParameters;
            this.method = builder.method;
            this.path = builder.path;
            this.pathParameterValues = builder.pathParameterValues;
            this.postBody = builder.postBody;
            this.queryStringParameters = builder.queryStringParameters;
            this.stage = builder.stage;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getEventRole() {
            return this.eventRole;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getHeaderParameters() {
            return this.headerParameters;
        }

        @Override
        public final java.lang.String getMethod() {
            return this.method;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.util.List<java.lang.String> getPathParameterValues() {
            return this.pathParameterValues;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getPostBody() {
            return this.postBody;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        public final java.lang.String getStage() {
            return this.stage;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEventRole() != null) {
                data.set("eventRole", om.valueToTree(this.getEventRole()));
            }
            if (this.getHeaderParameters() != null) {
                data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
            }
            if (this.getMethod() != null) {
                data.set("method", om.valueToTree(this.getMethod()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPathParameterValues() != null) {
                data.set("pathParameterValues", om.valueToTree(this.getPathParameterValues()));
            }
            if (this.getPostBody() != null) {
                data.set("postBody", om.valueToTree(this.getPostBody()));
            }
            if (this.getQueryStringParameters() != null) {
                data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.ApiGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiGatewayProps.Jsii$Proxy that = (ApiGatewayProps.Jsii$Proxy) o;

            if (this.eventRole != null ? !this.eventRole.equals(that.eventRole) : that.eventRole != null) return false;
            if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.pathParameterValues != null ? !this.pathParameterValues.equals(that.pathParameterValues) : that.pathParameterValues != null) return false;
            if (this.postBody != null ? !this.postBody.equals(that.postBody) : that.postBody != null) return false;
            if (this.queryStringParameters != null ? !this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters != null) return false;
            if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventRole != null ? this.eventRole.hashCode() : 0;
            result = 31 * result + (this.headerParameters != null ? this.headerParameters.hashCode() : 0);
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.pathParameterValues != null ? this.pathParameterValues.hashCode() : 0);
            result = 31 * result + (this.postBody != null ? this.postBody.hashCode() : 0);
            result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
