package software.amazon.awscdk.services.events.targets;

/**
 * Options used when creating a target input template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * Rule rule;
 * rule.addTarget(CloudWatchLogGroup.Builder.create(logGroup)
 *         .logEvent(LogGroupTargetInput.fromObject(LogGroupTargetInputOptions.builder()
 *                 .timestamp(EventField.fromPath("$.time"))
 *                 .message(EventField.fromPath("$.detail-type"))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:22.852Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.LogGroupTargetInputOptions")
@software.amazon.jsii.Jsii.Proxy(LogGroupTargetInputOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogGroupTargetInputOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value provided here will be used in the Log "message" field.
     * <p>
     * This field must be a string. If an object is passed (e.g. JSON data)
     * it will not throw an error, but the message that makes it to
     * CloudWatch logs will be incorrect. This is a likely scenario if
     * doing something like: EventField.fromPath('$.detail') since in most cases
     * the <code>detail</code> field contains JSON data.
     * <p>
     * Default: EventField.detailType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMessage() {
        return null;
    }

    /**
     * The timestamp that will appear in the CloudWatch Logs record.
     * <p>
     * Default: EventField.time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimestamp() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogGroupTargetInputOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogGroupTargetInputOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogGroupTargetInputOptions> {
        java.lang.Object message;
        java.lang.Object timestamp;

        /**
         * Sets the value of {@link LogGroupTargetInputOptions#getMessage}
         * @param message The value provided here will be used in the Log "message" field.
         *                This field must be a string. If an object is passed (e.g. JSON data)
         *                it will not throw an error, but the message that makes it to
         *                CloudWatch logs will be incorrect. This is a likely scenario if
         *                doing something like: EventField.fromPath('$.detail') since in most cases
         *                the <code>detail</code> field contains JSON data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(java.lang.Object message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupTargetInputOptions#getTimestamp}
         * @param timestamp The timestamp that will appear in the CloudWatch Logs record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timestamp(java.lang.Object timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogGroupTargetInputOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogGroupTargetInputOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogGroupTargetInputOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupTargetInputOptions {
        private final java.lang.Object message;
        private final java.lang.Object timestamp;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.message = builder.message;
            this.timestamp = builder.timestamp;
        }

        @Override
        public final java.lang.Object getMessage() {
            return this.message;
        }

        @Override
        public final java.lang.Object getTimestamp() {
            return this.timestamp;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMessage() != null) {
                data.set("message", om.valueToTree(this.getMessage()));
            }
            if (this.getTimestamp() != null) {
                data.set("timestamp", om.valueToTree(this.getTimestamp()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.LogGroupTargetInputOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogGroupTargetInputOptions.Jsii$Proxy that = (LogGroupTargetInputOptions.Jsii$Proxy) o;

            if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
            return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
        }

        @Override
        public final int hashCode() {
            int result = this.message != null ? this.message.hashCode() : 0;
            result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
            return result;
        }
    }
}
