package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnThing</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingProps cfnThingProps = CfnThingProps.builder()
 *         .attributePayload(AttributePayloadProperty.builder()
 *                 .attributes(Map.of(
 *                         "attributesKey", "attributes"))
 *                 .build())
 *         .thingName("thingName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:23.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingProps")
@software.amazon.jsii.Jsii.Proxy(CfnThingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnThingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A string that contains up to three key value pairs.
     * <p>
     * Maximum length of 800. Duplicates not allowed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributePayload() {
        return null;
    }

    /**
     * The name of the thing to update.
     * <p>
     * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnThingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnThingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnThingProps> {
        java.lang.Object attributePayload;
        java.lang.String thingName;

        /**
         * Sets the value of {@link CfnThingProps#getAttributePayload}
         * @param attributePayload A string that contains up to three key value pairs.
         *                         Maximum length of 800. Duplicates not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributePayload(software.amazon.awscdk.IResolvable attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingProps#getAttributePayload}
         * @param attributePayload A string that contains up to three key value pairs.
         *                         Maximum length of 800. Duplicates not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributePayload(software.amazon.awscdk.services.iot.CfnThing.AttributePayloadProperty attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingProps#getThingName}
         * @param thingName The name of the thing to update.
         *                  You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingName(java.lang.String thingName) {
            this.thingName = thingName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnThingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnThingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnThingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnThingProps {
        private final java.lang.Object attributePayload;
        private final java.lang.String thingName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributePayload = software.amazon.jsii.Kernel.get(this, "attributePayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.thingName = software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributePayload = builder.attributePayload;
            this.thingName = builder.thingName;
        }

        @Override
        public final java.lang.Object getAttributePayload() {
            return this.attributePayload;
        }

        @Override
        public final java.lang.String getThingName() {
            return this.thingName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAttributePayload() != null) {
                data.set("attributePayload", om.valueToTree(this.getAttributePayload()));
            }
            if (this.getThingName() != null) {
                data.set("thingName", om.valueToTree(this.getThingName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnThingProps.Jsii$Proxy that = (CfnThingProps.Jsii$Proxy) o;

            if (this.attributePayload != null ? !this.attributePayload.equals(that.attributePayload) : that.attributePayload != null) return false;
            return this.thingName != null ? this.thingName.equals(that.thingName) : that.thingName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attributePayload != null ? this.attributePayload.hashCode() : 0;
            result = 31 * result + (this.thingName != null ? this.thingName.hashCode() : 0);
            return result;
        }
    }
}
