package software.amazon.awscdk.services.kinesisanalytics;

/**
 * The <code>AWS::KinesisAnalytics::Application</code> resource creates an Amazon Kinesis Data Analytics application.
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com//kinesisanalytics/latest/dev/what-is.html">Amazon Kinesis Data Analytics Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalytics.*;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .inputs(List.of(InputProperty.builder()
 *                 .inputSchema(InputSchemaProperty.builder()
 *                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                 .name("name")
 *                                 .sqlType("sqlType")
 *                                 // the properties below are optional
 *                                 .mapping("mapping")
 *                                 .build()))
 *                         .recordFormat(RecordFormatProperty.builder()
 *                                 .recordFormatType("recordFormatType")
 *                                 // the properties below are optional
 *                                 .mappingParameters(MappingParametersProperty.builder()
 *                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                 .build())
 *                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                 .recordRowPath("recordRowPath")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .recordEncoding("recordEncoding")
 *                         .build())
 *                 .namePrefix("namePrefix")
 *                 // the properties below are optional
 *                 .inputParallelism(InputParallelismProperty.builder()
 *                         .count(123)
 *                         .build())
 *                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
 *                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
 *                                 .resourceArn("resourceArn")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .build())
 *                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .applicationCode("applicationCode")
 *         .applicationDescription("applicationDescription")
 *         .applicationName("applicationName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:24.349Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Use this parameter to configure the application input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputs() {
        return software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use this parameter to configure the application input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputs", java.util.Objects.requireNonNull(value, "inputs is required"));
    }

    /**
     * Use this parameter to configure the application input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputs", java.util.Objects.requireNonNull(value, "inputs is required"));
    }

    /**
     * One or more SQL statements that read input data, transform it, and generate output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationCode() {
        return software.amazon.jsii.Kernel.get(this, "applicationCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * One or more SQL statements that read input data, transform it, and generate output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationCode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationCode", value);
    }

    /**
     * Summary description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationDescription() {
        return software.amazon.jsii.Kernel.get(this, "applicationDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Summary description of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationDescription", value);
    }

    /**
     * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationName", value);
    }
    /**
     * Provides additional mapping information when the record format uses delimiters, such as CSV.
     * <p>
     * For example, the following sample records use CSV format, where the records use the <em>'\n'</em> as the row delimiter and a comma (",") as the column delimiter:
     * <p>
     * <code>"name1", "address1"</code>
     * <p>
     * <code>"name2", "address2"</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * CSVMappingParametersProperty cSVMappingParametersProperty = CSVMappingParametersProperty.builder()
     *         .recordColumnDelimiter("recordColumnDelimiter")
     *         .recordRowDelimiter("recordRowDelimiter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.CSVMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(CSVMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column delimiter.
         * <p>
         * For example, in a CSV format, a comma (",") is the typical column delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordColumnDelimiter();

        /**
         * Row delimiter.
         * <p>
         * For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CSVMappingParametersProperty> {
            java.lang.String recordColumnDelimiter;
            java.lang.String recordRowDelimiter;

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordColumnDelimiter}
             * @param recordColumnDelimiter Column delimiter. This parameter is required.
             *                              For example, in a CSV format, a comma (",") is the typical column delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumnDelimiter(java.lang.String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link CSVMappingParametersProperty#getRecordRowDelimiter}
             * @param recordRowDelimiter Row delimiter. This parameter is required.
             *                           For example, in a CSV format, <em>'\n'</em> is the typical row delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowDelimiter(java.lang.String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CSVMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CSVMappingParametersProperty {
            private final java.lang.String recordColumnDelimiter;
            private final java.lang.String recordRowDelimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumnDelimiter = software.amazon.jsii.Kernel.get(this, "recordColumnDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordRowDelimiter = software.amazon.jsii.Kernel.get(this, "recordRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumnDelimiter = java.util.Objects.requireNonNull(builder.recordColumnDelimiter, "recordColumnDelimiter is required");
                this.recordRowDelimiter = java.util.Objects.requireNonNull(builder.recordRowDelimiter, "recordRowDelimiter is required");
            }

            @Override
            public final java.lang.String getRecordColumnDelimiter() {
                return this.recordColumnDelimiter;
            }

            @Override
            public final java.lang.String getRecordRowDelimiter() {
                return this.recordRowDelimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                data.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.CSVMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CSVMappingParametersProperty.Jsii$Proxy that = (CSVMappingParametersProperty.Jsii$Proxy) o;

                if (!recordColumnDelimiter.equals(that.recordColumnDelimiter)) return false;
                return this.recordRowDelimiter.equals(that.recordRowDelimiter);
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumnDelimiter.hashCode();
                result = 31 * result + (this.recordRowDelimiter.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that contains the Amazon Resource Name (ARN) of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that is used to preprocess records in the stream, and the ARN of the IAM role that is used to access the AWS Lambda function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * InputLambdaProcessorProperty inputLambdaProcessorProperty = InputLambdaProcessorProperty.builder()
     *         .resourceArn("resourceArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputLambdaProcessorProperty")
    @software.amazon.jsii.Jsii.Proxy(InputLambdaProcessorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates on records in the stream.
         * <p>
         * <blockquote>
         * <p>
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * The ARN of the IAM role that is used to access the AWS Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputLambdaProcessorProperty> {
            java.lang.String resourceArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link InputLambdaProcessorProperty#getResourceArn}
             * @param resourceArn The ARN of the <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> function that operates on records in the stream. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda">Example ARNs: AWS Lambda</a>
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link InputLambdaProcessorProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that is used to access the AWS Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputLambdaProcessorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputLambdaProcessorProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputLambdaProcessorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputLambdaProcessorProperty.Jsii$Proxy that = (InputLambdaProcessorProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the number of in-application streams to create for a given streaming source.
     * <p>
     * For information about parallelism, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * InputParallelismProperty inputParallelismProperty = InputParallelismProperty.builder()
     *         .count(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputParallelismProperty")
    @software.amazon.jsii.Jsii.Proxy(InputParallelismProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Number of in-application streams to create.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputParallelismProperty> {
            java.lang.Number count;

            /**
             * Sets the value of {@link InputParallelismProperty#getCount}
             * @param count Number of in-application streams to create.
             *              For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputParallelismProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputParallelismProperty {
            private final java.lang.Number count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputParallelismProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputParallelismProperty.Jsii$Proxy that = (InputParallelismProperty.Jsii$Proxy) o;

                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides a description of a processor that is used to preprocess the records in the stream before being processed by your application code.
     * <p>
     * Currently, the only input processor available is <a href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * InputProcessingConfigurationProperty inputProcessingConfigurationProperty = InputProcessingConfigurationProperty.builder()
     *         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProcessingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream before being processed by your application code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputLambdaProcessor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProcessingConfigurationProperty> {
            java.lang.Object inputLambdaProcessor;

            /**
             * Sets the value of {@link InputProcessingConfigurationProperty#getInputLambdaProcessor}
             * @param inputLambdaProcessor The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream before being processed by your application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLambdaProcessor(software.amazon.awscdk.IResolvable inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Sets the value of {@link InputProcessingConfigurationProperty#getInputLambdaProcessor}
             * @param inputLambdaProcessor The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> that is used to preprocess the records in the stream before being processed by your application code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLambdaProcessor(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProcessingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProcessingConfigurationProperty {
            private final java.lang.Object inputLambdaProcessor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputLambdaProcessor = software.amazon.jsii.Kernel.get(this, "inputLambdaProcessor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputLambdaProcessor = builder.inputLambdaProcessor;
            }

            @Override
            public final java.lang.Object getInputLambdaProcessor() {
                return this.inputLambdaProcessor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputLambdaProcessor() != null) {
                    data.set("inputLambdaProcessor", om.valueToTree(this.getInputLambdaProcessor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProcessingConfigurationProperty.Jsii$Proxy that = (InputProcessingConfigurationProperty.Jsii$Proxy) o;

                return this.inputLambdaProcessor != null ? this.inputLambdaProcessor.equals(that.inputLambdaProcessor) : that.inputLambdaProcessor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputLambdaProcessor != null ? this.inputLambdaProcessor.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * When you configure the application input, you specify the streaming source, the in-application stream name that is created, and the mapping between the two.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * InputProperty inputProperty = InputProperty.builder()
     *         .inputSchema(InputSchemaProperty.builder()
     *                 .recordColumns(List.of(RecordColumnProperty.builder()
     *                         .name("name")
     *                         .sqlType("sqlType")
     *                         // the properties below are optional
     *                         .mapping("mapping")
     *                         .build()))
     *                 .recordFormat(RecordFormatProperty.builder()
     *                         .recordFormatType("recordFormatType")
     *                         // the properties below are optional
     *                         .mappingParameters(MappingParametersProperty.builder()
     *                                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                         .recordColumnDelimiter("recordColumnDelimiter")
     *                                         .recordRowDelimiter("recordRowDelimiter")
     *                                         .build())
     *                                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                         .recordRowPath("recordRowPath")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .recordEncoding("recordEncoding")
     *                 .build())
     *         .namePrefix("namePrefix")
     *         // the properties below are optional
     *         .inputParallelism(InputParallelismProperty.builder()
     *                 .count(123)
     *                 .build())
     *         .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
     *                 .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
     *                         .resourceArn("resourceArn")
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .build())
     *         .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
         * <p>
         * Also used to describe the format of the reference data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInputSchema();

        /**
         * Name prefix to use when creating an in-application stream.
         * <p>
         * Suppose that you specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as per the <code>InputParallelism</code> count you specified) in-application streams with names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamePrefix();

        /**
         * Describes the number of in-application streams to create.
         * <p>
         * Data from your source is routed to these in-application input streams.
         * <p>
         * See <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputParallelism() {
            return null;
        }

        /**
         * The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html">InputProcessingConfiguration</a> for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputProcessingConfiguration() {
            return null;
        }

        /**
         * If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * <p>
         * Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseInput() {
            return null;
        }

        /**
         * If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
         * <p>
         * Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamsInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProperty> {
            java.lang.Object inputSchema;
            java.lang.String namePrefix;
            java.lang.Object inputParallelism;
            java.lang.Object inputProcessingConfiguration;
            java.lang.Object kinesisFirehoseInput;
            java.lang.Object kinesisStreamsInput;

            /**
             * Sets the value of {@link InputProperty#getInputSchema}
             * @param inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created. This parameter is required.
             *                    Also used to describe the format of the reference data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputSchema}
             * @param inputSchema Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created. This parameter is required.
             *                    Also used to describe the format of the reference data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getNamePrefix}
             * @param namePrefix Name prefix to use when creating an in-application stream. This parameter is required.
             *                   Suppose that you specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates one or more (as per the <code>InputParallelism</code> count you specified) in-application streams with names "MyInApplicationStream_001," "MyInApplicationStream_002," and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namePrefix(java.lang.String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputParallelism}
             * @param inputParallelism Describes the number of in-application streams to create.
             *                         Data from your source is routed to these in-application input streams.
             *                         <p>
             *                         See <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParallelism(software.amazon.awscdk.IResolvable inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputParallelism}
             * @param inputParallelism Describes the number of in-application streams to create.
             *                         Data from your source is routed to these in-application input streams.
             *                         <p>
             *                         See <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html">Configuring Application Input</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputParallelism(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputProcessingConfiguration}
             * @param inputProcessingConfiguration The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html">InputProcessingConfiguration</a> for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.IResolvable inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getInputProcessingConfiguration}
             * @param inputProcessingConfiguration The <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html">InputProcessingConfiguration</a> for the input. An input processor transforms records as they are received from the stream, before the application's SQL code executes. Currently, the only input processing configuration available is <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html">InputLambdaProcessor</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisFirehoseInput}
             * @param kinesisFirehoseInput If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
             *                             Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.IResolvable kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisFirehoseInput}
             * @param kinesisFirehoseInput If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
             *                             Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisStreamsInput}
             * @param kinesisStreamsInput If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
             *                            Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsInput(software.amazon.awscdk.IResolvable kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getKinesisStreamsInput}
             * @param kinesisStreamsInput If the streaming source is an Amazon Kinesis stream, identifies the stream's Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to access the stream on your behalf.
             *                            Note: Either <code>KinesisStreamsInput</code> or <code>KinesisFirehoseInput</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamsInput(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProperty {
            private final java.lang.Object inputSchema;
            private final java.lang.String namePrefix;
            private final java.lang.Object inputParallelism;
            private final java.lang.Object inputProcessingConfiguration;
            private final java.lang.Object kinesisFirehoseInput;
            private final java.lang.Object kinesisStreamsInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputSchema = software.amazon.jsii.Kernel.get(this, "inputSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namePrefix = software.amazon.jsii.Kernel.get(this, "namePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputParallelism = software.amazon.jsii.Kernel.get(this, "inputParallelism", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputProcessingConfiguration = software.amazon.jsii.Kernel.get(this, "inputProcessingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseInput = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisStreamsInput = software.amazon.jsii.Kernel.get(this, "kinesisStreamsInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSchema = java.util.Objects.requireNonNull(builder.inputSchema, "inputSchema is required");
                this.namePrefix = java.util.Objects.requireNonNull(builder.namePrefix, "namePrefix is required");
                this.inputParallelism = builder.inputParallelism;
                this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
                this.kinesisFirehoseInput = builder.kinesisFirehoseInput;
                this.kinesisStreamsInput = builder.kinesisStreamsInput;
            }

            @Override
            public final java.lang.Object getInputSchema() {
                return this.inputSchema;
            }

            @Override
            public final java.lang.String getNamePrefix() {
                return this.namePrefix;
            }

            @Override
            public final java.lang.Object getInputParallelism() {
                return this.inputParallelism;
            }

            @Override
            public final java.lang.Object getInputProcessingConfiguration() {
                return this.inputProcessingConfiguration;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseInput() {
                return this.kinesisFirehoseInput;
            }

            @Override
            public final java.lang.Object getKinesisStreamsInput() {
                return this.kinesisStreamsInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputSchema", om.valueToTree(this.getInputSchema()));
                data.set("namePrefix", om.valueToTree(this.getNamePrefix()));
                if (this.getInputParallelism() != null) {
                    data.set("inputParallelism", om.valueToTree(this.getInputParallelism()));
                }
                if (this.getInputProcessingConfiguration() != null) {
                    data.set("inputProcessingConfiguration", om.valueToTree(this.getInputProcessingConfiguration()));
                }
                if (this.getKinesisFirehoseInput() != null) {
                    data.set("kinesisFirehoseInput", om.valueToTree(this.getKinesisFirehoseInput()));
                }
                if (this.getKinesisStreamsInput() != null) {
                    data.set("kinesisStreamsInput", om.valueToTree(this.getKinesisStreamsInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProperty.Jsii$Proxy that = (InputProperty.Jsii$Proxy) o;

                if (!inputSchema.equals(that.inputSchema)) return false;
                if (!namePrefix.equals(that.namePrefix)) return false;
                if (this.inputParallelism != null ? !this.inputParallelism.equals(that.inputParallelism) : that.inputParallelism != null) return false;
                if (this.inputProcessingConfiguration != null ? !this.inputProcessingConfiguration.equals(that.inputProcessingConfiguration) : that.inputProcessingConfiguration != null) return false;
                if (this.kinesisFirehoseInput != null ? !this.kinesisFirehoseInput.equals(that.kinesisFirehoseInput) : that.kinesisFirehoseInput != null) return false;
                return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.equals(that.kinesisStreamsInput) : that.kinesisStreamsInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputSchema.hashCode();
                result = 31 * result + (this.namePrefix.hashCode());
                result = 31 * result + (this.inputParallelism != null ? this.inputParallelism.hashCode() : 0);
                result = 31 * result + (this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsInput != null ? this.kinesisStreamsInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns in the in-application stream that is being created.
     * <p>
     * Also used to describe the format of the reference data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * InputSchemaProperty inputSchemaProperty = InputSchemaProperty.builder()
     *         .recordColumns(List.of(RecordColumnProperty.builder()
     *                 .name("name")
     *                 .sqlType("sqlType")
     *                 // the properties below are optional
     *                 .mapping("mapping")
     *                 .build()))
     *         .recordFormat(RecordFormatProperty.builder()
     *                 .recordFormatType("recordFormatType")
     *                 // the properties below are optional
     *                 .mappingParameters(MappingParametersProperty.builder()
     *                         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                                 .recordColumnDelimiter("recordColumnDelimiter")
     *                                 .recordRowDelimiter("recordRowDelimiter")
     *                                 .build())
     *                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                                 .recordRowPath("recordRowPath")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .recordEncoding("recordEncoding")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(InputSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of <code>RecordColumn</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordColumns();

        /**
         * Specifies the format of the records on the streaming source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRecordFormat();

        /**
         * Specifies the encoding of the records in the streaming source.
         * <p>
         * For example, UTF-8.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordEncoding() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputSchemaProperty> {
            java.lang.Object recordColumns;
            java.lang.Object recordFormat;
            java.lang.String recordEncoding;

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordColumns}
             * @param recordColumns A list of <code>RecordColumn</code> objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(software.amazon.awscdk.IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordColumns}
             * @param recordColumns A list of <code>RecordColumn</code> objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordColumns(java.util.List<? extends java.lang.Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the streaming source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordFormat}
             * @param recordFormat Specifies the format of the records on the streaming source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormat(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of {@link InputSchemaProperty#getRecordEncoding}
             * @param recordEncoding Specifies the encoding of the records in the streaming source.
             *                       For example, UTF-8.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordEncoding(java.lang.String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputSchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputSchemaProperty {
            private final java.lang.Object recordColumns;
            private final java.lang.Object recordFormat;
            private final java.lang.String recordEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordColumns = software.amazon.jsii.Kernel.get(this, "recordColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordFormat = software.amazon.jsii.Kernel.get(this, "recordFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordEncoding = software.amazon.jsii.Kernel.get(this, "recordEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumns = java.util.Objects.requireNonNull(builder.recordColumns, "recordColumns is required");
                this.recordFormat = java.util.Objects.requireNonNull(builder.recordFormat, "recordFormat is required");
                this.recordEncoding = builder.recordEncoding;
            }

            @Override
            public final java.lang.Object getRecordColumns() {
                return this.recordColumns;
            }

            @Override
            public final java.lang.Object getRecordFormat() {
                return this.recordFormat;
            }

            @Override
            public final java.lang.String getRecordEncoding() {
                return this.recordEncoding;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                data.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                if (this.getRecordEncoding() != null) {
                    data.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.InputSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputSchemaProperty.Jsii$Proxy that = (InputSchemaProperty.Jsii$Proxy) o;

                if (!recordColumns.equals(that.recordColumns)) return false;
                if (!recordFormat.equals(that.recordFormat)) return false;
                return this.recordEncoding != null ? this.recordEncoding.equals(that.recordEncoding) : that.recordEncoding == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordColumns.hashCode();
                result = 31 * result + (this.recordFormat.hashCode());
                result = 31 * result + (this.recordEncoding != null ? this.recordEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides additional mapping information when JSON is the record format on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * JSONMappingParametersProperty jSONMappingParametersProperty = JSONMappingParametersProperty.builder()
     *         .recordRowPath("recordRowPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.JSONMappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(JSONMappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Path to the top-level parent that contains the records.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JSONMappingParametersProperty> {
            java.lang.String recordRowPath;

            /**
             * Sets the value of {@link JSONMappingParametersProperty#getRecordRowPath}
             * @param recordRowPath Path to the top-level parent that contains the records. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordRowPath(java.lang.String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JSONMappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JSONMappingParametersProperty {
            private final java.lang.String recordRowPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordRowPath = software.amazon.jsii.Kernel.get(this, "recordRowPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordRowPath = java.util.Objects.requireNonNull(builder.recordRowPath, "recordRowPath is required");
            }

            @Override
            public final java.lang.String getRecordRowPath() {
                return this.recordRowPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.JSONMappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JSONMappingParametersProperty.Jsii$Proxy that = (JSONMappingParametersProperty.Jsii$Proxy) o;

                return this.recordRowPath.equals(that.recordRowPath);
            }

            @Override
            public final int hashCode() {
                int result = this.recordRowPath.hashCode();
                return result;
            }
        }
    }
    /**
     * Identifies an Amazon Kinesis Firehose delivery stream as the streaming source.
     * <p>
     * You provide the delivery stream's Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * KinesisFirehoseInputProperty kinesisFirehoseInputProperty = KinesisFirehoseInputProperty.builder()
     *         .resourceArn("resourceArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the input delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * <p>
         * You need to make sure that the role has the necessary permissions to access the stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseInputProperty> {
            java.lang.String resourceArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisFirehoseInputProperty#getResourceArn}
             * @param resourceArn ARN of the input delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisFirehoseInputProperty#getRoleArn}
             * @param roleArn ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. This parameter is required.
             *                You need to make sure that the role has the necessary permissions to access the stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseInputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseInputProperty.Jsii$Proxy that = (KinesisFirehoseInputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies an Amazon Kinesis stream as the streaming source.
     * <p>
     * You provide the stream's Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * KinesisStreamsInputProperty kinesisStreamsInputProperty = KinesisStreamsInputProperty.builder()
     *         .resourceArn("resourceArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.KinesisStreamsInputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamsInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the input Amazon Kinesis stream to read.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf.
         * <p>
         * You need to grant the necessary permissions to this role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamsInputProperty> {
            java.lang.String resourceArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisStreamsInputProperty#getResourceArn}
             * @param resourceArn ARN of the input Amazon Kinesis stream to read. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamsInputProperty#getRoleArn}
             * @param roleArn ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. This parameter is required.
             *                You need to grant the necessary permissions to this role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamsInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsInputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.KinesisStreamsInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsInputProperty.Jsii$Proxy that = (KinesisStreamsInputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * MappingParametersProperty mappingParametersProperty = MappingParametersProperty.builder()
     *         .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                 .recordColumnDelimiter("recordColumnDelimiter")
     *                 .recordRowDelimiter("recordRowDelimiter")
     *                 .build())
     *         .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                 .recordRowPath("recordRowPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.MappingParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsvMappingParameters() {
            return null;
        }

        /**
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingParametersProperty> {
            java.lang.Object csvMappingParameters;
            java.lang.Object jsonMappingParameters;

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getCsvMappingParameters}
             * @param csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link MappingParametersProperty#getJsonMappingParameters}
             * @param jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingParametersProperty {
            private final java.lang.Object csvMappingParameters;
            private final java.lang.Object jsonMappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvMappingParameters = software.amazon.jsii.Kernel.get(this, "csvMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonMappingParameters = software.amazon.jsii.Kernel.get(this, "jsonMappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvMappingParameters = builder.csvMappingParameters;
                this.jsonMappingParameters = builder.jsonMappingParameters;
            }

            @Override
            public final java.lang.Object getCsvMappingParameters() {
                return this.csvMappingParameters;
            }

            @Override
            public final java.lang.Object getJsonMappingParameters() {
                return this.jsonMappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvMappingParameters() != null) {
                    data.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                }
                if (this.getJsonMappingParameters() != null) {
                    data.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.MappingParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingParametersProperty.Jsii$Proxy that = (MappingParametersProperty.Jsii$Proxy) o;

                if (this.csvMappingParameters != null ? !this.csvMappingParameters.equals(that.csvMappingParameters) : that.csvMappingParameters != null) return false;
                return this.jsonMappingParameters != null ? this.jsonMappingParameters.equals(that.jsonMappingParameters) : that.jsonMappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvMappingParameters != null ? this.csvMappingParameters.hashCode() : 0;
                result = 31 * result + (this.jsonMappingParameters != null ? this.jsonMappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     * <p>
     * Also used to describe the format of the reference data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * RecordColumnProperty recordColumnProperty = RecordColumnProperty.builder()
     *         .name("name")
     *         .sqlType("sqlType")
     *         // the properties below are optional
     *         .mapping("mapping")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.RecordColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the column created in the in-application input stream or reference table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Type of column created in the in-application input stream or reference table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlType();

        /**
         * Reference to the data element in the streaming input or the reference data source.
         * <p>
         * This element is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMapping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordColumnProperty> {
            java.lang.String name;
            java.lang.String sqlType;
            java.lang.String mapping;

            /**
             * Sets the value of {@link RecordColumnProperty#getName}
             * @param name Name of the column created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getSqlType}
             * @param sqlType Type of column created in the in-application input stream or reference table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlType(java.lang.String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            /**
             * Sets the value of {@link RecordColumnProperty#getMapping}
             * @param mapping Reference to the data element in the streaming input or the reference data source.
             *                This element is required if the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel">RecordFormatType</a> is <code>JSON</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapping(java.lang.String mapping) {
                this.mapping = mapping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordColumnProperty {
            private final java.lang.String name;
            private final java.lang.String sqlType;
            private final java.lang.String mapping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlType = software.amazon.jsii.Kernel.get(this, "sqlType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlType = java.util.Objects.requireNonNull(builder.sqlType, "sqlType is required");
                this.mapping = builder.mapping;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlType() {
                return this.sqlType;
            }

            @Override
            public final java.lang.String getMapping() {
                return this.mapping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlType", om.valueToTree(this.getSqlType()));
                if (this.getMapping() != null) {
                    data.set("mapping", om.valueToTree(this.getMapping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.RecordColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordColumnProperty.Jsii$Proxy that = (RecordColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!sqlType.equals(that.sqlType)) return false;
                return this.mapping != null ? this.mapping.equals(that.mapping) : that.mapping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.sqlType.hashCode());
                result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the record format and relevant mapping information that should be applied to schematize the records on the stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisanalytics.*;
     * RecordFormatProperty recordFormatProperty = RecordFormatProperty.builder()
     *         .recordFormatType("recordFormatType")
     *         // the properties below are optional
     *         .mappingParameters(MappingParametersProperty.builder()
     *                 .csvMappingParameters(CSVMappingParametersProperty.builder()
     *                         .recordColumnDelimiter("recordColumnDelimiter")
     *                         .recordRowDelimiter("recordRowDelimiter")
     *                         .build())
     *                 .jsonMappingParameters(JSONMappingParametersProperty.builder()
     *                         .recordRowPath("recordRowPath")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalytics.CfnApplication.RecordFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(RecordFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of record format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordFormatType();

        /**
         * When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMappingParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecordFormatProperty> {
            java.lang.String recordFormatType;
            java.lang.Object mappingParameters;

            /**
             * Sets the value of {@link RecordFormatProperty#getRecordFormatType}
             * @param recordFormatType The type of record format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Sets the value of {@link RecordFormatProperty#getMappingParameters}
             * @param mappingParameters When configuring application input at the time of creating or updating an application, provides additional mapping information specific to the record format (such as JSON, CSV, or record fields delimited by some delimiter) on the streaming source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecordFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordFormatProperty {
            private final java.lang.String recordFormatType;
            private final java.lang.Object mappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordFormatType = software.amazon.jsii.Kernel.get(this, "recordFormatType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mappingParameters = software.amazon.jsii.Kernel.get(this, "mappingParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = java.util.Objects.requireNonNull(builder.recordFormatType, "recordFormatType is required");
                this.mappingParameters = builder.mappingParameters;
            }

            @Override
            public final java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public final java.lang.Object getMappingParameters() {
                return this.mappingParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                if (this.getMappingParameters() != null) {
                    data.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalytics.CfnApplication.RecordFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordFormatProperty.Jsii$Proxy that = (RecordFormatProperty.Jsii$Proxy) o;

                if (!recordFormatType.equals(that.recordFormatType)) return false;
                return this.mappingParameters != null ? this.mappingParameters.equals(that.mappingParameters) : that.mappingParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordFormatType.hashCode();
                result = 31 * result + (this.mappingParameters != null ? this.mappingParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kinesisanalytics.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps.Builder();
        }

        /**
         * Use this parameter to configure the application input.
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs</a>
         * @param inputs Use this parameter to configure the application input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputs(final software.amazon.awscdk.IResolvable inputs) {
            this.props.inputs(inputs);
            return this;
        }
        /**
         * Use this parameter to configure the application input.
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration, you map this streaming source to an in-application stream that is created. Your application code can then query the in-application stream like a table (you can think of it as a constantly updating table).
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this stream on your behalf.
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming source to record columns in the in-app stream.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs</a>
         * @param inputs Use this parameter to configure the application input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputs(final java.util.List<? extends java.lang.Object> inputs) {
            this.props.inputs(inputs);
            return this;
        }

        /**
         * One or more SQL statements that read input data, transform it, and generate output.
         * <p>
         * For example, you can write a SQL statement that reads data from one in-application stream, generates a running average of the number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more information about the typical pattern, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a> .
         * <p>
         * You can provide such series of SQL statements, where output of one statement can be used as the input for the next statement. You store intermediate results by creating in-application streams and pumps.
         * <p>
         * Note that the application code must create the streams with names specified in the <code>Outputs</code> . For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code> , then your application code must create these streams.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode</a>
         * @param applicationCode One or more SQL statements that read input data, transform it, and generate output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationCode(final java.lang.String applicationCode) {
            this.props.applicationCode(applicationCode);
            return this;
        }

        /**
         * Summary description of the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription</a>
         * @param applicationDescription Summary description of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationDescription(final java.lang.String applicationDescription) {
            this.props.applicationDescription(applicationDescription);
            return this;
        }

        /**
         * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname</a>
         * @param applicationName Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kinesisanalytics.CfnApplication build() {
            return new software.amazon.awscdk.services.kinesisanalytics.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
