package software.amazon.awscdk.services.lambda;

/**
 * The wrapper script to be used for the Lambda function in order to enable auto instrumentation with ADOT.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.AdotLambdaExecWrapper;
 * import software.amazon.awscdk.services.lambda.AdotLayerVersion;
 * import software.amazon.awscdk.services.lambda.AdotLambdaLayerJavaScriptSdkVersion;
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .adotInstrumentation(AdotInstrumentationConfig.builder()
 *                 .layerVersion(AdotLayerVersion.fromJavaScriptSdkLayerVersion(AdotLambdaLayerJavaScriptSdkVersion.LATEST))
 *                 .execWrapper(AdotLambdaExecWrapper.REGULAR_HANDLER)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:24.634Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.AdotLambdaExecWrapper")
public enum AdotLambdaExecWrapper {
    /**
     * Wrapping regular Lambda handlers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REGULAR_HANDLER,
    /**
     * Wrapping regular handlers (implementing RequestHandler) proxied through API Gateway, enabling HTTP context propagation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PROXY_HANDLER,
    /**
     * Wrapping streaming handlers (implementing RequestStreamHandler), enabling HTTP context propagation for HTTP requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STREAM_HANDLER,
    /**
     * Wrapping python lambda handlers see https://aws-otel.github.io/docs/getting-started/lambda/lambda-python.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSTRUMENT_HANDLER,
    /**
     * Wrapping SQS-triggered function handlers (implementing RequestHandler).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_HANDLER,
}
