package software.amazon.awscdk.services.location;

/**
 * Properties for defining a <code>CfnAPIKey</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnAPIKeyProps cfnAPIKeyProps = CfnAPIKeyProps.builder()
 *         .keyName("keyName")
 *         .restrictions(ApiKeyRestrictionsProperty.builder()
 *                 .allowActions(List.of("allowActions"))
 *                 .allowResources(List.of("allowResources"))
 *                 // the properties below are optional
 *                 .allowReferers(List.of("allowReferers"))
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .expireTime("expireTime")
 *         .forceDelete(false)
 *         .forceUpdate(false)
 *         .noExpiry(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:25.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnAPIKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnAPIKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAPIKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A custom name for the API key resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique API key name.</li>
     * <li>No spaces allowed. For example, <code>ExampleAPIKey</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-keyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyName();

    /**
     * The API key restrictions for the API key resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-restrictions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRestrictions();

    /**
     * Updates the description for the API key resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-expiretime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-expiretime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExpireTime() {
        return null;
    }

    /**
     * ForceDelete bypasses an API key's expiry conditions and deletes the key.
     * <p>
     * Set the parameter <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.
     * <p>
     * Valid values: <code>true</code> , or <code>false</code> .
     * <p>
     * <blockquote>
     * <p>
     * This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forcedelete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceDelete() {
        return null;
    }

    /**
     * The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
     * <p>
     * Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days. <code>False</code> if force update is not preferred.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-forceupdate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getForceUpdate() {
        return null;
    }

    /**
     * Whether the API key should expire.
     * <p>
     * Set to <code>true</code> to set the API key to have no expiration time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-noexpiry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNoExpiry() {
        return null;
    }

    /**
     * Applies one or more tags to the map resource.
     * <p>
     * A tag is a key-value pair that helps manage, identify, search, and filter your resources by labelling them.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-apikey.html#cfn-location-apikey-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAPIKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAPIKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAPIKeyProps> {
        java.lang.String keyName;
        java.lang.Object restrictions;
        java.lang.String description;
        java.lang.String expireTime;
        java.lang.Object forceDelete;
        java.lang.Object forceUpdate;
        java.lang.Object noExpiry;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAPIKeyProps#getKeyName}
         * @param keyName A custom name for the API key resource. This parameter is required.
         *                Requirements:
         *                <p>
         *                <ul>
         *                <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         *                <li>Must be a unique API key name.</li>
         *                <li>No spaces allowed. For example, <code>ExampleAPIKey</code> .</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getRestrictions}
         * @param restrictions The API key restrictions for the API key resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictions(software.amazon.awscdk.IResolvable restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getRestrictions}
         * @param restrictions The API key restrictions for the API key resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictions(software.amazon.awscdk.services.location.CfnAPIKey.ApiKeyRestrictionsProperty restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getDescription}
         * @param description Updates the description for the API key resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getExpireTime}
         * @param expireTime The optional timestamp for when the API key resource will expire in <a href="https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expireTime(java.lang.String expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getForceDelete}
         * @param forceDelete ForceDelete bypasses an API key's expiry conditions and deletes the key.
         *                    Set the parameter <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.
         *                    <p>
         *                    Valid values: <code>true</code> , or <code>false</code> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDelete(java.lang.Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getForceDelete}
         * @param forceDelete ForceDelete bypasses an API key's expiry conditions and deletes the key.
         *                    Set the parameter <code>true</code> to delete the key or to <code>false</code> to not preemptively delete the API key.
         *                    <p>
         *                    Valid values: <code>true</code> , or <code>false</code> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDelete(software.amazon.awscdk.IResolvable forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getForceUpdate}
         * @param forceUpdate The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
         *                    Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days. <code>False</code> if force update is not preferred.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(java.lang.Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getForceUpdate}
         * @param forceUpdate The boolean flag to be included for updating <code>ExpireTime</code> or Restrictions details.
         *                    Must be set to <code>true</code> to update an API key resource that has been used in the past 7 days. <code>False</code> if force update is not preferred.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceUpdate(software.amazon.awscdk.IResolvable forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getNoExpiry}
         * @param noExpiry Whether the API key should expire.
         *                 Set to <code>true</code> to set the API key to have no expiration time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noExpiry(java.lang.Boolean noExpiry) {
            this.noExpiry = noExpiry;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getNoExpiry}
         * @param noExpiry Whether the API key should expire.
         *                 Set to <code>true</code> to set the API key to have no expiration time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noExpiry(software.amazon.awscdk.IResolvable noExpiry) {
            this.noExpiry = noExpiry;
            return this;
        }

        /**
         * Sets the value of {@link CfnAPIKeyProps#getTags}
         * @param tags Applies one or more tags to the map resource.
         *             A tag is a key-value pair that helps manage, identify, search, and filter your resources by labelling them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAPIKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAPIKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAPIKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAPIKeyProps {
        private final java.lang.String keyName;
        private final java.lang.Object restrictions;
        private final java.lang.String description;
        private final java.lang.String expireTime;
        private final java.lang.Object forceDelete;
        private final java.lang.Object forceUpdate;
        private final java.lang.Object noExpiry;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restrictions = software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expireTime = software.amazon.jsii.Kernel.get(this, "expireTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.forceDelete = software.amazon.jsii.Kernel.get(this, "forceDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.forceUpdate = software.amazon.jsii.Kernel.get(this, "forceUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.noExpiry = software.amazon.jsii.Kernel.get(this, "noExpiry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyName = java.util.Objects.requireNonNull(builder.keyName, "keyName is required");
            this.restrictions = java.util.Objects.requireNonNull(builder.restrictions, "restrictions is required");
            this.description = builder.description;
            this.expireTime = builder.expireTime;
            this.forceDelete = builder.forceDelete;
            this.forceUpdate = builder.forceUpdate;
            this.noExpiry = builder.noExpiry;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.Object getRestrictions() {
            return this.restrictions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExpireTime() {
            return this.expireTime;
        }

        @Override
        public final java.lang.Object getForceDelete() {
            return this.forceDelete;
        }

        @Override
        public final java.lang.Object getForceUpdate() {
            return this.forceUpdate;
        }

        @Override
        public final java.lang.Object getNoExpiry() {
            return this.noExpiry;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyName", om.valueToTree(this.getKeyName()));
            data.set("restrictions", om.valueToTree(this.getRestrictions()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExpireTime() != null) {
                data.set("expireTime", om.valueToTree(this.getExpireTime()));
            }
            if (this.getForceDelete() != null) {
                data.set("forceDelete", om.valueToTree(this.getForceDelete()));
            }
            if (this.getForceUpdate() != null) {
                data.set("forceUpdate", om.valueToTree(this.getForceUpdate()));
            }
            if (this.getNoExpiry() != null) {
                data.set("noExpiry", om.valueToTree(this.getNoExpiry()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnAPIKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAPIKeyProps.Jsii$Proxy that = (CfnAPIKeyProps.Jsii$Proxy) o;

            if (!keyName.equals(that.keyName)) return false;
            if (!restrictions.equals(that.restrictions)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.expireTime != null ? !this.expireTime.equals(that.expireTime) : that.expireTime != null) return false;
            if (this.forceDelete != null ? !this.forceDelete.equals(that.forceDelete) : that.forceDelete != null) return false;
            if (this.forceUpdate != null ? !this.forceUpdate.equals(that.forceUpdate) : that.forceUpdate != null) return false;
            if (this.noExpiry != null ? !this.noExpiry.equals(that.noExpiry) : that.noExpiry != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyName.hashCode();
            result = 31 * result + (this.restrictions.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.expireTime != null ? this.expireTime.hashCode() : 0);
            result = 31 * result + (this.forceDelete != null ? this.forceDelete.hashCode() : 0);
            result = 31 * result + (this.forceUpdate != null ? this.forceUpdate.hashCode() : 0);
            result = 31 * result + (this.noExpiry != null ? this.noExpiry.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
