package software.amazon.awscdk.services.mediatailor;

/**
 * Adds a new playback configuration to AWS Elemental MediaTailor .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * Object configurationAliases;
 * CfnPlaybackConfiguration cfnPlaybackConfiguration = CfnPlaybackConfiguration.Builder.create(this, "MyCfnPlaybackConfiguration")
 *         .adDecisionServerUrl("adDecisionServerUrl")
 *         .name("name")
 *         .videoContentSourceUrl("videoContentSourceUrl")
 *         // the properties below are optional
 *         .availSuppression(AvailSuppressionProperty.builder()
 *                 .fillPolicy("fillPolicy")
 *                 .mode("mode")
 *                 .value("value")
 *                 .build())
 *         .bumper(BumperProperty.builder()
 *                 .endUrl("endUrl")
 *                 .startUrl("startUrl")
 *                 .build())
 *         .cdnConfiguration(CdnConfigurationProperty.builder()
 *                 .adSegmentUrlPrefix("adSegmentUrlPrefix")
 *                 .contentSegmentUrlPrefix("contentSegmentUrlPrefix")
 *                 .build())
 *         .configurationAliases(Map.of(
 *                 "configurationAliasesKey", configurationAliases))
 *         .dashConfiguration(DashConfigurationProperty.builder()
 *                 .manifestEndpointPrefix("manifestEndpointPrefix")
 *                 .mpdLocation("mpdLocation")
 *                 .originManifestType("originManifestType")
 *                 .build())
 *         .hlsConfiguration(HlsConfigurationProperty.builder()
 *                 .manifestEndpointPrefix("manifestEndpointPrefix")
 *                 .build())
 *         .livePreRollConfiguration(LivePreRollConfigurationProperty.builder()
 *                 .adDecisionServerUrl("adDecisionServerUrl")
 *                 .maxDurationSeconds(123)
 *                 .build())
 *         .manifestProcessingRules(ManifestProcessingRulesProperty.builder()
 *                 .adMarkerPassthrough(AdMarkerPassthroughProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .personalizationThresholdSeconds(123)
 *         .slateAdUrl("slateAdUrl")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transcodeProfileName("transcodeProfileName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:25.758Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration")
public class CfnPlaybackConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPlaybackConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPlaybackConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPlaybackConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediatailor.CfnPlaybackConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The URL generated by MediaTailor to initiate a playback session.
     * <p>
     * The session uses server-side reporting. This setting is ignored in PUT operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDashConfigurationManifestEndpointPrefix() {
        return software.amazon.jsii.Kernel.get(this, "attrDashConfigurationManifestEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL that is used to initiate a playback session for devices that support Apple HLS.
     * <p>
     * The session uses server-side reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrHlsConfigurationManifestEndpointPrefix() {
        return software.amazon.jsii.Kernel.get(this, "attrHlsConfigurationManifestEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPlaybackConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPlaybackConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL that the player accesses to get a manifest from MediaTailor .
     * <p>
     * This session will use server-side reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPlaybackEndpointPrefix() {
        return software.amazon.jsii.Kernel.get(this, "attrPlaybackEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL that the player uses to initialize a session that uses client-side reporting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSessionInitializationEndpointPrefix() {
        return software.amazon.jsii.Kernel.get(this, "attrSessionInitializationEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The URL for the ad decision server (ADS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAdDecisionServerUrl() {
        return software.amazon.jsii.Kernel.get(this, "adDecisionServerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for the ad decision server (ADS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdDecisionServerUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "adDecisionServerUrl", java.util.Objects.requireNonNull(value, "adDecisionServerUrl is required"));
    }

    /**
     * The identifier for the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The URL prefix for the parent manifest for the stream, minus the asset ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVideoContentSourceUrl() {
        return software.amazon.jsii.Kernel.get(this, "videoContentSourceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL prefix for the parent manifest for the stream, minus the asset ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVideoContentSourceUrl(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "videoContentSourceUrl", java.util.Objects.requireNonNull(value, "videoContentSourceUrl is required"));
    }

    /**
     * The configuration for avail suppression, also known as ad suppression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAvailSuppression() {
        return software.amazon.jsii.Kernel.get(this, "availSuppression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for avail suppression, also known as ad suppression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailSuppression(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "availSuppression", value);
    }

    /**
     * The configuration for avail suppression, also known as ad suppression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailSuppression(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty value) {
        software.amazon.jsii.Kernel.set(this, "availSuppression", value);
    }

    /**
     * The configuration for bumpers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBumper() {
        return software.amazon.jsii.Kernel.get(this, "bumper", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for bumpers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBumper(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bumper", value);
    }

    /**
     * The configuration for bumpers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBumper(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.BumperProperty value) {
        software.amazon.jsii.Kernel.set(this, "bumper", value);
    }

    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCdnConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "cdnConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdnConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cdnConfiguration", value);
    }

    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdnConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "cdnConfiguration", value);
    }

    /**
     * The player parameters and aliases used as dynamic variables during session initialization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationAliases() {
        return software.amazon.jsii.Kernel.get(this, "configurationAliases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The player parameters and aliases used as dynamic variables during session initialization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationAliases(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationAliases", value);
    }

    /**
     * The player parameters and aliases used as dynamic variables during session initialization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationAliases(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
            }
        }
        software.amazon.jsii.Kernel.set(this, "configurationAliases", value);
    }

    /**
     * The configuration for a DASH source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dashConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for a DASH source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashConfiguration", value);
    }

    /**
     * The configuration for a DASH source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dashConfiguration", value);
    }

    /**
     * The configuration for HLS content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHlsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "hlsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for HLS content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hlsConfiguration", value);
    }

    /**
     * The configuration for HLS content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.HlsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "hlsConfiguration", value);
    }

    /**
     * The configuration for pre-roll ad insertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLivePreRollConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "livePreRollConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for pre-roll ad insertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLivePreRollConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "livePreRollConfiguration", value);
    }

    /**
     * The configuration for pre-roll ad insertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLivePreRollConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "livePreRollConfiguration", value);
    }

    /**
     * The configuration for manifest processing rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManifestProcessingRules() {
        return software.amazon.jsii.Kernel.get(this, "manifestProcessingRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for manifest processing rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManifestProcessingRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "manifestProcessingRules", value);
    }

    /**
     * The configuration for manifest processing rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManifestProcessingRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty value) {
        software.amazon.jsii.Kernel.set(this, "manifestProcessingRules", value);
    }

    /**
     * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPersonalizationThresholdSeconds() {
        return software.amazon.jsii.Kernel.get(this, "personalizationThresholdSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPersonalizationThresholdSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "personalizationThresholdSeconds", value);
    }

    /**
     * The URL for a video asset to transcode and use to fill in time that's not used by ads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSlateAdUrl() {
        return software.amazon.jsii.Kernel.get(this, "slateAdUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for a video asset to transcode and use to fill in time that's not used by ads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSlateAdUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "slateAdUrl", value);
    }

    /**
     * The tags to assign to the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to assign to the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The name that is used to associate this playback configuration with a custom transcode profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTranscodeProfileName() {
        return software.amazon.jsii.Kernel.get(this, "transcodeProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name that is used to associate this playback configuration with a custom transcode profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTranscodeProfileName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transcodeProfileName", value);
    }
    /**
     * For HLS, when set to <code>true</code> , MediaTailor passes through <code>EXT-X-CUE-IN</code> , <code>EXT-X-CUE-OUT</code> , and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.
     * <p>
     * No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code> , but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * AdMarkerPassthroughProperty adMarkerPassthroughProperty = AdMarkerPassthroughProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.AdMarkerPassthroughProperty")
    @software.amazon.jsii.Jsii.Proxy(AdMarkerPassthroughProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdMarkerPassthroughProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables ad marker passthrough for your configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html#cfn-mediatailor-playbackconfiguration-admarkerpassthrough-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-admarkerpassthrough.html#cfn-mediatailor-playbackconfiguration-admarkerpassthrough-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdMarkerPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdMarkerPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdMarkerPassthroughProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AdMarkerPassthroughProperty#getEnabled}
             * @param enabled Enables ad marker passthrough for your configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AdMarkerPassthroughProperty#getEnabled}
             * @param enabled Enables ad marker passthrough for your configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdMarkerPassthroughProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdMarkerPassthroughProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdMarkerPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdMarkerPassthroughProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.AdMarkerPassthroughProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdMarkerPassthroughProperty.Jsii$Proxy that = (AdMarkerPassthroughProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for avail suppression, also known as ad suppression.
     * <p>
     * For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * AvailSuppressionProperty availSuppressionProperty = AvailSuppressionProperty.builder()
     *         .fillPolicy("fillPolicy")
     *         .mode("mode")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailSuppressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailSuppressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the policy to apply to the avail suppression mode.
         * <p>
         * <code>BEHIND_LIVE_EDGE</code> will always use the full avail suppression policy. <code>AFTER_LIVE_EDGE</code> mode can be used to invoke partial ad break fills when a session starts mid-break.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-fillpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-fillpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFillPolicy() {
            return null;
        }

        /**
         * Sets the ad suppression mode.
         * <p>
         * By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to <code>BEHIND_LIVE_EDGE</code> , ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to <code>AFTER_LIVE_EDGE</code> , ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * A live edge offset time in HH:MM:SS.
         * <p>
         * MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-availsuppression.html#cfn-mediatailor-playbackconfiguration-availsuppression-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailSuppressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailSuppressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailSuppressionProperty> {
            java.lang.String fillPolicy;
            java.lang.String mode;
            java.lang.String value;

            /**
             * Sets the value of {@link AvailSuppressionProperty#getFillPolicy}
             * @param fillPolicy Defines the policy to apply to the avail suppression mode.
             *                   <code>BEHIND_LIVE_EDGE</code> will always use the full avail suppression policy. <code>AFTER_LIVE_EDGE</code> mode can be used to invoke partial ad break fills when a session starts mid-break.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fillPolicy(java.lang.String fillPolicy) {
                this.fillPolicy = fillPolicy;
                return this;
            }

            /**
             * Sets the value of {@link AvailSuppressionProperty#getMode}
             * @param mode Sets the ad suppression mode.
             *             By default, ad suppression is off and all ad breaks are filled with ads or slate. When Mode is set to <code>BEHIND_LIVE_EDGE</code> , ad suppression is active and MediaTailor won't fill ad breaks on or behind the ad suppression Value time in the manifest lookback window. When Mode is set to <code>AFTER_LIVE_EDGE</code> , ad suppression is active and MediaTailor won't fill ad breaks that are within the live edge plus the avail suppression value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link AvailSuppressionProperty#getValue}
             * @param value A live edge offset time in HH:MM:SS.
             *              MediaTailor won't fill ad breaks on or behind this time in the manifest lookback window. If Value is set to 00:00:00, it is in sync with the live edge, and MediaTailor won't fill any ad breaks on or behind the live edge. If you set a Value time, MediaTailor won't fill any ad breaks on or behind this time in the manifest lookback window. For example, if you set 00:45:00, then MediaTailor will fill ad breaks that occur within 45 minutes behind the live edge, but won't fill ad breaks on or behind 45 minutes behind the live edge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailSuppressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailSuppressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailSuppressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailSuppressionProperty {
            private final java.lang.String fillPolicy;
            private final java.lang.String mode;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fillPolicy = software.amazon.jsii.Kernel.get(this, "fillPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fillPolicy = builder.fillPolicy;
                this.mode = builder.mode;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getFillPolicy() {
                return this.fillPolicy;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFillPolicy() != null) {
                    data.set("fillPolicy", om.valueToTree(this.getFillPolicy()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailSuppressionProperty.Jsii$Proxy that = (AvailSuppressionProperty.Jsii$Proxy) o;

                if (this.fillPolicy != null ? !this.fillPolicy.equals(that.fillPolicy) : that.fillPolicy != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fillPolicy != null ? this.fillPolicy.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for bumpers.
     * <p>
     * Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * BumperProperty bumperProperty = BumperProperty.builder()
     *         .endUrl("endUrl")
     *         .startUrl("startUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.BumperProperty")
    @software.amazon.jsii.Jsii.Proxy(BumperProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BumperProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL for the end bumper asset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-endurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-endurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndUrl() {
            return null;
        }

        /**
         * The URL for the start bumper asset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-starturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-bumper.html#cfn-mediatailor-playbackconfiguration-bumper-starturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BumperProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BumperProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BumperProperty> {
            java.lang.String endUrl;
            java.lang.String startUrl;

            /**
             * Sets the value of {@link BumperProperty#getEndUrl}
             * @param endUrl The URL for the end bumper asset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endUrl(java.lang.String endUrl) {
                this.endUrl = endUrl;
                return this;
            }

            /**
             * Sets the value of {@link BumperProperty#getStartUrl}
             * @param startUrl The URL for the start bumper asset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startUrl(java.lang.String startUrl) {
                this.startUrl = startUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BumperProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BumperProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BumperProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BumperProperty {
            private final java.lang.String endUrl;
            private final java.lang.String startUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endUrl = software.amazon.jsii.Kernel.get(this, "endUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startUrl = software.amazon.jsii.Kernel.get(this, "startUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endUrl = builder.endUrl;
                this.startUrl = builder.startUrl;
            }

            @Override
            public final java.lang.String getEndUrl() {
                return this.endUrl;
            }

            @Override
            public final java.lang.String getStartUrl() {
                return this.startUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndUrl() != null) {
                    data.set("endUrl", om.valueToTree(this.getEndUrl()));
                }
                if (this.getStartUrl() != null) {
                    data.set("startUrl", om.valueToTree(this.getStartUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.BumperProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BumperProperty.Jsii$Proxy that = (BumperProperty.Jsii$Proxy) o;

                if (this.endUrl != null ? !this.endUrl.equals(that.endUrl) : that.endUrl != null) return false;
                return this.startUrl != null ? this.startUrl.equals(that.startUrl) : that.startUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endUrl != null ? this.endUrl.hashCode() : 0;
                result = 31 * result + (this.startUrl != null ? this.startUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * CdnConfigurationProperty cdnConfigurationProperty = CdnConfigurationProperty.builder()
     *         .adSegmentUrlPrefix("adSegmentUrlPrefix")
     *         .contentSegmentUrlPrefix("contentSegmentUrlPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CdnConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CdnConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A non-default content delivery network (CDN) to serve ad segments.
         * <p>
         * By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor. <em><region></em> .amazonaws.com. Then specify the rule's name in this <code>AdSegmentUrlPrefix</code> . When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-adsegmenturlprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-adsegmenturlprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdSegmentUrlPrefix() {
            return null;
        }

        /**
         * A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to the origin server.
         * <p>
         * First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this <code>ContentSegmentUrlPrefix</code> . When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-contentsegmenturlprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-cdnconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration-contentsegmenturlprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentSegmentUrlPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CdnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CdnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CdnConfigurationProperty> {
            java.lang.String adSegmentUrlPrefix;
            java.lang.String contentSegmentUrlPrefix;

            /**
             * Sets the value of {@link CdnConfigurationProperty#getAdSegmentUrlPrefix}
             * @param adSegmentUrlPrefix A non-default content delivery network (CDN) to serve ad segments.
             *                           By default, AWS Elemental MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a rule in your CDN for the origin ads.mediatailor. <em><region></em> .amazonaws.com. Then specify the rule's name in this <code>AdSegmentUrlPrefix</code> . When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for ad segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adSegmentUrlPrefix(java.lang.String adSegmentUrlPrefix) {
                this.adSegmentUrlPrefix = adSegmentUrlPrefix;
                return this;
            }

            /**
             * Sets the value of {@link CdnConfigurationProperty#getContentSegmentUrlPrefix}
             * @param contentSegmentUrlPrefix A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to the origin server.
             *                                First, create a rule in your CDN for the content segment origin server. Then specify the rule's name in this <code>ContentSegmentUrlPrefix</code> . When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for content segments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentSegmentUrlPrefix(java.lang.String contentSegmentUrlPrefix) {
                this.contentSegmentUrlPrefix = contentSegmentUrlPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CdnConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CdnConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CdnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdnConfigurationProperty {
            private final java.lang.String adSegmentUrlPrefix;
            private final java.lang.String contentSegmentUrlPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adSegmentUrlPrefix = software.amazon.jsii.Kernel.get(this, "adSegmentUrlPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentSegmentUrlPrefix = software.amazon.jsii.Kernel.get(this, "contentSegmentUrlPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adSegmentUrlPrefix = builder.adSegmentUrlPrefix;
                this.contentSegmentUrlPrefix = builder.contentSegmentUrlPrefix;
            }

            @Override
            public final java.lang.String getAdSegmentUrlPrefix() {
                return this.adSegmentUrlPrefix;
            }

            @Override
            public final java.lang.String getContentSegmentUrlPrefix() {
                return this.contentSegmentUrlPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdSegmentUrlPrefix() != null) {
                    data.set("adSegmentUrlPrefix", om.valueToTree(this.getAdSegmentUrlPrefix()));
                }
                if (this.getContentSegmentUrlPrefix() != null) {
                    data.set("contentSegmentUrlPrefix", om.valueToTree(this.getContentSegmentUrlPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CdnConfigurationProperty.Jsii$Proxy that = (CdnConfigurationProperty.Jsii$Proxy) o;

                if (this.adSegmentUrlPrefix != null ? !this.adSegmentUrlPrefix.equals(that.adSegmentUrlPrefix) : that.adSegmentUrlPrefix != null) return false;
                return this.contentSegmentUrlPrefix != null ? this.contentSegmentUrlPrefix.equals(that.contentSegmentUrlPrefix) : that.contentSegmentUrlPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adSegmentUrlPrefix != null ? this.adSegmentUrlPrefix.hashCode() : 0;
                result = 31 * result + (this.contentSegmentUrlPrefix != null ? this.contentSegmentUrlPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for DASH content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * DashConfigurationProperty dashConfigurationProperty = DashConfigurationProperty.builder()
     *         .manifestEndpointPrefix("manifestEndpointPrefix")
     *         .mpdLocation("mpdLocation")
     *         .originManifestType("originManifestType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DashConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL generated by MediaTailor to initiate a playback session.
         * <p>
         * The session uses server-side reporting. This setting is ignored in PUT operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-manifestendpointprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-manifestendpointprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestEndpointPrefix() {
            return null;
        }

        /**
         * The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
         * <p>
         * MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are <code>DISABLED</code> and <code>EMT_DEFAULT</code> . The <code>EMT_DEFAULT</code> setting enables the inclusion of the tag and is the default value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-mpdlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-mpdlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMpdLocation() {
            return null;
        }

        /**
         * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests.
         * <p>
         * If your origin server produces single-period manifests, set this to <code>SINGLE_PERIOD</code> . The default setting is <code>MULTI_PERIOD</code> . For multi-period manifests, omit this setting or set it to <code>MULTI_PERIOD</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-originmanifesttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration-originmanifesttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginManifestType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashConfigurationProperty> {
            java.lang.String manifestEndpointPrefix;
            java.lang.String mpdLocation;
            java.lang.String originManifestType;

            /**
             * Sets the value of {@link DashConfigurationProperty#getManifestEndpointPrefix}
             * @param manifestEndpointPrefix The URL generated by MediaTailor to initiate a playback session.
             *                               The session uses server-side reporting. This setting is ignored in PUT operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestEndpointPrefix(java.lang.String manifestEndpointPrefix) {
                this.manifestEndpointPrefix = manifestEndpointPrefix;
                return this;
            }

            /**
             * Sets the value of {@link DashConfigurationProperty#getMpdLocation}
             * @param mpdLocation The setting that controls whether MediaTailor includes the Location tag in DASH manifests.
             *                    MediaTailor populates the Location tag with the URL for manifest update requests, to be used by players that don't support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are either using client-side reporting or your players support sticky HTTP redirects. Valid values are <code>DISABLED</code> and <code>EMT_DEFAULT</code> . The <code>EMT_DEFAULT</code> setting enables the inclusion of the tag and is the default value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mpdLocation(java.lang.String mpdLocation) {
                this.mpdLocation = mpdLocation;
                return this;
            }

            /**
             * Sets the value of {@link DashConfigurationProperty#getOriginManifestType}
             * @param originManifestType The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests or single-period manifests.
             *                           If your origin server produces single-period manifests, set this to <code>SINGLE_PERIOD</code> . The default setting is <code>MULTI_PERIOD</code> . For multi-period manifests, omit this setting or set it to <code>MULTI_PERIOD</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originManifestType(java.lang.String originManifestType) {
                this.originManifestType = originManifestType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashConfigurationProperty {
            private final java.lang.String manifestEndpointPrefix;
            private final java.lang.String mpdLocation;
            private final java.lang.String originManifestType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestEndpointPrefix = software.amazon.jsii.Kernel.get(this, "manifestEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mpdLocation = software.amazon.jsii.Kernel.get(this, "mpdLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originManifestType = software.amazon.jsii.Kernel.get(this, "originManifestType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestEndpointPrefix = builder.manifestEndpointPrefix;
                this.mpdLocation = builder.mpdLocation;
                this.originManifestType = builder.originManifestType;
            }

            @Override
            public final java.lang.String getManifestEndpointPrefix() {
                return this.manifestEndpointPrefix;
            }

            @Override
            public final java.lang.String getMpdLocation() {
                return this.mpdLocation;
            }

            @Override
            public final java.lang.String getOriginManifestType() {
                return this.originManifestType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifestEndpointPrefix() != null) {
                    data.set("manifestEndpointPrefix", om.valueToTree(this.getManifestEndpointPrefix()));
                }
                if (this.getMpdLocation() != null) {
                    data.set("mpdLocation", om.valueToTree(this.getMpdLocation()));
                }
                if (this.getOriginManifestType() != null) {
                    data.set("originManifestType", om.valueToTree(this.getOriginManifestType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashConfigurationProperty.Jsii$Proxy that = (DashConfigurationProperty.Jsii$Proxy) o;

                if (this.manifestEndpointPrefix != null ? !this.manifestEndpointPrefix.equals(that.manifestEndpointPrefix) : that.manifestEndpointPrefix != null) return false;
                if (this.mpdLocation != null ? !this.mpdLocation.equals(that.mpdLocation) : that.mpdLocation != null) return false;
                return this.originManifestType != null ? this.originManifestType.equals(that.originManifestType) : that.originManifestType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestEndpointPrefix != null ? this.manifestEndpointPrefix.hashCode() : 0;
                result = 31 * result + (this.mpdLocation != null ? this.mpdLocation.hashCode() : 0);
                result = 31 * result + (this.originManifestType != null ? this.originManifestType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for HLS content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * HlsConfigurationProperty hlsConfigurationProperty = HlsConfigurationProperty.builder()
     *         .manifestEndpointPrefix("manifestEndpointPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.HlsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL that is used to initiate a playback session for devices that support Apple HLS.
         * <p>
         * The session uses server-side reporting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration-manifestendpointprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-hlsconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration-manifestendpointprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestEndpointPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsConfigurationProperty> {
            java.lang.String manifestEndpointPrefix;

            /**
             * Sets the value of {@link HlsConfigurationProperty#getManifestEndpointPrefix}
             * @param manifestEndpointPrefix The URL that is used to initiate a playback session for devices that support Apple HLS.
             *                               The session uses server-side reporting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestEndpointPrefix(java.lang.String manifestEndpointPrefix) {
                this.manifestEndpointPrefix = manifestEndpointPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsConfigurationProperty {
            private final java.lang.String manifestEndpointPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestEndpointPrefix = software.amazon.jsii.Kernel.get(this, "manifestEndpointPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestEndpointPrefix = builder.manifestEndpointPrefix;
            }

            @Override
            public final java.lang.String getManifestEndpointPrefix() {
                return this.manifestEndpointPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifestEndpointPrefix() != null) {
                    data.set("manifestEndpointPrefix", om.valueToTree(this.getManifestEndpointPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.HlsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsConfigurationProperty.Jsii$Proxy that = (HlsConfigurationProperty.Jsii$Proxy) o;

                return this.manifestEndpointPrefix != null ? this.manifestEndpointPrefix.equals(that.manifestEndpointPrefix) : that.manifestEndpointPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestEndpointPrefix != null ? this.manifestEndpointPrefix.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for pre-roll ad insertion.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * LivePreRollConfigurationProperty livePreRollConfigurationProperty = LivePreRollConfigurationProperty.builder()
     *         .adDecisionServerUrl("adDecisionServerUrl")
     *         .maxDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LivePreRollConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LivePreRollConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL for the ad decision server (ADS) for pre-roll ads.
         * <p>
         * This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-addecisionserverurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-addecisionserverurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdDecisionServerUrl() {
            return null;
        }

        /**
         * The maximum allowed duration for the pre-roll ad avail.
         * <p>
         * AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-maxdurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-liveprerollconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration-maxdurationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LivePreRollConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LivePreRollConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LivePreRollConfigurationProperty> {
            java.lang.String adDecisionServerUrl;
            java.lang.Number maxDurationSeconds;

            /**
             * Sets the value of {@link LivePreRollConfigurationProperty#getAdDecisionServerUrl}
             * @param adDecisionServerUrl The URL for the ad decision server (ADS) for pre-roll ads.
             *                            This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is 25,000 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adDecisionServerUrl(java.lang.String adDecisionServerUrl) {
                this.adDecisionServerUrl = adDecisionServerUrl;
                return this;
            }

            /**
             * Sets the value of {@link LivePreRollConfigurationProperty#getMaxDurationSeconds}
             * @param maxDurationSeconds The maximum allowed duration for the pre-roll ad avail.
             *                           AWS Elemental MediaTailor won't play pre-roll ads to exceed this duration, regardless of the total duration of ads that the ADS returns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxDurationSeconds(java.lang.Number maxDurationSeconds) {
                this.maxDurationSeconds = maxDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LivePreRollConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LivePreRollConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LivePreRollConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LivePreRollConfigurationProperty {
            private final java.lang.String adDecisionServerUrl;
            private final java.lang.Number maxDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adDecisionServerUrl = software.amazon.jsii.Kernel.get(this, "adDecisionServerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxDurationSeconds = software.amazon.jsii.Kernel.get(this, "maxDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adDecisionServerUrl = builder.adDecisionServerUrl;
                this.maxDurationSeconds = builder.maxDurationSeconds;
            }

            @Override
            public final java.lang.String getAdDecisionServerUrl() {
                return this.adDecisionServerUrl;
            }

            @Override
            public final java.lang.Number getMaxDurationSeconds() {
                return this.maxDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdDecisionServerUrl() != null) {
                    data.set("adDecisionServerUrl", om.valueToTree(this.getAdDecisionServerUrl()));
                }
                if (this.getMaxDurationSeconds() != null) {
                    data.set("maxDurationSeconds", om.valueToTree(this.getMaxDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LivePreRollConfigurationProperty.Jsii$Proxy that = (LivePreRollConfigurationProperty.Jsii$Proxy) o;

                if (this.adDecisionServerUrl != null ? !this.adDecisionServerUrl.equals(that.adDecisionServerUrl) : that.adDecisionServerUrl != null) return false;
                return this.maxDurationSeconds != null ? this.maxDurationSeconds.equals(that.maxDurationSeconds) : that.maxDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adDecisionServerUrl != null ? this.adDecisionServerUrl.hashCode() : 0;
                result = 31 * result + (this.maxDurationSeconds != null ? this.maxDurationSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for manifest processing rules.
     * <p>
     * Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediatailor.*;
     * ManifestProcessingRulesProperty manifestProcessingRulesProperty = ManifestProcessingRulesProperty.builder()
     *         .adMarkerPassthrough(AdMarkerPassthroughProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(ManifestProcessingRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManifestProcessingRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For HLS, when set to <code>true</code> , MediaTailor passes through <code>EXT-X-CUE-IN</code> , <code>EXT-X-CUE-OUT</code> , and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.
         * <p>
         * No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code> , but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules-admarkerpassthrough">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-manifestprocessingrules.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules-admarkerpassthrough</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdMarkerPassthrough() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManifestProcessingRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManifestProcessingRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManifestProcessingRulesProperty> {
            java.lang.Object adMarkerPassthrough;

            /**
             * Sets the value of {@link ManifestProcessingRulesProperty#getAdMarkerPassthrough}
             * @param adMarkerPassthrough For HLS, when set to <code>true</code> , MediaTailor passes through <code>EXT-X-CUE-IN</code> , <code>EXT-X-CUE-OUT</code> , and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.
             *                            No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code> , but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkerPassthrough(software.amazon.awscdk.IResolvable adMarkerPassthrough) {
                this.adMarkerPassthrough = adMarkerPassthrough;
                return this;
            }

            /**
             * Sets the value of {@link ManifestProcessingRulesProperty#getAdMarkerPassthrough}
             * @param adMarkerPassthrough For HLS, when set to <code>true</code> , MediaTailor passes through <code>EXT-X-CUE-IN</code> , <code>EXT-X-CUE-OUT</code> , and <code>EXT-X-SPLICEPOINT-SCTE35</code> ad markers from the origin manifest to the MediaTailor personalized manifest.
             *                            No logic is applied to these ad markers. For example, if <code>EXT-X-CUE-OUT</code> has a value of <code>60</code> , but no ads are filled for that ad break, MediaTailor will not set the value to <code>0</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkerPassthrough(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.AdMarkerPassthroughProperty adMarkerPassthrough) {
                this.adMarkerPassthrough = adMarkerPassthrough;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManifestProcessingRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManifestProcessingRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManifestProcessingRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManifestProcessingRulesProperty {
            private final java.lang.Object adMarkerPassthrough;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkerPassthrough = software.amazon.jsii.Kernel.get(this, "adMarkerPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkerPassthrough = builder.adMarkerPassthrough;
            }

            @Override
            public final java.lang.Object getAdMarkerPassthrough() {
                return this.adMarkerPassthrough;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkerPassthrough() != null) {
                    data.set("adMarkerPassthrough", om.valueToTree(this.getAdMarkerPassthrough()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManifestProcessingRulesProperty.Jsii$Proxy that = (ManifestProcessingRulesProperty.Jsii$Proxy) o;

                return this.adMarkerPassthrough != null ? this.adMarkerPassthrough.equals(that.adMarkerPassthrough) : that.adMarkerPassthrough == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkerPassthrough != null ? this.adMarkerPassthrough.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediatailor.CfnPlaybackConfigurationProps.Builder();
        }

        /**
         * The URL for the ad decision server (ADS).
         * <p>
         * This includes the specification of static parameters and placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-addecisionserverurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-addecisionserverurl</a>
         * @param adDecisionServerUrl The URL for the ad decision server (ADS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adDecisionServerUrl(final java.lang.String adDecisionServerUrl) {
            this.props.adDecisionServerUrl(adDecisionServerUrl);
            return this;
        }

        /**
         * The identifier for the playback configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-name</a>
         * @param name The identifier for the playback configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The URL prefix for the parent manifest for the stream, minus the asset ID.
         * <p>
         * The maximum length is 512 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-videocontentsourceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-videocontentsourceurl</a>
         * @param videoContentSourceUrl The URL prefix for the parent manifest for the stream, minus the asset ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder videoContentSourceUrl(final java.lang.String videoContentSourceUrl) {
            this.props.videoContentSourceUrl(videoContentSourceUrl);
            return this;
        }

        /**
         * The configuration for avail suppression, also known as ad suppression.
         * <p>
         * For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression</a>
         * @param availSuppression The configuration for avail suppression, also known as ad suppression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availSuppression(final software.amazon.awscdk.IResolvable availSuppression) {
            this.props.availSuppression(availSuppression);
            return this;
        }
        /**
         * The configuration for avail suppression, also known as ad suppression.
         * <p>
         * For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-availsuppression</a>
         * @param availSuppression The configuration for avail suppression, also known as ad suppression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availSuppression(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty availSuppression) {
            this.props.availSuppression(availSuppression);
            return this;
        }

        /**
         * The configuration for bumpers.
         * <p>
         * Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper</a>
         * @param bumper The configuration for bumpers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bumper(final software.amazon.awscdk.IResolvable bumper) {
            this.props.bumper(bumper);
            return this;
        }
        /**
         * The configuration for bumpers.
         * <p>
         * Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-bumper</a>
         * @param bumper The configuration for bumpers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bumper(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.BumperProperty bumper) {
            this.props.bumper(bumper);
            return this;
        }

        /**
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration</a>
         * @param cdnConfiguration The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnConfiguration(final software.amazon.awscdk.IResolvable cdnConfiguration) {
            this.props.cdnConfiguration(cdnConfiguration);
            return this;
        }
        /**
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-cdnconfiguration</a>
         * @param cdnConfiguration The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnConfiguration(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty cdnConfiguration) {
            this.props.cdnConfiguration(cdnConfiguration);
            return this;
        }

        /**
         * The player parameters and aliases used as dynamic variables during session initialization.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases</a>
         * @param configurationAliases The player parameters and aliases used as dynamic variables during session initialization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAliases(final software.amazon.awscdk.IResolvable configurationAliases) {
            this.props.configurationAliases(configurationAliases);
            return this;
        }
        /**
         * The player parameters and aliases used as dynamic variables during session initialization.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-configurationaliases</a>
         * @param configurationAliases The player parameters and aliases used as dynamic variables during session initialization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAliases(final java.util.Map<java.lang.String, ? extends java.lang.Object> configurationAliases) {
            this.props.configurationAliases(configurationAliases);
            return this;
        }

        /**
         * The configuration for a DASH source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration</a>
         * @param dashConfiguration The configuration for a DASH source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashConfiguration(final software.amazon.awscdk.IResolvable dashConfiguration) {
            this.props.dashConfiguration(dashConfiguration);
            return this;
        }
        /**
         * The configuration for a DASH source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-dashconfiguration</a>
         * @param dashConfiguration The configuration for a DASH source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashConfiguration(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty dashConfiguration) {
            this.props.dashConfiguration(dashConfiguration);
            return this;
        }

        /**
         * The configuration for HLS content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration</a>
         * @param hlsConfiguration The configuration for HLS content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsConfiguration(final software.amazon.awscdk.IResolvable hlsConfiguration) {
            this.props.hlsConfiguration(hlsConfiguration);
            return this;
        }
        /**
         * The configuration for HLS content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-hlsconfiguration</a>
         * @param hlsConfiguration The configuration for HLS content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsConfiguration(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.HlsConfigurationProperty hlsConfiguration) {
            this.props.hlsConfiguration(hlsConfiguration);
            return this;
        }

        /**
         * The configuration for pre-roll ad insertion.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration</a>
         * @param livePreRollConfiguration The configuration for pre-roll ad insertion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder livePreRollConfiguration(final software.amazon.awscdk.IResolvable livePreRollConfiguration) {
            this.props.livePreRollConfiguration(livePreRollConfiguration);
            return this;
        }
        /**
         * The configuration for pre-roll ad insertion.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-liveprerollconfiguration</a>
         * @param livePreRollConfiguration The configuration for pre-roll ad insertion. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder livePreRollConfiguration(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty livePreRollConfiguration) {
            this.props.livePreRollConfiguration(livePreRollConfiguration);
            return this;
        }

        /**
         * The configuration for manifest processing rules.
         * <p>
         * Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules</a>
         * @param manifestProcessingRules The configuration for manifest processing rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestProcessingRules(final software.amazon.awscdk.IResolvable manifestProcessingRules) {
            this.props.manifestProcessingRules(manifestProcessingRules);
            return this;
        }
        /**
         * The configuration for manifest processing rules.
         * <p>
         * Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-manifestprocessingrules</a>
         * @param manifestProcessingRules The configuration for manifest processing rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestProcessingRules(final software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty manifestProcessingRules) {
            this.props.manifestProcessingRules(manifestProcessingRules);
            return this;
        }

        /**
         * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break.
         * <p>
         * If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <em>ad replacement</em> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental MediaTailor</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-personalizationthresholdseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-personalizationthresholdseconds</a>
         * @param personalizationThresholdSeconds Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder personalizationThresholdSeconds(final java.lang.Number personalizationThresholdSeconds) {
            this.props.personalizationThresholdSeconds(personalizationThresholdSeconds);
            return this;
        }

        /**
         * The URL for a video asset to transcode and use to fill in time that's not used by ads.
         * <p>
         * AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it in the slots designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-slateadurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-slateadurl</a>
         * @param slateAdUrl The URL for a video asset to transcode and use to fill in time that's not used by ads. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slateAdUrl(final java.lang.String slateAdUrl) {
            this.props.slateAdUrl(slateAdUrl);
            return this;
        }

        /**
         * The tags to assign to the playback configuration.
         * <p>
         * Tags are key-value pairs that you can associate with Amazon resources to help with organization, access control, and cost tracking. For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor Resources</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-tags</a>
         * @param tags The tags to assign to the playback configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name that is used to associate this playback configuration with a custom transcode profile.
         * <p>
         * This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-transcodeprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediatailor-playbackconfiguration.html#cfn-mediatailor-playbackconfiguration-transcodeprofilename</a>
         * @param transcodeProfileName The name that is used to associate this playback configuration with a custom transcode profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transcodeProfileName(final java.lang.String transcodeProfileName) {
            this.props.transcodeProfileName(transcodeProfileName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration build() {
            return new software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
