package software.amazon.awscdk.services.opensearchservice;

/**
 * Container for information about the SAML configuration for OpenSearch Dashboards.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_0)
 *         .enforceHttps(true)
 *         .nodeToNodeEncryption(true)
 *         .encryptionAtRest(EncryptionAtRestOptions.builder()
 *                 .enabled(true)
 *                 .build())
 *         .fineGrainedAccessControl(AdvancedSecurityOptions.builder()
 *                 .masterUserName("master-user")
 *                 .samlAuthenticationEnabled(true)
 *                 .samlAuthenticationOptions(SAMLOptionsProperty.builder()
 *                         .idpEntityId("entity-id")
 *                         .idpMetadataContent("metadata-content-with-quotes-escaped")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:26.565Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.SAMLOptionsProperty")
@software.amazon.jsii.Jsii.Proxy(SAMLOptionsProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SAMLOptionsProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique entity ID of the application in the SAML identity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdpEntityId();

    /**
     * The metadata of the SAML application, in XML format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdpMetadataContent();

    /**
     * The backend role that the SAML master user is mapped to.
     * <p>
     * Any users with this backend role receives full permission in OpenSearch Dashboards/Kibana.
     * To use a SAML master backend role, configure the <code>rolesKey</code> property.
     * <p>
     * Default: - The master user is not mapped to a backend role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterBackendRole() {
        return null;
    }

    /**
     * The SAML master username, which is stored in the domain's internal user database.
     * <p>
     * This SAML user receives full permission in OpenSearch Dashboards/Kibana.
     * Creating a new master username does not delete any existing master usernames.
     * <p>
     * Default: - No master user name is configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserName() {
        return null;
    }

    /**
     * Element of the SAML assertion to use for backend roles.
     * <p>
     * Default: - roles
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRolesKey() {
        return null;
    }

    /**
     * The duration, in minutes, after which a user session becomes inactive.
     * <p>
     * Default: - 60
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeoutMinutes() {
        return null;
    }

    /**
     * Element of the SAML assertion to use for the user name.
     * <p>
     * Default: - NameID element of the SAML assertion fot the user name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubjectKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SAMLOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SAMLOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SAMLOptionsProperty> {
        java.lang.String idpEntityId;
        java.lang.String idpMetadataContent;
        java.lang.String masterBackendRole;
        java.lang.String masterUserName;
        java.lang.String rolesKey;
        java.lang.Number sessionTimeoutMinutes;
        java.lang.String subjectKey;

        /**
         * Sets the value of {@link SAMLOptionsProperty#getIdpEntityId}
         * @param idpEntityId The unique entity ID of the application in the SAML identity provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpEntityId(java.lang.String idpEntityId) {
            this.idpEntityId = idpEntityId;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getIdpMetadataContent}
         * @param idpMetadataContent The metadata of the SAML application, in XML format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpMetadataContent(java.lang.String idpMetadataContent) {
            this.idpMetadataContent = idpMetadataContent;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getMasterBackendRole}
         * @param masterBackendRole The backend role that the SAML master user is mapped to.
         *                          Any users with this backend role receives full permission in OpenSearch Dashboards/Kibana.
         *                          To use a SAML master backend role, configure the <code>rolesKey</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterBackendRole(java.lang.String masterBackendRole) {
            this.masterBackendRole = masterBackendRole;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getMasterUserName}
         * @param masterUserName The SAML master username, which is stored in the domain's internal user database.
         *                       This SAML user receives full permission in OpenSearch Dashboards/Kibana.
         *                       Creating a new master username does not delete any existing master usernames.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserName(java.lang.String masterUserName) {
            this.masterUserName = masterUserName;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getRolesKey}
         * @param rolesKey Element of the SAML assertion to use for backend roles.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rolesKey(java.lang.String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getSessionTimeoutMinutes}
         * @param sessionTimeoutMinutes The duration, in minutes, after which a user session becomes inactive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeoutMinutes(java.lang.Number sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            return this;
        }

        /**
         * Sets the value of {@link SAMLOptionsProperty#getSubjectKey}
         * @param subjectKey Element of the SAML assertion to use for the user name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectKey(java.lang.String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SAMLOptionsProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SAMLOptionsProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SAMLOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMLOptionsProperty {
        private final java.lang.String idpEntityId;
        private final java.lang.String idpMetadataContent;
        private final java.lang.String masterBackendRole;
        private final java.lang.String masterUserName;
        private final java.lang.String rolesKey;
        private final java.lang.Number sessionTimeoutMinutes;
        private final java.lang.String subjectKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.idpEntityId = software.amazon.jsii.Kernel.get(this, "idpEntityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idpMetadataContent = software.amazon.jsii.Kernel.get(this, "idpMetadataContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterBackendRole = software.amazon.jsii.Kernel.get(this, "masterBackendRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserName = software.amazon.jsii.Kernel.get(this, "masterUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rolesKey = software.amazon.jsii.Kernel.get(this, "rolesKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "sessionTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.subjectKey = software.amazon.jsii.Kernel.get(this, "subjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.idpEntityId = java.util.Objects.requireNonNull(builder.idpEntityId, "idpEntityId is required");
            this.idpMetadataContent = java.util.Objects.requireNonNull(builder.idpMetadataContent, "idpMetadataContent is required");
            this.masterBackendRole = builder.masterBackendRole;
            this.masterUserName = builder.masterUserName;
            this.rolesKey = builder.rolesKey;
            this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
            this.subjectKey = builder.subjectKey;
        }

        @Override
        public final java.lang.String getIdpEntityId() {
            return this.idpEntityId;
        }

        @Override
        public final java.lang.String getIdpMetadataContent() {
            return this.idpMetadataContent;
        }

        @Override
        public final java.lang.String getMasterBackendRole() {
            return this.masterBackendRole;
        }

        @Override
        public final java.lang.String getMasterUserName() {
            return this.masterUserName;
        }

        @Override
        public final java.lang.String getRolesKey() {
            return this.rolesKey;
        }

        @Override
        public final java.lang.Number getSessionTimeoutMinutes() {
            return this.sessionTimeoutMinutes;
        }

        @Override
        public final java.lang.String getSubjectKey() {
            return this.subjectKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("idpEntityId", om.valueToTree(this.getIdpEntityId()));
            data.set("idpMetadataContent", om.valueToTree(this.getIdpMetadataContent()));
            if (this.getMasterBackendRole() != null) {
                data.set("masterBackendRole", om.valueToTree(this.getMasterBackendRole()));
            }
            if (this.getMasterUserName() != null) {
                data.set("masterUserName", om.valueToTree(this.getMasterUserName()));
            }
            if (this.getRolesKey() != null) {
                data.set("rolesKey", om.valueToTree(this.getRolesKey()));
            }
            if (this.getSessionTimeoutMinutes() != null) {
                data.set("sessionTimeoutMinutes", om.valueToTree(this.getSessionTimeoutMinutes()));
            }
            if (this.getSubjectKey() != null) {
                data.set("subjectKey", om.valueToTree(this.getSubjectKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.SAMLOptionsProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SAMLOptionsProperty.Jsii$Proxy that = (SAMLOptionsProperty.Jsii$Proxy) o;

            if (!idpEntityId.equals(that.idpEntityId)) return false;
            if (!idpMetadataContent.equals(that.idpMetadataContent)) return false;
            if (this.masterBackendRole != null ? !this.masterBackendRole.equals(that.masterBackendRole) : that.masterBackendRole != null) return false;
            if (this.masterUserName != null ? !this.masterUserName.equals(that.masterUserName) : that.masterUserName != null) return false;
            if (this.rolesKey != null ? !this.rolesKey.equals(that.rolesKey) : that.rolesKey != null) return false;
            if (this.sessionTimeoutMinutes != null ? !this.sessionTimeoutMinutes.equals(that.sessionTimeoutMinutes) : that.sessionTimeoutMinutes != null) return false;
            return this.subjectKey != null ? this.subjectKey.equals(that.subjectKey) : that.subjectKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.idpEntityId.hashCode();
            result = 31 * result + (this.idpMetadataContent.hashCode());
            result = 31 * result + (this.masterBackendRole != null ? this.masterBackendRole.hashCode() : 0);
            result = 31 * result + (this.masterUserName != null ? this.masterUserName.hashCode() : 0);
            result = 31 * result + (this.rolesKey != null ? this.rolesKey.hashCode() : 0);
            result = 31 * result + (this.sessionTimeoutMinutes != null ? this.sessionTimeoutMinutes.hashCode() : 0);
            result = 31 * result + (this.subjectKey != null ? this.subjectKey.hashCode() : 0);
            return result;
        }
    }
}
