package software.amazon.awscdk.services.pcs;

/**
 * Properties for defining a <code>CfnComputeNodeGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcs.*;
 * CfnComputeNodeGroupProps cfnComputeNodeGroupProps = CfnComputeNodeGroupProps.builder()
 *         .clusterId("clusterId")
 *         .customLaunchTemplate(CustomLaunchTemplateProperty.builder()
 *                 .id("id")
 *                 .version("version")
 *                 .build())
 *         .iamInstanceProfileArn("iamInstanceProfileArn")
 *         .instanceConfigs(List.of(InstanceConfigProperty.builder()
 *                 .instanceType("instanceType")
 *                 .build()))
 *         .scalingConfiguration(ScalingConfigurationProperty.builder()
 *                 .maxInstanceCount(123)
 *                 .minInstanceCount(123)
 *                 .build())
 *         .subnetIds(List.of("subnetIds"))
 *         // the properties below are optional
 *         .amiId("amiId")
 *         .name("name")
 *         .purchaseOption("purchaseOption")
 *         .slurmConfiguration(SlurmConfigurationProperty.builder()
 *                 .slurmCustomSettings(List.of(SlurmCustomSettingProperty.builder()
 *                         .parameterName("parameterName")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .build())
 *         .spotOptions(SpotOptionsProperty.builder()
 *                 .allocationStrategy("allocationStrategy")
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:26.930Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcs.CfnComputeNodeGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnComputeNodeGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComputeNodeGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the cluster of the compute node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-clusterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-clusterid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

    /**
     * An Amazon EC2 launch template AWS PCS uses to launch compute nodes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-customlaunchtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-customlaunchtemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCustomLaunchTemplate();

    /**
     * The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances.
     * <p>
     * The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-iaminstanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-iaminstanceprofilearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIamInstanceProfileArn();

    /**
     * A list of EC2 instance configurations that AWS PCS can provision in the compute node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-instanceconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-instanceconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInstanceConfigs();

    /**
     * Specifies the boundaries of the compute node group auto scaling.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-scalingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScalingConfiguration();

    /**
     * The list of subnet IDs where instances are provisioned by the compute node group.
     * <p>
     * The subnets must be in the same VPC as the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

    /**
     * The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances.
     * <p>
     * If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-amiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-amiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAmiId() {
        return null;
    }

    /**
     * The name that identifies the compute node group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies how EC2 instances are purchased on your behalf.
     * <p>
     * AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-purchaseoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-purchaseoption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPurchaseOption() {
        return null;
    }

    /**
     * Additional options related to the Slurm scheduler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-slurmconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-slurmconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSlurmConfiguration() {
        return null;
    }

    /**
     * Additional configuration when you specify <code>SPOT</code> as the <code>purchaseOption</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-spotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-spotoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSpotOptions() {
        return null;
    }

    /**
     * 1 or more tags added to the resource.
     * <p>
     * Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcs-computenodegroup.html#cfn-pcs-computenodegroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComputeNodeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComputeNodeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComputeNodeGroupProps> {
        java.lang.String clusterId;
        java.lang.Object customLaunchTemplate;
        java.lang.String iamInstanceProfileArn;
        java.lang.Object instanceConfigs;
        java.lang.Object scalingConfiguration;
        java.util.List<java.lang.String> subnetIds;
        java.lang.String amiId;
        java.lang.String name;
        java.lang.String purchaseOption;
        java.lang.Object slurmConfiguration;
        java.lang.Object spotOptions;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getClusterId}
         * @param clusterId The ID of the cluster of the compute node group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getCustomLaunchTemplate}
         * @param customLaunchTemplate An Amazon EC2 launch template AWS PCS uses to launch compute nodes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLaunchTemplate(software.amazon.awscdk.IResolvable customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getCustomLaunchTemplate}
         * @param customLaunchTemplate An Amazon EC2 launch template AWS PCS uses to launch compute nodes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLaunchTemplate(software.amazon.awscdk.services.pcs.CfnComputeNodeGroup.CustomLaunchTemplateProperty customLaunchTemplate) {
            this.customLaunchTemplate = customLaunchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getIamInstanceProfileArn}
         * @param iamInstanceProfileArn The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM role when launching EC2 instances. This parameter is required.
         *                              The role contained in your instance profile must have pcs:RegisterComputeNodeGroupInstance permissions attached to provision instances correctly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamInstanceProfileArn(java.lang.String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getInstanceConfigs}
         * @param instanceConfigs A list of EC2 instance configurations that AWS PCS can provision in the compute node group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfigs(software.amazon.awscdk.IResolvable instanceConfigs) {
            this.instanceConfigs = instanceConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getInstanceConfigs}
         * @param instanceConfigs A list of EC2 instance configurations that AWS PCS can provision in the compute node group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfigs(java.util.List<? extends java.lang.Object> instanceConfigs) {
            this.instanceConfigs = instanceConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getScalingConfiguration}
         * @param scalingConfiguration Specifies the boundaries of the compute node group auto scaling. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getScalingConfiguration}
         * @param scalingConfiguration Specifies the boundaries of the compute node group auto scaling. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.services.pcs.CfnComputeNodeGroup.ScalingConfigurationProperty scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getSubnetIds}
         * @param subnetIds The list of subnet IDs where instances are provisioned by the compute node group. This parameter is required.
         *                  The subnets must be in the same VPC as the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getAmiId}
         * @param amiId The ID of the Amazon Machine Image (AMI) that AWS PCS uses to launch instances.
         *              If not provided, AWS PCS uses the AMI ID specified in the custom launch template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amiId(java.lang.String amiId) {
            this.amiId = amiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getName}
         * @param name The name that identifies the compute node group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getPurchaseOption}
         * @param purchaseOption Specifies how EC2 instances are purchased on your behalf.
         *                       AWS PCS supports On-Demand and Spot instances. For more information, see Instance purchasing options in the Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it defaults to On-Demand.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder purchaseOption(java.lang.String purchaseOption) {
            this.purchaseOption = purchaseOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getSlurmConfiguration}
         * @param slurmConfiguration Additional options related to the Slurm scheduler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slurmConfiguration(software.amazon.awscdk.IResolvable slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getSlurmConfiguration}
         * @param slurmConfiguration Additional options related to the Slurm scheduler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slurmConfiguration(software.amazon.awscdk.services.pcs.CfnComputeNodeGroup.SlurmConfigurationProperty slurmConfiguration) {
            this.slurmConfiguration = slurmConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getSpotOptions}
         * @param spotOptions Additional configuration when you specify <code>SPOT</code> as the <code>purchaseOption</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.IResolvable spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getSpotOptions}
         * @param spotOptions Additional configuration when you specify <code>SPOT</code> as the <code>purchaseOption</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotOptions(software.amazon.awscdk.services.pcs.CfnComputeNodeGroup.SpotOptionsProperty spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeNodeGroupProps#getTags}
         * @param tags 1 or more tags added to the resource.
         *             Each tag consists of a tag key and tag value. The tag value is optional and can be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComputeNodeGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComputeNodeGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComputeNodeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComputeNodeGroupProps {
        private final java.lang.String clusterId;
        private final java.lang.Object customLaunchTemplate;
        private final java.lang.String iamInstanceProfileArn;
        private final java.lang.Object instanceConfigs;
        private final java.lang.Object scalingConfiguration;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String amiId;
        private final java.lang.String name;
        private final java.lang.String purchaseOption;
        private final java.lang.Object slurmConfiguration;
        private final java.lang.Object spotOptions;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customLaunchTemplate = software.amazon.jsii.Kernel.get(this, "customLaunchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iamInstanceProfileArn = software.amazon.jsii.Kernel.get(this, "iamInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceConfigs = software.amazon.jsii.Kernel.get(this, "instanceConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scalingConfiguration = software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.amiId = software.amazon.jsii.Kernel.get(this, "amiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.purchaseOption = software.amazon.jsii.Kernel.get(this, "purchaseOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slurmConfiguration = software.amazon.jsii.Kernel.get(this, "slurmConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.spotOptions = software.amazon.jsii.Kernel.get(this, "spotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterId = java.util.Objects.requireNonNull(builder.clusterId, "clusterId is required");
            this.customLaunchTemplate = java.util.Objects.requireNonNull(builder.customLaunchTemplate, "customLaunchTemplate is required");
            this.iamInstanceProfileArn = java.util.Objects.requireNonNull(builder.iamInstanceProfileArn, "iamInstanceProfileArn is required");
            this.instanceConfigs = java.util.Objects.requireNonNull(builder.instanceConfigs, "instanceConfigs is required");
            this.scalingConfiguration = java.util.Objects.requireNonNull(builder.scalingConfiguration, "scalingConfiguration is required");
            this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            this.amiId = builder.amiId;
            this.name = builder.name;
            this.purchaseOption = builder.purchaseOption;
            this.slurmConfiguration = builder.slurmConfiguration;
            this.spotOptions = builder.spotOptions;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final java.lang.Object getCustomLaunchTemplate() {
            return this.customLaunchTemplate;
        }

        @Override
        public final java.lang.String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        @Override
        public final java.lang.Object getInstanceConfigs() {
            return this.instanceConfigs;
        }

        @Override
        public final java.lang.Object getScalingConfiguration() {
            return this.scalingConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.lang.String getAmiId() {
            return this.amiId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPurchaseOption() {
            return this.purchaseOption;
        }

        @Override
        public final java.lang.Object getSlurmConfiguration() {
            return this.slurmConfiguration;
        }

        @Override
        public final java.lang.Object getSpotOptions() {
            return this.spotOptions;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterId", om.valueToTree(this.getClusterId()));
            data.set("customLaunchTemplate", om.valueToTree(this.getCustomLaunchTemplate()));
            data.set("iamInstanceProfileArn", om.valueToTree(this.getIamInstanceProfileArn()));
            data.set("instanceConfigs", om.valueToTree(this.getInstanceConfigs()));
            data.set("scalingConfiguration", om.valueToTree(this.getScalingConfiguration()));
            data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            if (this.getAmiId() != null) {
                data.set("amiId", om.valueToTree(this.getAmiId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPurchaseOption() != null) {
                data.set("purchaseOption", om.valueToTree(this.getPurchaseOption()));
            }
            if (this.getSlurmConfiguration() != null) {
                data.set("slurmConfiguration", om.valueToTree(this.getSlurmConfiguration()));
            }
            if (this.getSpotOptions() != null) {
                data.set("spotOptions", om.valueToTree(this.getSpotOptions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcs.CfnComputeNodeGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComputeNodeGroupProps.Jsii$Proxy that = (CfnComputeNodeGroupProps.Jsii$Proxy) o;

            if (!clusterId.equals(that.clusterId)) return false;
            if (!customLaunchTemplate.equals(that.customLaunchTemplate)) return false;
            if (!iamInstanceProfileArn.equals(that.iamInstanceProfileArn)) return false;
            if (!instanceConfigs.equals(that.instanceConfigs)) return false;
            if (!scalingConfiguration.equals(that.scalingConfiguration)) return false;
            if (!subnetIds.equals(that.subnetIds)) return false;
            if (this.amiId != null ? !this.amiId.equals(that.amiId) : that.amiId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.purchaseOption != null ? !this.purchaseOption.equals(that.purchaseOption) : that.purchaseOption != null) return false;
            if (this.slurmConfiguration != null ? !this.slurmConfiguration.equals(that.slurmConfiguration) : that.slurmConfiguration != null) return false;
            if (this.spotOptions != null ? !this.spotOptions.equals(that.spotOptions) : that.spotOptions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + (this.customLaunchTemplate.hashCode());
            result = 31 * result + (this.iamInstanceProfileArn.hashCode());
            result = 31 * result + (this.instanceConfigs.hashCode());
            result = 31 * result + (this.scalingConfiguration.hashCode());
            result = 31 * result + (this.subnetIds.hashCode());
            result = 31 * result + (this.amiId != null ? this.amiId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.purchaseOption != null ? this.purchaseOption.hashCode() : 0);
            result = 31 * result + (this.slurmConfiguration != null ? this.slurmConfiguration.hashCode() : 0);
            result = 31 * result + (this.spotOptions != null ? this.spotOptions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
