package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a <code>CfnDataSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * Object tagRuleConfigurations;
 * CfnDataSetProps cfnDataSetProps = CfnDataSetProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .columnGroups(List.of(ColumnGroupProperty.builder()
 *                 .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .countryCode("countryCode")
 *                         .build())
 *                 .build()))
 *         .columnLevelPermissionRules(List.of(ColumnLevelPermissionRuleProperty.builder()
 *                 .columnNames(List.of("columnNames"))
 *                 .principals(List.of("principals"))
 *                 .build()))
 *         .dataSetId("dataSetId")
 *         .datasetParameters(List.of(DatasetParameterProperty.builder()
 *                 .dateTimeDatasetParameter(DateTimeDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of("staticValues"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build())
 *                 .decimalDatasetParameter(DecimalDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of(123))
 *                                 .build())
 *                         .build())
 *                 .integerDatasetParameter(IntegerDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of(123))
 *                                 .build())
 *                         .build())
 *                 .stringDatasetParameter(StringDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(StringDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of("staticValues"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .dataSetRefreshProperties(DataSetRefreshPropertiesProperty.builder()
 *                 .refreshConfiguration(RefreshConfigurationProperty.builder()
 *                         .incrementalRefresh(IncrementalRefreshProperty.builder()
 *                                 .lookbackWindow(LookbackWindowProperty.builder()
 *                                         .columnName("columnName")
 *                                         .size(123)
 *                                         .sizeUnit("sizeUnit")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .dataSetUsageConfiguration(DataSetUsageConfigurationProperty.builder()
 *                 .disableUseAsDirectQuerySource(false)
 *                 .disableUseAsImportedSource(false)
 *                 .build())
 *         .fieldFolders(Map.of(
 *                 "fieldFoldersKey", FieldFolderProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .description("description")
 *                         .build()))
 *         .folderArns(List.of("folderArns"))
 *         .importMode("importMode")
 *         .ingestionWaitPolicy(IngestionWaitPolicyProperty.builder()
 *                 .ingestionWaitTimeInHours(123)
 *                 .waitForSpiceIngestion(false)
 *                 .build())
 *         .logicalTableMap(Map.of(
 *                 "logicalTableMapKey", LogicalTableProperty.builder()
 *                         .alias("alias")
 *                         // the properties below are optional
 *                         .dataTransforms(List.of(TransformOperationProperty.builder()
 *                                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .newColumnType("newColumnType")
 *                                         // the properties below are optional
 *                                         .format("format")
 *                                         .subType("subType")
 *                                         .build())
 *                                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
 *                                         .columns(List.of(CalculatedColumnProperty.builder()
 *                                                 .columnId("columnId")
 *                                                 .columnName("columnName")
 *                                                 .expression("expression")
 *                                                 .build()))
 *                                         .build())
 *                                 .filterOperation(FilterOperationProperty.builder()
 *                                         .conditionExpression("conditionExpression")
 *                                         .build())
 *                                 .overrideDatasetParameterOperation(OverrideDatasetParameterOperationProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         // the properties below are optional
 *                                         .newDefaultValues(NewDefaultValuesProperty.builder()
 *                                                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
 *                                                 .decimalStaticValues(List.of(123))
 *                                                 .integerStaticValues(List.of(123))
 *                                                 .stringStaticValues(List.of("stringStaticValues"))
 *                                                 .build())
 *                                         .newParameterName("newParameterName")
 *                                         .build())
 *                                 .projectOperation(ProjectOperationProperty.builder()
 *                                         .projectedColumns(List.of("projectedColumns"))
 *                                         .build())
 *                                 .renameColumnOperation(RenameColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .newColumnName("newColumnName")
 *                                         .build())
 *                                 .tagColumnOperation(TagColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .tags(List.of(ColumnTagProperty.builder()
 *                                                 .columnDescription(ColumnDescriptionProperty.builder()
 *                                                         .text("text")
 *                                                         .build())
 *                                                 .columnGeographicRole("columnGeographicRole")
 *                                                 .build()))
 *                                         .build())
 *                                 .untagColumnOperation(UntagColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .tagNames(List.of("tagNames"))
 *                                         .build())
 *                                 .build()))
 *                         .source(LogicalTableSourceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .joinInstruction(JoinInstructionProperty.builder()
 *                                         .leftOperand("leftOperand")
 *                                         .onClause("onClause")
 *                                         .rightOperand("rightOperand")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .build())
 *                                 .physicalTableId("physicalTableId")
 *                                 .build())
 *                         .build()))
 *         .name("name")
 *         .performanceConfiguration(PerformanceConfigurationProperty.builder()
 *                 .uniqueKeys(List.of(UniqueKeyProperty.builder()
 *                         .columnNames(List.of("columnNames"))
 *                         .build()))
 *                 .build())
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .physicalTableMap(Map.of(
 *                 "physicalTableMapKey", PhysicalTableProperty.builder()
 *                         .customSql(CustomSqlProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .name("name")
 *                                 .sqlQuery("sqlQuery")
 *                                 // the properties below are optional
 *                                 .columns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 .build())
 *                         .relationalTable(RelationalTableProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .catalog("catalog")
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 .schema("schema")
 *                                 .build())
 *                         .s3Source(S3SourceProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .uploadSettings(UploadSettingsProperty.builder()
 *                                         .containsHeader(false)
 *                                         .delimiter("delimiter")
 *                                         .format("format")
 *                                         .startFromRow(123)
 *                                         .textQualifier("textQualifier")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *         .rowLevelPermissionDataSet(RowLevelPermissionDataSetProperty.builder()
 *                 .arn("arn")
 *                 .permissionPolicy("permissionPolicy")
 *                 // the properties below are optional
 *                 .formatVersion("formatVersion")
 *                 .namespace("namespace")
 *                 .status("status")
 *                 .build())
 *         .rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfigurationProperty.builder()
 *                 .tagRules(List.of(RowLevelPermissionTagRuleProperty.builder()
 *                         .columnName("columnName")
 *                         .tagKey("tagKey")
 *                         // the properties below are optional
 *                         .matchAllValue("matchAllValue")
 *                         .tagMultiValueDelimiter("tagMultiValueDelimiter")
 *                         .build()))
 *                 // the properties below are optional
 *                 .status("status")
 *                 .tagRuleConfigurations(tagRuleConfigurations)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:28.662Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return null;
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * Currently, only geospatial hierarchy is supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroups() {
        return null;
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getColumnLevelPermissionRules() {
        return null;
    }

    /**
     * An ID for the dataset that you want to create.
     * <p>
     * This ID is unique per AWS Region for each AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return null;
    }

    /**
     * The parameters that are declared in a dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetParameters() {
        return null;
    }

    /**
     * The refresh properties of a dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSetRefreshProperties() {
        return null;
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSetUsageConfiguration() {
        return null;
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFieldFolders() {
        return null;
    }

    /**
     * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-folderarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return null;
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImportMode() {
        return null;
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIngestionWaitPolicy() {
        return null;
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogicalTableMap() {
        return null;
    }

    /**
     * The display name for the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The performance optimization configuration of a dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceConfiguration() {
        return null;
    }

    /**
     * A list of resource permissions on the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return null;
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalTableMap() {
        return null;
    }

    /**
     * The row-level security configuration for the data that you want to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionDataSet() {
        return null;
    }

    /**
     * The element you can use to define tags for row-level security.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionTagConfiguration() {
        return null;
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSetProps> {
        java.lang.String awsAccountId;
        java.lang.Object columnGroups;
        java.lang.Object columnLevelPermissionRules;
        java.lang.String dataSetId;
        java.lang.Object datasetParameters;
        java.lang.Object dataSetRefreshProperties;
        java.lang.Object dataSetUsageConfiguration;
        java.lang.Object fieldFolders;
        java.util.List<java.lang.String> folderArns;
        java.lang.String importMode;
        java.lang.Object ingestionWaitPolicy;
        java.lang.Object logicalTableMap;
        java.lang.String name;
        java.lang.Object performanceConfiguration;
        java.lang.Object permissions;
        java.lang.Object physicalTableMap;
        java.lang.Object rowLevelPermissionDataSet;
        java.lang.Object rowLevelPermissionTagConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataSetProps#getAwsAccountId}
         * @param awsAccountId The AWS account ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getColumnGroups}
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features.
         *                     Currently, only geospatial hierarchy is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(software.amazon.awscdk.IResolvable columnGroups) {
            this.columnGroups = columnGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getColumnGroups}
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features.
         *                     Currently, only geospatial hierarchy is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(java.util.List<? extends java.lang.Object> columnGroups) {
            this.columnGroups = columnGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getColumnLevelPermissionRules}
         * @param columnLevelPermissionRules A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(software.amazon.awscdk.IResolvable columnLevelPermissionRules) {
            this.columnLevelPermissionRules = columnLevelPermissionRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getColumnLevelPermissionRules}
         * @param columnLevelPermissionRules A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(java.util.List<? extends java.lang.Object> columnLevelPermissionRules) {
            this.columnLevelPermissionRules = columnLevelPermissionRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDataSetId}
         * @param dataSetId An ID for the dataset that you want to create.
         *                  This ID is unique per AWS Region for each AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(java.lang.String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDatasetParameters}
         * @param datasetParameters The parameters that are declared in a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetParameters(software.amazon.awscdk.IResolvable datasetParameters) {
            this.datasetParameters = datasetParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDatasetParameters}
         * @param datasetParameters The parameters that are declared in a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetParameters(java.util.List<? extends java.lang.Object> datasetParameters) {
            this.datasetParameters = datasetParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDataSetRefreshProperties}
         * @param dataSetRefreshProperties The refresh properties of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetRefreshProperties(software.amazon.awscdk.IResolvable dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDataSetRefreshProperties}
         * @param dataSetRefreshProperties The refresh properties of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetRefreshProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetRefreshPropertiesProperty dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDataSetUsageConfiguration}
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(software.amazon.awscdk.IResolvable dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getDataSetUsageConfiguration}
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty dataSetUsageConfiguration) {
            this.dataSetUsageConfiguration = dataSetUsageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getFieldFolders}
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(software.amazon.awscdk.IResolvable fieldFolders) {
            this.fieldFolders = fieldFolders;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getFieldFolders}
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(java.util.Map<java.lang.String, ? extends java.lang.Object> fieldFolders) {
            this.fieldFolders = fieldFolders;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getFolderArns}
         * @param folderArns <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(java.util.List<java.lang.String> folderArns) {
            this.folderArns = folderArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getImportMode}
         * @param importMode Indicates whether you want to import the data into SPICE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importMode(java.lang.String importMode) {
            this.importMode = importMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getIngestionWaitPolicy}
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset.
         *                            The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(software.amazon.awscdk.IResolvable ingestionWaitPolicy) {
            this.ingestionWaitPolicy = ingestionWaitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getIngestionWaitPolicy}
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset.
         *                            The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty ingestionWaitPolicy) {
            this.ingestionWaitPolicy = ingestionWaitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getLogicalTableMap}
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(software.amazon.awscdk.IResolvable logicalTableMap) {
            this.logicalTableMap = logicalTableMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getLogicalTableMap}
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(java.util.Map<java.lang.String, ? extends java.lang.Object> logicalTableMap) {
            this.logicalTableMap = logicalTableMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getName}
         * @param name The display name for the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPerformanceConfiguration}
         * @param performanceConfiguration The performance optimization configuration of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceConfiguration(software.amazon.awscdk.IResolvable performanceConfiguration) {
            this.performanceConfiguration = performanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPerformanceConfiguration}
         * @param performanceConfiguration The performance optimization configuration of a dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.PerformanceConfigurationProperty performanceConfiguration) {
            this.performanceConfiguration = performanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPermissions}
         * @param permissions A list of resource permissions on the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(software.amazon.awscdk.IResolvable permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPermissions}
         * @param permissions A list of resource permissions on the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<? extends java.lang.Object> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPhysicalTableMap}
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(software.amazon.awscdk.IResolvable physicalTableMap) {
            this.physicalTableMap = physicalTableMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getPhysicalTableMap}
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(java.util.Map<java.lang.String, ? extends java.lang.Object> physicalTableMap) {
            this.physicalTableMap = physicalTableMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getRowLevelPermissionDataSet}
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(software.amazon.awscdk.IResolvable rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getRowLevelPermissionDataSet}
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getRowLevelPermissionTagConfiguration}
         * @param rowLevelPermissionTagConfiguration The element you can use to define tags for row-level security.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionTagConfiguration(software.amazon.awscdk.IResolvable rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getRowLevelPermissionTagConfiguration}
         * @param rowLevelPermissionTagConfiguration The element you can use to define tags for row-level security.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionTagConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty rowLevelPermissionTagConfiguration) {
            this.rowLevelPermissionTagConfiguration = rowLevelPermissionTagConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSetProps#getTags}
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSetProps {
        private final java.lang.String awsAccountId;
        private final java.lang.Object columnGroups;
        private final java.lang.Object columnLevelPermissionRules;
        private final java.lang.String dataSetId;
        private final java.lang.Object datasetParameters;
        private final java.lang.Object dataSetRefreshProperties;
        private final java.lang.Object dataSetUsageConfiguration;
        private final java.lang.Object fieldFolders;
        private final java.util.List<java.lang.String> folderArns;
        private final java.lang.String importMode;
        private final java.lang.Object ingestionWaitPolicy;
        private final java.lang.Object logicalTableMap;
        private final java.lang.String name;
        private final java.lang.Object performanceConfiguration;
        private final java.lang.Object permissions;
        private final java.lang.Object physicalTableMap;
        private final java.lang.Object rowLevelPermissionDataSet;
        private final java.lang.Object rowLevelPermissionTagConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.columnGroups = software.amazon.jsii.Kernel.get(this, "columnGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.columnLevelPermissionRules = software.amazon.jsii.Kernel.get(this, "columnLevelPermissionRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSetId = software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datasetParameters = software.amazon.jsii.Kernel.get(this, "datasetParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSetRefreshProperties = software.amazon.jsii.Kernel.get(this, "dataSetRefreshProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSetUsageConfiguration = software.amazon.jsii.Kernel.get(this, "dataSetUsageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fieldFolders = software.amazon.jsii.Kernel.get(this, "fieldFolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.folderArns = software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.importMode = software.amazon.jsii.Kernel.get(this, "importMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ingestionWaitPolicy = software.amazon.jsii.Kernel.get(this, "ingestionWaitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logicalTableMap = software.amazon.jsii.Kernel.get(this, "logicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performanceConfiguration = software.amazon.jsii.Kernel.get(this, "performanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.physicalTableMap = software.amazon.jsii.Kernel.get(this, "physicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rowLevelPermissionDataSet = software.amazon.jsii.Kernel.get(this, "rowLevelPermissionDataSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rowLevelPermissionTagConfiguration = software.amazon.jsii.Kernel.get(this, "rowLevelPermissionTagConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = builder.awsAccountId;
            this.columnGroups = builder.columnGroups;
            this.columnLevelPermissionRules = builder.columnLevelPermissionRules;
            this.dataSetId = builder.dataSetId;
            this.datasetParameters = builder.datasetParameters;
            this.dataSetRefreshProperties = builder.dataSetRefreshProperties;
            this.dataSetUsageConfiguration = builder.dataSetUsageConfiguration;
            this.fieldFolders = builder.fieldFolders;
            this.folderArns = builder.folderArns;
            this.importMode = builder.importMode;
            this.ingestionWaitPolicy = builder.ingestionWaitPolicy;
            this.logicalTableMap = builder.logicalTableMap;
            this.name = builder.name;
            this.performanceConfiguration = builder.performanceConfiguration;
            this.permissions = builder.permissions;
            this.physicalTableMap = builder.physicalTableMap;
            this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
            this.rowLevelPermissionTagConfiguration = builder.rowLevelPermissionTagConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.Object getColumnGroups() {
            return this.columnGroups;
        }

        @Override
        public final java.lang.Object getColumnLevelPermissionRules() {
            return this.columnLevelPermissionRules;
        }

        @Override
        public final java.lang.String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final java.lang.Object getDatasetParameters() {
            return this.datasetParameters;
        }

        @Override
        public final java.lang.Object getDataSetRefreshProperties() {
            return this.dataSetRefreshProperties;
        }

        @Override
        public final java.lang.Object getDataSetUsageConfiguration() {
            return this.dataSetUsageConfiguration;
        }

        @Override
        public final java.lang.Object getFieldFolders() {
            return this.fieldFolders;
        }

        @Override
        public final java.util.List<java.lang.String> getFolderArns() {
            return this.folderArns;
        }

        @Override
        public final java.lang.String getImportMode() {
            return this.importMode;
        }

        @Override
        public final java.lang.Object getIngestionWaitPolicy() {
            return this.ingestionWaitPolicy;
        }

        @Override
        public final java.lang.Object getLogicalTableMap() {
            return this.logicalTableMap;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPerformanceConfiguration() {
            return this.performanceConfiguration;
        }

        @Override
        public final java.lang.Object getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.lang.Object getPhysicalTableMap() {
            return this.physicalTableMap;
        }

        @Override
        public final java.lang.Object getRowLevelPermissionDataSet() {
            return this.rowLevelPermissionDataSet;
        }

        @Override
        public final java.lang.Object getRowLevelPermissionTagConfiguration() {
            return this.rowLevelPermissionTagConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAwsAccountId() != null) {
                data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            }
            if (this.getColumnGroups() != null) {
                data.set("columnGroups", om.valueToTree(this.getColumnGroups()));
            }
            if (this.getColumnLevelPermissionRules() != null) {
                data.set("columnLevelPermissionRules", om.valueToTree(this.getColumnLevelPermissionRules()));
            }
            if (this.getDataSetId() != null) {
                data.set("dataSetId", om.valueToTree(this.getDataSetId()));
            }
            if (this.getDatasetParameters() != null) {
                data.set("datasetParameters", om.valueToTree(this.getDatasetParameters()));
            }
            if (this.getDataSetRefreshProperties() != null) {
                data.set("dataSetRefreshProperties", om.valueToTree(this.getDataSetRefreshProperties()));
            }
            if (this.getDataSetUsageConfiguration() != null) {
                data.set("dataSetUsageConfiguration", om.valueToTree(this.getDataSetUsageConfiguration()));
            }
            if (this.getFieldFolders() != null) {
                data.set("fieldFolders", om.valueToTree(this.getFieldFolders()));
            }
            if (this.getFolderArns() != null) {
                data.set("folderArns", om.valueToTree(this.getFolderArns()));
            }
            if (this.getImportMode() != null) {
                data.set("importMode", om.valueToTree(this.getImportMode()));
            }
            if (this.getIngestionWaitPolicy() != null) {
                data.set("ingestionWaitPolicy", om.valueToTree(this.getIngestionWaitPolicy()));
            }
            if (this.getLogicalTableMap() != null) {
                data.set("logicalTableMap", om.valueToTree(this.getLogicalTableMap()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPerformanceConfiguration() != null) {
                data.set("performanceConfiguration", om.valueToTree(this.getPerformanceConfiguration()));
            }
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getPhysicalTableMap() != null) {
                data.set("physicalTableMap", om.valueToTree(this.getPhysicalTableMap()));
            }
            if (this.getRowLevelPermissionDataSet() != null) {
                data.set("rowLevelPermissionDataSet", om.valueToTree(this.getRowLevelPermissionDataSet()));
            }
            if (this.getRowLevelPermissionTagConfiguration() != null) {
                data.set("rowLevelPermissionTagConfiguration", om.valueToTree(this.getRowLevelPermissionTagConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSetProps.Jsii$Proxy that = (CfnDataSetProps.Jsii$Proxy) o;

            if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
            if (this.columnGroups != null ? !this.columnGroups.equals(that.columnGroups) : that.columnGroups != null) return false;
            if (this.columnLevelPermissionRules != null ? !this.columnLevelPermissionRules.equals(that.columnLevelPermissionRules) : that.columnLevelPermissionRules != null) return false;
            if (this.dataSetId != null ? !this.dataSetId.equals(that.dataSetId) : that.dataSetId != null) return false;
            if (this.datasetParameters != null ? !this.datasetParameters.equals(that.datasetParameters) : that.datasetParameters != null) return false;
            if (this.dataSetRefreshProperties != null ? !this.dataSetRefreshProperties.equals(that.dataSetRefreshProperties) : that.dataSetRefreshProperties != null) return false;
            if (this.dataSetUsageConfiguration != null ? !this.dataSetUsageConfiguration.equals(that.dataSetUsageConfiguration) : that.dataSetUsageConfiguration != null) return false;
            if (this.fieldFolders != null ? !this.fieldFolders.equals(that.fieldFolders) : that.fieldFolders != null) return false;
            if (this.folderArns != null ? !this.folderArns.equals(that.folderArns) : that.folderArns != null) return false;
            if (this.importMode != null ? !this.importMode.equals(that.importMode) : that.importMode != null) return false;
            if (this.ingestionWaitPolicy != null ? !this.ingestionWaitPolicy.equals(that.ingestionWaitPolicy) : that.ingestionWaitPolicy != null) return false;
            if (this.logicalTableMap != null ? !this.logicalTableMap.equals(that.logicalTableMap) : that.logicalTableMap != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.performanceConfiguration != null ? !this.performanceConfiguration.equals(that.performanceConfiguration) : that.performanceConfiguration != null) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.physicalTableMap != null ? !this.physicalTableMap.equals(that.physicalTableMap) : that.physicalTableMap != null) return false;
            if (this.rowLevelPermissionDataSet != null ? !this.rowLevelPermissionDataSet.equals(that.rowLevelPermissionDataSet) : that.rowLevelPermissionDataSet != null) return false;
            if (this.rowLevelPermissionTagConfiguration != null ? !this.rowLevelPermissionTagConfiguration.equals(that.rowLevelPermissionTagConfiguration) : that.rowLevelPermissionTagConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
            result = 31 * result + (this.columnGroups != null ? this.columnGroups.hashCode() : 0);
            result = 31 * result + (this.columnLevelPermissionRules != null ? this.columnLevelPermissionRules.hashCode() : 0);
            result = 31 * result + (this.dataSetId != null ? this.dataSetId.hashCode() : 0);
            result = 31 * result + (this.datasetParameters != null ? this.datasetParameters.hashCode() : 0);
            result = 31 * result + (this.dataSetRefreshProperties != null ? this.dataSetRefreshProperties.hashCode() : 0);
            result = 31 * result + (this.dataSetUsageConfiguration != null ? this.dataSetUsageConfiguration.hashCode() : 0);
            result = 31 * result + (this.fieldFolders != null ? this.fieldFolders.hashCode() : 0);
            result = 31 * result + (this.folderArns != null ? this.folderArns.hashCode() : 0);
            result = 31 * result + (this.importMode != null ? this.importMode.hashCode() : 0);
            result = 31 * result + (this.ingestionWaitPolicy != null ? this.ingestionWaitPolicy.hashCode() : 0);
            result = 31 * result + (this.logicalTableMap != null ? this.logicalTableMap.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.performanceConfiguration != null ? this.performanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.physicalTableMap != null ? this.physicalTableMap.hashCode() : 0);
            result = 31 * result + (this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.hashCode() : 0);
            result = 31 * result + (this.rowLevelPermissionTagConfiguration != null ? this.rowLevelPermissionTagConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
