package software.amazon.awscdk.services.rekognition;

/**
 * The <code>AWS::Rekognition::StreamProcessor</code> type creates a stream processor used to detect and recognize faces or to detect connected home labels in a streaming video.
 * <p>
 * Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. There are two different settings for stream processors in Amazon Rekognition, one for detecting faces and one for connected home features.
 * <p>
 * If you are creating a stream processor for detecting faces, you provide a Kinesis video stream (input) and a Kinesis data stream (output). You also specify the face recognition criteria in FaceSearchSettings. For example, the collection containing faces that you want to recognize.
 * <p>
 * If you are creating a stream processor for detection of connected home labels, you provide a Kinesis video stream for input, and for output an Amazon S3 bucket and an Amazon SNS topic. You can also provide a KMS key ID to encrypt the data sent to your Amazon S3 bucket. You specify what you want to detect in ConnectedHomeSettings, such as people, packages, and pets.
 * <p>
 * You can also specify where in the frame you want Amazon Rekognition to monitor with BoundingBoxRegionsOfInterest and PolygonRegionsOfInterest. The Name is used to manage the stream processor and it is the identifier for the stream processor. The <code>AWS::Rekognition::StreamProcessor</code> resource creates a stream processor in the same Region where you create the Amazon CloudFormation stack.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rekognition.*;
 * Object polygonRegionsOfInterest;
 * CfnStreamProcessor cfnStreamProcessor = CfnStreamProcessor.Builder.create(this, "MyCfnStreamProcessor")
 *         .kinesisVideoStream(KinesisVideoStreamProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .boundingBoxRegionsOfInterest(List.of(BoundingBoxProperty.builder()
 *                 .height(123)
 *                 .left(123)
 *                 .top(123)
 *                 .width(123)
 *                 .build()))
 *         .connectedHomeSettings(ConnectedHomeSettingsProperty.builder()
 *                 .labels(List.of("labels"))
 *                 // the properties below are optional
 *                 .minConfidence(123)
 *                 .build())
 *         .dataSharingPreference(DataSharingPreferenceProperty.builder()
 *                 .optIn(false)
 *                 .build())
 *         .faceSearchSettings(FaceSearchSettingsProperty.builder()
 *                 .collectionId("collectionId")
 *                 // the properties below are optional
 *                 .faceMatchThreshold(123)
 *                 .build())
 *         .kinesisDataStream(KinesisDataStreamProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .name("name")
 *         .notificationChannel(NotificationChannelProperty.builder()
 *                 .arn("arn")
 *                 .build())
 *         .polygonRegionsOfInterest(polygonRegionsOfInterest)
 *         .s3Destination(S3DestinationProperty.builder()
 *                 .bucketName("bucketName")
 *                 // the properties below are optional
 *                 .objectKeyPrefix("objectKeyPrefix")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:29.720Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor")
public class CfnStreamProcessor extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnStreamProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStreamProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rekognition.CfnStreamProcessor.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStreamProcessor(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rekognition.CfnStreamProcessorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Amazon Resource Name for the newly created stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Current status of the Amazon Rekognition stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Detailed status message about the stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKinesisVideoStream() {
        return software.amazon.jsii.Kernel.get(this, "kinesisVideoStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisVideoStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisVideoStream", java.util.Objects.requireNonNull(value, "kinesisVideoStream is required"));
    }

    /**
     * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisVideoStream(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisVideoStreamProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisVideoStream", java.util.Objects.requireNonNull(value, "kinesisVideoStream is required"));
    }

    /**
     * The ARN of the IAM role that allows access to the stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM role that allows access to the stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * List of BoundingBox objects, each of which denotes a region of interest on screen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBoundingBoxRegionsOfInterest() {
        return software.amazon.jsii.Kernel.get(this, "boundingBoxRegionsOfInterest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * List of BoundingBox objects, each of which denotes a region of interest on screen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBoundingBoxRegionsOfInterest(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "boundingBoxRegionsOfInterest", value);
    }

    /**
     * List of BoundingBox objects, each of which denotes a region of interest on screen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBoundingBoxRegionsOfInterest(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.rekognition.CfnStreamProcessor.BoundingBoxProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rekognition.CfnStreamProcessor.BoundingBoxProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "boundingBoxRegionsOfInterest", value);
    }

    /**
     * Connected home settings to use on a streaming video.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectedHomeSettings() {
        return software.amazon.jsii.Kernel.get(this, "connectedHomeSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Connected home settings to use on a streaming video.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectedHomeSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectedHomeSettings", value);
    }

    /**
     * Connected home settings to use on a streaming video.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectedHomeSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.ConnectedHomeSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectedHomeSettings", value);
    }

    /**
     * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSharingPreference() {
        return software.amazon.jsii.Kernel.get(this, "dataSharingPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSharingPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSharingPreference", value);
    }

    /**
     * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSharingPreference(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.DataSharingPreferenceProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSharingPreference", value);
    }

    /**
     * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFaceSearchSettings() {
        return software.amazon.jsii.Kernel.get(this, "faceSearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFaceSearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "faceSearchSettings", value);
    }

    /**
     * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFaceSearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.FaceSearchSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "faceSearchSettings", value);
    }

    /**
     * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisDataStream() {
        return software.amazon.jsii.Kernel.get(this, "kinesisDataStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisDataStream(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisDataStream", value);
    }

    /**
     * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisDataStream(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisDataStreamProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisDataStream", value);
    }

    /**
     * The identifier for your Amazon Key Management Service key (Amazon KMS key).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for your Amazon Key Management Service key (Amazon KMS key).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor">StreamProcessor</a> . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor">StreamProcessor</a> . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationChannel() {
        return software.amazon.jsii.Kernel.get(this, "notificationChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationChannel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationChannel", value);
    }

    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationChannel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.NotificationChannelProperty value) {
        software.amazon.jsii.Kernel.set(this, "notificationChannel", value);
    }

    /**
     * A set of ordered lists of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. For more information, see the Polygon field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPolygonRegionsOfInterest() {
        return software.amazon.jsii.Kernel.get(this, "polygonRegionsOfInterest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of ordered lists of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. For more information, see the Polygon field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolygonRegionsOfInterest(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "polygonRegionsOfInterest", value);
    }

    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
        return software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Destination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Destination", value);
    }

    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Destination(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rekognition.CfnStreamProcessor.S3DestinationProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Destination", value);
    }

    /**
     * A set of tags (key-value pairs) that you want to attach to the stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A set of tags (key-value pairs) that you want to attach to the stream processor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Identifies the bounding box around the label, face, text, or personal protective equipment.
     * <p>
     * The <code>left</code> (x-coordinate) and <code>top</code> (y-coordinate) are coordinates representing the top and left sides of the bounding box. Note that the upper-left corner of the image is the origin (0,0).
     * <p>
     * The <code>top</code> and <code>left</code> values returned are ratios of the overall image size. For example, if the input image is 700x200 pixels, and the top-left coordinate of the bounding box is 350x50 pixels, the API returns a <code>left</code> value of 0.5 (350/700) and a <code>top</code> value of 0.25 (50/200).
     * <p>
     * The <code>width</code> and <code>height</code> values represent the dimensions of the bounding box as a ratio of the overall image dimension. For example, if the input image is 700x200 pixels, and the bounding box width is 70 pixels, the width returned is 0.1. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_BoundingBox">BoundingBox</a> .
     * <p>
     * <blockquote>
     * <p>
     * The bounding box coordinates can have negative values. For example, if Amazon Rekognition is able to detect a face that is at the image edge and is only partially visible, the service can return coordinates that are outside the image bounds and, depending on the image edge, you might get negative values or values greater than 1 for the <code>left</code> or <code>top</code> values.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * BoundingBoxProperty boundingBoxProperty = BoundingBoxProperty.builder()
     *         .height(123)
     *         .left(123)
     *         .top(123)
     *         .width(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.BoundingBoxProperty")
    @software.amazon.jsii.Jsii.Proxy(BoundingBoxProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BoundingBoxProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Height of the bounding box as a ratio of the overall image height.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-height">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-height</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHeight();

        /**
         * Left coordinate of the bounding box as a ratio of overall image width.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-left">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-left</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLeft();

        /**
         * Top coordinate of the bounding box as a ratio of overall image height.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-top">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-top</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTop();

        /**
         * Width of the bounding box as a ratio of the overall image width.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-width">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-boundingbox.html#cfn-rekognition-streamprocessor-boundingbox-width</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWidth();

        /**
         * @return a {@link Builder} of {@link BoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BoundingBoxProperty> {
            java.lang.Number height;
            java.lang.Number left;
            java.lang.Number top;
            java.lang.Number width;

            /**
             * Sets the value of {@link BoundingBoxProperty#getHeight}
             * @param height Height of the bounding box as a ratio of the overall image height. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder height(java.lang.Number height) {
                this.height = height;
                return this;
            }

            /**
             * Sets the value of {@link BoundingBoxProperty#getLeft}
             * @param left Left coordinate of the bounding box as a ratio of overall image width. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder left(java.lang.Number left) {
                this.left = left;
                return this;
            }

            /**
             * Sets the value of {@link BoundingBoxProperty#getTop}
             * @param top Top coordinate of the bounding box as a ratio of overall image height. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder top(java.lang.Number top) {
                this.top = top;
                return this;
            }

            /**
             * Sets the value of {@link BoundingBoxProperty#getWidth}
             * @param width Width of the bounding box as a ratio of the overall image width. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder width(java.lang.Number width) {
                this.width = width;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BoundingBoxProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BoundingBoxProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BoundingBoxProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BoundingBoxProperty {
            private final java.lang.Number height;
            private final java.lang.Number left;
            private final java.lang.Number top;
            private final java.lang.Number width;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.left = software.amazon.jsii.Kernel.get(this, "left", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.top = software.amazon.jsii.Kernel.get(this, "top", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.height = java.util.Objects.requireNonNull(builder.height, "height is required");
                this.left = java.util.Objects.requireNonNull(builder.left, "left is required");
                this.top = java.util.Objects.requireNonNull(builder.top, "top is required");
                this.width = java.util.Objects.requireNonNull(builder.width, "width is required");
            }

            @Override
            public final java.lang.Number getHeight() {
                return this.height;
            }

            @Override
            public final java.lang.Number getLeft() {
                return this.left;
            }

            @Override
            public final java.lang.Number getTop() {
                return this.top;
            }

            @Override
            public final java.lang.Number getWidth() {
                return this.width;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("height", om.valueToTree(this.getHeight()));
                data.set("left", om.valueToTree(this.getLeft()));
                data.set("top", om.valueToTree(this.getTop()));
                data.set("width", om.valueToTree(this.getWidth()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.BoundingBoxProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BoundingBoxProperty.Jsii$Proxy that = (BoundingBoxProperty.Jsii$Proxy) o;

                if (!height.equals(that.height)) return false;
                if (!left.equals(that.left)) return false;
                if (!top.equals(that.top)) return false;
                return this.width.equals(that.width);
            }

            @Override
            public final int hashCode() {
                int result = this.height.hashCode();
                result = 31 * result + (this.left.hashCode());
                result = 31 * result + (this.top.hashCode());
                result = 31 * result + (this.width.hashCode());
                return result;
            }
        }
    }
    /**
     * Connected home settings to use on a streaming video.
     * <p>
     * Defining the settings is required in the request parameter for <code>CreateStreamProcessor</code> . Including this setting in the CreateStreamProcessor request lets you use the stream processor for connected home features. You can then select what you want the stream processor to detect, such as people or pets.
     * <p>
     * When the stream processor has started, one notification is sent for each object class specified. For example, if packages and pets are selected, one SNS notification is published the first time a package is detected and one SNS notification is published the first time a pet is detected. An end-of-session summary is also published. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * ConnectedHomeSettingsProperty connectedHomeSettingsProperty = ConnectedHomeSettingsProperty.builder()
     *         .labels(List.of("labels"))
     *         // the properties below are optional
     *         .minConfidence(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.ConnectedHomeSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectedHomeSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectedHomeSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies what you want to detect in the video, such as people, packages, or pets.
         * <p>
         * The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html#cfn-rekognition-streamprocessor-connectedhomesettings-labels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html#cfn-rekognition-streamprocessor-connectedhomesettings-labels</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLabels();

        /**
         * The minimum confidence required to label an object in the video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html#cfn-rekognition-streamprocessor-connectedhomesettings-minconfidence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-connectedhomesettings.html#cfn-rekognition-streamprocessor-connectedhomesettings-minconfidence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinConfidence() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectedHomeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectedHomeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectedHomeSettingsProperty> {
            java.util.List<java.lang.String> labels;
            java.lang.Number minConfidence;

            /**
             * Sets the value of {@link ConnectedHomeSettingsProperty#getLabels}
             * @param labels Specifies what you want to detect in the video, such as people, packages, or pets. This parameter is required.
             *               The current valid labels you can include in this list are: "PERSON", "PET", "PACKAGE", and "ALL".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labels(java.util.List<java.lang.String> labels) {
                this.labels = labels;
                return this;
            }

            /**
             * Sets the value of {@link ConnectedHomeSettingsProperty#getMinConfidence}
             * @param minConfidence The minimum confidence required to label an object in the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minConfidence(java.lang.Number minConfidence) {
                this.minConfidence = minConfidence;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectedHomeSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectedHomeSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectedHomeSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectedHomeSettingsProperty {
            private final java.util.List<java.lang.String> labels;
            private final java.lang.Number minConfidence;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.minConfidence = software.amazon.jsii.Kernel.get(this, "minConfidence", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.labels = java.util.Objects.requireNonNull(builder.labels, "labels is required");
                this.minConfidence = builder.minConfidence;
            }

            @Override
            public final java.util.List<java.lang.String> getLabels() {
                return this.labels;
            }

            @Override
            public final java.lang.Number getMinConfidence() {
                return this.minConfidence;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("labels", om.valueToTree(this.getLabels()));
                if (this.getMinConfidence() != null) {
                    data.set("minConfidence", om.valueToTree(this.getMinConfidence()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.ConnectedHomeSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectedHomeSettingsProperty.Jsii$Proxy that = (ConnectedHomeSettingsProperty.Jsii$Proxy) o;

                if (!labels.equals(that.labels)) return false;
                return this.minConfidence != null ? this.minConfidence.equals(that.minConfidence) : that.minConfidence == null;
            }

            @Override
            public final int hashCode() {
                int result = this.labels.hashCode();
                result = 31 * result + (this.minConfidence != null ? this.minConfidence.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
     * <p>
     * You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level, this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * DataSharingPreferenceProperty dataSharingPreferenceProperty = DataSharingPreferenceProperty.builder()
     *         .optIn(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-datasharingpreference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-datasharingpreference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.DataSharingPreferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSharingPreferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSharingPreferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the opt-in status applied to a stream processor's data sharing policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-datasharingpreference.html#cfn-rekognition-streamprocessor-datasharingpreference-optin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-datasharingpreference.html#cfn-rekognition-streamprocessor-datasharingpreference-optin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptIn();

        /**
         * @return a {@link Builder} of {@link DataSharingPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSharingPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSharingPreferenceProperty> {
            java.lang.Object optIn;

            /**
             * Sets the value of {@link DataSharingPreferenceProperty#getOptIn}
             * @param optIn Describes the opt-in status applied to a stream processor's data sharing policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optIn(java.lang.Boolean optIn) {
                this.optIn = optIn;
                return this;
            }

            /**
             * Sets the value of {@link DataSharingPreferenceProperty#getOptIn}
             * @param optIn Describes the opt-in status applied to a stream processor's data sharing policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optIn(software.amazon.awscdk.IResolvable optIn) {
                this.optIn = optIn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSharingPreferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSharingPreferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSharingPreferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSharingPreferenceProperty {
            private final java.lang.Object optIn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.optIn = software.amazon.jsii.Kernel.get(this, "optIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.optIn = java.util.Objects.requireNonNull(builder.optIn, "optIn is required");
            }

            @Override
            public final java.lang.Object getOptIn() {
                return this.optIn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("optIn", om.valueToTree(this.getOptIn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.DataSharingPreferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSharingPreferenceProperty.Jsii$Proxy that = (DataSharingPreferenceProperty.Jsii$Proxy) o;

                return this.optIn.equals(that.optIn);
            }

            @Override
            public final int hashCode() {
                int result = this.optIn.hashCode();
                return result;
            }
        }
    }
    /**
     * The input parameters used to recognize faces in a streaming video analyzed by a Amazon Rekognition stream processor.
     * <p>
     * <code>FaceSearchSettings</code> is a request parameter for <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> . For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * FaceSearchSettingsProperty faceSearchSettingsProperty = FaceSearchSettingsProperty.builder()
     *         .collectionId("collectionId")
     *         // the properties below are optional
     *         .faceMatchThreshold(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.FaceSearchSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FaceSearchSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FaceSearchSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of a collection that contains faces that you want to search for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html#cfn-rekognition-streamprocessor-facesearchsettings-collectionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html#cfn-rekognition-streamprocessor-facesearchsettings-collectionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

        /**
         * Minimum face match confidence score that must be met to return a result for a recognized face.
         * <p>
         * The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html#cfn-rekognition-streamprocessor-facesearchsettings-facematchthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-facesearchsettings.html#cfn-rekognition-streamprocessor-facesearchsettings-facematchthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFaceMatchThreshold() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FaceSearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FaceSearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FaceSearchSettingsProperty> {
            java.lang.String collectionId;
            java.lang.Number faceMatchThreshold;

            /**
             * Sets the value of {@link FaceSearchSettingsProperty#getCollectionId}
             * @param collectionId The ID of a collection that contains faces that you want to search for. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionId(java.lang.String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            /**
             * Sets the value of {@link FaceSearchSettingsProperty#getFaceMatchThreshold}
             * @param faceMatchThreshold Minimum face match confidence score that must be met to return a result for a recognized face.
             *                           The default is 80. 0 is the lowest confidence. 100 is the highest confidence. Values between 0 and 100 are accepted, and values lower than 80 are set to 80.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder faceMatchThreshold(java.lang.Number faceMatchThreshold) {
                this.faceMatchThreshold = faceMatchThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FaceSearchSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FaceSearchSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FaceSearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FaceSearchSettingsProperty {
            private final java.lang.String collectionId;
            private final java.lang.Number faceMatchThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.faceMatchThreshold = software.amazon.jsii.Kernel.get(this, "faceMatchThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
                this.faceMatchThreshold = builder.faceMatchThreshold;
            }

            @Override
            public final java.lang.String getCollectionId() {
                return this.collectionId;
            }

            @Override
            public final java.lang.Number getFaceMatchThreshold() {
                return this.faceMatchThreshold;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionId", om.valueToTree(this.getCollectionId()));
                if (this.getFaceMatchThreshold() != null) {
                    data.set("faceMatchThreshold", om.valueToTree(this.getFaceMatchThreshold()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.FaceSearchSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FaceSearchSettingsProperty.Jsii$Proxy that = (FaceSearchSettingsProperty.Jsii$Proxy) o;

                if (!collectionId.equals(that.collectionId)) return false;
                return this.faceMatchThreshold != null ? this.faceMatchThreshold.equals(that.faceMatchThreshold) : that.faceMatchThreshold == null;
            }

            @Override
            public final int hashCode() {
                int result = this.collectionId.hashCode();
                result = 31 * result + (this.faceMatchThreshold != null ? this.faceMatchThreshold.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Amazon Rekognition Video Stream Processor take as input a Kinesis video stream (Input) and a Kinesis data stream (Output).
     * <p>
     * This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * KinesisDataStreamProperty kinesisDataStreamProperty = KinesisDataStreamProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisdatastream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisdatastream.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.KinesisDataStreamProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisDataStreamProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisDataStreamProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the output Amazon Kinesis Data Streams stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisdatastream.html#cfn-rekognition-streamprocessor-kinesisdatastream-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisdatastream.html#cfn-rekognition-streamprocessor-kinesisdatastream-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link KinesisDataStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisDataStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisDataStreamProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link KinesisDataStreamProperty#getArn}
             * @param arn ARN of the output Amazon Kinesis Data Streams stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisDataStreamProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisDataStreamProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisDataStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisDataStreamProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.KinesisDataStreamProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisDataStreamProperty.Jsii$Proxy that = (KinesisDataStreamProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * KinesisVideoStreamProperty kinesisVideoStreamProperty = KinesisVideoStreamProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisvideostream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisvideostream.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.KinesisVideoStreamProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisVideoStreamProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisVideoStreamProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the Kinesis video stream stream that streams the source video.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisvideostream.html#cfn-rekognition-streamprocessor-kinesisvideostream-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-kinesisvideostream.html#cfn-rekognition-streamprocessor-kinesisvideostream-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link KinesisVideoStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisVideoStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisVideoStreamProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link KinesisVideoStreamProperty#getArn}
             * @param arn ARN of the Kinesis video stream stream that streams the source video. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisVideoStreamProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisVideoStreamProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisVideoStreamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisVideoStreamProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.KinesisVideoStreamProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisVideoStreamProperty.Jsii$Proxy that = (KinesisVideoStreamProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
     * <p>
     * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * NotificationChannelProperty notificationChannelProperty = NotificationChannelProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-notificationchannel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-notificationchannel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.NotificationChannelProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationChannelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationChannelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the SNS topic that receives notifications.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-notificationchannel.html#cfn-rekognition-streamprocessor-notificationchannel-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-notificationchannel.html#cfn-rekognition-streamprocessor-notificationchannel-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link NotificationChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationChannelProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link NotificationChannelProperty#getArn}
             * @param arn The ARN of the SNS topic that receives notifications. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationChannelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationChannelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationChannelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationChannelProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.NotificationChannelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationChannelProperty.Jsii$Proxy that = (NotificationChannelProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * The X and Y coordinates of a point on an image or video frame.
     * <p>
     * The X and Y values are ratios of the overall image size or video resolution. For example, if the input image is 700x200 and the values are X=0.5 and Y=0.25, then the point is at the (350,50) pixel coordinate on the image.
     * <p>
     * An array of <code>Point</code> objects, <code>Polygon</code> , is returned by <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectText">DetectText</a> and by <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectCustomLabels">DetectCustomLabels</a> or used to define regions of interest in Amazon Rekognition Video operations such as <code>CreateStreamProcessor</code> . <code>Polygon</code> represents a fine-grained polygon around a detected item. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Geometry">Geometry</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * PointProperty pointProperty = PointProperty.builder()
     *         .x(123)
     *         .y(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.PointProperty")
    @software.amazon.jsii.Jsii.Proxy(PointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the X coordinate for a point on a <code>Polygon</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html#cfn-rekognition-streamprocessor-point-x">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html#cfn-rekognition-streamprocessor-point-x</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getX();

        /**
         * The value of the Y coordinate for a point on a <code>Polygon</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html#cfn-rekognition-streamprocessor-point-y">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-point.html#cfn-rekognition-streamprocessor-point-y</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getY();

        /**
         * @return a {@link Builder} of {@link PointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PointProperty> {
            java.lang.Number x;
            java.lang.Number y;

            /**
             * Sets the value of {@link PointProperty#getX}
             * @param x The value of the X coordinate for a point on a <code>Polygon</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x(java.lang.Number x) {
                this.x = x;
                return this;
            }

            /**
             * Sets the value of {@link PointProperty#getY}
             * @param y The value of the Y coordinate for a point on a <code>Polygon</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder y(java.lang.Number y) {
                this.y = y;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PointProperty {
            private final java.lang.Number x;
            private final java.lang.Number y;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x = software.amazon.jsii.Kernel.get(this, "x", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.y = software.amazon.jsii.Kernel.get(this, "y", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x = java.util.Objects.requireNonNull(builder.x, "x is required");
                this.y = java.util.Objects.requireNonNull(builder.y, "y is required");
            }

            @Override
            public final java.lang.Number getX() {
                return this.x;
            }

            @Override
            public final java.lang.Number getY() {
                return this.y;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("x", om.valueToTree(this.getX()));
                data.set("y", om.valueToTree(this.getY()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.PointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PointProperty.Jsii$Proxy that = (PointProperty.Jsii$Proxy) o;

                if (!x.equals(that.x)) return false;
                return this.y.equals(that.y);
            }

            @Override
            public final int hashCode() {
                int result = this.x.hashCode();
                result = 31 * result + (this.y.hashCode());
                return result;
            }
        }
    }
    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     * <p>
     * These results include the name of the stream processor resource, the session ID of the stream processing session, and labeled timestamps and bounding boxes for detected labels. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_S3Destination">S3Destination</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rekognition.*;
     * S3DestinationProperty s3DestinationProperty = S3DestinationProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .objectKeyPrefix("objectKeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CfnStreamProcessor.S3DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name of a stream processor's exports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html#cfn-rekognition-streamprocessor-s3destination-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html#cfn-rekognition-streamprocessor-s3destination-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * Describes the destination Amazon Simple Storage Service (Amazon S3) object keys of a stream processor's exports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html#cfn-rekognition-streamprocessor-s3destination-objectkeyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rekognition-streamprocessor-s3destination.html#cfn-rekognition-streamprocessor-s3destination-objectkeyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationProperty> {
            java.lang.String bucketName;
            java.lang.String objectKeyPrefix;

            /**
             * Sets the value of {@link S3DestinationProperty#getBucketName}
             * @param bucketName Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name of a stream processor's exports. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationProperty#getObjectKeyPrefix}
             * @param objectKeyPrefix Describes the destination Amazon Simple Storage Service (Amazon S3) object keys of a stream processor's exports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String objectKeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.objectKeyPrefix = builder.objectKeyPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getObjectKeyPrefix() {
                return this.objectKeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getObjectKeyPrefix() != null) {
                    data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CfnStreamProcessor.S3DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationProperty.Jsii$Proxy that = (S3DestinationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.objectKeyPrefix != null ? this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rekognition.CfnStreamProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rekognition.CfnStreamProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rekognition.CfnStreamProcessorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rekognition.CfnStreamProcessorProps.Builder();
        }

        /**
         * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisvideostream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisvideostream</a>
         * @param kinesisVideoStream The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStream(final software.amazon.awscdk.IResolvable kinesisVideoStream) {
            this.props.kinesisVideoStream(kinesisVideoStream);
            return this;
        }
        /**
         * The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisVideoStream">KinesisVideoStream</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisvideostream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisvideostream</a>
         * @param kinesisVideoStream The Kinesis video stream that provides the source of the streaming video for an Amazon Rekognition Video stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisVideoStream(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisVideoStreamProperty kinesisVideoStream) {
            this.props.kinesisVideoStream(kinesisVideoStream);
            return this;
        }

        /**
         * The ARN of the IAM role that allows access to the stream processor.
         * <p>
         * The IAM role provides Rekognition read permissions to the Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a connected home stream processor. This is required for both face search and connected home stream processors. For information about constraints, see the RoleArn section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-rolearn</a>
         * @param roleArn The ARN of the IAM role that allows access to the stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * List of BoundingBox objects, each of which denotes a region of interest on screen.
         * <p>
         * For more information, see the BoundingBox field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-boundingboxregionsofinterest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-boundingboxregionsofinterest</a>
         * @param boundingBoxRegionsOfInterest List of BoundingBox objects, each of which denotes a region of interest on screen. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder boundingBoxRegionsOfInterest(final software.amazon.awscdk.IResolvable boundingBoxRegionsOfInterest) {
            this.props.boundingBoxRegionsOfInterest(boundingBoxRegionsOfInterest);
            return this;
        }
        /**
         * List of BoundingBox objects, each of which denotes a region of interest on screen.
         * <p>
         * For more information, see the BoundingBox field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-boundingboxregionsofinterest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-boundingboxregionsofinterest</a>
         * @param boundingBoxRegionsOfInterest List of BoundingBox objects, each of which denotes a region of interest on screen. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder boundingBoxRegionsOfInterest(final java.util.List<? extends java.lang.Object> boundingBoxRegionsOfInterest) {
            this.props.boundingBoxRegionsOfInterest(boundingBoxRegionsOfInterest);
            return this;
        }

        /**
         * Connected home settings to use on a streaming video.
         * <p>
         * You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-connectedhomesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-connectedhomesettings</a>
         * @param connectedHomeSettings Connected home settings to use on a streaming video. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectedHomeSettings(final software.amazon.awscdk.IResolvable connectedHomeSettings) {
            this.props.connectedHomeSettings(connectedHomeSettings);
            return this;
        }
        /**
         * Connected home settings to use on a streaming video.
         * <p>
         * You can use a stream processor for connected home features and select what you want the stream processor to detect, such as people or pets. When the stream processor has started, one notification is sent for each object class specified. For more information, see the ConnectedHome section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorSettings">StreamProcessorSettings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-connectedhomesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-connectedhomesettings</a>
         * @param connectedHomeSettings Connected home settings to use on a streaming video. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectedHomeSettings(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.ConnectedHomeSettingsProperty connectedHomeSettings) {
            this.props.connectedHomeSettings(connectedHomeSettings);
            return this;
        }

        /**
         * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
         * <p>
         * You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-datasharingpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-datasharingpreference</a>
         * @param dataSharingPreference Allows you to opt in or opt out to share data with Rekognition to improve model performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSharingPreference(final software.amazon.awscdk.IResolvable dataSharingPreference) {
            this.props.dataSharingPreference(dataSharingPreference);
            return this;
        }
        /**
         * Allows you to opt in or opt out to share data with Rekognition to improve model performance.
         * <p>
         * You can choose this option at the account level or on a per-stream basis. Note that if you opt out at the account level this setting is ignored on individual streams. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorDataSharingPreference">StreamProcessorDataSharingPreference</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-datasharingpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-datasharingpreference</a>
         * @param dataSharingPreference Allows you to opt in or opt out to share data with Rekognition to improve model performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSharingPreference(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.DataSharingPreferenceProperty dataSharingPreference) {
            this.props.dataSharingPreference(dataSharingPreference);
            return this;
        }

        /**
         * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
         * <p>
         * For more information regarding the contents of the parameters, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-facesearchsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-facesearchsettings</a>
         * @param faceSearchSettings The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faceSearchSettings(final software.amazon.awscdk.IResolvable faceSearchSettings) {
            this.props.faceSearchSettings(faceSearchSettings);
            return this;
        }
        /**
         * The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor.
         * <p>
         * For more information regarding the contents of the parameters, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_FaceSearchSettings">FaceSearchSettings</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-facesearchsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-facesearchsettings</a>
         * @param faceSearchSettings The input parameters used to recognize faces in a streaming video analyzed by an Amazon Rekognition stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder faceSearchSettings(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.FaceSearchSettingsProperty faceSearchSettings) {
            this.props.faceSearchSettings(faceSearchSettings);
            return this;
        }

        /**
         * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
         * <p>
         * This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisdatastream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisdatastream</a>
         * @param kinesisDataStream Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisDataStream(final software.amazon.awscdk.IResolvable kinesisDataStream) {
            this.props.kinesisDataStream(kinesisDataStream);
            return this;
        }
        /**
         * Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input.
         * <p>
         * This is the Amazon Kinesis Data Streams instance to which the Amazon Rekognition stream processor streams the analysis results. This must be created within the constraints specified at <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_KinesisDataStream">KinesisDataStream</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisdatastream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kinesisdatastream</a>
         * @param kinesisDataStream Amazon Rekognition's Video Stream Processor takes a Kinesis video stream as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisDataStream(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.KinesisDataStreamProperty kinesisDataStream) {
            this.props.kinesisDataStream(kinesisDataStream);
            return this;
        }

        /**
         * The identifier for your Amazon Key Management Service key (Amazon KMS key).
         * <p>
         * Optional parameter for connected home stream processors used to encrypt results and data published to your Amazon S3 bucket. For more information, see the KMSKeyId section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-kmskeyid</a>
         * @param kmsKeyId The identifier for your Amazon Key Management Service key (Amazon KMS key). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor">StreamProcessor</a> . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-name</a>
         * @param name The Name attribute specifies the name of the stream processor and it must be within the constraints described in the Name section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessor">StreamProcessor</a> . If you don't specify a name, Amazon CloudFormation generates a unique ID and uses that ID for the stream processor name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
         * <p>
         * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-notificationchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-notificationchannel</a>
         * @param notificationChannel The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationChannel(final software.amazon.awscdk.IResolvable notificationChannel) {
            this.props.notificationChannel(notificationChannel);
            return this;
        }
        /**
         * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation.
         * <p>
         * Amazon Rekognition publishes a notification the first time an object of interest or a person is detected in the video stream. Amazon Rekognition also publishes an end-of-session notification with a summary when the stream processing session is complete. For more information, see <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorNotificationChannel">StreamProcessorNotificationChannel</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-notificationchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-notificationchannel</a>
         * @param notificationChannel The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the object detection results and completion status of a video analysis operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationChannel(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.NotificationChannelProperty notificationChannel) {
            this.props.notificationChannel(notificationChannel);
            return this;
        }

        /**
         * A set of ordered lists of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. For more information, see the Polygon field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-polygonregionsofinterest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-polygonregionsofinterest</a>
         * @param polygonRegionsOfInterest A set of ordered lists of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. Each entry of the set contains a polygon denoting a region of interest on the screen. Each polygon is an ordered list of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_Point">Point</a> objects. For more information, see the Polygon field of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RegionOfInterest">RegionOfInterest</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder polygonRegionsOfInterest(final java.lang.Object polygonRegionsOfInterest) {
            this.props.polygonRegionsOfInterest(polygonRegionsOfInterest);
            return this;
        }

        /**
         * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
         * <p>
         * For more information, see the S3Destination section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput">StreamProcessorOutput</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-s3destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-s3destination</a>
         * @param s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(final software.amazon.awscdk.IResolvable s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }
        /**
         * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
         * <p>
         * For more information, see the S3Destination section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StreamProcessorOutput">StreamProcessorOutput</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-s3destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-s3destination</a>
         * @param s3Destination The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(final software.amazon.awscdk.services.rekognition.CfnStreamProcessor.S3DestinationProperty s3Destination) {
            this.props.s3Destination(s3Destination);
            return this;
        }

        /**
         * A set of tags (key-value pairs) that you want to attach to the stream processor.
         * <p>
         * For more information, see the Tags section of <a href="https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor">CreateStreamProcessor</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rekognition-streamprocessor.html#cfn-rekognition-streamprocessor-tags</a>
         * @param tags A set of tags (key-value pairs) that you want to attach to the stream processor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rekognition.CfnStreamProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rekognition.CfnStreamProcessor build() {
            return new software.amazon.awscdk.services.rekognition.CfnStreamProcessor(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
