package software.amazon.awscdk.services.route53;

/**
 * Properties for a CAA record value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CaaRecordValue caaRecordValue = CaaRecordValue.builder()
 *         .flag(123)
 *         .tag(CaaTag.ISSUE)
 *         .value("value")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:29.806Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CaaRecordValue")
@software.amazon.jsii.Jsii.Proxy(CaaRecordValue.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CaaRecordValue extends software.amazon.jsii.JsiiSerializable {

    /**
     * The flag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getFlag();

    /**
     * The tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CaaTag getTag();

    /**
     * The value associated with the tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * @return a {@link Builder} of {@link CaaRecordValue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CaaRecordValue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CaaRecordValue> {
        java.lang.Number flag;
        software.amazon.awscdk.services.route53.CaaTag tag;
        java.lang.String value;

        /**
         * Sets the value of {@link CaaRecordValue#getFlag}
         * @param flag The flag. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flag(java.lang.Number flag) {
            this.flag = flag;
            return this;
        }

        /**
         * Sets the value of {@link CaaRecordValue#getTag}
         * @param tag The tag. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(software.amazon.awscdk.services.route53.CaaTag tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Sets the value of {@link CaaRecordValue#getValue}
         * @param value The value associated with the tag. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CaaRecordValue}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CaaRecordValue build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CaaRecordValue}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaaRecordValue {
        private final java.lang.Number flag;
        private final software.amazon.awscdk.services.route53.CaaTag tag;
        private final java.lang.String value;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flag = software.amazon.jsii.Kernel.get(this, "flag", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CaaTag.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flag = java.util.Objects.requireNonNull(builder.flag, "flag is required");
            this.tag = java.util.Objects.requireNonNull(builder.tag, "tag is required");
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
        }

        @Override
        public final java.lang.Number getFlag() {
            return this.flag;
        }

        @Override
        public final software.amazon.awscdk.services.route53.CaaTag getTag() {
            return this.tag;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flag", om.valueToTree(this.getFlag()));
            data.set("tag", om.valueToTree(this.getTag()));
            data.set("value", om.valueToTree(this.getValue()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CaaRecordValue"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CaaRecordValue.Jsii$Proxy that = (CaaRecordValue.Jsii$Proxy) o;

            if (!flag.equals(that.flag)) return false;
            if (!tag.equals(that.tag)) return false;
            return this.value.equals(that.value);
        }

        @Override
        public final int hashCode() {
            int result = this.flag.hashCode();
            result = 31 * result + (this.tag.hashCode());
            result = 31 * result + (this.value.hashCode());
            return result;
        }
    }
}
