package software.amazon.awscdk.services.s3;

/**
 * Modes in which S3 Object Lock retention can be configured.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html#object-lock-retention-modes">https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html#object-lock-retention-modes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:30.170Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.ObjectLockMode")
public enum ObjectLockMode {
    /**
     * The Governance retention mode.
     * <p>
     * With governance mode, you protect objects against being deleted by most users, but you can
     * still grant some users permission to alter the retention settings or delete the object if
     * necessary. You can also use governance mode to test retention-period settings before
     * creating a compliance-mode retention period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GOVERNANCE,
    /**
     * The Compliance retention mode.
     * <p>
     * When an object is locked in compliance mode, its retention mode can't be changed, and
     * its retention period can't be shortened. Compliance mode helps ensure that an object
     * version can't be overwritten or deleted for the duration of the retention period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPLIANCE,
}
