package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnModelPackage</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object modelInput;
 * CfnModelPackageProps cfnModelPackageProps = CfnModelPackageProps.builder()
 *         .additionalInferenceSpecifications(List.of(AdditionalInferenceSpecificationDefinitionProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataSource(ModelDataSourceProperty.builder()
 *                                 .s3DataSource(S3ModelDataSourceProperty.builder()
 *                                         .compressionType("compressionType")
 *                                         .s3DataType("s3DataType")
 *                                         .s3Uri("s3Uri")
 *                                         // the properties below are optional
 *                                         .modelAccessConfig(ModelAccessConfigProperty.builder()
 *                                                 .acceptEula(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build()))
 *         .additionalInferenceSpecificationsToAdd(List.of(AdditionalInferenceSpecificationDefinitionProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataSource(ModelDataSourceProperty.builder()
 *                                 .s3DataSource(S3ModelDataSourceProperty.builder()
 *                                         .compressionType("compressionType")
 *                                         .s3DataType("s3DataType")
 *                                         .s3Uri("s3Uri")
 *                                         // the properties below are optional
 *                                         .modelAccessConfig(ModelAccessConfigProperty.builder()
 *                                                 .acceptEula(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build()))
 *         .approvalDescription("approvalDescription")
 *         .certifyForMarketplace(false)
 *         .clientToken("clientToken")
 *         .customerMetadataProperties(Map.of(
 *                 "customerMetadataPropertiesKey", "customerMetadataProperties"))
 *         .domain("domain")
 *         .driftCheckBaselines(DriftCheckBaselinesProperty.builder()
 *                 .bias(DriftCheckBiasProperty.builder()
 *                         .configFile(FileSourceProperty.builder()
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .contentType("contentType")
 *                                 .build())
 *                         .postTrainingConstraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .preTrainingConstraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .explainability(DriftCheckExplainabilityProperty.builder()
 *                         .configFile(FileSourceProperty.builder()
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .contentType("contentType")
 *                                 .build())
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelDataQuality(DriftCheckModelDataQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelQuality(DriftCheckModelQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .inferenceSpecification(InferenceSpecificationProperty.builder()
 *                 .containers(List.of(ModelPackageContainerDefinitionProperty.builder()
 *                         .image("image")
 *                         // the properties below are optional
 *                         .containerHostname("containerHostname")
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .framework("framework")
 *                         .frameworkVersion("frameworkVersion")
 *                         .imageDigest("imageDigest")
 *                         .modelDataSource(ModelDataSourceProperty.builder()
 *                                 .s3DataSource(S3ModelDataSourceProperty.builder()
 *                                         .compressionType("compressionType")
 *                                         .s3DataType("s3DataType")
 *                                         .s3Uri("s3Uri")
 *                                         // the properties below are optional
 *                                         .modelAccessConfig(ModelAccessConfigProperty.builder()
 *                                                 .acceptEula(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .modelDataUrl("modelDataUrl")
 *                         .modelInput(modelInput)
 *                         .nearestModelName("nearestModelName")
 *                         .build()))
 *                 .supportedContentTypes(List.of("supportedContentTypes"))
 *                 .supportedResponseMimeTypes(List.of("supportedResponseMimeTypes"))
 *                 // the properties below are optional
 *                 .supportedRealtimeInferenceInstanceTypes(List.of("supportedRealtimeInferenceInstanceTypes"))
 *                 .supportedTransformInstanceTypes(List.of("supportedTransformInstanceTypes"))
 *                 .build())
 *         .lastModifiedTime("lastModifiedTime")
 *         .metadataProperties(MetadataPropertiesProperty.builder()
 *                 .commitId("commitId")
 *                 .generatedBy("generatedBy")
 *                 .projectId("projectId")
 *                 .repository("repository")
 *                 .build())
 *         .modelApprovalStatus("modelApprovalStatus")
 *         .modelCard(ModelCardProperty.builder()
 *                 .modelCardContent("modelCardContent")
 *                 .modelCardStatus("modelCardStatus")
 *                 .build())
 *         .modelMetrics(ModelMetricsProperty.builder()
 *                 .bias(BiasProperty.builder()
 *                         .postTrainingReport(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .preTrainingReport(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .report(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .explainability(ExplainabilityProperty.builder()
 *                         .report(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelDataQuality(ModelDataQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .modelQuality(ModelQualityProperty.builder()
 *                         .constraints(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .statistics(MetricsSourceProperty.builder()
 *                                 .contentType("contentType")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .contentDigest("contentDigest")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .modelPackageDescription("modelPackageDescription")
 *         .modelPackageGroupName("modelPackageGroupName")
 *         .modelPackageName("modelPackageName")
 *         .modelPackageStatusDetails(ModelPackageStatusDetailsProperty.builder()
 *                 .validationStatuses(List.of(ModelPackageStatusItemProperty.builder()
 *                         .name("name")
 *                         .status("status")
 *                         // the properties below are optional
 *                         .failureReason("failureReason")
 *                         .build()))
 *                 .build())
 *         .modelPackageVersion(123)
 *         .samplePayloadUrl("samplePayloadUrl")
 *         .securityConfig(SecurityConfigProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .skipModelValidation("skipModelValidation")
 *         .sourceAlgorithmSpecification(SourceAlgorithmSpecificationProperty.builder()
 *                 .sourceAlgorithms(List.of(SourceAlgorithmProperty.builder()
 *                         .algorithmName("algorithmName")
 *                         // the properties below are optional
 *                         .modelDataUrl("modelDataUrl")
 *                         .build()))
 *                 .build())
 *         .sourceUri("sourceUri")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .task("task")
 *         .validationSpecification(ValidationSpecificationProperty.builder()
 *                 .validationProfiles(List.of(ValidationProfileProperty.builder()
 *                         .profileName("profileName")
 *                         .transformJobDefinition(TransformJobDefinitionProperty.builder()
 *                                 .transformInput(TransformInputProperty.builder()
 *                                         .dataSource(DataSourceProperty.builder()
 *                                                 .s3DataSource(S3DataSourceProperty.builder()
 *                                                         .s3DataType("s3DataType")
 *                                                         .s3Uri("s3Uri")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .compressionType("compressionType")
 *                                         .contentType("contentType")
 *                                         .splitType("splitType")
 *                                         .build())
 *                                 .transformOutput(TransformOutputProperty.builder()
 *                                         .s3OutputPath("s3OutputPath")
 *                                         // the properties below are optional
 *                                         .accept("accept")
 *                                         .assembleWith("assembleWith")
 *                                         .kmsKeyId("kmsKeyId")
 *                                         .build())
 *                                 .transformResources(TransformResourcesProperty.builder()
 *                                         .instanceCount(123)
 *                                         .instanceType("instanceType")
 *                                         // the properties below are optional
 *                                         .volumeKmsKeyId("volumeKmsKeyId")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .batchStrategy("batchStrategy")
 *                                 .environment(Map.of(
 *                                         "environmentKey", "environment"))
 *                                 .maxConcurrentTransforms(123)
 *                                 .maxPayloadInMb(123)
 *                                 .build())
 *                         .build()))
 *                 .validationRole("validationRole")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:30.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnModelPackageProps")
@software.amazon.jsii.Jsii.Proxy(CfnModelPackageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnModelPackageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of additional Inference Specification objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-additionalinferencespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-additionalinferencespecifications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInferenceSpecifications() {
        return null;
    }

    /**
     * An array of additional Inference Specification objects to be added to the existing array.
     * <p>
     * The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-additionalinferencespecificationstoadd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-additionalinferencespecificationstoadd</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInferenceSpecificationsToAdd() {
        return null;
    }

    /**
     * A description provided when the model approval is set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-approvaldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-approvaldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApprovalDescription() {
        return null;
    }

    /**
     * Whether the model package is to be certified to be listed on AWS Marketplace.
     * <p>
     * For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-certifyformarketplace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-certifyformarketplace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertifyForMarketplace() {
        return null;
    }

    /**
     * A unique token that guarantees that the call to this API is idempotent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-clienttoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * The metadata properties for the model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-customermetadataproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-customermetadataproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerMetadataProperties() {
        return null;
    }

    /**
     * The machine learning domain of your model package and its components.
     * <p>
     * Common machine learning domains include computer vision and natural language processing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-driftcheckbaselines">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-driftcheckbaselines</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDriftCheckBaselines() {
        return null;
    }

    /**
     * Defines how to perform inference generation after a training job is run.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-inferencespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-inferencespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceSpecification() {
        return null;
    }

    /**
     * The last time the model package was modified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-lastmodifiedtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-lastmodifiedtime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLastModifiedTime() {
        return null;
    }

    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-metadataproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-metadataproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataProperties() {
        return null;
    }

    /**
     * The approval status of the model. This can be one of the following values.
     * <p>
     * <ul>
     * <li><code>APPROVED</code> - The model is approved</li>
     * <li><code>REJECTED</code> - The model is rejected.</li>
     * <li><code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelapprovalstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelapprovalstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelApprovalStatus() {
        return null;
    }

    /**
     * An Amazon SageMaker Model Card.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelcard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelcard</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelCard() {
        return null;
    }

    /**
     * Metrics for the model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelmetrics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelMetrics() {
        return null;
    }

    /**
     * The description of the model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagedescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelPackageDescription() {
        return null;
    }

    /**
     * The model group to which the model belongs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagegroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelPackageGroupName() {
        return null;
    }

    /**
     * The name of the model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelPackageName() {
        return null;
    }

    /**
     * Specifies the validation and image scan statuses of the model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagestatusdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackagestatusdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getModelPackageStatusDetails() {
        return null;
    }

    /**
     * The version number of a versioned model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackageversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-modelpackageversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getModelPackageVersion() {
        return null;
    }

    /**
     * The Amazon Simple Storage Service path where the sample payload are stored.
     * <p>
     * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-samplepayloadurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-samplepayloadurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSamplePayloadUrl() {
        return null;
    }

    /**
     * An optional AWS Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-securityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-securityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityConfig() {
        return null;
    }

    /**
     * Indicates if you want to skip model validation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-skipmodelvalidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-skipmodelvalidation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSkipModelValidation() {
        return null;
    }

    /**
     * A list of algorithms that were used to create a model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-sourcealgorithmspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-sourcealgorithmspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceAlgorithmSpecification() {
        return null;
    }

    /**
     * The URI of the source for the model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-sourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-sourceuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceUri() {
        return null;
    }

    /**
     * A list of the tags associated with the model package.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The machine learning task your model package accomplishes.
     * <p>
     * Common machine learning tasks include object detection and image classification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-task">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-task</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTask() {
        return null;
    }

    /**
     * Specifies batch transform jobs that SageMaker runs to validate your model package.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-validationspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackage.html#cfn-sagemaker-modelpackage-validationspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidationSpecification() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnModelPackageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnModelPackageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnModelPackageProps> {
        java.lang.Object additionalInferenceSpecifications;
        java.lang.Object additionalInferenceSpecificationsToAdd;
        java.lang.String approvalDescription;
        java.lang.Object certifyForMarketplace;
        java.lang.String clientToken;
        java.lang.Object customerMetadataProperties;
        java.lang.String domain;
        java.lang.Object driftCheckBaselines;
        java.lang.Object inferenceSpecification;
        java.lang.String lastModifiedTime;
        java.lang.Object metadataProperties;
        java.lang.String modelApprovalStatus;
        java.lang.Object modelCard;
        java.lang.Object modelMetrics;
        java.lang.String modelPackageDescription;
        java.lang.String modelPackageGroupName;
        java.lang.String modelPackageName;
        java.lang.Object modelPackageStatusDetails;
        java.lang.Number modelPackageVersion;
        java.lang.String samplePayloadUrl;
        java.lang.Object securityConfig;
        java.lang.String skipModelValidation;
        java.lang.Object sourceAlgorithmSpecification;
        java.lang.String sourceUri;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String task;
        java.lang.Object validationSpecification;

        /**
         * Sets the value of {@link CfnModelPackageProps#getAdditionalInferenceSpecifications}
         * @param additionalInferenceSpecifications An array of additional Inference Specification objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecifications(software.amazon.awscdk.IResolvable additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = additionalInferenceSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getAdditionalInferenceSpecifications}
         * @param additionalInferenceSpecifications An array of additional Inference Specification objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecifications(java.util.List<? extends java.lang.Object> additionalInferenceSpecifications) {
            this.additionalInferenceSpecifications = additionalInferenceSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getAdditionalInferenceSpecificationsToAdd}
         * @param additionalInferenceSpecificationsToAdd An array of additional Inference Specification objects to be added to the existing array.
         *                                               The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationsToAdd(software.amazon.awscdk.IResolvable additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = additionalInferenceSpecificationsToAdd;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getAdditionalInferenceSpecificationsToAdd}
         * @param additionalInferenceSpecificationsToAdd An array of additional Inference Specification objects to be added to the existing array.
         *                                               The total number of additional Inference Specification objects cannot exceed 15. Each additional Inference Specification object specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalInferenceSpecificationsToAdd(java.util.List<? extends java.lang.Object> additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd = additionalInferenceSpecificationsToAdd;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getApprovalDescription}
         * @param approvalDescription A description provided when the model approval is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder approvalDescription(java.lang.String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getCertifyForMarketplace}
         * @param certifyForMarketplace Whether the model package is to be certified to be listed on AWS Marketplace.
         *                              For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certifyForMarketplace(java.lang.Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getCertifyForMarketplace}
         * @param certifyForMarketplace Whether the model package is to be certified to be listed on AWS Marketplace.
         *                              For information about listing model packages on AWS Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on AWS Marketplace</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certifyForMarketplace(software.amazon.awscdk.IResolvable certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getClientToken}
         * @param clientToken A unique token that guarantees that the call to this API is idempotent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getCustomerMetadataProperties}
         * @param customerMetadataProperties The metadata properties for the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerMetadataProperties(software.amazon.awscdk.IResolvable customerMetadataProperties) {
            this.customerMetadataProperties = customerMetadataProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getCustomerMetadataProperties}
         * @param customerMetadataProperties The metadata properties for the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerMetadataProperties(java.util.Map<java.lang.String, java.lang.String> customerMetadataProperties) {
            this.customerMetadataProperties = customerMetadataProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getDomain}
         * @param domain The machine learning domain of your model package and its components.
         *               Common machine learning domains include computer vision and natural language processing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getDriftCheckBaselines}
         * @param driftCheckBaselines Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driftCheckBaselines(software.amazon.awscdk.IResolvable driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getDriftCheckBaselines}
         * @param driftCheckBaselines Represents the drift check baselines that can be used when the model monitor is set using the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder driftCheckBaselines(software.amazon.awscdk.services.sagemaker.CfnModelPackage.DriftCheckBaselinesProperty driftCheckBaselines) {
            this.driftCheckBaselines = driftCheckBaselines;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getInferenceSpecification}
         * @param inferenceSpecification Defines how to perform inference generation after a training job is run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSpecification(software.amazon.awscdk.IResolvable inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getInferenceSpecification}
         * @param inferenceSpecification Defines how to perform inference generation after a training job is run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSpecification(software.amazon.awscdk.services.sagemaker.CfnModelPackage.InferenceSpecificationProperty inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getLastModifiedTime}
         * @param lastModifiedTime The last time the model package was modified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastModifiedTime(java.lang.String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getMetadataProperties}
         * @param metadataProperties Metadata properties of the tracking entity, trial, or trial component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataProperties(software.amazon.awscdk.IResolvable metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getMetadataProperties}
         * @param metadataProperties Metadata properties of the tracking entity, trial, or trial component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataProperties(software.amazon.awscdk.services.sagemaker.CfnModelPackage.MetadataPropertiesProperty metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelApprovalStatus}
         * @param modelApprovalStatus The approval status of the model. This can be one of the following values.
         *                            <ul>
         *                            <li><code>APPROVED</code> - The model is approved</li>
         *                            <li><code>REJECTED</code> - The model is rejected.</li>
         *                            <li><code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</li>
         *                            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelApprovalStatus(java.lang.String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelCard}
         * @param modelCard An Amazon SageMaker Model Card.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCard(software.amazon.awscdk.IResolvable modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelCard}
         * @param modelCard An Amazon SageMaker Model Card.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCard(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelCardProperty modelCard) {
            this.modelCard = modelCard;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelMetrics}
         * @param modelMetrics Metrics for the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelMetrics(software.amazon.awscdk.IResolvable modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelMetrics}
         * @param modelMetrics Metrics for the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelMetrics(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelMetricsProperty modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageDescription}
         * @param modelPackageDescription The description of the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageDescription(java.lang.String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageGroupName}
         * @param modelPackageGroupName The model group to which the model belongs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageGroupName(java.lang.String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageName}
         * @param modelPackageName The name of the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageName(java.lang.String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageStatusDetails}
         * @param modelPackageStatusDetails Specifies the validation and image scan statuses of the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusDetails(software.amazon.awscdk.IResolvable modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageStatusDetails}
         * @param modelPackageStatusDetails Specifies the validation and image scan statuses of the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageStatusDetails(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getModelPackageVersion}
         * @param modelPackageVersion The version number of a versioned model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageVersion(java.lang.Number modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSamplePayloadUrl}
         * @param samplePayloadUrl The Amazon Simple Storage Service path where the sample payload are stored.
         *                         This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samplePayloadUrl(java.lang.String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSecurityConfig}
         * @param securityConfig An optional AWS Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfig(software.amazon.awscdk.IResolvable securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSecurityConfig}
         * @param securityConfig An optional AWS Key Management Service key to encrypt, decrypt, and re-encrypt model package information for regulated workloads with highly sensitive data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfig(software.amazon.awscdk.services.sagemaker.CfnModelPackage.SecurityConfigProperty securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSkipModelValidation}
         * @param skipModelValidation Indicates if you want to skip model validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipModelValidation(java.lang.String skipModelValidation) {
            this.skipModelValidation = skipModelValidation;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSourceAlgorithmSpecification}
         * @param sourceAlgorithmSpecification A list of algorithms that were used to create a model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAlgorithmSpecification(software.amazon.awscdk.IResolvable sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSourceAlgorithmSpecification}
         * @param sourceAlgorithmSpecification A list of algorithms that were used to create a model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAlgorithmSpecification(software.amazon.awscdk.services.sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getSourceUri}
         * @param sourceUri The URI of the source for the model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceUri(java.lang.String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getTags}
         * @param tags A list of the tags associated with the model package.
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getTask}
         * @param task The machine learning task your model package accomplishes.
         *             Common machine learning tasks include object detection and image classification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder task(java.lang.String task) {
            this.task = task;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getValidationSpecification}
         * @param validationSpecification Specifies batch transform jobs that SageMaker runs to validate your model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationSpecification(software.amazon.awscdk.IResolvable validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnModelPackageProps#getValidationSpecification}
         * @param validationSpecification Specifies batch transform jobs that SageMaker runs to validate your model package.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationSpecification(software.amazon.awscdk.services.sagemaker.CfnModelPackage.ValidationSpecificationProperty validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnModelPackageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnModelPackageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnModelPackageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnModelPackageProps {
        private final java.lang.Object additionalInferenceSpecifications;
        private final java.lang.Object additionalInferenceSpecificationsToAdd;
        private final java.lang.String approvalDescription;
        private final java.lang.Object certifyForMarketplace;
        private final java.lang.String clientToken;
        private final java.lang.Object customerMetadataProperties;
        private final java.lang.String domain;
        private final java.lang.Object driftCheckBaselines;
        private final java.lang.Object inferenceSpecification;
        private final java.lang.String lastModifiedTime;
        private final java.lang.Object metadataProperties;
        private final java.lang.String modelApprovalStatus;
        private final java.lang.Object modelCard;
        private final java.lang.Object modelMetrics;
        private final java.lang.String modelPackageDescription;
        private final java.lang.String modelPackageGroupName;
        private final java.lang.String modelPackageName;
        private final java.lang.Object modelPackageStatusDetails;
        private final java.lang.Number modelPackageVersion;
        private final java.lang.String samplePayloadUrl;
        private final java.lang.Object securityConfig;
        private final java.lang.String skipModelValidation;
        private final java.lang.Object sourceAlgorithmSpecification;
        private final java.lang.String sourceUri;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String task;
        private final java.lang.Object validationSpecification;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalInferenceSpecifications = software.amazon.jsii.Kernel.get(this, "additionalInferenceSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.additionalInferenceSpecificationsToAdd = software.amazon.jsii.Kernel.get(this, "additionalInferenceSpecificationsToAdd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.approvalDescription = software.amazon.jsii.Kernel.get(this, "approvalDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certifyForMarketplace = software.amazon.jsii.Kernel.get(this, "certifyForMarketplace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerMetadataProperties = software.amazon.jsii.Kernel.get(this, "customerMetadataProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.driftCheckBaselines = software.amazon.jsii.Kernel.get(this, "driftCheckBaselines", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inferenceSpecification = software.amazon.jsii.Kernel.get(this, "inferenceSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lastModifiedTime = software.amazon.jsii.Kernel.get(this, "lastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataProperties = software.amazon.jsii.Kernel.get(this, "metadataProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelApprovalStatus = software.amazon.jsii.Kernel.get(this, "modelApprovalStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelCard = software.amazon.jsii.Kernel.get(this, "modelCard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelMetrics = software.amazon.jsii.Kernel.get(this, "modelMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelPackageDescription = software.amazon.jsii.Kernel.get(this, "modelPackageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelPackageGroupName = software.amazon.jsii.Kernel.get(this, "modelPackageGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelPackageName = software.amazon.jsii.Kernel.get(this, "modelPackageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelPackageStatusDetails = software.amazon.jsii.Kernel.get(this, "modelPackageStatusDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.modelPackageVersion = software.amazon.jsii.Kernel.get(this, "modelPackageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.samplePayloadUrl = software.amazon.jsii.Kernel.get(this, "samplePayloadUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityConfig = software.amazon.jsii.Kernel.get(this, "securityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.skipModelValidation = software.amazon.jsii.Kernel.get(this, "skipModelValidation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceAlgorithmSpecification = software.amazon.jsii.Kernel.get(this, "sourceAlgorithmSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceUri = software.amazon.jsii.Kernel.get(this, "sourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.task = software.amazon.jsii.Kernel.get(this, "task", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validationSpecification = software.amazon.jsii.Kernel.get(this, "validationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalInferenceSpecifications = builder.additionalInferenceSpecifications;
            this.additionalInferenceSpecificationsToAdd = builder.additionalInferenceSpecificationsToAdd;
            this.approvalDescription = builder.approvalDescription;
            this.certifyForMarketplace = builder.certifyForMarketplace;
            this.clientToken = builder.clientToken;
            this.customerMetadataProperties = builder.customerMetadataProperties;
            this.domain = builder.domain;
            this.driftCheckBaselines = builder.driftCheckBaselines;
            this.inferenceSpecification = builder.inferenceSpecification;
            this.lastModifiedTime = builder.lastModifiedTime;
            this.metadataProperties = builder.metadataProperties;
            this.modelApprovalStatus = builder.modelApprovalStatus;
            this.modelCard = builder.modelCard;
            this.modelMetrics = builder.modelMetrics;
            this.modelPackageDescription = builder.modelPackageDescription;
            this.modelPackageGroupName = builder.modelPackageGroupName;
            this.modelPackageName = builder.modelPackageName;
            this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
            this.modelPackageVersion = builder.modelPackageVersion;
            this.samplePayloadUrl = builder.samplePayloadUrl;
            this.securityConfig = builder.securityConfig;
            this.skipModelValidation = builder.skipModelValidation;
            this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
            this.sourceUri = builder.sourceUri;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.task = builder.task;
            this.validationSpecification = builder.validationSpecification;
        }

        @Override
        public final java.lang.Object getAdditionalInferenceSpecifications() {
            return this.additionalInferenceSpecifications;
        }

        @Override
        public final java.lang.Object getAdditionalInferenceSpecificationsToAdd() {
            return this.additionalInferenceSpecificationsToAdd;
        }

        @Override
        public final java.lang.String getApprovalDescription() {
            return this.approvalDescription;
        }

        @Override
        public final java.lang.Object getCertifyForMarketplace() {
            return this.certifyForMarketplace;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.Object getCustomerMetadataProperties() {
            return this.customerMetadataProperties;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.Object getDriftCheckBaselines() {
            return this.driftCheckBaselines;
        }

        @Override
        public final java.lang.Object getInferenceSpecification() {
            return this.inferenceSpecification;
        }

        @Override
        public final java.lang.String getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final java.lang.Object getMetadataProperties() {
            return this.metadataProperties;
        }

        @Override
        public final java.lang.String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        @Override
        public final java.lang.Object getModelCard() {
            return this.modelCard;
        }

        @Override
        public final java.lang.Object getModelMetrics() {
            return this.modelMetrics;
        }

        @Override
        public final java.lang.String getModelPackageDescription() {
            return this.modelPackageDescription;
        }

        @Override
        public final java.lang.String getModelPackageGroupName() {
            return this.modelPackageGroupName;
        }

        @Override
        public final java.lang.String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final java.lang.Object getModelPackageStatusDetails() {
            return this.modelPackageStatusDetails;
        }

        @Override
        public final java.lang.Number getModelPackageVersion() {
            return this.modelPackageVersion;
        }

        @Override
        public final java.lang.String getSamplePayloadUrl() {
            return this.samplePayloadUrl;
        }

        @Override
        public final java.lang.Object getSecurityConfig() {
            return this.securityConfig;
        }

        @Override
        public final java.lang.String getSkipModelValidation() {
            return this.skipModelValidation;
        }

        @Override
        public final java.lang.Object getSourceAlgorithmSpecification() {
            return this.sourceAlgorithmSpecification;
        }

        @Override
        public final java.lang.String getSourceUri() {
            return this.sourceUri;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTask() {
            return this.task;
        }

        @Override
        public final java.lang.Object getValidationSpecification() {
            return this.validationSpecification;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalInferenceSpecifications() != null) {
                data.set("additionalInferenceSpecifications", om.valueToTree(this.getAdditionalInferenceSpecifications()));
            }
            if (this.getAdditionalInferenceSpecificationsToAdd() != null) {
                data.set("additionalInferenceSpecificationsToAdd", om.valueToTree(this.getAdditionalInferenceSpecificationsToAdd()));
            }
            if (this.getApprovalDescription() != null) {
                data.set("approvalDescription", om.valueToTree(this.getApprovalDescription()));
            }
            if (this.getCertifyForMarketplace() != null) {
                data.set("certifyForMarketplace", om.valueToTree(this.getCertifyForMarketplace()));
            }
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getCustomerMetadataProperties() != null) {
                data.set("customerMetadataProperties", om.valueToTree(this.getCustomerMetadataProperties()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDriftCheckBaselines() != null) {
                data.set("driftCheckBaselines", om.valueToTree(this.getDriftCheckBaselines()));
            }
            if (this.getInferenceSpecification() != null) {
                data.set("inferenceSpecification", om.valueToTree(this.getInferenceSpecification()));
            }
            if (this.getLastModifiedTime() != null) {
                data.set("lastModifiedTime", om.valueToTree(this.getLastModifiedTime()));
            }
            if (this.getMetadataProperties() != null) {
                data.set("metadataProperties", om.valueToTree(this.getMetadataProperties()));
            }
            if (this.getModelApprovalStatus() != null) {
                data.set("modelApprovalStatus", om.valueToTree(this.getModelApprovalStatus()));
            }
            if (this.getModelCard() != null) {
                data.set("modelCard", om.valueToTree(this.getModelCard()));
            }
            if (this.getModelMetrics() != null) {
                data.set("modelMetrics", om.valueToTree(this.getModelMetrics()));
            }
            if (this.getModelPackageDescription() != null) {
                data.set("modelPackageDescription", om.valueToTree(this.getModelPackageDescription()));
            }
            if (this.getModelPackageGroupName() != null) {
                data.set("modelPackageGroupName", om.valueToTree(this.getModelPackageGroupName()));
            }
            if (this.getModelPackageName() != null) {
                data.set("modelPackageName", om.valueToTree(this.getModelPackageName()));
            }
            if (this.getModelPackageStatusDetails() != null) {
                data.set("modelPackageStatusDetails", om.valueToTree(this.getModelPackageStatusDetails()));
            }
            if (this.getModelPackageVersion() != null) {
                data.set("modelPackageVersion", om.valueToTree(this.getModelPackageVersion()));
            }
            if (this.getSamplePayloadUrl() != null) {
                data.set("samplePayloadUrl", om.valueToTree(this.getSamplePayloadUrl()));
            }
            if (this.getSecurityConfig() != null) {
                data.set("securityConfig", om.valueToTree(this.getSecurityConfig()));
            }
            if (this.getSkipModelValidation() != null) {
                data.set("skipModelValidation", om.valueToTree(this.getSkipModelValidation()));
            }
            if (this.getSourceAlgorithmSpecification() != null) {
                data.set("sourceAlgorithmSpecification", om.valueToTree(this.getSourceAlgorithmSpecification()));
            }
            if (this.getSourceUri() != null) {
                data.set("sourceUri", om.valueToTree(this.getSourceUri()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTask() != null) {
                data.set("task", om.valueToTree(this.getTask()));
            }
            if (this.getValidationSpecification() != null) {
                data.set("validationSpecification", om.valueToTree(this.getValidationSpecification()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnModelPackageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnModelPackageProps.Jsii$Proxy that = (CfnModelPackageProps.Jsii$Proxy) o;

            if (this.additionalInferenceSpecifications != null ? !this.additionalInferenceSpecifications.equals(that.additionalInferenceSpecifications) : that.additionalInferenceSpecifications != null) return false;
            if (this.additionalInferenceSpecificationsToAdd != null ? !this.additionalInferenceSpecificationsToAdd.equals(that.additionalInferenceSpecificationsToAdd) : that.additionalInferenceSpecificationsToAdd != null) return false;
            if (this.approvalDescription != null ? !this.approvalDescription.equals(that.approvalDescription) : that.approvalDescription != null) return false;
            if (this.certifyForMarketplace != null ? !this.certifyForMarketplace.equals(that.certifyForMarketplace) : that.certifyForMarketplace != null) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.customerMetadataProperties != null ? !this.customerMetadataProperties.equals(that.customerMetadataProperties) : that.customerMetadataProperties != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.driftCheckBaselines != null ? !this.driftCheckBaselines.equals(that.driftCheckBaselines) : that.driftCheckBaselines != null) return false;
            if (this.inferenceSpecification != null ? !this.inferenceSpecification.equals(that.inferenceSpecification) : that.inferenceSpecification != null) return false;
            if (this.lastModifiedTime != null ? !this.lastModifiedTime.equals(that.lastModifiedTime) : that.lastModifiedTime != null) return false;
            if (this.metadataProperties != null ? !this.metadataProperties.equals(that.metadataProperties) : that.metadataProperties != null) return false;
            if (this.modelApprovalStatus != null ? !this.modelApprovalStatus.equals(that.modelApprovalStatus) : that.modelApprovalStatus != null) return false;
            if (this.modelCard != null ? !this.modelCard.equals(that.modelCard) : that.modelCard != null) return false;
            if (this.modelMetrics != null ? !this.modelMetrics.equals(that.modelMetrics) : that.modelMetrics != null) return false;
            if (this.modelPackageDescription != null ? !this.modelPackageDescription.equals(that.modelPackageDescription) : that.modelPackageDescription != null) return false;
            if (this.modelPackageGroupName != null ? !this.modelPackageGroupName.equals(that.modelPackageGroupName) : that.modelPackageGroupName != null) return false;
            if (this.modelPackageName != null ? !this.modelPackageName.equals(that.modelPackageName) : that.modelPackageName != null) return false;
            if (this.modelPackageStatusDetails != null ? !this.modelPackageStatusDetails.equals(that.modelPackageStatusDetails) : that.modelPackageStatusDetails != null) return false;
            if (this.modelPackageVersion != null ? !this.modelPackageVersion.equals(that.modelPackageVersion) : that.modelPackageVersion != null) return false;
            if (this.samplePayloadUrl != null ? !this.samplePayloadUrl.equals(that.samplePayloadUrl) : that.samplePayloadUrl != null) return false;
            if (this.securityConfig != null ? !this.securityConfig.equals(that.securityConfig) : that.securityConfig != null) return false;
            if (this.skipModelValidation != null ? !this.skipModelValidation.equals(that.skipModelValidation) : that.skipModelValidation != null) return false;
            if (this.sourceAlgorithmSpecification != null ? !this.sourceAlgorithmSpecification.equals(that.sourceAlgorithmSpecification) : that.sourceAlgorithmSpecification != null) return false;
            if (this.sourceUri != null ? !this.sourceUri.equals(that.sourceUri) : that.sourceUri != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.task != null ? !this.task.equals(that.task) : that.task != null) return false;
            return this.validationSpecification != null ? this.validationSpecification.equals(that.validationSpecification) : that.validationSpecification == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalInferenceSpecifications != null ? this.additionalInferenceSpecifications.hashCode() : 0;
            result = 31 * result + (this.additionalInferenceSpecificationsToAdd != null ? this.additionalInferenceSpecificationsToAdd.hashCode() : 0);
            result = 31 * result + (this.approvalDescription != null ? this.approvalDescription.hashCode() : 0);
            result = 31 * result + (this.certifyForMarketplace != null ? this.certifyForMarketplace.hashCode() : 0);
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.customerMetadataProperties != null ? this.customerMetadataProperties.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.driftCheckBaselines != null ? this.driftCheckBaselines.hashCode() : 0);
            result = 31 * result + (this.inferenceSpecification != null ? this.inferenceSpecification.hashCode() : 0);
            result = 31 * result + (this.lastModifiedTime != null ? this.lastModifiedTime.hashCode() : 0);
            result = 31 * result + (this.metadataProperties != null ? this.metadataProperties.hashCode() : 0);
            result = 31 * result + (this.modelApprovalStatus != null ? this.modelApprovalStatus.hashCode() : 0);
            result = 31 * result + (this.modelCard != null ? this.modelCard.hashCode() : 0);
            result = 31 * result + (this.modelMetrics != null ? this.modelMetrics.hashCode() : 0);
            result = 31 * result + (this.modelPackageDescription != null ? this.modelPackageDescription.hashCode() : 0);
            result = 31 * result + (this.modelPackageGroupName != null ? this.modelPackageGroupName.hashCode() : 0);
            result = 31 * result + (this.modelPackageName != null ? this.modelPackageName.hashCode() : 0);
            result = 31 * result + (this.modelPackageStatusDetails != null ? this.modelPackageStatusDetails.hashCode() : 0);
            result = 31 * result + (this.modelPackageVersion != null ? this.modelPackageVersion.hashCode() : 0);
            result = 31 * result + (this.samplePayloadUrl != null ? this.samplePayloadUrl.hashCode() : 0);
            result = 31 * result + (this.securityConfig != null ? this.securityConfig.hashCode() : 0);
            result = 31 * result + (this.skipModelValidation != null ? this.skipModelValidation.hashCode() : 0);
            result = 31 * result + (this.sourceAlgorithmSpecification != null ? this.sourceAlgorithmSpecification.hashCode() : 0);
            result = 31 * result + (this.sourceUri != null ? this.sourceUri.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
            result = 31 * result + (this.validationSpecification != null ? this.validationSpecification.hashCode() : 0);
            return result;
        }
    }
}
