package software.amazon.awscdk.services.scheduler;

/**
 * Properties for defining a <code>CfnSchedule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.scheduler.*;
 * Object tags;
 * CfnScheduleProps cfnScheduleProps = CfnScheduleProps.builder()
 *         .flexibleTimeWindow(FlexibleTimeWindowProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .maximumWindowInMinutes(123)
 *                 .build())
 *         .scheduleExpression("scheduleExpression")
 *         .target(TargetProperty.builder()
 *                 .arn("arn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .ecsParameters(EcsParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategy(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tags(tags)
 *                         .taskCount(123)
 *                         .build())
 *                 .eventBridgeParameters(EventBridgeParametersProperty.builder()
 *                         .detailType("detailType")
 *                         .source("source")
 *                         .build())
 *                 .input("input")
 *                 .kinesisParameters(KinesisParametersProperty.builder()
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .retryPolicy(RetryPolicyProperty.builder()
 *                         .maximumEventAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .build())
 *                 .sageMakerPipelineParameters(SageMakerPipelineParametersProperty.builder()
 *                         .pipelineParameterList(List.of(SageMakerPipelineParameterProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sqsParameters(SqsParametersProperty.builder()
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .endDate("endDate")
 *         .groupName("groupName")
 *         .kmsKeyArn("kmsKeyArn")
 *         .name("name")
 *         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *         .startDate("startDate")
 *         .state("state")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:30.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.CfnScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-flexibletimewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-flexibletimewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFlexibleTimeWindow();

    /**
     * The expression that defines when the schedule runs. The following formats are supported.
     * <p>
     * <ul>
     * <li><code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code></li>
     * <li><code>rate</code> expression - <code>rate(value unit)</code></li>
     * <li><code>cron</code> expression - <code>cron(fields)</code></li>
     * </ul>
     * <p>
     * You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
     * <p>
     * A <code>cron</code> expression consists of six fields separated by white spaces: <code>(minutes hours day_of_month month day_of_week year)</code> .
     * <p>
     * A <code>rate</code> expression consists of a <em>value</em> as a positive integer, and a <em>unit</em> with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>
     * <p>
     * For more information and examples, see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge Scheduler</a> in the <em>EventBridge Scheduler User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-scheduleexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

    /**
     * The schedule's target details.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-target</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTarget();

    /**
     * The description you specify for the schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The date, in UTC, before which the schedule can invoke its target.
     * <p>
     * Depending on the schedule's recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify.
     * EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-enddate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-enddate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndDate() {
        return null;
    }

    /**
     * The name of the schedule group associated with this schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-groupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-groupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * The name of the schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The timezone in which the scheduling expression is evaluated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-scheduleexpressiontimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-scheduleexpressiontimezone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpressionTimezone() {
        return null;
    }

    /**
     * The date, in UTC, after which the schedule can begin invoking its target.
     * <p>
     * Depending on the schedule's recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
     * EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-startdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-startdate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartDate() {
        return null;
    }

    /**
     * Specifies whether the schedule is enabled or disabled.
     * <p>
     * <em>Allowed Values</em> : <code>ENABLED</code> | <code>DISABLED</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-scheduler-schedule.html#cfn-scheduler-schedule-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScheduleProps> {
        java.lang.Object flexibleTimeWindow;
        java.lang.String scheduleExpression;
        java.lang.Object target;
        java.lang.String description;
        java.lang.String endDate;
        java.lang.String groupName;
        java.lang.String kmsKeyArn;
        java.lang.String name;
        java.lang.String scheduleExpressionTimezone;
        java.lang.String startDate;
        java.lang.String state;

        /**
         * Sets the value of {@link CfnScheduleProps#getFlexibleTimeWindow}
         * @param flexibleTimeWindow Allows you to configure a time window during which EventBridge Scheduler invokes the schedule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(software.amazon.awscdk.IResolvable flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getFlexibleTimeWindow}
         * @param flexibleTimeWindow Allows you to configure a time window during which EventBridge Scheduler invokes the schedule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(software.amazon.awscdk.services.scheduler.CfnSchedule.FlexibleTimeWindowProperty flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getScheduleExpression}
         * @param scheduleExpression The expression that defines when the schedule runs. The following formats are supported. This parameter is required.
         *                           <ul>
         *                           <li><code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code></li>
         *                           <li><code>rate</code> expression - <code>rate(value unit)</code></li>
         *                           <li><code>cron</code> expression - <code>cron(fields)</code></li>
         *                           </ul>
         *                           <p>
         *                           You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
         *                           <p>
         *                           A <code>cron</code> expression consists of six fields separated by white spaces: <code>(minutes hours day_of_month month day_of_week year)</code> .
         *                           <p>
         *                           A <code>rate</code> expression consists of a <em>value</em> as a positive integer, and a <em>unit</em> with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> | <code>day</code> | <code>days</code>
         *                           <p>
         *                           For more information and examples, see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge Scheduler</a> in the <em>EventBridge Scheduler User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(java.lang.String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getTarget}
         * @param target The schedule's target details. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.IResolvable target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getTarget}
         * @param target The schedule's target details. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.scheduler.CfnSchedule.TargetProperty target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getDescription}
         * @param description The description you specify for the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getEndDate}
         * @param endDate The date, in UTC, before which the schedule can invoke its target.
         *                Depending on the schedule's recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify.
         *                EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(java.lang.String endDate) {
            this.endDate = endDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getGroupName}
         * @param groupName The name of the schedule group associated with this schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(java.lang.String groupName) {
            this.groupName = groupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getKmsKeyArn}
         * @param kmsKeyArn The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getName}
         * @param name The name of the schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getScheduleExpressionTimezone}
         * @param scheduleExpressionTimezone The timezone in which the scheduling expression is evaluated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(java.lang.String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getStartDate}
         * @param startDate The date, in UTC, after which the schedule can begin invoking its target.
         *                  Depending on the schedule's recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
         *                  EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startDate(java.lang.String startDate) {
            this.startDate = startDate;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduleProps#getState}
         * @param state Specifies whether the schedule is enabled or disabled.
         *              <em>Allowed Values</em> : <code>ENABLED</code> | <code>DISABLED</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScheduleProps {
        private final java.lang.Object flexibleTimeWindow;
        private final java.lang.String scheduleExpression;
        private final java.lang.Object target;
        private final java.lang.String description;
        private final java.lang.String endDate;
        private final java.lang.String groupName;
        private final java.lang.String kmsKeyArn;
        private final java.lang.String name;
        private final java.lang.String scheduleExpressionTimezone;
        private final java.lang.String startDate;
        private final java.lang.String state;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.flexibleTimeWindow = software.amazon.jsii.Kernel.get(this, "flexibleTimeWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endDate = software.amazon.jsii.Kernel.get(this, "endDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpressionTimezone = software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startDate = software.amazon.jsii.Kernel.get(this, "startDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.flexibleTimeWindow = java.util.Objects.requireNonNull(builder.flexibleTimeWindow, "flexibleTimeWindow is required");
            this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.description = builder.description;
            this.endDate = builder.endDate;
            this.groupName = builder.groupName;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.name = builder.name;
            this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
            this.startDate = builder.startDate;
            this.state = builder.state;
        }

        @Override
        public final java.lang.Object getFlexibleTimeWindow() {
            return this.flexibleTimeWindow;
        }

        @Override
        public final java.lang.String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final java.lang.Object getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEndDate() {
            return this.endDate;
        }

        @Override
        public final java.lang.String getGroupName() {
            return this.groupName;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getScheduleExpressionTimezone() {
            return this.scheduleExpressionTimezone;
        }

        @Override
        public final java.lang.String getStartDate() {
            return this.startDate;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("flexibleTimeWindow", om.valueToTree(this.getFlexibleTimeWindow()));
            data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndDate() != null) {
                data.set("endDate", om.valueToTree(this.getEndDate()));
            }
            if (this.getGroupName() != null) {
                data.set("groupName", om.valueToTree(this.getGroupName()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getScheduleExpressionTimezone() != null) {
                data.set("scheduleExpressionTimezone", om.valueToTree(this.getScheduleExpressionTimezone()));
            }
            if (this.getStartDate() != null) {
                data.set("startDate", om.valueToTree(this.getStartDate()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.CfnScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScheduleProps.Jsii$Proxy that = (CfnScheduleProps.Jsii$Proxy) o;

            if (!flexibleTimeWindow.equals(that.flexibleTimeWindow)) return false;
            if (!scheduleExpression.equals(that.scheduleExpression)) return false;
            if (!target.equals(that.target)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endDate != null ? !this.endDate.equals(that.endDate) : that.endDate != null) return false;
            if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.scheduleExpressionTimezone != null ? !this.scheduleExpressionTimezone.equals(that.scheduleExpressionTimezone) : that.scheduleExpressionTimezone != null) return false;
            if (this.startDate != null ? !this.startDate.equals(that.startDate) : that.startDate != null) return false;
            return this.state != null ? this.state.equals(that.state) : that.state == null;
        }

        @Override
        public final int hashCode() {
            int result = this.flexibleTimeWindow.hashCode();
            result = 31 * result + (this.scheduleExpression.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
            result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.scheduleExpressionTimezone != null ? this.scheduleExpressionTimezone.hashCode() : 0);
            result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }
    }
}
