package software.amazon.awscdk.services.servicecatalog;

/**
 * Options for portfolio share.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * PortfolioShareOptions portfolioShareOptions = PortfolioShareOptions.builder()
 *         .messageLanguage(MessageLanguage.EN)
 *         .shareTagOptions(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:30.939Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.PortfolioShareOptions")
@software.amazon.jsii.Jsii.Proxy(PortfolioShareOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortfolioShareOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The message language of the share.
     * <p>
     * Controls status and error message language for share.
     * <p>
     * Default: - English
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
        return null;
    }

    /**
     * Whether to share tagOptions as a part of the portfolio share.
     * <p>
     * Default: - share not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getShareTagOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PortfolioShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortfolioShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PortfolioShareOptions> {
        software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        java.lang.Boolean shareTagOptions;

        /**
         * Sets the value of {@link PortfolioShareOptions#getMessageLanguage}
         * @param messageLanguage The message language of the share.
         *                        Controls status and error message language for share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.messageLanguage = messageLanguage;
            return this;
        }

        /**
         * Sets the value of {@link PortfolioShareOptions#getShareTagOptions}
         * @param shareTagOptions Whether to share tagOptions as a part of the portfolio share.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shareTagOptions(java.lang.Boolean shareTagOptions) {
            this.shareTagOptions = shareTagOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortfolioShareOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PortfolioShareOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortfolioShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortfolioShareOptions {
        private final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        private final java.lang.Boolean shareTagOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.messageLanguage = software.amazon.jsii.Kernel.get(this, "messageLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.MessageLanguage.class));
            this.shareTagOptions = software.amazon.jsii.Kernel.get(this, "shareTagOptions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.messageLanguage = builder.messageLanguage;
            this.shareTagOptions = builder.shareTagOptions;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
            return this.messageLanguage;
        }

        @Override
        public final java.lang.Boolean getShareTagOptions() {
            return this.shareTagOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMessageLanguage() != null) {
                data.set("messageLanguage", om.valueToTree(this.getMessageLanguage()));
            }
            if (this.getShareTagOptions() != null) {
                data.set("shareTagOptions", om.valueToTree(this.getShareTagOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.PortfolioShareOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortfolioShareOptions.Jsii$Proxy that = (PortfolioShareOptions.Jsii$Proxy) o;

            if (this.messageLanguage != null ? !this.messageLanguage.equals(that.messageLanguage) : that.messageLanguage != null) return false;
            return this.shareTagOptions != null ? this.shareTagOptions.equals(that.shareTagOptions) : that.shareTagOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.messageLanguage != null ? this.messageLanguage.hashCode() : 0;
            result = 31 * result + (this.shareTagOptions != null ? this.shareTagOptions.hashCode() : 0);
            return result;
        }
    }
}
