package software.amazon.awscdk.services.ses;

/**
 * Properties for an email identity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * User user;
 * EmailIdentity identity = EmailIdentity.Builder.create(this, "Identity")
 *         .identity(Identity.domain("cdk.dev"))
 *         .build();
 * identity.grantSendEmail(user);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.114Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.EmailIdentityProps")
@software.amazon.jsii.Jsii.Proxy(EmailIdentityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmailIdentityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The email address or domain to verify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.Identity getIdentity();

    /**
     * The configuration set to associate with the email identity.
     * <p>
     * Default: - do not use a specific configuration set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.IConfigurationSet getConfigurationSet() {
        return null;
    }

    /**
     * The type of DKIM identity to use.
     * <p>
     * Default: - Easy DKIM with a key length of 2048-bit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DkimIdentity getDkimIdentity() {
        return null;
    }

    /**
     * Whether the messages that are sent from the identity are signed using DKIM.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDkimSigning() {
        return null;
    }

    /**
     * Whether to receive email notifications when bounce or complaint events occur.
     * <p>
     * These notifications are sent to the address that you specified in the <code>Return-Path</code>
     * header of the original email.
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set
     * up another mechanism for receiving bounce or complaint notifications (for example, by
     * setting up an event destination), you receive an email notification when these events
     * occur (even if this setting is disabled).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getFeedbackForwarding() {
        return null;
    }

    /**
     * The action to take if the required MX record for the MAIL FROM domain isn't found when you send an email.
     * <p>
     * Default: MailFromBehaviorOnMxFailure.USE_DEFAULT_VALUE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure getMailFromBehaviorOnMxFailure() {
        return null;
    }

    /**
     * The custom MAIL FROM domain that you want the verified identity to use.
     * <p>
     * The MAIL FROM domain
     * must meet the following criteria:
     * <p>
     * <ul>
     * <li>It has to be a subdomain of the verified identity</li>
     * <li>It can't be used to receive email</li>
     * <li>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback
     * forwarding emails</li>
     * </ul>
     * <p>
     * Default: - use amazonses.com
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMailFromDomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmailIdentityProps> {
        software.amazon.awscdk.services.ses.Identity identity;
        software.amazon.awscdk.services.ses.IConfigurationSet configurationSet;
        software.amazon.awscdk.services.ses.DkimIdentity dkimIdentity;
        java.lang.Boolean dkimSigning;
        java.lang.Boolean feedbackForwarding;
        software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure mailFromBehaviorOnMxFailure;
        java.lang.String mailFromDomain;

        /**
         * Sets the value of {@link EmailIdentityProps#getIdentity}
         * @param identity The email address or domain to verify. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identity(software.amazon.awscdk.services.ses.Identity identity) {
            this.identity = identity;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getConfigurationSet}
         * @param configurationSet The configuration set to associate with the email identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSet(software.amazon.awscdk.services.ses.IConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getDkimIdentity}
         * @param dkimIdentity The type of DKIM identity to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimIdentity(software.amazon.awscdk.services.ses.DkimIdentity dkimIdentity) {
            this.dkimIdentity = dkimIdentity;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getDkimSigning}
         * @param dkimSigning Whether the messages that are sent from the identity are signed using DKIM.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigning(java.lang.Boolean dkimSigning) {
            this.dkimSigning = dkimSigning;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getFeedbackForwarding}
         * @param feedbackForwarding Whether to receive email notifications when bounce or complaint events occur.
         *                           These notifications are sent to the address that you specified in the <code>Return-Path</code>
         *                           header of the original email.
         *                           <p>
         *                           You're required to have a method of tracking bounces and complaints. If you haven't set
         *                           up another mechanism for receiving bounce or complaint notifications (for example, by
         *                           setting up an event destination), you receive an email notification when these events
         *                           occur (even if this setting is disabled).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwarding(java.lang.Boolean feedbackForwarding) {
            this.feedbackForwarding = feedbackForwarding;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getMailFromBehaviorOnMxFailure}
         * @param mailFromBehaviorOnMxFailure The action to take if the required MX record for the MAIL FROM domain isn't found when you send an email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromBehaviorOnMxFailure(software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure mailFromBehaviorOnMxFailure) {
            this.mailFromBehaviorOnMxFailure = mailFromBehaviorOnMxFailure;
            return this;
        }

        /**
         * Sets the value of {@link EmailIdentityProps#getMailFromDomain}
         * @param mailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
         *                       The MAIL FROM domain
         *                       must meet the following criteria:
         *                       <p>
         *                       <ul>
         *                       <li>It has to be a subdomain of the verified identity</li>
         *                       <li>It can't be used to receive email</li>
         *                       <li>It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback
         *                       forwarding emails</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromDomain(java.lang.String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmailIdentityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmailIdentityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmailIdentityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailIdentityProps {
        private final software.amazon.awscdk.services.ses.Identity identity;
        private final software.amazon.awscdk.services.ses.IConfigurationSet configurationSet;
        private final software.amazon.awscdk.services.ses.DkimIdentity dkimIdentity;
        private final java.lang.Boolean dkimSigning;
        private final java.lang.Boolean feedbackForwarding;
        private final software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure mailFromBehaviorOnMxFailure;
        private final java.lang.String mailFromDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identity = software.amazon.jsii.Kernel.get(this, "identity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.Identity.class));
            this.configurationSet = software.amazon.jsii.Kernel.get(this, "configurationSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IConfigurationSet.class));
            this.dkimIdentity = software.amazon.jsii.Kernel.get(this, "dkimIdentity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentity.class));
            this.dkimSigning = software.amazon.jsii.Kernel.get(this, "dkimSigning", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.feedbackForwarding = software.amazon.jsii.Kernel.get(this, "feedbackForwarding", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mailFromBehaviorOnMxFailure = software.amazon.jsii.Kernel.get(this, "mailFromBehaviorOnMxFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure.class));
            this.mailFromDomain = software.amazon.jsii.Kernel.get(this, "mailFromDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identity = java.util.Objects.requireNonNull(builder.identity, "identity is required");
            this.configurationSet = builder.configurationSet;
            this.dkimIdentity = builder.dkimIdentity;
            this.dkimSigning = builder.dkimSigning;
            this.feedbackForwarding = builder.feedbackForwarding;
            this.mailFromBehaviorOnMxFailure = builder.mailFromBehaviorOnMxFailure;
            this.mailFromDomain = builder.mailFromDomain;
        }

        @Override
        public final software.amazon.awscdk.services.ses.Identity getIdentity() {
            return this.identity;
        }

        @Override
        public final software.amazon.awscdk.services.ses.IConfigurationSet getConfigurationSet() {
            return this.configurationSet;
        }

        @Override
        public final software.amazon.awscdk.services.ses.DkimIdentity getDkimIdentity() {
            return this.dkimIdentity;
        }

        @Override
        public final java.lang.Boolean getDkimSigning() {
            return this.dkimSigning;
        }

        @Override
        public final java.lang.Boolean getFeedbackForwarding() {
            return this.feedbackForwarding;
        }

        @Override
        public final software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure getMailFromBehaviorOnMxFailure() {
            return this.mailFromBehaviorOnMxFailure;
        }

        @Override
        public final java.lang.String getMailFromDomain() {
            return this.mailFromDomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identity", om.valueToTree(this.getIdentity()));
            if (this.getConfigurationSet() != null) {
                data.set("configurationSet", om.valueToTree(this.getConfigurationSet()));
            }
            if (this.getDkimIdentity() != null) {
                data.set("dkimIdentity", om.valueToTree(this.getDkimIdentity()));
            }
            if (this.getDkimSigning() != null) {
                data.set("dkimSigning", om.valueToTree(this.getDkimSigning()));
            }
            if (this.getFeedbackForwarding() != null) {
                data.set("feedbackForwarding", om.valueToTree(this.getFeedbackForwarding()));
            }
            if (this.getMailFromBehaviorOnMxFailure() != null) {
                data.set("mailFromBehaviorOnMxFailure", om.valueToTree(this.getMailFromBehaviorOnMxFailure()));
            }
            if (this.getMailFromDomain() != null) {
                data.set("mailFromDomain", om.valueToTree(this.getMailFromDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.EmailIdentityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmailIdentityProps.Jsii$Proxy that = (EmailIdentityProps.Jsii$Proxy) o;

            if (!identity.equals(that.identity)) return false;
            if (this.configurationSet != null ? !this.configurationSet.equals(that.configurationSet) : that.configurationSet != null) return false;
            if (this.dkimIdentity != null ? !this.dkimIdentity.equals(that.dkimIdentity) : that.dkimIdentity != null) return false;
            if (this.dkimSigning != null ? !this.dkimSigning.equals(that.dkimSigning) : that.dkimSigning != null) return false;
            if (this.feedbackForwarding != null ? !this.feedbackForwarding.equals(that.feedbackForwarding) : that.feedbackForwarding != null) return false;
            if (this.mailFromBehaviorOnMxFailure != null ? !this.mailFromBehaviorOnMxFailure.equals(that.mailFromBehaviorOnMxFailure) : that.mailFromBehaviorOnMxFailure != null) return false;
            return this.mailFromDomain != null ? this.mailFromDomain.equals(that.mailFromDomain) : that.mailFromDomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identity.hashCode();
            result = 31 * result + (this.configurationSet != null ? this.configurationSet.hashCode() : 0);
            result = 31 * result + (this.dkimIdentity != null ? this.dkimIdentity.hashCode() : 0);
            result = 31 * result + (this.dkimSigning != null ? this.dkimSigning.hashCode() : 0);
            result = 31 * result + (this.feedbackForwarding != null ? this.feedbackForwarding.hashCode() : 0);
            result = 31 * result + (this.mailFromBehaviorOnMxFailure != null ? this.mailFromBehaviorOnMxFailure.hashCode() : 0);
            result = 31 * result + (this.mailFromDomain != null ? this.mailFromDomain.hashCode() : 0);
            return result;
        }
    }
}
