package software.amazon.awscdk.services.sns;

/**
 * Properties for defining a <code>CfnTopic</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * Object archivePolicy;
 * Object dataProtectionPolicy;
 * CfnTopicProps cfnTopicProps = CfnTopicProps.builder()
 *         .archivePolicy(archivePolicy)
 *         .contentBasedDeduplication(false)
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .deliveryStatusLogging(List.of(LoggingConfigProperty.builder()
 *                 .protocol("protocol")
 *                 // the properties below are optional
 *                 .failureFeedbackRoleArn("failureFeedbackRoleArn")
 *                 .successFeedbackRoleArn("successFeedbackRoleArn")
 *                 .successFeedbackSampleRate("successFeedbackSampleRate")
 *                 .build()))
 *         .displayName("displayName")
 *         .fifoTopic(false)
 *         .kmsMasterKeyId("kmsMasterKeyId")
 *         .signatureVersion("signatureVersion")
 *         .subscription(List.of(SubscriptionProperty.builder()
 *                 .endpoint("endpoint")
 *                 .protocol("protocol")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicName("topicName")
 *         .tracingConfig("tracingConfig")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.191Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.CfnTopicProps")
@software.amazon.jsii.Jsii.Proxy(CfnTopicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTopicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The <code>ArchivePolicy</code> determines the number of days Amazon SNS retains messages in FIFO topics.
     * <p>
     * You can set a retention period ranging from 1 to 365 days. This property is only applicable to FIFO topics; attempting to use it with standard topics will result in a creation failure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-archivepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-archivepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArchivePolicy() {
        return null;
    }

    /**
     * <code>ContentBasedDeduplication</code> enables deduplication of messages based on their content for FIFO topics.
     * <p>
     * By default, this property is set to false. If you create a FIFO topic with <code>ContentBasedDeduplication</code> set to false, you must provide a <code>MessageDeduplicationId</code> for each <code>Publish</code> action. When set to true, Amazon SNS automatically generates a <code>MessageDeduplicationId</code> using a SHA-256 hash of the message body (excluding message attributes). You can optionally override this generated value by specifying a <code>MessageDeduplicationId</code> in the <code>Publish</code> action. Note that this property only applies to FIFO topics; using it with standard topics will cause the creation to fail.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-contentbaseddeduplication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContentBasedDeduplication() {
        return null;
    }

    /**
     * The body of the policy document you want to use for this topic.
     * <p>
     * You can only add one policy per topic.
     * <p>
     * The policy must be in JSON string format.
     * <p>
     * Length Constraints: Maximum length of 30,720.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-dataprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-dataprotectionpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionPolicy() {
        return null;
    }

    /**
     * The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
     * <p>
     * <ul>
     * <li>HTTP</li>
     * <li>Amazon Kinesis Data Firehose</li>
     * <li>AWS Lambda</li>
     * <li>Platform application endpoint</li>
     * <li>Amazon Simple Queue Service</li>
     * </ul>
     * <p>
     * Once configured, log entries are sent to Amazon CloudWatch Logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-deliverystatuslogging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStatusLogging() {
        return null;
    }

    /**
     * The display name to use for an Amazon SNS topic with SMS subscriptions.
     * <p>
     * The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * Set to true to create a FIFO topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-fifotopic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFifoTopic() {
        return null;
    }

    /**
     * The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key terms</a> . For more examples, see <code>[KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)</code> in the <em>AWS Key Management Service API Reference</em> .
     * <p>
     * This property applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-kmsmasterkeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
        return null;
    }

    /**
     * The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
     * <p>
     * By default, <code>SignatureVersion</code> is set to <code>1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-signatureversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-signatureversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSignatureVersion() {
        return null;
    }

    /**
     * The Amazon SNS subscriptions (endpoints) for this topic.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>Subscription</code> property in the <code>AWS::SNS::Topic</code> resource and it creates an associated subscription resource, the associated subscription is not deleted when the <code>AWS::SNS::Topic</code> resource is deleted.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-subscription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubscription() {
        return null;
    }

    /**
     * The list of tags to add to a new topic.
     * <p>
     * <blockquote>
     * <p>
     * To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the topic you want to create.
     * <p>
     * Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with <code>.fifo</code> .
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the topic name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-topicname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-topicname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicName() {
        return null;
    }

    /**
     * Tracing mode of an Amazon SNS topic.
     * <p>
     * By default <code>TracingConfig</code> is set to <code>PassThrough</code> , and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code> , Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tracingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html#cfn-sns-topic-tracingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTracingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTopicProps> {
        java.lang.Object archivePolicy;
        java.lang.Object contentBasedDeduplication;
        java.lang.Object dataProtectionPolicy;
        java.lang.Object deliveryStatusLogging;
        java.lang.String displayName;
        java.lang.Object fifoTopic;
        java.lang.String kmsMasterKeyId;
        java.lang.String signatureVersion;
        java.lang.Object subscription;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String topicName;
        java.lang.String tracingConfig;

        /**
         * Sets the value of {@link CfnTopicProps#getArchivePolicy}
         * @param archivePolicy The <code>ArchivePolicy</code> determines the number of days Amazon SNS retains messages in FIFO topics.
         *                      You can set a retention period ranging from 1 to 365 days. This property is only applicable to FIFO topics; attempting to use it with standard topics will result in a creation failure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archivePolicy(java.lang.Object archivePolicy) {
            this.archivePolicy = archivePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication <code>ContentBasedDeduplication</code> enables deduplication of messages based on their content for FIFO topics.
         *                                  By default, this property is set to false. If you create a FIFO topic with <code>ContentBasedDeduplication</code> set to false, you must provide a <code>MessageDeduplicationId</code> for each <code>Publish</code> action. When set to true, Amazon SNS automatically generates a <code>MessageDeduplicationId</code> using a SHA-256 hash of the message body (excluding message attributes). You can optionally override this generated value by specifying a <code>MessageDeduplicationId</code> in the <code>Publish</code> action. Note that this property only applies to FIFO topics; using it with standard topics will cause the creation to fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(java.lang.Boolean contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getContentBasedDeduplication}
         * @param contentBasedDeduplication <code>ContentBasedDeduplication</code> enables deduplication of messages based on their content for FIFO topics.
         *                                  By default, this property is set to false. If you create a FIFO topic with <code>ContentBasedDeduplication</code> set to false, you must provide a <code>MessageDeduplicationId</code> for each <code>Publish</code> action. When set to true, Amazon SNS automatically generates a <code>MessageDeduplicationId</code> using a SHA-256 hash of the message body (excluding message attributes). You can optionally override this generated value by specifying a <code>MessageDeduplicationId</code> in the <code>Publish</code> action. Note that this property only applies to FIFO topics; using it with standard topics will cause the creation to fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentBasedDeduplication(software.amazon.awscdk.IResolvable contentBasedDeduplication) {
            this.contentBasedDeduplication = contentBasedDeduplication;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDataProtectionPolicy}
         * @param dataProtectionPolicy The body of the policy document you want to use for this topic.
         *                             You can only add one policy per topic.
         *                             <p>
         *                             The policy must be in JSON string format.
         *                             <p>
         *                             Length Constraints: Maximum length of 30,720.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionPolicy(java.lang.Object dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDeliveryStatusLogging}
         * @param deliveryStatusLogging The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
         *                              <ul>
         *                              <li>HTTP</li>
         *                              <li>Amazon Kinesis Data Firehose</li>
         *                              <li>AWS Lambda</li>
         *                              <li>Platform application endpoint</li>
         *                              <li>Amazon Simple Queue Service</li>
         *                              </ul>
         *                              <p>
         *                              Once configured, log entries are sent to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStatusLogging(software.amazon.awscdk.IResolvable deliveryStatusLogging) {
            this.deliveryStatusLogging = deliveryStatusLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDeliveryStatusLogging}
         * @param deliveryStatusLogging The <code>DeliveryStatusLogging</code> configuration enables you to log the delivery status of messages sent from your Amazon SNS topic to subscribed endpoints with the following supported delivery protocols:.
         *                              <ul>
         *                              <li>HTTP</li>
         *                              <li>Amazon Kinesis Data Firehose</li>
         *                              <li>AWS Lambda</li>
         *                              <li>Platform application endpoint</li>
         *                              <li>Amazon Simple Queue Service</li>
         *                              </ul>
         *                              <p>
         *                              Once configured, log entries are sent to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStatusLogging(java.util.List<? extends java.lang.Object> deliveryStatusLogging) {
            this.deliveryStatusLogging = deliveryStatusLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDisplayName}
         * @param displayName The display name to use for an Amazon SNS topic with SMS subscriptions.
         *                    The display name must be maximum 100 characters long, including hyphens (-), underscores (_), spaces, and tabs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getFifoTopic}
         * @param fifoTopic Set to true to create a FIFO topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(java.lang.Boolean fifoTopic) {
            this.fifoTopic = fifoTopic;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getFifoTopic}
         * @param fifoTopic Set to true to create a FIFO topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fifoTopic(software.amazon.awscdk.IResolvable fifoTopic) {
            this.fifoTopic = fifoTopic;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getKmsMasterKeyId}
         * @param kmsMasterKeyId The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom CMK.
         *                       For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms">Key terms</a> . For more examples, see <code>[KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)</code> in the <em>AWS Key Management Service API Reference</em> .
         *                       <p>
         *                       This property applies only to <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html">server-side-encryption</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSignatureVersion}
         * @param signatureVersion The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS.
         *                         By default, <code>SignatureVersion</code> is set to <code>1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signatureVersion(java.lang.String signatureVersion) {
            this.signatureVersion = signatureVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSubscription}
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic.
         *                     <blockquote>
         *                     <p>
         *                     If you specify the <code>Subscription</code> property in the <code>AWS::SNS::Topic</code> resource and it creates an associated subscription resource, the associated subscription is not deleted when the <code>AWS::SNS::Topic</code> resource is deleted.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(software.amazon.awscdk.IResolvable subscription) {
            this.subscription = subscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getSubscription}
         * @param subscription The Amazon SNS subscriptions (endpoints) for this topic.
         *                     <blockquote>
         *                     <p>
         *                     If you specify the <code>Subscription</code> property in the <code>AWS::SNS::Topic</code> resource and it creates an associated subscription resource, the associated subscription is not deleted when the <code>AWS::SNS::Topic</code> resource is deleted.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscription(java.util.List<? extends java.lang.Object> subscription) {
            this.subscription = subscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTags}
         * @param tags The list of tags to add to a new topic.
         *             <blockquote>
         *             <p>
         *             To be able to tag a topic on creation, you must have the <code>sns:CreateTopic</code> and <code>sns:TagResource</code> permissions.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTopicName}
         * @param topicName The name of the topic you want to create.
         *                  Topic names must include only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long. FIFO topic names must end with <code>.fifo</code> .
         *                  <p>
         *                  If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the topic name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicName(java.lang.String topicName) {
            this.topicName = topicName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTracingConfig}
         * @param tracingConfig Tracing mode of an Amazon SNS topic.
         *                      By default <code>TracingConfig</code> is set to <code>PassThrough</code> , and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to <code>Active</code> , Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfig(java.lang.String tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTopicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTopicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTopicProps {
        private final java.lang.Object archivePolicy;
        private final java.lang.Object contentBasedDeduplication;
        private final java.lang.Object dataProtectionPolicy;
        private final java.lang.Object deliveryStatusLogging;
        private final java.lang.String displayName;
        private final java.lang.Object fifoTopic;
        private final java.lang.String kmsMasterKeyId;
        private final java.lang.String signatureVersion;
        private final java.lang.Object subscription;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String topicName;
        private final java.lang.String tracingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.archivePolicy = software.amazon.jsii.Kernel.get(this, "archivePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.contentBasedDeduplication = software.amazon.jsii.Kernel.get(this, "contentBasedDeduplication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataProtectionPolicy = software.amazon.jsii.Kernel.get(this, "dataProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryStatusLogging = software.amazon.jsii.Kernel.get(this, "deliveryStatusLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fifoTopic = software.amazon.jsii.Kernel.get(this, "fifoTopic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signatureVersion = software.amazon.jsii.Kernel.get(this, "signatureVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscription = software.amazon.jsii.Kernel.get(this, "subscription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tracingConfig = software.amazon.jsii.Kernel.get(this, "tracingConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.archivePolicy = builder.archivePolicy;
            this.contentBasedDeduplication = builder.contentBasedDeduplication;
            this.dataProtectionPolicy = builder.dataProtectionPolicy;
            this.deliveryStatusLogging = builder.deliveryStatusLogging;
            this.displayName = builder.displayName;
            this.fifoTopic = builder.fifoTopic;
            this.kmsMasterKeyId = builder.kmsMasterKeyId;
            this.signatureVersion = builder.signatureVersion;
            this.subscription = builder.subscription;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.topicName = builder.topicName;
            this.tracingConfig = builder.tracingConfig;
        }

        @Override
        public final java.lang.Object getArchivePolicy() {
            return this.archivePolicy;
        }

        @Override
        public final java.lang.Object getContentBasedDeduplication() {
            return this.contentBasedDeduplication;
        }

        @Override
        public final java.lang.Object getDataProtectionPolicy() {
            return this.dataProtectionPolicy;
        }

        @Override
        public final java.lang.Object getDeliveryStatusLogging() {
            return this.deliveryStatusLogging;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.Object getFifoTopic() {
            return this.fifoTopic;
        }

        @Override
        public final java.lang.String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final java.lang.String getSignatureVersion() {
            return this.signatureVersion;
        }

        @Override
        public final java.lang.Object getSubscription() {
            return this.subscription;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTopicName() {
            return this.topicName;
        }

        @Override
        public final java.lang.String getTracingConfig() {
            return this.tracingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArchivePolicy() != null) {
                data.set("archivePolicy", om.valueToTree(this.getArchivePolicy()));
            }
            if (this.getContentBasedDeduplication() != null) {
                data.set("contentBasedDeduplication", om.valueToTree(this.getContentBasedDeduplication()));
            }
            if (this.getDataProtectionPolicy() != null) {
                data.set("dataProtectionPolicy", om.valueToTree(this.getDataProtectionPolicy()));
            }
            if (this.getDeliveryStatusLogging() != null) {
                data.set("deliveryStatusLogging", om.valueToTree(this.getDeliveryStatusLogging()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getFifoTopic() != null) {
                data.set("fifoTopic", om.valueToTree(this.getFifoTopic()));
            }
            if (this.getKmsMasterKeyId() != null) {
                data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
            }
            if (this.getSignatureVersion() != null) {
                data.set("signatureVersion", om.valueToTree(this.getSignatureVersion()));
            }
            if (this.getSubscription() != null) {
                data.set("subscription", om.valueToTree(this.getSubscription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTopicName() != null) {
                data.set("topicName", om.valueToTree(this.getTopicName()));
            }
            if (this.getTracingConfig() != null) {
                data.set("tracingConfig", om.valueToTree(this.getTracingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.CfnTopicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTopicProps.Jsii$Proxy that = (CfnTopicProps.Jsii$Proxy) o;

            if (this.archivePolicy != null ? !this.archivePolicy.equals(that.archivePolicy) : that.archivePolicy != null) return false;
            if (this.contentBasedDeduplication != null ? !this.contentBasedDeduplication.equals(that.contentBasedDeduplication) : that.contentBasedDeduplication != null) return false;
            if (this.dataProtectionPolicy != null ? !this.dataProtectionPolicy.equals(that.dataProtectionPolicy) : that.dataProtectionPolicy != null) return false;
            if (this.deliveryStatusLogging != null ? !this.deliveryStatusLogging.equals(that.deliveryStatusLogging) : that.deliveryStatusLogging != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.fifoTopic != null ? !this.fifoTopic.equals(that.fifoTopic) : that.fifoTopic != null) return false;
            if (this.kmsMasterKeyId != null ? !this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId != null) return false;
            if (this.signatureVersion != null ? !this.signatureVersion.equals(that.signatureVersion) : that.signatureVersion != null) return false;
            if (this.subscription != null ? !this.subscription.equals(that.subscription) : that.subscription != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) return false;
            return this.tracingConfig != null ? this.tracingConfig.equals(that.tracingConfig) : that.tracingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.archivePolicy != null ? this.archivePolicy.hashCode() : 0;
            result = 31 * result + (this.contentBasedDeduplication != null ? this.contentBasedDeduplication.hashCode() : 0);
            result = 31 * result + (this.dataProtectionPolicy != null ? this.dataProtectionPolicy.hashCode() : 0);
            result = 31 * result + (this.deliveryStatusLogging != null ? this.deliveryStatusLogging.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.fifoTopic != null ? this.fifoTopic.hashCode() : 0);
            result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
            result = 31 * result + (this.signatureVersion != null ? this.signatureVersion.hashCode() : 0);
            result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
            result = 31 * result + (this.tracingConfig != null ? this.tracingConfig.hashCode() : 0);
            return result;
        }
    }
}
