package software.amazon.awscdk.services.ssmcontacts;

/**
 * Information about the stages and on-call rotation teams associated with an escalation plan or engagement plan.
 * <p>
 * <blockquote>
 * <p>
 * <em>Template example</em> : We recommend creating all Incident Manager <code>Contacts</code> resources using a single AWS CloudFormation template. For a demonstration, see the examples for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-contact.html">AWS::SSMContacts::Contacts</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmcontacts.*;
 * CfnPlan cfnPlan = CfnPlan.Builder.create(this, "MyCfnPlan")
 *         .contactId("contactId")
 *         // the properties below are optional
 *         .rotationIds(List.of("rotationIds"))
 *         .stages(List.of(StageProperty.builder()
 *                 .durationInMinutes(123)
 *                 // the properties below are optional
 *                 .targets(List.of(TargetsProperty.builder()
 *                         .channelTargetInfo(ChannelTargetInfoProperty.builder()
 *                                 .channelId("channelId")
 *                                 .retryIntervalInMinutes(123)
 *                                 .build())
 *                         .contactTargetInfo(ContactTargetInfoProperty.builder()
 *                                 .contactId("contactId")
 *                                 .isEssential(false)
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.337Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlan")
public class CfnPlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssmcontacts.CfnPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmcontacts.CfnPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the <code>Plan</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the contact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContactId() {
        return software.amazon.jsii.Kernel.get(this, "contactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the contact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContactId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "contactId", java.util.Objects.requireNonNull(value, "contactId is required"));
    }

    /**
     * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRotationIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "rotationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "rotationIds", value);
    }

    /**
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStages() {
        return software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stages", value);
    }

    /**
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssmcontacts.CfnPlan.StageProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssmcontacts.CfnPlan.StageProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stages", value);
    }
    /**
     * Information about the contact channel that Incident Manager uses to engage the contact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * ChannelTargetInfoProperty channelTargetInfoProperty = ChannelTargetInfoProperty.builder()
     *         .channelId("channelId")
     *         .retryIntervalInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlan.ChannelTargetInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelTargetInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelTargetInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html#cfn-ssmcontacts-plan-channeltargetinfo-channelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html#cfn-ssmcontacts-plan-channeltargetinfo-channelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannelId();

        /**
         * The number of minutes to wait before retrying to send engagement if the engagement initially failed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html#cfn-ssmcontacts-plan-channeltargetinfo-retryintervalinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-channeltargetinfo.html#cfn-ssmcontacts-plan-channeltargetinfo-retryintervalinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRetryIntervalInMinutes();

        /**
         * @return a {@link Builder} of {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelTargetInfoProperty> {
            java.lang.String channelId;
            java.lang.Number retryIntervalInMinutes;

            /**
             * Sets the value of {@link ChannelTargetInfoProperty#getChannelId}
             * @param channelId The Amazon Resource Name (ARN) of the contact channel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelId(java.lang.String channelId) {
                this.channelId = channelId;
                return this;
            }

            /**
             * Sets the value of {@link ChannelTargetInfoProperty#getRetryIntervalInMinutes}
             * @param retryIntervalInMinutes The number of minutes to wait before retrying to send engagement if the engagement initially failed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryIntervalInMinutes(java.lang.Number retryIntervalInMinutes) {
                this.retryIntervalInMinutes = retryIntervalInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelTargetInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelTargetInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelTargetInfoProperty {
            private final java.lang.String channelId;
            private final java.lang.Number retryIntervalInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelId = software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retryIntervalInMinutes = software.amazon.jsii.Kernel.get(this, "retryIntervalInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelId = java.util.Objects.requireNonNull(builder.channelId, "channelId is required");
                this.retryIntervalInMinutes = java.util.Objects.requireNonNull(builder.retryIntervalInMinutes, "retryIntervalInMinutes is required");
            }

            @Override
            public final java.lang.String getChannelId() {
                return this.channelId;
            }

            @Override
            public final java.lang.Number getRetryIntervalInMinutes() {
                return this.retryIntervalInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channelId", om.valueToTree(this.getChannelId()));
                data.set("retryIntervalInMinutes", om.valueToTree(this.getRetryIntervalInMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnPlan.ChannelTargetInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelTargetInfoProperty.Jsii$Proxy that = (ChannelTargetInfoProperty.Jsii$Proxy) o;

                if (!channelId.equals(that.channelId)) return false;
                return this.retryIntervalInMinutes.equals(that.retryIntervalInMinutes);
            }

            @Override
            public final int hashCode() {
                int result = this.channelId.hashCode();
                result = 31 * result + (this.retryIntervalInMinutes.hashCode());
                return result;
            }
        }
    }
    /**
     * The contact that Incident Manager is engaging during an incident.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * ContactTargetInfoProperty contactTargetInfoProperty = ContactTargetInfoProperty.builder()
     *         .contactId("contactId")
     *         .isEssential(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlan.ContactTargetInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ContactTargetInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContactTargetInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html#cfn-ssmcontacts-plan-contacttargetinfo-contactid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html#cfn-ssmcontacts-plan-contacttargetinfo-contactid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContactId();

        /**
         * A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html#cfn-ssmcontacts-plan-contacttargetinfo-isessential">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-contacttargetinfo.html#cfn-ssmcontacts-plan-contacttargetinfo-isessential</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsEssential();

        /**
         * @return a {@link Builder} of {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContactTargetInfoProperty> {
            java.lang.String contactId;
            java.lang.Object isEssential;

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getContactId}
             * @param contactId The Amazon Resource Name (ARN) of the contact. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactId(java.lang.String contactId) {
                this.contactId = contactId;
                return this;
            }

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getIsEssential}
             * @param isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEssential(java.lang.Boolean isEssential) {
                this.isEssential = isEssential;
                return this;
            }

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getIsEssential}
             * @param isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEssential(software.amazon.awscdk.IResolvable isEssential) {
                this.isEssential = isEssential;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContactTargetInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContactTargetInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContactTargetInfoProperty {
            private final java.lang.String contactId;
            private final java.lang.Object isEssential;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contactId = software.amazon.jsii.Kernel.get(this, "contactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isEssential = software.amazon.jsii.Kernel.get(this, "isEssential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contactId = java.util.Objects.requireNonNull(builder.contactId, "contactId is required");
                this.isEssential = java.util.Objects.requireNonNull(builder.isEssential, "isEssential is required");
            }

            @Override
            public final java.lang.String getContactId() {
                return this.contactId;
            }

            @Override
            public final java.lang.Object getIsEssential() {
                return this.isEssential;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contactId", om.valueToTree(this.getContactId()));
                data.set("isEssential", om.valueToTree(this.getIsEssential()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnPlan.ContactTargetInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContactTargetInfoProperty.Jsii$Proxy that = (ContactTargetInfoProperty.Jsii$Proxy) o;

                if (!contactId.equals(that.contactId)) return false;
                return this.isEssential.equals(that.isEssential);
            }

            @Override
            public final int hashCode() {
                int result = this.contactId.hashCode();
                result = 31 * result + (this.isEssential.hashCode());
                return result;
            }
        }
    }
    /**
     * A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * StageProperty stageProperty = StageProperty.builder()
     *         .durationInMinutes(123)
     *         // the properties below are optional
     *         .targets(List.of(TargetsProperty.builder()
     *                 .channelTargetInfo(ChannelTargetInfoProperty.builder()
     *                         .channelId("channelId")
     *                         .retryIntervalInMinutes(123)
     *                         .build())
     *                 .contactTargetInfo(ContactTargetInfoProperty.builder()
     *                         .contactId("contactId")
     *                         .isEssential(false)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlan.StageProperty")
    @software.amazon.jsii.Jsii.Proxy(StageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time to wait until beginning the next stage.
         * <p>
         * The duration can only be set to 0 if a target is specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html#cfn-ssmcontacts-plan-stage-durationinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html#cfn-ssmcontacts-plan-stage-durationinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDurationInMinutes();

        /**
         * The contacts or contact methods that the escalation plan or engagement plan is engaging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html#cfn-ssmcontacts-plan-stage-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-stage.html#cfn-ssmcontacts-plan-stage-targets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageProperty> {
            java.lang.Number durationInMinutes;
            java.lang.Object targets;

            /**
             * Sets the value of {@link StageProperty#getDurationInMinutes}
             * @param durationInMinutes The time to wait until beginning the next stage. This parameter is required.
             *                          The duration can only be set to 0 if a target is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInMinutes(java.lang.Number durationInMinutes) {
                this.durationInMinutes = durationInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StageProperty#getTargets}
             * @param targets The contacts or contact methods that the escalation plan or engagement plan is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(software.amazon.awscdk.IResolvable targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Sets the value of {@link StageProperty#getTargets}
             * @param targets The contacts or contact methods that the escalation plan or engagement plan is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(java.util.List<? extends java.lang.Object> targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProperty {
            private final java.lang.Number durationInMinutes;
            private final java.lang.Object targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInMinutes = software.amazon.jsii.Kernel.get(this, "durationInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInMinutes = java.util.Objects.requireNonNull(builder.durationInMinutes, "durationInMinutes is required");
                this.targets = builder.targets;
            }

            @Override
            public final java.lang.Number getDurationInMinutes() {
                return this.durationInMinutes;
            }

            @Override
            public final java.lang.Object getTargets() {
                return this.targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("durationInMinutes", om.valueToTree(this.getDurationInMinutes()));
                if (this.getTargets() != null) {
                    data.set("targets", om.valueToTree(this.getTargets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnPlan.StageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageProperty.Jsii$Proxy that = (StageProperty.Jsii$Proxy) o;

                if (!durationInMinutes.equals(that.durationInMinutes)) return false;
                return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInMinutes.hashCode();
                result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The contact or contact channel that's being engaged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * TargetsProperty targetsProperty = TargetsProperty.builder()
     *         .channelTargetInfo(ChannelTargetInfoProperty.builder()
     *                 .channelId("channelId")
     *                 .retryIntervalInMinutes(123)
     *                 .build())
     *         .contactTargetInfo(ContactTargetInfoProperty.builder()
     *                 .contactId("contactId")
     *                 .isEssential(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnPlan.TargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the contact channel that Incident Manager engages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html#cfn-ssmcontacts-plan-targets-channeltargetinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html#cfn-ssmcontacts-plan-targets-channeltargetinfo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChannelTargetInfo() {
            return null;
        }

        /**
         * Information about the contact that Incident Manager engages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html#cfn-ssmcontacts-plan-targets-contacttargetinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssmcontacts-plan-targets.html#cfn-ssmcontacts-plan-targets-contacttargetinfo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactTargetInfo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetsProperty> {
            java.lang.Object channelTargetInfo;
            java.lang.Object contactTargetInfo;

            /**
             * Sets the value of {@link TargetsProperty#getChannelTargetInfo}
             * @param channelTargetInfo Information about the contact channel that Incident Manager engages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelTargetInfo(software.amazon.awscdk.IResolvable channelTargetInfo) {
                this.channelTargetInfo = channelTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getChannelTargetInfo}
             * @param channelTargetInfo Information about the contact channel that Incident Manager engages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelTargetInfo(software.amazon.awscdk.services.ssmcontacts.CfnPlan.ChannelTargetInfoProperty channelTargetInfo) {
                this.channelTargetInfo = channelTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getContactTargetInfo}
             * @param contactTargetInfo Information about the contact that Incident Manager engages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactTargetInfo(software.amazon.awscdk.IResolvable contactTargetInfo) {
                this.contactTargetInfo = contactTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getContactTargetInfo}
             * @param contactTargetInfo Information about the contact that Incident Manager engages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactTargetInfo(software.amazon.awscdk.services.ssmcontacts.CfnPlan.ContactTargetInfoProperty contactTargetInfo) {
                this.contactTargetInfo = contactTargetInfo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetsProperty {
            private final java.lang.Object channelTargetInfo;
            private final java.lang.Object contactTargetInfo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelTargetInfo = software.amazon.jsii.Kernel.get(this, "channelTargetInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactTargetInfo = software.amazon.jsii.Kernel.get(this, "contactTargetInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelTargetInfo = builder.channelTargetInfo;
                this.contactTargetInfo = builder.contactTargetInfo;
            }

            @Override
            public final java.lang.Object getChannelTargetInfo() {
                return this.channelTargetInfo;
            }

            @Override
            public final java.lang.Object getContactTargetInfo() {
                return this.contactTargetInfo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChannelTargetInfo() != null) {
                    data.set("channelTargetInfo", om.valueToTree(this.getChannelTargetInfo()));
                }
                if (this.getContactTargetInfo() != null) {
                    data.set("contactTargetInfo", om.valueToTree(this.getContactTargetInfo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnPlan.TargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetsProperty.Jsii$Proxy that = (TargetsProperty.Jsii$Proxy) o;

                if (this.channelTargetInfo != null ? !this.channelTargetInfo.equals(that.channelTargetInfo) : that.channelTargetInfo != null) return false;
                return this.contactTargetInfo != null ? this.contactTargetInfo.equals(that.contactTargetInfo) : that.contactTargetInfo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelTargetInfo != null ? this.channelTargetInfo.hashCode() : 0;
                result = 31 * result + (this.contactTargetInfo != null ? this.contactTargetInfo.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssmcontacts.CfnPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssmcontacts.CfnPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssmcontacts.CfnPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssmcontacts.CfnPlanProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the contact.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-contactid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-contactid</a>
         * @param contactId The Amazon Resource Name (ARN) of the contact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactId(final java.lang.String contactId) {
            this.props.contactId(contactId);
            return this;
        }

        /**
         * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-rotationids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-rotationids</a>
         * @param rotationIds The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationIds(final java.util.List<java.lang.String> rotationIds) {
            this.props.rotationIds(rotationIds);
            return this;
        }

        /**
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages</a>
         * @param stages A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final software.amazon.awscdk.IResolvable stages) {
            this.props.stages(stages);
            return this;
        }
        /**
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmcontacts-plan.html#cfn-ssmcontacts-plan-stages</a>
         * @param stages A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final java.util.List<? extends java.lang.Object> stages) {
            this.props.stages(stages);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssmcontacts.CfnPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssmcontacts.CfnPlan build() {
            return new software.amazon.awscdk.services.ssmcontacts.CfnPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
