package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for configuring an Item Reader that iterates over items in a CSV file in S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Bucket bucket;
 * CsvHeaders csvHeaders;
 * S3CsvItemReaderProps s3CsvItemReaderProps = S3CsvItemReaderProps.builder()
 *         .key("key")
 *         // the properties below are optional
 *         .bucket(bucket)
 *         .bucketNamePath("bucketNamePath")
 *         .csvHeaders(csvHeaders)
 *         .maxItems(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.486Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3CsvItemReaderProps")
@software.amazon.jsii.Jsii.Proxy(S3CsvItemReaderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3CsvItemReaderProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.S3FileItemReaderProps {

    /**
     * CSV file header configuration.
     * <p>
     * Default: - CsvHeaders with CsvHeadersLocation.FIRST_ROW
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CsvHeaders getCsvHeaders() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3CsvItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3CsvItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3CsvItemReaderProps> {
        software.amazon.awscdk.services.stepfunctions.CsvHeaders csvHeaders;
        java.lang.String key;
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketNamePath;
        java.lang.Number maxItems;

        /**
         * Sets the value of {@link S3CsvItemReaderProps#getCsvHeaders}
         * @param csvHeaders CSV file header configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder csvHeaders(software.amazon.awscdk.services.stepfunctions.CsvHeaders csvHeaders) {
            this.csvHeaders = csvHeaders;
            return this;
        }

        /**
         * Sets the value of {@link S3CsvItemReaderProps#getKey}
         * @param key Key of file stored in S3 bucket containing an array to iterate over. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link S3CsvItemReaderProps#getBucket}
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3CsvItemReaderProps#getBucketNamePath}
         * @param bucketNamePath S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(java.lang.String bucketNamePath) {
            this.bucketNamePath = bucketNamePath;
            return this;
        }

        /**
         * Sets the value of {@link S3CsvItemReaderProps#getMaxItems}
         * @param maxItems Limits the number of items passed to the Distributed Map state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(java.lang.Number maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3CsvItemReaderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3CsvItemReaderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3CsvItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3CsvItemReaderProps {
        private final software.amazon.awscdk.services.stepfunctions.CsvHeaders csvHeaders;
        private final java.lang.String key;
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketNamePath;
        private final java.lang.Number maxItems;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.csvHeaders = software.amazon.jsii.Kernel.get(this, "csvHeaders", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CsvHeaders.class));
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketNamePath = software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxItems = software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.csvHeaders = builder.csvHeaders;
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.bucket = builder.bucket;
            this.bucketNamePath = builder.bucketNamePath;
            this.maxItems = builder.maxItems;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.CsvHeaders getCsvHeaders() {
            return this.csvHeaders;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketNamePath() {
            return this.bucketNamePath;
        }

        @Override
        public final java.lang.Number getMaxItems() {
            return this.maxItems;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCsvHeaders() != null) {
                data.set("csvHeaders", om.valueToTree(this.getCsvHeaders()));
            }
            data.set("key", om.valueToTree(this.getKey()));
            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getBucketNamePath() != null) {
                data.set("bucketNamePath", om.valueToTree(this.getBucketNamePath()));
            }
            if (this.getMaxItems() != null) {
                data.set("maxItems", om.valueToTree(this.getMaxItems()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.S3CsvItemReaderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3CsvItemReaderProps.Jsii$Proxy that = (S3CsvItemReaderProps.Jsii$Proxy) o;

            if (this.csvHeaders != null ? !this.csvHeaders.equals(that.csvHeaders) : that.csvHeaders != null) return false;
            if (!key.equals(that.key)) return false;
            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.bucketNamePath != null ? !this.bucketNamePath.equals(that.bucketNamePath) : that.bucketNamePath != null) return false;
            return this.maxItems != null ? this.maxItems.equals(that.maxItems) : that.maxItems == null;
        }

        @Override
        public final int hashCode() {
            int result = this.csvHeaders != null ? this.csvHeaders.hashCode() : 0;
            result = 31 * result + (this.key.hashCode());
            result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
            result = 31 * result + (this.bucketNamePath != null ? this.bucketNamePath.hashCode() : 0);
            result = 31 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
            return result;
        }
    }
}
