package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Class that supports methods which return the EKS cluster name depending on input type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersCreateVirtualCluster.Builder.create(this, "Create a Virtual Cluster")
 *         .eksCluster(EksClusterInput.fromTaskInput(TaskInput.fromText("clusterId")))
 *         .eksNamespace("specified-namespace")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EksClusterInput")
public class EksClusterInput extends software.amazon.jsii.JsiiObject {

    protected EksClusterInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksClusterInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Specify an existing EKS Cluster as the name for this Cluster.
     * <p>
     * @param cluster This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput fromCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster cluster) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput.class, "fromCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput.class), new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required") });
    }

    /**
     * Specify a Task Input as the name for this Cluster.
     * <p>
     * @param taskInput This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput fromTaskInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput taskInput) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput.class, "fromTaskInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EksClusterInput.class), new Object[] { java.util.Objects.requireNonNull(taskInput, "taskInput is required") });
    }

    /**
     * The name of the EKS Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
