package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * An entry to be sent to EventBridge.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * EventBus eventBus;
 * TaskInput taskInput;
 * EventBridgePutEventsEntry eventBridgePutEventsEntry = EventBridgePutEventsEntry.builder()
 *         .detail(taskInput)
 *         .detailType("detailType")
 *         .source("source")
 *         // the properties below are optional
 *         .eventBus(eventBus)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html">https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.694Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EventBridgePutEventsEntry")
@software.amazon.jsii.Jsii.Proxy(EventBridgePutEventsEntry.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventBridgePutEventsEntry extends software.amazon.jsii.JsiiSerializable {

    /**
     * The event body.
     * <p>
     * Can either be provided as an object or as a JSON-serialized string
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * TaskInput.fromText("{\"instance-id\": \"i-1234567890abcdef0\", \"state\": \"terminated\"}");
     * TaskInput.fromObject(Map.of("Message", "Hello from Step Functions"));
     * TaskInput.fromJsonPathAt("$.EventDetail");
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getDetail();

    /**
     * Used along with the source field to help identify the fields and values expected in the detail field.
     * <p>
     * For example, events by CloudTrail have detail type "AWS API Call via CloudTrail"
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetailType();

    /**
     * The service or application that caused this event to be generated.
     * <p>
     * Example value: <code>com.example.service</code>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The event bus the entry will be sent to.
     * <p>
     * Default: - event is sent to account's default event bus
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IEventBus getEventBus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventBridgePutEventsEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventBridgePutEventsEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventBridgePutEventsEntry> {
        software.amazon.awscdk.services.stepfunctions.TaskInput detail;
        java.lang.String detailType;
        java.lang.String source;
        software.amazon.awscdk.services.events.IEventBus eventBus;

        /**
         * Sets the value of {@link EventBridgePutEventsEntry#getDetail}
         * @param detail The event body. This parameter is required.
         *               Can either be provided as an object or as a JSON-serialized string
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detail(software.amazon.awscdk.services.stepfunctions.TaskInput detail) {
            this.detail = detail;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgePutEventsEntry#getDetailType}
         * @param detailType Used along with the source field to help identify the fields and values expected in the detail field. This parameter is required.
         *                   For example, events by CloudTrail have detail type "AWS API Call via CloudTrail"
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(java.lang.String detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgePutEventsEntry#getSource}
         * @param source The service or application that caused this event to be generated. This parameter is required.
         *               Example value: <code>com.example.service</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link EventBridgePutEventsEntry#getEventBus}
         * @param eventBus The event bus the entry will be sent to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventBridgePutEventsEntry}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventBridgePutEventsEntry build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventBridgePutEventsEntry}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgePutEventsEntry {
        private final software.amazon.awscdk.services.stepfunctions.TaskInput detail;
        private final java.lang.String detailType;
        private final java.lang.String source;
        private final software.amazon.awscdk.services.events.IEventBus eventBus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detail = software.amazon.jsii.Kernel.get(this, "detail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBus = software.amazon.jsii.Kernel.get(this, "eventBus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IEventBus.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detail = java.util.Objects.requireNonNull(builder.detail, "detail is required");
            this.detailType = java.util.Objects.requireNonNull(builder.detailType, "detailType is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.eventBus = builder.eventBus;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getDetail() {
            return this.detail;
        }

        @Override
        public final java.lang.String getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final software.amazon.awscdk.services.events.IEventBus getEventBus() {
            return this.eventBus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detail", om.valueToTree(this.getDetail()));
            data.set("detailType", om.valueToTree(this.getDetailType()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getEventBus() != null) {
                data.set("eventBus", om.valueToTree(this.getEventBus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EventBridgePutEventsEntry"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventBridgePutEventsEntry.Jsii$Proxy that = (EventBridgePutEventsEntry.Jsii$Proxy) o;

            if (!detail.equals(that.detail)) return false;
            if (!detailType.equals(that.detailType)) return false;
            if (!source.equals(that.source)) return false;
            return this.eventBus != null ? this.eventBus.equals(that.eventBus) : that.eventBus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detail.hashCode();
            result = 31 * result + (this.detailType.hashCode());
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.eventBus != null ? this.eventBus.hashCode() : 0);
            return result;
        }
    }
}
