package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A message attribute to add to the SNS message.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = new Topic(this, "Topic");
 * // Use a field from the execution data as message.
 * SnsPublish task1 = SnsPublish.Builder.create(this, "Publish1")
 *         .topic(topic)
 *         .integrationPattern(IntegrationPattern.REQUEST_RESPONSE)
 *         .message(TaskInput.fromDataAt("$.state.message"))
 *         .messageAttributes(Map.of(
 *                 "place", MessageAttribute.builder()
 *                         .value(JsonPath.stringAt("$.place"))
 *                         .build(),
 *                 "pic", MessageAttribute.builder()
 *                         // BINARY must be explicitly set
 *                         .dataType(MessageAttributeDataType.BINARY)
 *                         .value(JsonPath.stringAt("$.pic"))
 *                         .build(),
 *                 "people", MessageAttribute.builder()
 *                         .value(4)
 *                         .build(),
 *                 "handles", MessageAttribute.builder()
 *                         .value(List.of("&#64;kslater", "&#64;jjf", null, "&#64;mfanning"))
 *                         .build()))
 *         .build();
 * // Combine a field from the execution data with
 * // a literal object.
 * SnsPublish task2 = SnsPublish.Builder.create(this, "Publish2")
 *         .topic(topic)
 *         .message(TaskInput.fromObject(Map.of(
 *                 "field1", "somedata",
 *                 "field2", JsonPath.stringAt("$.field2"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.731Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.MessageAttribute")
@software.amazon.jsii.Jsii.Proxy(MessageAttribute.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MessageAttribute extends software.amazon.jsii.JsiiSerializable {

    /**
     * The value of the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getValue();

    /**
     * The data type for the attribute.
     * <p>
     * Default: determined by type inspection if possible, fallback is String
     * <p>
     * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes">https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html#SNSMessageAttributes.DataTypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType getDataType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MessageAttribute> {
        java.lang.Object value;
        software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType;

        /**
         * Sets the value of {@link MessageAttribute#getValue}
         * @param value The value of the attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.Object value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link MessageAttribute#getDataType}
         * @param dataType The data type for the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataType(software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MessageAttribute}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MessageAttribute build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MessageAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageAttribute {
        private final java.lang.Object value;
        private final software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType dataType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            this.dataType = builder.dataType;
        }

        @Override
        public final java.lang.Object getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.MessageAttributeDataType getDataType() {
            return this.dataType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("value", om.valueToTree(this.getValue()));
            if (this.getDataType() != null) {
                data.set("dataType", om.valueToTree(this.getDataType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.MessageAttribute"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MessageAttribute.Jsii$Proxy that = (MessageAttribute.Jsii$Proxy) o;

            if (!value.equals(that.value)) return false;
            return this.dataType != null ? this.dataType.equals(that.dataType) : that.dataType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
            return result;
        }
    }
}
