package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Class that returns a virtual cluster's id depending on input type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.779Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.VirtualClusterInput")
public class VirtualClusterInput extends software.amazon.jsii.JsiiObject {

    protected VirtualClusterInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualClusterInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Input for a virtualClusterId from a Task Input.
     * <p>
     * @param taskInput This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput fromTaskInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput taskInput) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput.class, "fromTaskInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput.class), new Object[] { java.util.Objects.requireNonNull(taskInput, "taskInput is required") });
    }

    /**
     * Input for virtualClusterId from a literal string.
     * <p>
     * @param virtualClusterId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput fromVirtualClusterId(final @org.jetbrains.annotations.NotNull java.lang.String virtualClusterId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput.class, "fromVirtualClusterId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.VirtualClusterInput.class), new Object[] { java.util.Objects.requireNonNull(virtualClusterId, "virtualClusterId is required") });
    }

    /**
     * The VirtualCluster Id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
