package software.amazon.awscdk.services.verifiedpermissions;

/**
 * Properties for defining a <code>CfnIdentitySource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.verifiedpermissions.*;
 * CfnIdentitySourceProps cfnIdentitySourceProps = CfnIdentitySourceProps.builder()
 *         .configuration(IdentitySourceConfigurationProperty.builder()
 *                 .cognitoUserPoolConfiguration(CognitoUserPoolConfigurationProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         // the properties below are optional
 *                         .clientIds(List.of("clientIds"))
 *                         .groupConfiguration(CognitoGroupConfigurationProperty.builder()
 *                                 .groupEntityType("groupEntityType")
 *                                 .build())
 *                         .build())
 *                 .openIdConnectConfiguration(OpenIdConnectConfigurationProperty.builder()
 *                         .issuer("issuer")
 *                         .tokenSelection(OpenIdConnectTokenSelectionProperty.builder()
 *                                 .accessTokenOnly(OpenIdConnectAccessTokenConfigurationProperty.builder()
 *                                         .audiences(List.of("audiences"))
 *                                         .principalIdClaim("principalIdClaim")
 *                                         .build())
 *                                 .identityTokenOnly(OpenIdConnectIdentityTokenConfigurationProperty.builder()
 *                                         .clientIds(List.of("clientIds"))
 *                                         .principalIdClaim("principalIdClaim")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .entityIdPrefix("entityIdPrefix")
 *                         .groupConfiguration(OpenIdConnectGroupConfigurationProperty.builder()
 *                                 .groupClaim("groupClaim")
 *                                 .groupEntityType("groupEntityType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .policyStoreId("policyStoreId")
 *         // the properties below are optional
 *         .principalEntityType("principalEntityType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2025-01-04T09:06:31.920Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentitySourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentitySourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains configuration information used when creating a new identity source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * Specifies the ID of the policy store in which you want to store this identity source.
     * <p>
     * Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-policystoreid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId();

    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-identitysource.html#cfn-verifiedpermissions-identitysource-principalentitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrincipalEntityType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentitySourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentitySourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentitySourceProps> {
        java.lang.Object configuration;
        java.lang.String policyStoreId;
        java.lang.String principalEntityType;

        /**
         * Sets the value of {@link CfnIdentitySourceProps#getConfiguration}
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentitySourceProps#getConfiguration}
         * @param configuration Contains configuration information used when creating a new identity source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.verifiedpermissions.CfnIdentitySource.IdentitySourceConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentitySourceProps#getPolicyStoreId}
         * @param policyStoreId Specifies the ID of the policy store in which you want to store this identity source. This parameter is required.
         *                      Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(java.lang.String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentitySourceProps#getPrincipalEntityType}
         * @param principalEntityType Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalEntityType(java.lang.String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentitySourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentitySourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentitySourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentitySourceProps {
        private final java.lang.Object configuration;
        private final java.lang.String policyStoreId;
        private final java.lang.String principalEntityType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyStoreId = software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principalEntityType = software.amazon.jsii.Kernel.get(this, "principalEntityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.policyStoreId = java.util.Objects.requireNonNull(builder.policyStoreId, "policyStoreId is required");
            this.principalEntityType = builder.principalEntityType;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getPolicyStoreId() {
            return this.policyStoreId;
        }

        @Override
        public final java.lang.String getPrincipalEntityType() {
            return this.principalEntityType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("policyStoreId", om.valueToTree(this.getPolicyStoreId()));
            if (this.getPrincipalEntityType() != null) {
                data.set("principalEntityType", om.valueToTree(this.getPrincipalEntityType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnIdentitySourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentitySourceProps.Jsii$Proxy that = (CfnIdentitySourceProps.Jsii$Proxy) o;

            if (!configuration.equals(that.configuration)) return false;
            if (!policyStoreId.equals(that.policyStoreId)) return false;
            return this.principalEntityType != null ? this.principalEntityType.equals(that.principalEntityType) : that.principalEntityType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            result = 31 * result + (this.policyStoreId.hashCode());
            result = 31 * result + (this.principalEntityType != null ? this.principalEntityType.hashCode() : 0);
            return result;
        }
    }
}
