/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnKnowledgeBase;
import software.amazon.awscdk.services.bedrock.CfnKnowledgeBaseProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase")
public class CfnKnowledgeBase
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnKnowledgeBase.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnKnowledgeBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKnowledgeBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnKnowledgeBase(@NotNull Construct scope, @NotNull String id, @NotNull CfnKnowledgeBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrFailureReasons() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrFailureReasons", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrKnowledgeBaseArn() {
        return (String)Kernel.get((Object)this, (String)"attrKnowledgeBaseArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrKnowledgeBaseId() {
        return (String)Kernel.get((Object)this, (String)"attrKnowledgeBaseId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getKnowledgeBaseConfiguration() {
        return Kernel.get((Object)this, (String)"knowledgeBaseConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKnowledgeBaseConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"knowledgeBaseConfiguration", (Object)Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    public void setKnowledgeBaseConfiguration(@NotNull KnowledgeBaseConfigurationProperty value) {
        Kernel.set((Object)this, (String)"knowledgeBaseConfiguration", (Object)Objects.requireNonNull(value, "knowledgeBaseConfiguration is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getStorageConfiguration() {
        return Kernel.get((Object)this, (String)"storageConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStorageConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"storageConfiguration", (Object)value);
    }

    public void setStorageConfiguration(@Nullable StorageConfigurationProperty value) {
        Kernel.set((Object)this, (String)"storageConfiguration", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnKnowledgeBase> {
        private final Construct scope;
        private final String id;
        private final CfnKnowledgeBaseProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnKnowledgeBaseProps.Builder();
        }

        public Builder knowledgeBaseConfiguration(IResolvable knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }

        public Builder knowledgeBaseConfiguration(KnowledgeBaseConfigurationProperty knowledgeBaseConfiguration) {
            this.props.knowledgeBaseConfiguration(knowledgeBaseConfiguration);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder storageConfiguration(IResolvable storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }

        public Builder storageConfiguration(StorageConfigurationProperty storageConfiguration) {
            this.props.storageConfiguration(storageConfiguration);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnKnowledgeBase build() {
            return new CfnKnowledgeBase(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.VectorKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorKnowledgeBaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEmbeddingModelArn();

        @Nullable
        default public Object getEmbeddingModelConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSupplementalDataStorageConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorKnowledgeBaseConfigurationProperty> {
            String embeddingModelArn;
            Object embeddingModelConfiguration;
            Object supplementalDataStorageConfiguration;

            public Builder embeddingModelArn(String embeddingModelArn) {
                this.embeddingModelArn = embeddingModelArn;
                return this;
            }

            public Builder embeddingModelConfiguration(IResolvable embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            public Builder embeddingModelConfiguration(EmbeddingModelConfigurationProperty embeddingModelConfiguration) {
                this.embeddingModelConfiguration = embeddingModelConfiguration;
                return this;
            }

            public Builder supplementalDataStorageConfiguration(IResolvable supplementalDataStorageConfiguration) {
                this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
                return this;
            }

            public Builder supplementalDataStorageConfiguration(SupplementalDataStorageConfigurationProperty supplementalDataStorageConfiguration) {
                this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
                return this;
            }

            public VectorKnowledgeBaseConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SupplementalDataStorageLocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSupplementalDataStorageLocationType();

        @Nullable
        default public Object getS3Location() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SupplementalDataStorageLocationProperty> {
            String supplementalDataStorageLocationType;
            Object s3Location;

            public Builder supplementalDataStorageLocationType(String supplementalDataStorageLocationType) {
                this.supplementalDataStorageLocationType = supplementalDataStorageLocationType;
                return this;
            }

            public Builder s3Location(IResolvable s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public Builder s3Location(S3LocationProperty s3Location) {
                this.s3Location = s3Location;
                return this;
            }

            public SupplementalDataStorageLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.SupplementalDataStorageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SupplementalDataStorageConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSupplementalDataStorageLocations();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SupplementalDataStorageConfigurationProperty> {
            Object supplementalDataStorageLocations;

            public Builder supplementalDataStorageLocations(IResolvable supplementalDataStorageLocations) {
                this.supplementalDataStorageLocations = supplementalDataStorageLocations;
                return this;
            }

            public Builder supplementalDataStorageLocations(List<? extends Object> supplementalDataStorageLocations) {
                this.supplementalDataStorageLocations = supplementalDataStorageLocations;
                return this;
            }

            public SupplementalDataStorageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.StorageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getOpensearchServerlessConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPineconeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRdsConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageConfigurationProperty> {
            String type;
            Object opensearchServerlessConfiguration;
            Object pineconeConfiguration;
            Object rdsConfiguration;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder opensearchServerlessConfiguration(IResolvable opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            public Builder opensearchServerlessConfiguration(OpenSearchServerlessConfigurationProperty opensearchServerlessConfiguration) {
                this.opensearchServerlessConfiguration = opensearchServerlessConfiguration;
                return this;
            }

            public Builder pineconeConfiguration(IResolvable pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            public Builder pineconeConfiguration(PineconeConfigurationProperty pineconeConfiguration) {
                this.pineconeConfiguration = pineconeConfiguration;
                return this;
            }

            public Builder rdsConfiguration(IResolvable rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            public Builder rdsConfiguration(RdsConfigurationProperty rdsConfiguration) {
                this.rdsConfiguration = rdsConfiguration;
                return this;
            }

            public StorageConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getUri();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String uri;

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RdsFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMetadataField();

        @NotNull
        public String getPrimaryKeyField();

        @NotNull
        public String getTextField();

        @NotNull
        public String getVectorField();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RdsFieldMappingProperty> {
            String metadataField;
            String primaryKeyField;
            String textField;
            String vectorField;

            public Builder metadataField(String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            public Builder primaryKeyField(String primaryKeyField) {
                this.primaryKeyField = primaryKeyField;
                return this;
            }

            public Builder textField(String textField) {
                this.textField = textField;
                return this;
            }

            public Builder vectorField(String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            public RdsFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.RdsConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RdsConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCredentialsSecretArn();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Object getFieldMapping();

        @NotNull
        public String getResourceArn();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RdsConfigurationProperty> {
            String credentialsSecretArn;
            String databaseName;
            Object fieldMapping;
            String resourceArn;
            String tableName;

            public Builder credentialsSecretArn(String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder fieldMapping(IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder fieldMapping(RdsFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder resourceArn(String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public RdsConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PineconeFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMetadataField();

        @NotNull
        public String getTextField();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PineconeFieldMappingProperty> {
            String metadataField;
            String textField;

            public Builder metadataField(String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            public Builder textField(String textField) {
                this.textField = textField;
                return this;
            }

            public PineconeFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.PineconeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PineconeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getConnectionString();

        @NotNull
        public String getCredentialsSecretArn();

        @NotNull
        public Object getFieldMapping();

        @Nullable
        default public String getNamespace() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PineconeConfigurationProperty> {
            String connectionString;
            String credentialsSecretArn;
            Object fieldMapping;
            String namespace;

            public Builder connectionString(String connectionString) {
                this.connectionString = connectionString;
                return this;
            }

            public Builder credentialsSecretArn(String credentialsSecretArn) {
                this.credentialsSecretArn = credentialsSecretArn;
                return this;
            }

            public Builder fieldMapping(IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder fieldMapping(PineconeFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public PineconeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenSearchServerlessFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMetadataField();

        @NotNull
        public String getTextField();

        @NotNull
        public String getVectorField();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenSearchServerlessFieldMappingProperty> {
            String metadataField;
            String textField;
            String vectorField;

            public Builder metadataField(String metadataField) {
                this.metadataField = metadataField;
                return this;
            }

            public Builder textField(String textField) {
                this.textField = textField;
                return this;
            }

            public Builder vectorField(String vectorField) {
                this.vectorField = vectorField;
                return this;
            }

            public OpenSearchServerlessFieldMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.OpenSearchServerlessConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenSearchServerlessConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCollectionArn();

        @NotNull
        public Object getFieldMapping();

        @NotNull
        public String getVectorIndexName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenSearchServerlessConfigurationProperty> {
            String collectionArn;
            Object fieldMapping;
            String vectorIndexName;

            public Builder collectionArn(String collectionArn) {
                this.collectionArn = collectionArn;
                return this;
            }

            public Builder fieldMapping(IResolvable fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder fieldMapping(OpenSearchServerlessFieldMappingProperty fieldMapping) {
                this.fieldMapping = fieldMapping;
                return this;
            }

            public Builder vectorIndexName(String vectorIndexName) {
                this.vectorIndexName = vectorIndexName;
                return this;
            }

            public OpenSearchServerlessConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KnowledgeBaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getKendraKnowledgeBaseConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVectorKnowledgeBaseConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KnowledgeBaseConfigurationProperty> {
            String type;
            Object kendraKnowledgeBaseConfiguration;
            Object vectorKnowledgeBaseConfiguration;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder kendraKnowledgeBaseConfiguration(IResolvable kendraKnowledgeBaseConfiguration) {
                this.kendraKnowledgeBaseConfiguration = kendraKnowledgeBaseConfiguration;
                return this;
            }

            public Builder kendraKnowledgeBaseConfiguration(KendraKnowledgeBaseConfigurationProperty kendraKnowledgeBaseConfiguration) {
                this.kendraKnowledgeBaseConfiguration = kendraKnowledgeBaseConfiguration;
                return this;
            }

            public Builder vectorKnowledgeBaseConfiguration(IResolvable vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            public Builder vectorKnowledgeBaseConfiguration(VectorKnowledgeBaseConfigurationProperty vectorKnowledgeBaseConfiguration) {
                this.vectorKnowledgeBaseConfiguration = vectorKnowledgeBaseConfiguration;
                return this;
            }

            public KnowledgeBaseConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.KendraKnowledgeBaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KendraKnowledgeBaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKendraIndexArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KendraKnowledgeBaseConfigurationProperty> {
            String kendraIndexArn;

            public Builder kendraIndexArn(String kendraIndexArn) {
                this.kendraIndexArn = kendraIndexArn;
                return this;
            }

            public KendraKnowledgeBaseConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.EmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmbeddingModelConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBedrockEmbeddingModelConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmbeddingModelConfigurationProperty> {
            Object bedrockEmbeddingModelConfiguration;

            public Builder bedrockEmbeddingModelConfiguration(IResolvable bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            public Builder bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfigurationProperty bedrockEmbeddingModelConfiguration) {
                this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
                return this;
            }

            public EmbeddingModelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnKnowledgeBase.BedrockEmbeddingModelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BedrockEmbeddingModelConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDimensions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BedrockEmbeddingModelConfigurationProperty> {
            Number dimensions;

            public Builder dimensions(Number dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public BedrockEmbeddingModelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

