/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.rds.CfnDBCluster;
import software.amazon.awscdk.services.rds.CfnDBClusterProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster")
public class CfnDBCluster
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDBCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDBCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDBCluster(@NotNull Construct scope, @NotNull String id, @Nullable CfnDBClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnDBCluster(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDbClusterArn() {
        return (String)Kernel.get((Object)this, (String)"attrDbClusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDbClusterResourceId() {
        return (String)Kernel.get((Object)this, (String)"attrDbClusterResourceId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrEndpoint() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrEndpoint", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"attrEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrMasterUserSecretSecretArn() {
        return (String)Kernel.get((Object)this, (String)"attrMasterUserSecretSecretArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrReadEndpoint() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrReadEndpoint", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrReadEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"attrReadEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrStorageThroughput() {
        return (Number)Kernel.get((Object)this, (String)"attrStorageThroughput", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Number getAllocatedStorage() {
        return (Number)Kernel.get((Object)this, (String)"allocatedStorage", (NativeType)NativeType.forClass(Number.class));
    }

    public void setAllocatedStorage(@Nullable Number value) {
        Kernel.set((Object)this, (String)"allocatedStorage", (Object)value);
    }

    @Nullable
    public Object getAssociatedRoles() {
        return Kernel.get((Object)this, (String)"associatedRoles", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAssociatedRoles(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"associatedRoles", (Object)value);
    }

    public void setAssociatedRoles(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof DBClusterRoleProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rds.CfnDBCluster.DBClusterRoleProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"associatedRoles", value);
    }

    @Nullable
    public Object getAutoMinorVersionUpgrade() {
        return Kernel.get((Object)this, (String)"autoMinorVersionUpgrade", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoMinorVersionUpgrade(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    public void setAutoMinorVersionUpgrade(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoMinorVersionUpgrade", (Object)value);
    }

    @Nullable
    public List<String> getAvailabilityZones() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"availabilityZones", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAvailabilityZones(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"availabilityZones", value);
    }

    @Nullable
    public Number getBacktrackWindow() {
        return (Number)Kernel.get((Object)this, (String)"backtrackWindow", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBacktrackWindow(@Nullable Number value) {
        Kernel.set((Object)this, (String)"backtrackWindow", (Object)value);
    }

    @Nullable
    public Number getBackupRetentionPeriod() {
        return (Number)Kernel.get((Object)this, (String)"backupRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBackupRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"backupRetentionPeriod", (Object)value);
    }

    @Nullable
    public String getClusterScalabilityType() {
        return (String)Kernel.get((Object)this, (String)"clusterScalabilityType", (NativeType)NativeType.forClass(String.class));
    }

    public void setClusterScalabilityType(@Nullable String value) {
        Kernel.set((Object)this, (String)"clusterScalabilityType", (Object)value);
    }

    @Nullable
    public Object getCopyTagsToSnapshot() {
        return Kernel.get((Object)this, (String)"copyTagsToSnapshot", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCopyTagsToSnapshot(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"copyTagsToSnapshot", (Object)value);
    }

    public void setCopyTagsToSnapshot(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"copyTagsToSnapshot", (Object)value);
    }

    @Nullable
    public String getDatabaseInsightsMode() {
        return (String)Kernel.get((Object)this, (String)"databaseInsightsMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatabaseInsightsMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"databaseInsightsMode", (Object)value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatabaseName(@Nullable String value) {
        Kernel.set((Object)this, (String)"databaseName", (Object)value);
    }

    @Nullable
    public String getDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"dbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getDbClusterInstanceClass() {
        return (String)Kernel.get((Object)this, (String)"dbClusterInstanceClass", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterInstanceClass(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterInstanceClass", (Object)value);
    }

    @Nullable
    public String getDbClusterParameterGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbClusterParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbClusterParameterGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbClusterParameterGroupName", (Object)value);
    }

    @Nullable
    public String getDbInstanceParameterGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceParameterGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbInstanceParameterGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbInstanceParameterGroupName", (Object)value);
    }

    @Nullable
    public String getDbSubnetGroupName() {
        return (String)Kernel.get((Object)this, (String)"dbSubnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbSubnetGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbSubnetGroupName", (Object)value);
    }

    @Nullable
    public String getDbSystemId() {
        return (String)Kernel.get((Object)this, (String)"dbSystemId", (NativeType)NativeType.forClass(String.class));
    }

    public void setDbSystemId(@Nullable String value) {
        Kernel.set((Object)this, (String)"dbSystemId", (Object)value);
    }

    @Nullable
    public Object getDeletionProtection() {
        return Kernel.get((Object)this, (String)"deletionProtection", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDeletionProtection(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    public void setDeletionProtection(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"deletionProtection", (Object)value);
    }

    @Nullable
    public String getDomain() {
        return (String)Kernel.get((Object)this, (String)"domain", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomain(@Nullable String value) {
        Kernel.set((Object)this, (String)"domain", (Object)value);
    }

    @Nullable
    public String getDomainIamRoleName() {
        return (String)Kernel.get((Object)this, (String)"domainIamRoleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainIamRoleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"domainIamRoleName", (Object)value);
    }

    @Nullable
    public List<String> getEnableCloudwatchLogsExports() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"enableCloudwatchLogsExports", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setEnableCloudwatchLogsExports(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"enableCloudwatchLogsExports", value);
    }

    @Nullable
    public Object getEnableGlobalWriteForwarding() {
        return Kernel.get((Object)this, (String)"enableGlobalWriteForwarding", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableGlobalWriteForwarding(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableGlobalWriteForwarding", (Object)value);
    }

    public void setEnableGlobalWriteForwarding(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableGlobalWriteForwarding", (Object)value);
    }

    @Nullable
    public Object getEnableHttpEndpoint() {
        return Kernel.get((Object)this, (String)"enableHttpEndpoint", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableHttpEndpoint(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableHttpEndpoint", (Object)value);
    }

    public void setEnableHttpEndpoint(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableHttpEndpoint", (Object)value);
    }

    @Nullable
    public Object getEnableIamDatabaseAuthentication() {
        return Kernel.get((Object)this, (String)"enableIamDatabaseAuthentication", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableIamDatabaseAuthentication(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    public void setEnableIamDatabaseAuthentication(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableIamDatabaseAuthentication", (Object)value);
    }

    @Nullable
    public Object getEnableLocalWriteForwarding() {
        return Kernel.get((Object)this, (String)"enableLocalWriteForwarding", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableLocalWriteForwarding(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableLocalWriteForwarding", (Object)value);
    }

    public void setEnableLocalWriteForwarding(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableLocalWriteForwarding", (Object)value);
    }

    @Nullable
    public String getEngine() {
        return (String)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngine(@Nullable String value) {
        Kernel.set((Object)this, (String)"engine", (Object)value);
    }

    @Nullable
    public String getEngineLifecycleSupport() {
        return (String)Kernel.get((Object)this, (String)"engineLifecycleSupport", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineLifecycleSupport(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineLifecycleSupport", (Object)value);
    }

    @Nullable
    public String getEngineMode() {
        return (String)Kernel.get((Object)this, (String)"engineMode", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineMode(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineMode", (Object)value);
    }

    @Nullable
    public String getEngineVersion() {
        return (String)Kernel.get((Object)this, (String)"engineVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setEngineVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"engineVersion", (Object)value);
    }

    @Nullable
    public String getGlobalClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"globalClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setGlobalClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"globalClusterIdentifier", (Object)value);
    }

    @Nullable
    public Number getIops() {
        return (Number)Kernel.get((Object)this, (String)"iops", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIops(@Nullable Number value) {
        Kernel.set((Object)this, (String)"iops", (Object)value);
    }

    @Nullable
    public String getKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyId", (Object)value);
    }

    @Nullable
    public Object getManageMasterUserPassword() {
        return Kernel.get((Object)this, (String)"manageMasterUserPassword", (NativeType)NativeType.forClass(Object.class));
    }

    public void setManageMasterUserPassword(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"manageMasterUserPassword", (Object)value);
    }

    public void setManageMasterUserPassword(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"manageMasterUserPassword", (Object)value);
    }

    @Nullable
    public String getMasterUsername() {
        return (String)Kernel.get((Object)this, (String)"masterUsername", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUsername(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUsername", (Object)value);
    }

    @Nullable
    public String getMasterUserPassword() {
        return (String)Kernel.get((Object)this, (String)"masterUserPassword", (NativeType)NativeType.forClass(String.class));
    }

    public void setMasterUserPassword(@Nullable String value) {
        Kernel.set((Object)this, (String)"masterUserPassword", (Object)value);
    }

    @Nullable
    public Object getMasterUserSecret() {
        return Kernel.get((Object)this, (String)"masterUserSecret", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMasterUserSecret(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"masterUserSecret", (Object)value);
    }

    public void setMasterUserSecret(@Nullable MasterUserSecretProperty value) {
        Kernel.set((Object)this, (String)"masterUserSecret", (Object)value);
    }

    @Nullable
    public Number getMonitoringInterval() {
        return (Number)Kernel.get((Object)this, (String)"monitoringInterval", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMonitoringInterval(@Nullable Number value) {
        Kernel.set((Object)this, (String)"monitoringInterval", (Object)value);
    }

    @Nullable
    public String getMonitoringRoleArn() {
        return (String)Kernel.get((Object)this, (String)"monitoringRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setMonitoringRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"monitoringRoleArn", (Object)value);
    }

    @Nullable
    public String getNetworkType() {
        return (String)Kernel.get((Object)this, (String)"networkType", (NativeType)NativeType.forClass(String.class));
    }

    public void setNetworkType(@Nullable String value) {
        Kernel.set((Object)this, (String)"networkType", (Object)value);
    }

    @Nullable
    public Object getPerformanceInsightsEnabled() {
        return Kernel.get((Object)this, (String)"performanceInsightsEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPerformanceInsightsEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"performanceInsightsEnabled", (Object)value);
    }

    public void setPerformanceInsightsEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"performanceInsightsEnabled", (Object)value);
    }

    @Nullable
    public String getPerformanceInsightsKmsKeyId() {
        return (String)Kernel.get((Object)this, (String)"performanceInsightsKmsKeyId", (NativeType)NativeType.forClass(String.class));
    }

    public void setPerformanceInsightsKmsKeyId(@Nullable String value) {
        Kernel.set((Object)this, (String)"performanceInsightsKmsKeyId", (Object)value);
    }

    @Nullable
    public Number getPerformanceInsightsRetentionPeriod() {
        return (Number)Kernel.get((Object)this, (String)"performanceInsightsRetentionPeriod", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPerformanceInsightsRetentionPeriod(@Nullable Number value) {
        Kernel.set((Object)this, (String)"performanceInsightsRetentionPeriod", (Object)value);
    }

    @Nullable
    public Number getPort() {
        return (Number)Kernel.get((Object)this, (String)"port", (NativeType)NativeType.forClass(Number.class));
    }

    public void setPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"port", (Object)value);
    }

    @Nullable
    public String getPreferredBackupWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredBackupWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredBackupWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredBackupWindow", (Object)value);
    }

    @Nullable
    public String getPreferredMaintenanceWindow() {
        return (String)Kernel.get((Object)this, (String)"preferredMaintenanceWindow", (NativeType)NativeType.forClass(String.class));
    }

    public void setPreferredMaintenanceWindow(@Nullable String value) {
        Kernel.set((Object)this, (String)"preferredMaintenanceWindow", (Object)value);
    }

    @Nullable
    public Object getPubliclyAccessible() {
        return Kernel.get((Object)this, (String)"publiclyAccessible", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPubliclyAccessible(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    public void setPubliclyAccessible(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publiclyAccessible", (Object)value);
    }

    @Nullable
    public String getReplicationSourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"replicationSourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setReplicationSourceIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"replicationSourceIdentifier", (Object)value);
    }

    @Nullable
    public String getRestoreToTime() {
        return (String)Kernel.get((Object)this, (String)"restoreToTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setRestoreToTime(@Nullable String value) {
        Kernel.set((Object)this, (String)"restoreToTime", (Object)value);
    }

    @Nullable
    public String getRestoreType() {
        return (String)Kernel.get((Object)this, (String)"restoreType", (NativeType)NativeType.forClass(String.class));
    }

    public void setRestoreType(@Nullable String value) {
        Kernel.set((Object)this, (String)"restoreType", (Object)value);
    }

    @Nullable
    public Object getScalingConfiguration() {
        return Kernel.get((Object)this, (String)"scalingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScalingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    public void setScalingConfiguration(@Nullable ScalingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    @Nullable
    public Object getServerlessV2ScalingConfiguration() {
        return Kernel.get((Object)this, (String)"serverlessV2ScalingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServerlessV2ScalingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serverlessV2ScalingConfiguration", (Object)value);
    }

    public void setServerlessV2ScalingConfiguration(@Nullable ServerlessV2ScalingConfigurationProperty value) {
        Kernel.set((Object)this, (String)"serverlessV2ScalingConfiguration", (Object)value);
    }

    @Nullable
    public String getSnapshotIdentifier() {
        return (String)Kernel.get((Object)this, (String)"snapshotIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSnapshotIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"snapshotIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceDbClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"sourceDbClusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceDbClusterIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceDbClusterIdentifier", (Object)value);
    }

    @Nullable
    public String getSourceRegion() {
        return (String)Kernel.get((Object)this, (String)"sourceRegion", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceRegion(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceRegion", (Object)value);
    }

    @Nullable
    public Object getStorageEncrypted() {
        return Kernel.get((Object)this, (String)"storageEncrypted", (NativeType)NativeType.forClass(Object.class));
    }

    public void setStorageEncrypted(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    public void setStorageEncrypted(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"storageEncrypted", (Object)value);
    }

    @Nullable
    public String getStorageType() {
        return (String)Kernel.get((Object)this, (String)"storageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setStorageType(@Nullable String value) {
        Kernel.set((Object)this, (String)"storageType", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getUseLatestRestorableTime() {
        return Kernel.get((Object)this, (String)"useLatestRestorableTime", (NativeType)NativeType.forClass(Object.class));
    }

    public void setUseLatestRestorableTime(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    public void setUseLatestRestorableTime(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"useLatestRestorableTime", (Object)value);
    }

    @Nullable
    public List<String> getVpcSecurityGroupIds() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"vpcSecurityGroupIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVpcSecurityGroupIds(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"vpcSecurityGroupIds", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DBClusterRoleProperty
    extends JsiiSerializable {
        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getFeatureName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DBClusterRoleProperty> {
            String roleArn;
            String featureName;

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder featureName(String featureName) {
                this.featureName = featureName;
                return this;
            }

            public DBClusterRoleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDBCluster> {
        private final Construct scope;
        private final String id;
        private CfnDBClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allocatedStorage(Number allocatedStorage) {
            this.props().allocatedStorage(allocatedStorage);
            return this;
        }

        public Builder associatedRoles(IResolvable associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        public Builder associatedRoles(List<? extends Object> associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder autoMinorVersionUpgrade(IResolvable autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZones(List<String> availabilityZones) {
            this.props().availabilityZones(availabilityZones);
            return this;
        }

        public Builder backtrackWindow(Number backtrackWindow) {
            this.props().backtrackWindow(backtrackWindow);
            return this;
        }

        public Builder backupRetentionPeriod(Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        public Builder clusterScalabilityType(String clusterScalabilityType) {
            this.props().clusterScalabilityType(clusterScalabilityType);
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder copyTagsToSnapshot(IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder databaseInsightsMode(String databaseInsightsMode) {
            this.props().databaseInsightsMode(databaseInsightsMode);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props().databaseName(databaseName);
            return this;
        }

        public Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        public Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.props().dbClusterInstanceClass(dbClusterInstanceClass);
            return this;
        }

        public Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.props().dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        public Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            this.props().dbInstanceParameterGroupName(dbInstanceParameterGroupName);
            return this;
        }

        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.props().dbSystemId(dbSystemId);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        public Builder deletionProtection(IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        public Builder domain(String domain) {
            this.props().domain(domain);
            return this;
        }

        public Builder domainIamRoleName(String domainIamRoleName) {
            this.props().domainIamRoleName(domainIamRoleName);
            return this;
        }

        public Builder enableCloudwatchLogsExports(List<String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        public Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.props().enableGlobalWriteForwarding(enableGlobalWriteForwarding);
            return this;
        }

        public Builder enableGlobalWriteForwarding(IResolvable enableGlobalWriteForwarding) {
            this.props().enableGlobalWriteForwarding(enableGlobalWriteForwarding);
            return this;
        }

        public Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.props().enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        public Builder enableHttpEndpoint(IResolvable enableHttpEndpoint) {
            this.props().enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(Boolean enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder enableIamDatabaseAuthentication(IResolvable enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        public Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.props().enableLocalWriteForwarding(enableLocalWriteForwarding);
            return this;
        }

        public Builder enableLocalWriteForwarding(IResolvable enableLocalWriteForwarding) {
            this.props().enableLocalWriteForwarding(enableLocalWriteForwarding);
            return this;
        }

        public Builder engine(String engine) {
            this.props().engine(engine);
            return this;
        }

        public Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.props().engineLifecycleSupport(engineLifecycleSupport);
            return this;
        }

        public Builder engineMode(String engineMode) {
            this.props().engineMode(engineMode);
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        public Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.props().globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        public Builder iops(Number iops) {
            this.props().iops(iops);
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        public Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }

        public Builder manageMasterUserPassword(IResolvable manageMasterUserPassword) {
            this.props().manageMasterUserPassword(manageMasterUserPassword);
            return this;
        }

        public Builder masterUsername(String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        public Builder masterUserPassword(String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        public Builder masterUserSecret(IResolvable masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }

        public Builder masterUserSecret(MasterUserSecretProperty masterUserSecret) {
            this.props().masterUserSecret(masterUserSecret);
            return this;
        }

        public Builder monitoringInterval(Number monitoringInterval) {
            this.props().monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRoleArn(String monitoringRoleArn) {
            this.props().monitoringRoleArn(monitoringRoleArn);
            return this;
        }

        public Builder networkType(String networkType) {
            this.props().networkType(networkType);
            return this;
        }

        public Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.props().performanceInsightsEnabled(performanceInsightsEnabled);
            return this;
        }

        public Builder performanceInsightsEnabled(IResolvable performanceInsightsEnabled) {
            this.props().performanceInsightsEnabled(performanceInsightsEnabled);
            return this;
        }

        public Builder performanceInsightsKmsKeyId(String performanceInsightsKmsKeyId) {
            this.props().performanceInsightsKmsKeyId(performanceInsightsKmsKeyId);
            return this;
        }

        public Builder performanceInsightsRetentionPeriod(Number performanceInsightsRetentionPeriod) {
            this.props().performanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
            return this;
        }

        public Builder port(Number port) {
            this.props().port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder publiclyAccessible(IResolvable publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.props().replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        public Builder restoreToTime(String restoreToTime) {
            this.props().restoreToTime(restoreToTime);
            return this;
        }

        public Builder restoreType(String restoreType) {
            this.props().restoreType(restoreType);
            return this;
        }

        public Builder scalingConfiguration(IResolvable scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder scalingConfiguration(ScalingConfigurationProperty scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder serverlessV2ScalingConfiguration(IResolvable serverlessV2ScalingConfiguration) {
            this.props().serverlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
            return this;
        }

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationProperty serverlessV2ScalingConfiguration) {
            this.props().serverlessV2ScalingConfiguration(serverlessV2ScalingConfiguration);
            return this;
        }

        public Builder snapshotIdentifier(String snapshotIdentifier) {
            this.props().snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        public Builder sourceDbClusterIdentifier(String sourceDbClusterIdentifier) {
            this.props().sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        public Builder sourceRegion(String sourceRegion) {
            this.props().sourceRegion(sourceRegion);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncrypted(IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageType(String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder useLatestRestorableTime(IResolvable useLatestRestorableTime) {
            this.props().useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            this.props().vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        public CfnDBCluster build() {
            return new CfnDBCluster(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnDBClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnDBClusterProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServerlessV2ScalingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxCapacity() {
            return null;
        }

        @Nullable
        default public Number getMinCapacity() {
            return null;
        }

        @Nullable
        default public Number getSecondsUntilAutoPause() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServerlessV2ScalingConfigurationProperty> {
            Number maxCapacity;
            Number minCapacity;
            Number secondsUntilAutoPause;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public Builder secondsUntilAutoPause(Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            public ServerlessV2ScalingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoPause() {
            return null;
        }

        @Nullable
        default public Number getMaxCapacity() {
            return null;
        }

        @Nullable
        default public Number getMinCapacity() {
            return null;
        }

        @Nullable
        default public Number getSecondsBeforeTimeout() {
            return null;
        }

        @Nullable
        default public Number getSecondsUntilAutoPause() {
            return null;
        }

        @Nullable
        default public String getTimeoutAction() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConfigurationProperty> {
            Object autoPause;
            Number maxCapacity;
            Number minCapacity;
            Number secondsBeforeTimeout;
            Number secondsUntilAutoPause;
            String timeoutAction;

            public Builder autoPause(Boolean autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            public Builder autoPause(IResolvable autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder minCapacity(Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            public Builder secondsBeforeTimeout(Number secondsBeforeTimeout) {
                this.secondsBeforeTimeout = secondsBeforeTimeout;
                return this;
            }

            public Builder secondsUntilAutoPause(Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            public Builder timeoutAction(String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            public ScalingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.ReadEndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReadEndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReadEndpointProperty> {
            String address;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public ReadEndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.MasterUserSecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MasterUserSecretProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MasterUserSecretProperty> {
            String kmsKeyId;
            String secretArn;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public MasterUserSecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.CfnDBCluster.EndpointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAddress() {
            return null;
        }

        @Nullable
        default public String getPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointProperty> {
            String address;
            String port;

            public Builder address(String address) {
                this.address = address;
                return this;
            }

            public Builder port(String port) {
                this.port = port;
                return this;
            }

            public EndpointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

