/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnModelPackage;
import software.amazon.awscdk.services.sagemaker.CfnModelPackageProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage")
public class CfnModelPackage
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnModelPackage.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnModelPackage(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnModelPackage(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnModelPackage(@NotNull Construct scope, @NotNull String id, @Nullable CfnModelPackageProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnModelPackage(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModelPackageArn() {
        return (String)Kernel.get((Object)this, (String)"attrModelPackageArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrModelPackageStatus() {
        return (String)Kernel.get((Object)this, (String)"attrModelPackageStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Nullable
    public Object getAdditionalInferenceSpecifications() {
        return Kernel.get((Object)this, (String)"additionalInferenceSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdditionalInferenceSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"additionalInferenceSpecifications", (Object)value);
    }

    public void setAdditionalInferenceSpecifications(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AdditionalInferenceSpecificationDefinitionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"additionalInferenceSpecifications", value);
    }

    @Nullable
    public Object getAdditionalInferenceSpecificationsToAdd() {
        return Kernel.get((Object)this, (String)"additionalInferenceSpecificationsToAdd", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAdditionalInferenceSpecificationsToAdd(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"additionalInferenceSpecificationsToAdd", (Object)value);
    }

    public void setAdditionalInferenceSpecificationsToAdd(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AdditionalInferenceSpecificationDefinitionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"additionalInferenceSpecificationsToAdd", value);
    }

    @Nullable
    public String getApprovalDescription() {
        return (String)Kernel.get((Object)this, (String)"approvalDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setApprovalDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"approvalDescription", (Object)value);
    }

    @Nullable
    public Object getCertifyForMarketplace() {
        return Kernel.get((Object)this, (String)"certifyForMarketplace", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCertifyForMarketplace(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"certifyForMarketplace", (Object)value);
    }

    public void setCertifyForMarketplace(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"certifyForMarketplace", (Object)value);
    }

    @Nullable
    public String getClientToken() {
        return (String)Kernel.get((Object)this, (String)"clientToken", (NativeType)NativeType.forClass(String.class));
    }

    public void setClientToken(@Nullable String value) {
        Kernel.set((Object)this, (String)"clientToken", (Object)value);
    }

    @Nullable
    public Object getCustomerMetadataProperties() {
        return Kernel.get((Object)this, (String)"customerMetadataProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCustomerMetadataProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"customerMetadataProperties", (Object)value);
    }

    public void setCustomerMetadataProperties(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"customerMetadataProperties", value);
    }

    @Nullable
    public String getDomain() {
        return (String)Kernel.get((Object)this, (String)"domain", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomain(@Nullable String value) {
        Kernel.set((Object)this, (String)"domain", (Object)value);
    }

    @Nullable
    public Object getDriftCheckBaselines() {
        return Kernel.get((Object)this, (String)"driftCheckBaselines", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDriftCheckBaselines(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"driftCheckBaselines", (Object)value);
    }

    public void setDriftCheckBaselines(@Nullable DriftCheckBaselinesProperty value) {
        Kernel.set((Object)this, (String)"driftCheckBaselines", (Object)value);
    }

    @Nullable
    public Object getInferenceSpecification() {
        return Kernel.get((Object)this, (String)"inferenceSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInferenceSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"inferenceSpecification", (Object)value);
    }

    public void setInferenceSpecification(@Nullable InferenceSpecificationProperty value) {
        Kernel.set((Object)this, (String)"inferenceSpecification", (Object)value);
    }

    @Nullable
    public String getLastModifiedTime() {
        return (String)Kernel.get((Object)this, (String)"lastModifiedTime", (NativeType)NativeType.forClass(String.class));
    }

    public void setLastModifiedTime(@Nullable String value) {
        Kernel.set((Object)this, (String)"lastModifiedTime", (Object)value);
    }

    @Nullable
    public Object getMetadataProperties() {
        return Kernel.get((Object)this, (String)"metadataProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMetadataProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"metadataProperties", (Object)value);
    }

    public void setMetadataProperties(@Nullable MetadataPropertiesProperty value) {
        Kernel.set((Object)this, (String)"metadataProperties", (Object)value);
    }

    @Nullable
    public String getModelApprovalStatus() {
        return (String)Kernel.get((Object)this, (String)"modelApprovalStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelApprovalStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"modelApprovalStatus", (Object)value);
    }

    @Nullable
    public Object getModelCard() {
        return Kernel.get((Object)this, (String)"modelCard", (NativeType)NativeType.forClass(Object.class));
    }

    public void setModelCard(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"modelCard", (Object)value);
    }

    public void setModelCard(@Nullable ModelCardProperty value) {
        Kernel.set((Object)this, (String)"modelCard", (Object)value);
    }

    @Nullable
    public Object getModelMetrics() {
        return Kernel.get((Object)this, (String)"modelMetrics", (NativeType)NativeType.forClass(Object.class));
    }

    public void setModelMetrics(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"modelMetrics", (Object)value);
    }

    public void setModelMetrics(@Nullable ModelMetricsProperty value) {
        Kernel.set((Object)this, (String)"modelMetrics", (Object)value);
    }

    @Nullable
    public String getModelPackageDescription() {
        return (String)Kernel.get((Object)this, (String)"modelPackageDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelPackageDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"modelPackageDescription", (Object)value);
    }

    @Nullable
    public String getModelPackageGroupName() {
        return (String)Kernel.get((Object)this, (String)"modelPackageGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelPackageGroupName(@Nullable String value) {
        Kernel.set((Object)this, (String)"modelPackageGroupName", (Object)value);
    }

    @Nullable
    public String getModelPackageName() {
        return (String)Kernel.get((Object)this, (String)"modelPackageName", (NativeType)NativeType.forClass(String.class));
    }

    public void setModelPackageName(@Nullable String value) {
        Kernel.set((Object)this, (String)"modelPackageName", (Object)value);
    }

    @Nullable
    public Object getModelPackageStatusDetails() {
        return Kernel.get((Object)this, (String)"modelPackageStatusDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setModelPackageStatusDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"modelPackageStatusDetails", (Object)value);
    }

    public void setModelPackageStatusDetails(@Nullable ModelPackageStatusDetailsProperty value) {
        Kernel.set((Object)this, (String)"modelPackageStatusDetails", (Object)value);
    }

    @Nullable
    public Number getModelPackageVersion() {
        return (Number)Kernel.get((Object)this, (String)"modelPackageVersion", (NativeType)NativeType.forClass(Number.class));
    }

    public void setModelPackageVersion(@Nullable Number value) {
        Kernel.set((Object)this, (String)"modelPackageVersion", (Object)value);
    }

    @Nullable
    public String getSamplePayloadUrl() {
        return (String)Kernel.get((Object)this, (String)"samplePayloadUrl", (NativeType)NativeType.forClass(String.class));
    }

    public void setSamplePayloadUrl(@Nullable String value) {
        Kernel.set((Object)this, (String)"samplePayloadUrl", (Object)value);
    }

    @Nullable
    public Object getSecurityConfig() {
        return Kernel.get((Object)this, (String)"securityConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSecurityConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"securityConfig", (Object)value);
    }

    public void setSecurityConfig(@Nullable SecurityConfigProperty value) {
        Kernel.set((Object)this, (String)"securityConfig", (Object)value);
    }

    @Nullable
    public String getSkipModelValidation() {
        return (String)Kernel.get((Object)this, (String)"skipModelValidation", (NativeType)NativeType.forClass(String.class));
    }

    public void setSkipModelValidation(@Nullable String value) {
        Kernel.set((Object)this, (String)"skipModelValidation", (Object)value);
    }

    @Nullable
    public Object getSourceAlgorithmSpecification() {
        return Kernel.get((Object)this, (String)"sourceAlgorithmSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceAlgorithmSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sourceAlgorithmSpecification", (Object)value);
    }

    public void setSourceAlgorithmSpecification(@Nullable SourceAlgorithmSpecificationProperty value) {
        Kernel.set((Object)this, (String)"sourceAlgorithmSpecification", (Object)value);
    }

    @Nullable
    public String getSourceUri() {
        return (String)Kernel.get((Object)this, (String)"sourceUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setSourceUri(@Nullable String value) {
        Kernel.set((Object)this, (String)"sourceUri", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public String getTask() {
        return (String)Kernel.get((Object)this, (String)"task", (NativeType)NativeType.forClass(String.class));
    }

    public void setTask(@Nullable String value) {
        Kernel.set((Object)this, (String)"task", (Object)value);
    }

    @Nullable
    public Object getValidationSpecification() {
        return Kernel.get((Object)this, (String)"validationSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setValidationSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"validationSpecification", (Object)value);
    }

    public void setValidationSpecification(@Nullable ValidationSpecificationProperty value) {
        Kernel.set((Object)this, (String)"validationSpecification", (Object)value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.AdditionalInferenceSpecificationDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AdditionalInferenceSpecificationDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContainers();

        @NotNull
        public String getName();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public List<String> getSupportedContentTypes() {
            return null;
        }

        @Nullable
        default public List<String> getSupportedRealtimeInferenceInstanceTypes() {
            return null;
        }

        @Nullable
        default public List<String> getSupportedResponseMimeTypes() {
            return null;
        }

        @Nullable
        default public List<String> getSupportedTransformInstanceTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AdditionalInferenceSpecificationDefinitionProperty> {
            Object containers;
            String name;
            String description;
            List<String> supportedContentTypes;
            List<String> supportedRealtimeInferenceInstanceTypes;
            List<String> supportedResponseMimeTypes;
            List<String> supportedTransformInstanceTypes;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder supportedContentTypes(List<String> supportedContentTypes) {
                this.supportedContentTypes = supportedContentTypes;
                return this;
            }

            public Builder supportedRealtimeInferenceInstanceTypes(List<String> supportedRealtimeInferenceInstanceTypes) {
                this.supportedRealtimeInferenceInstanceTypes = supportedRealtimeInferenceInstanceTypes;
                return this;
            }

            public Builder supportedResponseMimeTypes(List<String> supportedResponseMimeTypes) {
                this.supportedResponseMimeTypes = supportedResponseMimeTypes;
                return this;
            }

            public Builder supportedTransformInstanceTypes(List<String> supportedTransformInstanceTypes) {
                this.supportedTransformInstanceTypes = supportedTransformInstanceTypes;
                return this;
            }

            public AdditionalInferenceSpecificationDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnModelPackage> {
        private final Construct scope;
        private final String id;
        private CfnModelPackageProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder additionalInferenceSpecifications(IResolvable additionalInferenceSpecifications) {
            this.props().additionalInferenceSpecifications(additionalInferenceSpecifications);
            return this;
        }

        public Builder additionalInferenceSpecifications(List<? extends Object> additionalInferenceSpecifications) {
            this.props().additionalInferenceSpecifications(additionalInferenceSpecifications);
            return this;
        }

        public Builder additionalInferenceSpecificationsToAdd(IResolvable additionalInferenceSpecificationsToAdd) {
            this.props().additionalInferenceSpecificationsToAdd(additionalInferenceSpecificationsToAdd);
            return this;
        }

        public Builder additionalInferenceSpecificationsToAdd(List<? extends Object> additionalInferenceSpecificationsToAdd) {
            this.props().additionalInferenceSpecificationsToAdd(additionalInferenceSpecificationsToAdd);
            return this;
        }

        public Builder approvalDescription(String approvalDescription) {
            this.props().approvalDescription(approvalDescription);
            return this;
        }

        public Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.props().certifyForMarketplace(certifyForMarketplace);
            return this;
        }

        public Builder certifyForMarketplace(IResolvable certifyForMarketplace) {
            this.props().certifyForMarketplace(certifyForMarketplace);
            return this;
        }

        public Builder clientToken(String clientToken) {
            this.props().clientToken(clientToken);
            return this;
        }

        public Builder customerMetadataProperties(IResolvable customerMetadataProperties) {
            this.props().customerMetadataProperties(customerMetadataProperties);
            return this;
        }

        public Builder customerMetadataProperties(Map<String, String> customerMetadataProperties) {
            this.props().customerMetadataProperties(customerMetadataProperties);
            return this;
        }

        public Builder domain(String domain) {
            this.props().domain(domain);
            return this;
        }

        public Builder driftCheckBaselines(IResolvable driftCheckBaselines) {
            this.props().driftCheckBaselines(driftCheckBaselines);
            return this;
        }

        public Builder driftCheckBaselines(DriftCheckBaselinesProperty driftCheckBaselines) {
            this.props().driftCheckBaselines(driftCheckBaselines);
            return this;
        }

        public Builder inferenceSpecification(IResolvable inferenceSpecification) {
            this.props().inferenceSpecification(inferenceSpecification);
            return this;
        }

        public Builder inferenceSpecification(InferenceSpecificationProperty inferenceSpecification) {
            this.props().inferenceSpecification(inferenceSpecification);
            return this;
        }

        public Builder lastModifiedTime(String lastModifiedTime) {
            this.props().lastModifiedTime(lastModifiedTime);
            return this;
        }

        public Builder metadataProperties(IResolvable metadataProperties) {
            this.props().metadataProperties(metadataProperties);
            return this;
        }

        public Builder metadataProperties(MetadataPropertiesProperty metadataProperties) {
            this.props().metadataProperties(metadataProperties);
            return this;
        }

        public Builder modelApprovalStatus(String modelApprovalStatus) {
            this.props().modelApprovalStatus(modelApprovalStatus);
            return this;
        }

        public Builder modelCard(IResolvable modelCard) {
            this.props().modelCard(modelCard);
            return this;
        }

        public Builder modelCard(ModelCardProperty modelCard) {
            this.props().modelCard(modelCard);
            return this;
        }

        public Builder modelMetrics(IResolvable modelMetrics) {
            this.props().modelMetrics(modelMetrics);
            return this;
        }

        public Builder modelMetrics(ModelMetricsProperty modelMetrics) {
            this.props().modelMetrics(modelMetrics);
            return this;
        }

        public Builder modelPackageDescription(String modelPackageDescription) {
            this.props().modelPackageDescription(modelPackageDescription);
            return this;
        }

        public Builder modelPackageGroupName(String modelPackageGroupName) {
            this.props().modelPackageGroupName(modelPackageGroupName);
            return this;
        }

        public Builder modelPackageName(String modelPackageName) {
            this.props().modelPackageName(modelPackageName);
            return this;
        }

        public Builder modelPackageStatusDetails(IResolvable modelPackageStatusDetails) {
            this.props().modelPackageStatusDetails(modelPackageStatusDetails);
            return this;
        }

        public Builder modelPackageStatusDetails(ModelPackageStatusDetailsProperty modelPackageStatusDetails) {
            this.props().modelPackageStatusDetails(modelPackageStatusDetails);
            return this;
        }

        public Builder modelPackageVersion(Number modelPackageVersion) {
            this.props().modelPackageVersion(modelPackageVersion);
            return this;
        }

        public Builder samplePayloadUrl(String samplePayloadUrl) {
            this.props().samplePayloadUrl(samplePayloadUrl);
            return this;
        }

        public Builder securityConfig(IResolvable securityConfig) {
            this.props().securityConfig(securityConfig);
            return this;
        }

        public Builder securityConfig(SecurityConfigProperty securityConfig) {
            this.props().securityConfig(securityConfig);
            return this;
        }

        public Builder skipModelValidation(String skipModelValidation) {
            this.props().skipModelValidation(skipModelValidation);
            return this;
        }

        public Builder sourceAlgorithmSpecification(IResolvable sourceAlgorithmSpecification) {
            this.props().sourceAlgorithmSpecification(sourceAlgorithmSpecification);
            return this;
        }

        public Builder sourceAlgorithmSpecification(SourceAlgorithmSpecificationProperty sourceAlgorithmSpecification) {
            this.props().sourceAlgorithmSpecification(sourceAlgorithmSpecification);
            return this;
        }

        public Builder sourceUri(String sourceUri) {
            this.props().sourceUri(sourceUri);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder task(String task) {
            this.props().task(task);
            return this;
        }

        public Builder validationSpecification(IResolvable validationSpecification) {
            this.props().validationSpecification(validationSpecification);
            return this;
        }

        public Builder validationSpecification(ValidationSpecificationProperty validationSpecification) {
            this.props().validationSpecification(validationSpecification);
            return this;
        }

        public CfnModelPackage build() {
            return new CfnModelPackage(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnModelPackageProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnModelPackageProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ValidationSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ValidationSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getValidationProfiles();

        @NotNull
        public String getValidationRole();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ValidationSpecificationProperty> {
            Object validationProfiles;
            String validationRole;

            public Builder validationProfiles(IResolvable validationProfiles) {
                this.validationProfiles = validationProfiles;
                return this;
            }

            public Builder validationProfiles(List<? extends Object> validationProfiles) {
                this.validationProfiles = validationProfiles;
                return this;
            }

            public Builder validationRole(String validationRole) {
                this.validationRole = validationRole;
                return this;
            }

            public ValidationSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ValidationProfileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ValidationProfileProperty
    extends JsiiSerializable {
        @NotNull
        public String getProfileName();

        @NotNull
        public Object getTransformJobDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ValidationProfileProperty> {
            String profileName;
            Object transformJobDefinition;

            public Builder profileName(String profileName) {
                this.profileName = profileName;
                return this;
            }

            public Builder transformJobDefinition(IResolvable transformJobDefinition) {
                this.transformJobDefinition = transformJobDefinition;
                return this;
            }

            public Builder transformJobDefinition(TransformJobDefinitionProperty transformJobDefinition) {
                this.transformJobDefinition = transformJobDefinition;
                return this;
            }

            public ValidationProfileProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.TransformResourcesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformResourcesProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public String getInstanceType();

        @Nullable
        default public String getVolumeKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformResourcesProperty> {
            Number instanceCount;
            String instanceType;
            String volumeKmsKeyId;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder volumeKmsKeyId(String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            public TransformResourcesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.TransformOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3OutputPath();

        @Nullable
        default public String getAccept() {
            return null;
        }

        @Nullable
        default public String getAssembleWith() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformOutputProperty> {
            String s3OutputPath;
            String accept;
            String assembleWith;
            String kmsKeyId;

            public Builder s3OutputPath(String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            public Builder accept(String accept) {
                this.accept = accept;
                return this;
            }

            public Builder assembleWith(String assembleWith) {
                this.assembleWith = assembleWith;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public TransformOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.TransformJobDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformJobDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTransformInput();

        @NotNull
        public Object getTransformOutput();

        @NotNull
        public Object getTransformResources();

        @Nullable
        default public String getBatchStrategy() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Number getMaxConcurrentTransforms() {
            return null;
        }

        @Nullable
        default public Number getMaxPayloadInMb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformJobDefinitionProperty> {
            Object transformInput;
            Object transformOutput;
            Object transformResources;
            String batchStrategy;
            Object environment;
            Number maxConcurrentTransforms;
            Number maxPayloadInMb;

            public Builder transformInput(IResolvable transformInput) {
                this.transformInput = transformInput;
                return this;
            }

            public Builder transformInput(TransformInputProperty transformInput) {
                this.transformInput = transformInput;
                return this;
            }

            public Builder transformOutput(IResolvable transformOutput) {
                this.transformOutput = transformOutput;
                return this;
            }

            public Builder transformOutput(TransformOutputProperty transformOutput) {
                this.transformOutput = transformOutput;
                return this;
            }

            public Builder transformResources(IResolvable transformResources) {
                this.transformResources = transformResources;
                return this;
            }

            public Builder transformResources(TransformResourcesProperty transformResources) {
                this.transformResources = transformResources;
                return this;
            }

            public Builder batchStrategy(String batchStrategy) {
                this.batchStrategy = batchStrategy;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(Map<String, String> environment) {
                this.environment = environment;
                return this;
            }

            public Builder maxConcurrentTransforms(Number maxConcurrentTransforms) {
                this.maxConcurrentTransforms = maxConcurrentTransforms;
                return this;
            }

            public Builder maxPayloadInMb(Number maxPayloadInMb) {
                this.maxPayloadInMb = maxPayloadInMb;
                return this;
            }

            public TransformJobDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.TransformInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransformInputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDataSource();

        @Nullable
        default public String getCompressionType() {
            return null;
        }

        @Nullable
        default public String getContentType() {
            return null;
        }

        @Nullable
        default public String getSplitType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransformInputProperty> {
            Object dataSource;
            String compressionType;
            String contentType;
            String splitType;

            public Builder dataSource(IResolvable dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            public Builder dataSource(DataSourceProperty dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            public Builder compressionType(String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder splitType(String splitType) {
                this.splitType = splitType;
                return this;
            }

            public TransformInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.SourceAlgorithmSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceAlgorithmSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceAlgorithms();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceAlgorithmSpecificationProperty> {
            Object sourceAlgorithms;

            public Builder sourceAlgorithms(IResolvable sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            public Builder sourceAlgorithms(List<? extends Object> sourceAlgorithms) {
                this.sourceAlgorithms = sourceAlgorithms;
                return this;
            }

            public SourceAlgorithmSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.SourceAlgorithmProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceAlgorithmProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlgorithmName();

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceAlgorithmProperty> {
            String algorithmName;
            String modelDataUrl;

            public Builder algorithmName(String algorithmName) {
                this.algorithmName = algorithmName;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public SourceAlgorithmProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.SecurityConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecurityConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getKmsKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecurityConfigProperty> {
            String kmsKeyId;

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public SecurityConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.S3ModelDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ModelDataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getCompressionType();

        @NotNull
        public String getS3DataType();

        @NotNull
        public String getS3Uri();

        @Nullable
        default public Object getModelAccessConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ModelDataSourceProperty> {
            String compressionType;
            String s3DataType;
            String s3Uri;
            Object modelAccessConfig;

            public Builder compressionType(String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            public Builder s3DataType(String s3DataType) {
                this.s3DataType = s3DataType;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder modelAccessConfig(IResolvable modelAccessConfig) {
                this.modelAccessConfig = modelAccessConfig;
                return this;
            }

            public Builder modelAccessConfig(ModelAccessConfigProperty modelAccessConfig) {
                this.modelAccessConfig = modelAccessConfig;
                return this;
            }

            public S3ModelDataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.S3DataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3DataType();

        @NotNull
        public String getS3Uri();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceProperty> {
            String s3DataType;
            String s3Uri;

            public Builder s3DataType(String s3DataType) {
                this.s3DataType = s3DataType;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public S3DataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelQualityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelQualityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraints() {
            return null;
        }

        @Nullable
        default public Object getStatistics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelQualityProperty> {
            Object constraints;
            Object statistics;

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder statistics(IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder statistics(MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            public ModelQualityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelPackageStatusItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelPackageStatusItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getStatus();

        @Nullable
        default public String getFailureReason() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelPackageStatusItemProperty> {
            String name;
            String status;
            String failureReason;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder failureReason(String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            public ModelPackageStatusItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelPackageStatusDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelPackageStatusDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getValidationStatuses() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelPackageStatusDetailsProperty> {
            Object validationStatuses;

            public Builder validationStatuses(IResolvable validationStatuses) {
                this.validationStatuses = validationStatuses;
                return this;
            }

            public Builder validationStatuses(List<? extends Object> validationStatuses) {
                this.validationStatuses = validationStatuses;
                return this;
            }

            public ModelPackageStatusDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelPackageContainerDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelPackageContainerDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public String getContainerHostname() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getFramework() {
            return null;
        }

        @Nullable
        default public String getFrameworkVersion() {
            return null;
        }

        @Nullable
        default public String getImageDigest() {
            return null;
        }

        @Nullable
        default public Object getModelDataSource() {
            return null;
        }

        @Nullable
        default public String getModelDataUrl() {
            return null;
        }

        @Nullable
        default public Object getModelInput() {
            return null;
        }

        @Nullable
        default public String getNearestModelName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelPackageContainerDefinitionProperty> {
            String image;
            String containerHostname;
            Object environment;
            String framework;
            String frameworkVersion;
            String imageDigest;
            Object modelDataSource;
            String modelDataUrl;
            Object modelInput;
            String nearestModelName;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder containerHostname(String containerHostname) {
                this.containerHostname = containerHostname;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(Map<String, String> environment) {
                this.environment = environment;
                return this;
            }

            public Builder framework(String framework) {
                this.framework = framework;
                return this;
            }

            public Builder frameworkVersion(String frameworkVersion) {
                this.frameworkVersion = frameworkVersion;
                return this;
            }

            public Builder imageDigest(String imageDigest) {
                this.imageDigest = imageDigest;
                return this;
            }

            public Builder modelDataSource(IResolvable modelDataSource) {
                this.modelDataSource = modelDataSource;
                return this;
            }

            public Builder modelDataSource(ModelDataSourceProperty modelDataSource) {
                this.modelDataSource = modelDataSource;
                return this;
            }

            public Builder modelDataUrl(String modelDataUrl) {
                this.modelDataUrl = modelDataUrl;
                return this;
            }

            public Builder modelInput(Object modelInput) {
                this.modelInput = modelInput;
                return this;
            }

            public Builder nearestModelName(String nearestModelName) {
                this.nearestModelName = nearestModelName;
                return this;
            }

            public ModelPackageContainerDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelMetricsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelMetricsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBias() {
            return null;
        }

        @Nullable
        default public Object getExplainability() {
            return null;
        }

        @Nullable
        default public Object getModelDataQuality() {
            return null;
        }

        @Nullable
        default public Object getModelQuality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelMetricsProperty> {
            Object bias;
            Object explainability;
            Object modelDataQuality;
            Object modelQuality;

            public Builder bias(IResolvable bias) {
                this.bias = bias;
                return this;
            }

            public Builder bias(BiasProperty bias) {
                this.bias = bias;
                return this;
            }

            public Builder explainability(IResolvable explainability) {
                this.explainability = explainability;
                return this;
            }

            public Builder explainability(ExplainabilityProperty explainability) {
                this.explainability = explainability;
                return this;
            }

            public Builder modelDataQuality(IResolvable modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            public Builder modelDataQuality(ModelDataQualityProperty modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            public Builder modelQuality(IResolvable modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            public Builder modelQuality(ModelQualityProperty modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            public ModelMetricsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataInputConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelInputProperty> {
            String dataInputConfig;

            public Builder dataInputConfig(String dataInputConfig) {
                this.dataInputConfig = dataInputConfig;
                return this;
            }

            public ModelInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelDataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelDataSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3DataSource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelDataSourceProperty> {
            Object s3DataSource;

            public Builder s3DataSource(IResolvable s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            public Builder s3DataSource(S3ModelDataSourceProperty s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            public ModelDataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelDataQualityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelDataQualityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraints() {
            return null;
        }

        @Nullable
        default public Object getStatistics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelDataQualityProperty> {
            Object constraints;
            Object statistics;

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder statistics(IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder statistics(MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            public ModelDataQualityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelCardProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelCardProperty
    extends JsiiSerializable {
        @NotNull
        public String getModelCardContent();

        @NotNull
        public String getModelCardStatus();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelCardProperty> {
            String modelCardContent;
            String modelCardStatus;

            public Builder modelCardContent(String modelCardContent) {
                this.modelCardContent = modelCardContent;
                return this;
            }

            public Builder modelCardStatus(String modelCardStatus) {
                this.modelCardStatus = modelCardStatus;
                return this;
            }

            public ModelCardProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ModelAccessConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ModelAccessConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAcceptEula();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ModelAccessConfigProperty> {
            Object acceptEula;

            public Builder acceptEula(Boolean acceptEula) {
                this.acceptEula = acceptEula;
                return this;
            }

            public Builder acceptEula(IResolvable acceptEula) {
                this.acceptEula = acceptEula;
                return this;
            }

            public ModelAccessConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.MetricsSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetricsSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getContentType();

        @NotNull
        public String getS3Uri();

        @Nullable
        default public String getContentDigest() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetricsSourceProperty> {
            String contentType;
            String s3Uri;
            String contentDigest;

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder contentDigest(String contentDigest) {
                this.contentDigest = contentDigest;
                return this;
            }

            public MetricsSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.MetadataPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCommitId() {
            return null;
        }

        @Nullable
        default public String getGeneratedBy() {
            return null;
        }

        @Nullable
        default public String getProjectId() {
            return null;
        }

        @Nullable
        default public String getRepository() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataPropertiesProperty> {
            String commitId;
            String generatedBy;
            String projectId;
            String repository;

            public Builder commitId(String commitId) {
                this.commitId = commitId;
                return this;
            }

            public Builder generatedBy(String generatedBy) {
                this.generatedBy = generatedBy;
                return this;
            }

            public Builder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Builder repository(String repository) {
                this.repository = repository;
                return this;
            }

            public MetadataPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.InferenceSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InferenceSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContainers();

        @NotNull
        public List<String> getSupportedContentTypes();

        @NotNull
        public List<String> getSupportedResponseMimeTypes();

        @Nullable
        default public List<String> getSupportedRealtimeInferenceInstanceTypes() {
            return null;
        }

        @Nullable
        default public List<String> getSupportedTransformInstanceTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InferenceSpecificationProperty> {
            Object containers;
            List<String> supportedContentTypes;
            List<String> supportedResponseMimeTypes;
            List<String> supportedRealtimeInferenceInstanceTypes;
            List<String> supportedTransformInstanceTypes;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder supportedContentTypes(List<String> supportedContentTypes) {
                this.supportedContentTypes = supportedContentTypes;
                return this;
            }

            public Builder supportedResponseMimeTypes(List<String> supportedResponseMimeTypes) {
                this.supportedResponseMimeTypes = supportedResponseMimeTypes;
                return this;
            }

            public Builder supportedRealtimeInferenceInstanceTypes(List<String> supportedRealtimeInferenceInstanceTypes) {
                this.supportedRealtimeInferenceInstanceTypes = supportedRealtimeInferenceInstanceTypes;
                return this;
            }

            public Builder supportedTransformInstanceTypes(List<String> supportedTransformInstanceTypes) {
                this.supportedTransformInstanceTypes = supportedTransformInstanceTypes;
                return this;
            }

            public InferenceSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.FileSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FileSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3Uri();

        @Nullable
        default public String getContentDigest() {
            return null;
        }

        @Nullable
        default public String getContentType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FileSourceProperty> {
            String s3Uri;
            String contentDigest;
            String contentType;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder contentDigest(String contentDigest) {
                this.contentDigest = contentDigest;
                return this;
            }

            public Builder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            public FileSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.ExplainabilityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExplainabilityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getReport() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExplainabilityProperty> {
            Object report;

            public Builder report(IResolvable report) {
                this.report = report;
                return this;
            }

            public Builder report(MetricsSourceProperty report) {
                this.report = report;
                return this;
            }

            public ExplainabilityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DriftCheckModelQualityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DriftCheckModelQualityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraints() {
            return null;
        }

        @Nullable
        default public Object getStatistics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DriftCheckModelQualityProperty> {
            Object constraints;
            Object statistics;

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder statistics(IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder statistics(MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            public DriftCheckModelQualityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DriftCheckModelDataQualityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DriftCheckModelDataQualityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraints() {
            return null;
        }

        @Nullable
        default public Object getStatistics() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DriftCheckModelDataQualityProperty> {
            Object constraints;
            Object statistics;

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder statistics(IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            public Builder statistics(MetricsSourceProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            public DriftCheckModelDataQualityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DriftCheckExplainabilityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DriftCheckExplainabilityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigFile() {
            return null;
        }

        @Nullable
        default public Object getConstraints() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DriftCheckExplainabilityProperty> {
            Object configFile;
            Object constraints;

            public Builder configFile(IResolvable configFile) {
                this.configFile = configFile;
                return this;
            }

            public Builder configFile(FileSourceProperty configFile) {
                this.configFile = configFile;
                return this;
            }

            public Builder constraints(IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            public Builder constraints(MetricsSourceProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            public DriftCheckExplainabilityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DriftCheckBiasProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DriftCheckBiasProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigFile() {
            return null;
        }

        @Nullable
        default public Object getPostTrainingConstraints() {
            return null;
        }

        @Nullable
        default public Object getPreTrainingConstraints() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DriftCheckBiasProperty> {
            Object configFile;
            Object postTrainingConstraints;
            Object preTrainingConstraints;

            public Builder configFile(IResolvable configFile) {
                this.configFile = configFile;
                return this;
            }

            public Builder configFile(FileSourceProperty configFile) {
                this.configFile = configFile;
                return this;
            }

            public Builder postTrainingConstraints(IResolvable postTrainingConstraints) {
                this.postTrainingConstraints = postTrainingConstraints;
                return this;
            }

            public Builder postTrainingConstraints(MetricsSourceProperty postTrainingConstraints) {
                this.postTrainingConstraints = postTrainingConstraints;
                return this;
            }

            public Builder preTrainingConstraints(IResolvable preTrainingConstraints) {
                this.preTrainingConstraints = preTrainingConstraints;
                return this;
            }

            public Builder preTrainingConstraints(MetricsSourceProperty preTrainingConstraints) {
                this.preTrainingConstraints = preTrainingConstraints;
                return this;
            }

            public DriftCheckBiasProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DriftCheckBaselinesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DriftCheckBaselinesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBias() {
            return null;
        }

        @Nullable
        default public Object getExplainability() {
            return null;
        }

        @Nullable
        default public Object getModelDataQuality() {
            return null;
        }

        @Nullable
        default public Object getModelQuality() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DriftCheckBaselinesProperty> {
            Object bias;
            Object explainability;
            Object modelDataQuality;
            Object modelQuality;

            public Builder bias(IResolvable bias) {
                this.bias = bias;
                return this;
            }

            public Builder bias(DriftCheckBiasProperty bias) {
                this.bias = bias;
                return this;
            }

            public Builder explainability(IResolvable explainability) {
                this.explainability = explainability;
                return this;
            }

            public Builder explainability(DriftCheckExplainabilityProperty explainability) {
                this.explainability = explainability;
                return this;
            }

            public Builder modelDataQuality(IResolvable modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            public Builder modelDataQuality(DriftCheckModelDataQualityProperty modelDataQuality) {
                this.modelDataQuality = modelDataQuality;
                return this;
            }

            public Builder modelQuality(IResolvable modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            public Builder modelQuality(DriftCheckModelQualityProperty modelQuality) {
                this.modelQuality = modelQuality;
                return this;
            }

            public DriftCheckBaselinesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.DataSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3DataSource();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceProperty> {
            Object s3DataSource;

            public Builder s3DataSource(IResolvable s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            public Builder s3DataSource(S3DataSourceProperty s3DataSource) {
                this.s3DataSource = s3DataSource;
                return this;
            }

            public DataSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnModelPackage.BiasProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BiasProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPostTrainingReport() {
            return null;
        }

        @Nullable
        default public Object getPreTrainingReport() {
            return null;
        }

        @Nullable
        default public Object getReport() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BiasProperty> {
            Object postTrainingReport;
            Object preTrainingReport;
            Object report;

            public Builder postTrainingReport(IResolvable postTrainingReport) {
                this.postTrainingReport = postTrainingReport;
                return this;
            }

            public Builder postTrainingReport(MetricsSourceProperty postTrainingReport) {
                this.postTrainingReport = postTrainingReport;
                return this;
            }

            public Builder preTrainingReport(IResolvable preTrainingReport) {
                this.preTrainingReport = preTrainingReport;
                return this;
            }

            public Builder preTrainingReport(MetricsSourceProperty preTrainingReport) {
                this.preTrainingReport = preTrainingReport;
                return this;
            }

            public Builder report(IResolvable report) {
                this.report = report;
                return this;
            }

            public Builder report(MetricsSourceProperty report) {
                this.report = report;
                return this;
            }

            public BiasProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

