package software.amazon.awscdk;

/**
 * A Docker image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:49.554Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DockerImage")
public class DockerImage extends software.amazon.jsii.JsiiObject {

    protected DockerImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param image The Docker image. This parameter is required.
     * @param _imageHash
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerImage(final @org.jetbrains.annotations.NotNull java.lang.String image, final @org.jetbrains.annotations.Nullable java.lang.String _imageHash) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(image, "image is required"), _imageHash });
    }

    /**
     * @param image The Docker image. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerImage(final @org.jetbrains.annotations.NotNull java.lang.String image) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * Builds a Docker image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     * @param options Docker build options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImage fromBuild(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerBuildOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.DockerImage.class, "fromBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Builds a Docker image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImage fromBuild(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.DockerImage.class, "fromBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Reference an image on DockerHub or another online registry.
     * <p>
     * @param image the image name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String image) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.DockerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * Copies a file or directory out of the Docker image to the local filesystem.
     * <p>
     * If <code>outputPath</code> is omitted the destination path is a temporary directory.
     * <p>
     * @return the destination path
     * @param imagePath the path in the Docker image. This parameter is required.
     * @param outputPath the destination path for the copy operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String cp(final @org.jetbrains.annotations.NotNull java.lang.String imagePath, final @org.jetbrains.annotations.Nullable java.lang.String outputPath) {
        return software.amazon.jsii.Kernel.call(this, "cp", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(imagePath, "imagePath is required"), outputPath });
    }

    /**
     * Copies a file or directory out of the Docker image to the local filesystem.
     * <p>
     * If <code>outputPath</code> is omitted the destination path is a temporary directory.
     * <p>
     * @return the destination path
     * @param imagePath the path in the Docker image. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String cp(final @org.jetbrains.annotations.NotNull java.lang.String imagePath) {
        return software.amazon.jsii.Kernel.call(this, "cp", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(imagePath, "imagePath is required") });
    }

    /**
     * Runs a Docker image.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void run(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerRunOptions options) {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * Runs a Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void run() {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Provides a stable representation of this image for JSON serialization.
     * <p>
     * @return The overridden image name if set or image hash name in that order
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
