package software.amazon.awscdk;

/**
 * The report emitted by the plugin after evaluation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * PolicyValidationPluginReportBeta1 policyValidationPluginReportBeta1 = PolicyValidationPluginReportBeta1.builder()
 *         .success(false)
 *         .violations(List.of(PolicyViolationBeta1.builder()
 *                 .description("description")
 *                 .ruleName("ruleName")
 *                 .violatingResources(List.of(PolicyViolatingResourceBeta1.builder()
 *                         .locations(List.of("locations"))
 *                         .resourceLogicalId("resourceLogicalId")
 *                         .templatePath("templatePath")
 *                         .build()))
 *                 // the properties below are optional
 *                 .fix("fix")
 *                 .ruleMetadata(Map.of(
 *                         "ruleMetadataKey", "ruleMetadata"))
 *                 .severity("severity")
 *                 .build()))
 *         // the properties below are optional
 *         .metadata(Map.of(
 *                 "metadataKey", "metadata"))
 *         .pluginVersion("pluginVersion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:49.604Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.PolicyValidationPluginReportBeta1")
@software.amazon.jsii.Jsii.Proxy(PolicyValidationPluginReportBeta1.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyValidationPluginReportBeta1 extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not the report was successful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getSuccess();

    /**
     * List of violations in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.PolicyViolationBeta1> getViolations();

    /**
     * Arbitrary information about the report.
     * <p>
     * Default: - no metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getMetadata() {
        return null;
    }

    /**
     * The version of the plugin that created the report.
     * <p>
     * Default: - no version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPluginVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyValidationPluginReportBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyValidationPluginReportBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyValidationPluginReportBeta1> {
        java.lang.Boolean success;
        java.util.List<software.amazon.awscdk.PolicyViolationBeta1> violations;
        java.util.Map<java.lang.String, java.lang.String> metadata;
        java.lang.String pluginVersion;

        /**
         * Sets the value of {@link PolicyValidationPluginReportBeta1#getSuccess}
         * @param success Whether or not the report was successful. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder success(java.lang.Boolean success) {
            this.success = success;
            return this;
        }

        /**
         * Sets the value of {@link PolicyValidationPluginReportBeta1#getViolations}
         * @param violations List of violations in the report. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder violations(java.util.List<? extends software.amazon.awscdk.PolicyViolationBeta1> violations) {
            this.violations = (java.util.List<software.amazon.awscdk.PolicyViolationBeta1>)violations;
            return this;
        }

        /**
         * Sets the value of {@link PolicyValidationPluginReportBeta1#getMetadata}
         * @param metadata Arbitrary information about the report.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(java.util.Map<java.lang.String, java.lang.String> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link PolicyValidationPluginReportBeta1#getPluginVersion}
         * @param pluginVersion The version of the plugin that created the report.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginVersion(java.lang.String pluginVersion) {
            this.pluginVersion = pluginVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyValidationPluginReportBeta1}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyValidationPluginReportBeta1 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyValidationPluginReportBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyValidationPluginReportBeta1 {
        private final java.lang.Boolean success;
        private final java.util.List<software.amazon.awscdk.PolicyViolationBeta1> violations;
        private final java.util.Map<java.lang.String, java.lang.String> metadata;
        private final java.lang.String pluginVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.success = software.amazon.jsii.Kernel.get(this, "success", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.violations = software.amazon.jsii.Kernel.get(this, "violations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PolicyViolationBeta1.class)));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pluginVersion = software.amazon.jsii.Kernel.get(this, "pluginVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.success = java.util.Objects.requireNonNull(builder.success, "success is required");
            this.violations = (java.util.List<software.amazon.awscdk.PolicyViolationBeta1>)java.util.Objects.requireNonNull(builder.violations, "violations is required");
            this.metadata = builder.metadata;
            this.pluginVersion = builder.pluginVersion;
        }

        @Override
        public final java.lang.Boolean getSuccess() {
            return this.success;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.PolicyViolationBeta1> getViolations() {
            return this.violations;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.String getPluginVersion() {
            return this.pluginVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("success", om.valueToTree(this.getSuccess()));
            data.set("violations", om.valueToTree(this.getViolations()));
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPluginVersion() != null) {
                data.set("pluginVersion", om.valueToTree(this.getPluginVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.PolicyValidationPluginReportBeta1"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyValidationPluginReportBeta1.Jsii$Proxy that = (PolicyValidationPluginReportBeta1.Jsii$Proxy) o;

            if (!success.equals(that.success)) return false;
            if (!violations.equals(that.violations)) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            return this.pluginVersion != null ? this.pluginVersion.equals(that.pluginVersion) : that.pluginVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.success.hashCode();
            result = 31 * result + (this.violations.hashCode());
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.pluginVersion != null ? this.pluginVersion.hashCode() : 0);
            return result;
        }
    }
}
