package software.amazon.awscdk.assertions;

/**
 * Match failure details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.assertions.*;
 * Matcher matcher;
 * MatchFailure matchFailure = MatchFailure.builder()
 *         .matcher(matcher)
 *         .message("message")
 *         .path(List.of("path"))
 *         // the properties below are optional
 *         .cost(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:20:49.676Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.MatchFailure")
@software.amazon.jsii.Jsii.Proxy(MatchFailure.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MatchFailure extends software.amazon.jsii.JsiiSerializable {

    /**
     * The matcher that had the failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Matcher getMatcher();

    /**
     * Failure message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMessage();

    /**
     * The relative path in the target where the failure occurred.
     * <p>
     * If the failure occurred at root of the match tree, set the path to an empty list.
     * If it occurs in the 5th index of an array nested within the 'foo' key of an object,
     * set the path as <code>['/foo', '[5]']</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPath();

    /**
     * The cost of this particular mismatch.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCost() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MatchFailure}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MatchFailure}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MatchFailure> {
        software.amazon.awscdk.assertions.Matcher matcher;
        java.lang.String message;
        java.util.List<java.lang.String> path;
        java.lang.Number cost;

        /**
         * Sets the value of {@link MatchFailure#getMatcher}
         * @param matcher The matcher that had the failure. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matcher(software.amazon.awscdk.assertions.Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        /**
         * Sets the value of {@link MatchFailure#getMessage}
         * @param message Failure message. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(java.lang.String message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link MatchFailure#getPath}
         * @param path The relative path in the target where the failure occurred. This parameter is required.
         *             If the failure occurred at root of the match tree, set the path to an empty list.
         *             If it occurs in the 5th index of an array nested within the 'foo' key of an object,
         *             set the path as <code>['/foo', '[5]']</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.util.List<java.lang.String> path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link MatchFailure#getCost}
         * @param cost The cost of this particular mismatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cost(java.lang.Number cost) {
            this.cost = cost;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MatchFailure}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MatchFailure build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MatchFailure}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchFailure {
        private final software.amazon.awscdk.assertions.Matcher matcher;
        private final java.lang.String message;
        private final java.util.List<java.lang.String> path;
        private final java.lang.Number cost;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.matcher = software.amazon.jsii.Kernel.get(this, "matcher", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Matcher.class));
            this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cost = software.amazon.jsii.Kernel.get(this, "cost", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.matcher = java.util.Objects.requireNonNull(builder.matcher, "matcher is required");
            this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.cost = builder.cost;
        }

        @Override
        public final software.amazon.awscdk.assertions.Matcher getMatcher() {
            return this.matcher;
        }

        @Override
        public final java.lang.String getMessage() {
            return this.message;
        }

        @Override
        public final java.util.List<java.lang.String> getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Number getCost() {
            return this.cost;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("matcher", om.valueToTree(this.getMatcher()));
            data.set("message", om.valueToTree(this.getMessage()));
            data.set("path", om.valueToTree(this.getPath()));
            if (this.getCost() != null) {
                data.set("cost", om.valueToTree(this.getCost()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.assertions.MatchFailure"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MatchFailure.Jsii$Proxy that = (MatchFailure.Jsii$Proxy) o;

            if (!matcher.equals(that.matcher)) return false;
            if (!message.equals(that.message)) return false;
            if (!path.equals(that.path)) return false;
            return this.cost != null ? this.cost.equals(that.cost) : that.cost == null;
        }

        @Override
        public final int hashCode() {
            int result = this.matcher.hashCode();
            result = 31 * result + (this.message.hashCode());
            result = 31 * result + (this.path.hashCode());
            result = 31 * result + (this.cost != null ? this.cost.hashCode() : 0);
            return result;
        }
    }
}
