package software.amazon.awscdk.pipelines;

/**
 * Options for defining access for a Docker Credential composed of ECR repos.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.pipelines.*;
 * Role role;
 * EcrDockerCredentialOptions ecrDockerCredentialOptions = EcrDockerCredentialOptions.builder()
 *         .assumeRole(role)
 *         .usages(List.of(DockerCredentialUsage.SYNTH))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:05.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.EcrDockerCredentialOptions")
@software.amazon.jsii.Jsii.Proxy(EcrDockerCredentialOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcrDockerCredentialOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * An IAM role to assume prior to accessing the secret.
     * <p>
     * Default: - none. The current execution role will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAssumeRole() {
        return null;
    }

    /**
     * Defines which stages of the pipeline should be granted access to these credentials.
     * <p>
     * Default: - all relevant stages (synth, self-update, asset publishing) are granted access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> getUsages() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcrDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcrDockerCredentialOptions> {
        software.amazon.awscdk.services.iam.IRole assumeRole;
        java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> usages;

        /**
         * Sets the value of {@link EcrDockerCredentialOptions#getAssumeRole}
         * @param assumeRole An IAM role to assume prior to accessing the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        /**
         * Sets the value of {@link EcrDockerCredentialOptions#getUsages}
         * @param usages Defines which stages of the pipeline should be granted access to these credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder usages(java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredentialUsage> usages) {
            this.usages = (java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage>)usages;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrDockerCredentialOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcrDockerCredentialOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrDockerCredentialOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrDockerCredentialOptions {
        private final software.amazon.awscdk.services.iam.IRole assumeRole;
        private final java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> usages;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assumeRole = software.amazon.jsii.Kernel.get(this, "assumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.usages = software.amazon.jsii.Kernel.get(this, "usages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DockerCredentialUsage.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assumeRole = builder.assumeRole;
            this.usages = (java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage>)builder.usages;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAssumeRole() {
            return this.assumeRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.DockerCredentialUsage> getUsages() {
            return this.usages;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssumeRole() != null) {
                data.set("assumeRole", om.valueToTree(this.getAssumeRole()));
            }
            if (this.getUsages() != null) {
                data.set("usages", om.valueToTree(this.getUsages()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.EcrDockerCredentialOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrDockerCredentialOptions.Jsii$Proxy that = (EcrDockerCredentialOptions.Jsii$Proxy) o;

            if (this.assumeRole != null ? !this.assumeRole.equals(that.assumeRole) : that.assumeRole != null) return false;
            return this.usages != null ? this.usages.equals(that.usages) : that.usages == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assumeRole != null ? this.assumeRole.hashCode() : 0;
            result = 31 * result + (this.usages != null ? this.usages.hashCode() : 0);
            return result;
        }
    }
}
