package software.amazon.awscdk.pipelines;

/**
 * Multiple stages that are deployed in parallel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * Wave europeWave = pipeline.addWave("Europe");
 * europeWave.addStage(
 * MyApplicationStage.Builder.create(this, "Ireland")
 *         .env(Environment.builder().region("eu-west-1").build())
 *         .build());
 * europeWave.addStage(
 * MyApplicationStage.Builder.create(this, "Germany")
 *         .env(Environment.builder().region("eu-central-1").build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-01-25T00:21:05.452Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.Wave")
public class Wave extends software.amazon.jsii.JsiiObject {

    protected Wave(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Wave(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this Wave. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Wave(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.WaveProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param id Identifier for this Wave. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Wave(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add an additional step to run after all of the stages in this wave.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPost(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPost", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * Add an additional step to run before any of the stages in this wave.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPre(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step... steps) {
        software.amazon.jsii.Kernel.call(this, "addPre", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(steps).toArray(Object[]::new));
    }

    /**
     * Add a Stage to this wave.
     * <p>
     * It will be deployed in parallel with all other stages in this
     * wave.
     * <p>
     * @param stage This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStageOpts options) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), options });
    }

    /**
     * Add a Stage to this wave.
     * <p>
     * It will be deployed in parallel with all other stages in this
     * wave.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Identifier for this Wave.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional steps that are run after all of the stages in the wave.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * Additional steps that are run before any of the stages in the wave.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * The stages that are deployed in this wave.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StageDeployment> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.pipelines.Wave}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.pipelines.Wave> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id Identifier for this Wave. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private software.amazon.awscdk.pipelines.WaveProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
        }

        /**
         * Additional steps to run after all of the stages in the wave.
         * <p>
         * Default: - No additional steps
         * <p>
         * @return {@code this}
         * @param post Additional steps to run after all of the stages in the wave. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder post(final java.util.List<? extends software.amazon.awscdk.pipelines.Step> post) {
            this.props().post(post);
            return this;
        }

        /**
         * Additional steps to run before any of the stages in the wave.
         * <p>
         * Default: - No additional steps
         * <p>
         * @return {@code this}
         * @param pre Additional steps to run before any of the stages in the wave. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pre(final java.util.List<? extends software.amazon.awscdk.pipelines.Step> pre) {
            this.props().pre(pre);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.pipelines.Wave}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.pipelines.Wave build() {
            return new software.amazon.awscdk.pipelines.Wave(
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.pipelines.WaveProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.pipelines.WaveProps.Builder();
            }
            return this.props;
        }
    }
}
